;========================================================================== 
;  File:   d3d8.h ( MASM32 beta version )
;  Content:    Direct3D include file
;
;      eYMax  
;          mybox@aib.ru
;         h  inc
;
;        MICROSOFT DIRECTX SDK 8.1
;     (       ;)
;=============================================================================

DIRECT3D_VERSION			EQU	00000800h

D3DCAPS8 STRUC    
    DeviceType				DWORD		?	;D3DDEVTYPE Device Info
    AdapterOrdinal			UINT    	?    
    Caps				DWORD   	?	;Caps from DX7 Draw
    Caps2				DWORD   	?
    Caps3				DWORD   	?
    PresentationIntervals		DWORD   	?    
    CursorCaps				DWORD   	?	;Cursor Caps
    DevCaps				DWORD   	?	;3D Device Caps
    PrimitiveMiscCaps			DWORD   	?
    RasterCaps				DWORD   	?
    ZCmpCaps				DWORD   	?
    SrcBlendCaps			DWORD   	?
    DestBlendCaps			DWORD   	?
    AlphaCmpCaps			DWORD   	?
    ShadeCaps				DWORD   	?
    TextureCaps				DWORD   	?
    TextureFilterCaps			DWORD   	?   	;D3DPTFILTERCAPS for IDirect3DTexture8's
    CubeTextureFilterCaps		DWORD   	?     	;D3DPTFILTERCAPS for IDirect3DCubeTexture8's
    VolumeTextureFilterCaps		DWORD   	?	;D3DPTFILTERCAPS for IDirect3DVolumeTexture8's
    TextureAddressCaps			DWORD   	?	;D3DPTADDRESSCAPS for IDirect3DTexture8's
    VolumeTextureAddressCaps		DWORD   	?	;D3DPTADDRESSCAPS for IDirect3DVolumeTexture8's
    LineCaps				DWORD   	?	;D3DLINECAPS
    MaxTextureWidth			DWORD   	?	;????
    MaxTextureHeight			DWORD		?	;????
    MaxVolumeExtent			DWORD   	?
    MaxTextureRepeat			DWORD		?
    MaxTextureAspectRatio		DWORD   	?
    MaxAnisotropy			DWORD   	?
    MaxVertexW				REAL4   	?
    GuardBandLeft			REAL4   	?
    GuardBandTop			REAL4   	?
    GuardBandRight			REAL4		?
    GuardBandBottom			REAL4		?
    ExtentsAdjust			REAL4		?
    StencilCaps				DWORD   	?
    FVFCaps				DWORD   	?
    TextureOpCaps			DWORD   	?
    MaxTextureBlendStages		DWORD  		?
    MaxSimultaneousTextures		DWORD   	?
    VertexProcessingCaps		DWORD   	?
    MaxActiveLights			DWORD   	?
    MaxUserClipPlanes			DWORD   	?
    MaxVertexBlendMatrices		DWORD   	?
    MaxVertexBlendMatrixIndex		DWORD   	?
    MaxPointSize			REAL4		?
    MaxPrimitiveCount			DWORD  		?       ;max number of primitives per DrawPrimitive call
    MaxVertexIndex			DWORD   	?
    MaxStreams				DWORD   	?
    MaxStreamStride			DWORD   	?   	;max stride for SetStreamSource
    VertexShaderVersion			DWORD   	?
    MaxVertexShaderConst		DWORD   	?      	;number of vertex shader constant registers
    PixelShaderVersion			DWORD   	?
    MaxPixelShaderValue			REAL4        	?	;max value of pixel shader arithmetic component
D3DCAPS8 ENDS

;Caps
D3DCAPS_READ_SCANLINE			EQU	00020000h

;Caps2
D3DCAPS2_NO2DDURING3DSCENE		EQU	00000002h
D3DCAPS2_FULLSCREENGAMMA		EQU   	00020000h
D3DCAPS2_CANRENDERWINDOWED		EQU    	00080000h
D3DCAPS2_CANCALIBRATEGAMMA		EQU    	00100000h
D3DCAPS2_RESERVED			EQU   	02000000h
D3DCAPS2_CANMANAGERESOURCE		EQU   	10000000h
D3DCAPS2_DYNAMICTEXTURES		EQU    	20000000h

;Caps3
D3DCAPS3_RESERVED			EQU   	8000001fh

;Indicates that the device can respect the ALPHABLENDENABLE render state
;when fullscreen while using the FLIP or DISCARD swap effect.
;COPY and COPYVSYNC swap effects work whether or not this flag is set.

D3DCAPS3_ALPHA_FULLSCREEN_FLIP_OR_DISCARD	EQU	00000020h

;PresentationIntervals
D3DPRESENT_INTERVAL_DEFAULT		EQU	00000000h
D3DPRESENT_INTERVAL_ONE			EQU	00000001h
D3DPRESENT_INTERVAL_TWO			EQU	00000002h
D3DPRESENT_INTERVAL_THREE		EQU	00000004h
D3DPRESENT_INTERVAL_FOUR		EQU	00000008h
D3DPRESENT_INTERVAL_IMMEDIATE		EQU	80000000h

;CursorCaps
;Driver supports HW color cursor in at least hi-res modes(height >=400)

D3DCURSORCAPS_COLOR			EQU	00000001h

;Driver supports HW cursor also in low-res modes(height < 400)

D3DCURSORCAPS_LOWRES    		EQU	00000002h

;DevCaps
D3DDEVCAPS_EXECUTESYSTEMMEMORY		EQU	00000010h 	;Device can use execute buffers from system memory
D3DDEVCAPS_EXECUTEVIDEOMEMORY  		EQU	00000020h 	;Device can use execute buffers from video memory
D3DDEVCAPS_TLVERTEXSYSTEMMEMORY 	EQU	00000040h 	;Device can use TL buffers from system memory
D3DDEVCAPS_TLVERTEXVIDEOMEMORY  	EQU	00000080h 	;Device can use TL buffers from video memory
D3DDEVCAPS_TEXTURESYSTEMMEMORY  	EQU	00000100h 	;Device can texture from system memory
D3DDEVCAPS_TEXTUREVIDEOMEMORY   	EQU	00000200h 	;Device can texture from device memory
D3DDEVCAPS_DRAWPRIMTLVERTEX     	EQU	00000400h 	;Device can draw TLVERTEX primitives
D3DDEVCAPS_CANRENDERAFTERFLIP   	EQU	00000800h 	;Device can render without waiting for flip to complete
D3DDEVCAPS_TEXTURENONLOCALVIDMEM 	EQU	00001000h 	;Device can texture from nonlocal video memory
D3DDEVCAPS_DRAWPRIMITIVES2      	EQU	00002000h 	;Device can support DrawPrimitives2
D3DDEVCAPS_SEPARATETEXTUREMEMORIES 	EQU	00004000h 	;Device is texturing from separate memory pools
D3DDEVCAPS_DRAWPRIMITIVES2EX    	EQU	00008000h 	;Device can support Extended DrawPrimitives2 i.e. DX7 compliant driver
D3DDEVCAPS_HWTRANSFORMANDLIGHT  	EQU	00010000h 	;Device can support transformation and lighting in hardware and DRAWPRIMITIVES2EX must be also
D3DDEVCAPS_CANBLTSYSTONONLOCAL  	EQU	00020000h 	;Device supports a Tex Blt from system memory to non-local vidmem
D3DDEVCAPS_HWRASTERIZATION      	EQU	00080000h 	;Device has HW acceleration for rasterization
D3DDEVCAPS_PUREDEVICE           	EQU	00100000h 	;Device supports D3DCREATE_PUREDEVICE
D3DDEVCAPS_QUINTICRTPATCHES    		EQU	00200000h 	;Device supports quintic Beziers and BSplines
D3DDEVCAPS_RTPATCHES            	EQU	00400000h 	;Device supports Rect and Tri patches
D3DDEVCAPS_RTPATCHHANDLEZERO    	EQU	00800000h 	;Indicates that RT Patches may be drawn efficiently using handle 0
D3DDEVCAPS_NPATCHES             	EQU	01000000h 	;Device supports N-Patches

;PrimitiveMiscCaps
D3DPMISCCAPS_MASKZ              		EQU	00000002h
D3DPMISCCAPS_LINEPATTERNREP     		EQU	00000004h
D3DPMISCCAPS_CULLNONE           		EQU	00000010h
D3DPMISCCAPS_CULLCW             		EQU	00000020h
D3DPMISCCAPS_CULLCCW            		EQU	00000040h
D3DPMISCCAPS_COLORWRITEENABLE   		EQU	00000080h
D3DPMISCCAPS_CLIPPLANESCALEDPOINTS 		EQU	00000100h 	;Device correctly clips scaled points to clip planes
D3DPMISCCAPS_CLIPTLVERTS        		EQU	00000200h 	;device will clip post-transformed vertex primitives
D3DPMISCCAPS_TSSARGTEMP         		EQU	00000400h 	;device supports D3DTA_TEMP for temporary register
D3DPMISCCAPS_BLENDOP            		EQU	00000800h 	;device supports D3DRS_BLENDOP
D3DPMISCCAPS_NULLREFERENCE      		EQU	00001000h 	;Reference Device that doesnt render

;LineCaps
D3DLINECAPS_TEXTURE             		EQU 	00000001h
D3DLINECAPS_ZTEST               		EQU	00000002h
D3DLINECAPS_BLEND               		EQU	00000004h
D3DLINECAPS_ALPHACMP            		EQU	00000008h
D3DLINECAPS_FOG                 		EQU	00000010h

;RasterCaps
D3DPRASTERCAPS_DITHER          			EQU	00000001h
D3DPRASTERCAPS_PAT              		EQU	00000008h
D3DPRASTERCAPS_ZTEST            		EQU	00000010h
D3DPRASTERCAPS_FOGVERTEX        		EQU	00000080h
D3DPRASTERCAPS_FOGTABLE         		EQU	00000100h
D3DPRASTERCAPS_ANTIALIASEDGES   		EQU	00001000h
D3DPRASTERCAPS_MIPMAPLODBIAS    		EQU	00002000h
D3DPRASTERCAPS_ZBIAS            		EQU	00004000h
D3DPRASTERCAPS_ZBUFFERLESSHSR   		EQU	00008000h
D3DPRASTERCAPS_FOGRANGE         		EQU	00010000h	
D3DPRASTERCAPS_ANISOTROPY       		EQU	00020000h
D3DPRASTERCAPS_WBUFFER          		EQU	00040000h
D3DPRASTERCAPS_WFOG             		EQU	00100000h
D3DPRASTERCAPS_ZFOG             		EQU	00200000h
D3DPRASTERCAPS_COLORPERSPECTIVE 		EQU	00400000h 	;Device iterates colors perspective correct
D3DPRASTERCAPS_STRETCHBLTMULTISAMPLE  		EQU	00800000L

;ZCmpCaps, AlphaCmpCaps
D3DPCMPCAPS_NEVER               		EQU	00000001h
D3DPCMPCAPS_LESS                		EQU	00000002h
D3DPCMPCAPS_EQUAL               		EQU	00000004h
D3DPCMPCAPS_LESSEQUAL           		EQU	00000008h
D3DPCMPCAPS_GREATER             		EQU	00000010h
D3DPCMPCAPS_NOTEQUAL            		EQU	00000020h
D3DPCMPCAPS_GREATEREQUAL        		EQU	00000040h
D3DPCMPCAPS_ALWAYS              		EQU	00000080h

;SourceBlendCaps, DestBlendCaps
D3DPBLENDCAPS_ZERO              		EQU	00000001h
D3DPBLENDCAPS_ONE               		EQU	00000002h
D3DPBLENDCAPS_SRCCOLOR          		EQU	00000004h
D3DPBLENDCAPS_INVSRCCOLOR       		EQU	00000008h
D3DPBLENDCAPS_SRCALPHA          		EQU	00000010h
D3DPBLENDCAPS_INVSRCALPHA       		EQU	00000020h
D3DPBLENDCAPS_DESTALPHA         		EQU	00000040h
D3DPBLENDCAPS_INVDESTALPHA      		EQU	00000080h
D3DPBLENDCAPS_DESTCOLOR         		EQU	00000100h
D3DPBLENDCAPS_INVDESTCOLOR      		EQU	00000200h
D3DPBLENDCAPS_SRCALPHASAT       		EQU	00000400h
D3DPBLENDCAPS_BOTHSRCALPHA      		EQU	00000800h
D3DPBLENDCAPS_BOTHINVSRCALPHA   		EQU	00001000h

;ShadeCaps
D3DPSHADECAPS_COLORGOURAUDRGB       		EQU	00000008h
D3DPSHADECAPS_SPECULARGOURAUDRGB    		EQU	00000200h
D3DPSHADECAPS_ALPHAGOURAUDBLEND     		EQU	00004000h
D3DPSHADECAPS_FOGGOURAUD            		EQU	00080000h

;TextureCaps
D3DPTEXTURECAPS_PERSPECTIVE         		EQU	00000001h 	;Perspective-correct texturing is supported
D3DPTEXTURECAPS_POW2                		EQU	00000002h 	;Power-of-2 texture dimensions are required - applies to non-Cube/Volume textures only.
D3DPTEXTURECAPS_ALPHA               		EQU	00000004h 	;Alpha in texture pixels is supported
D3DPTEXTURECAPS_SQUAREONLY          		EQU	00000020h 	;Only square textures are supported
D3DPTEXTURECAPS_TEXREPEATNOTSCALEDBYSIZE 	EQU	00000040h 	;Texture indices are not scaled by the texture size prior to interpolation
D3DPTEXTURECAPS_ALPHAPALETTE        		EQU	00000080h 	;Device can draw alpha from texture palettes

;Device can use non-POW2 textures if:
;1) D3DTEXTURE_ADDRESS is set to CLAMP for this texture's stage
;2) D3DRS_WRAP(N) is zero for this texture's coordinates
;3) mip mapping is not enabled (use magnification filter only)

D3DPTEXTURECAPS_NONPOW2CONDITIONAL  		EQU	00000100h
D3DPTEXTURECAPS_PROJECTED           		EQU	00000400h 	;Device can do D3DTTFF_PROJECTED
D3DPTEXTURECAPS_CUBEMAP             		EQU	00000800h 	;Device can do cubemap textures
D3DPTEXTURECAPS_VOLUMEMAP           		EQU	00002000h 	;Device can do volume textures
D3DPTEXTURECAPS_MIPMAP              		EQU	00004000h 	;Device can do mipmapped textures
D3DPTEXTURECAPS_MIPVOLUMEMAP        		EQU	00008000h 	;Device can do mipmapped volume textures
D3DPTEXTURECAPS_MIPCUBEMAP          		EQU	00010000h 	;Device can do mipmapped cube maps
D3DPTEXTURECAPS_CUBEMAP_POW2        		EQU	00020000h 	;Device requires that cubemaps be power-of-2 dimension
D3DPTEXTURECAPS_VOLUMEMAP_POW2      		EQU	00040000h 	;Device requires that volume maps be power-of-2 dimension

;TextureFilterCaps
D3DPTFILTERCAPS_MINFPOINT           		EQU	00000100h 	;Min Filter
D3DPTFILTERCAPS_MINFLINEAR          		EQU	00000200h
D3DPTFILTERCAPS_MINFANISOTROPIC     		EQU	00000400h
D3DPTFILTERCAPS_MIPFPOINT           		EQU	00010000h 	;Mip Filter
D3DPTFILTERCAPS_MIPFLINEAR          		EQU	00020000h
D3DPTFILTERCAPS_MAGFPOINT           		EQU	01000000h 	;Mag Filter
D3DPTFILTERCAPS_MAGFLINEAR          		EQU	02000000h
D3DPTFILTERCAPS_MAGFANISOTROPIC     		EQU	04000000h
D3DPTFILTERCAPS_MAGFAFLATCUBIC      		EQU	08000000h
D3DPTFILTERCAPS_MAGFGAUSSIANCUBIC   		EQU	10000000h

;TextureAddressCaps
D3DPTADDRESSCAPS_WRAP           		EQU	00000001h
D3DPTADDRESSCAPS_MIRROR         		EQU	00000002h
D3DPTADDRESSCAPS_CLAMP          		EQU	00000004h
D3DPTADDRESSCAPS_BORDER         		EQU 	00000008h
D3DPTADDRESSCAPS_INDEPENDENTUV  		EQU	00000010h
D3DPTADDRESSCAPS_MIRRORONCE     		EQU	00000020h

;StencilCaps
D3DSTENCILCAPS_KEEP             		EQU	00000001h
D3DSTENCILCAPS_ZERO             		EQU	00000002h
D3DSTENCILCAPS_REPLACE          		EQU	00000004h
D3DSTENCILCAPS_INCRSAT          		EQU	00000008h
D3DSTENCILCAPS_DECRSAT          		EQU	00000010h
D3DSTENCILCAPS_INVERT           		EQU	00000020h
D3DSTENCILCAPS_INCR             		EQU	00000040h
D3DSTENCILCAPS_DECR             		EQU	00000080h

;TextureOpCaps
D3DTEXOPCAPS_DISABLE                    	EQU	00000001h
D3DTEXOPCAPS_SELECTARG1                 	EQU	00000002h
D3DTEXOPCAPS_SELECTARG2                 	EQU	00000004h
D3DTEXOPCAPS_MODULATE                   	EQU	00000008h
D3DTEXOPCAPS_MODULATE2X                 	EQU	00000010h
D3DTEXOPCAPS_MODULATE4X                 	EQU	00000020h
D3DTEXOPCAPS_ADD                        	EQU	00000040h
D3DTEXOPCAPS_ADDSIGNED                  	EQU	00000080h
D3DTEXOPCAPS_ADDSIGNED2X                	EQU	00000100h
D3DTEXOPCAPS_SUBTRACT                   	EQU	00000200h
D3DTEXOPCAPS_ADDSMOOTH                  	EQU	00000400h
D3DTEXOPCAPS_BLENDDIFFUSEALPHA          	EQU	00000800h
D3DTEXOPCAPS_BLENDTEXTUREALPHA          	EQU	00001000h
D3DTEXOPCAPS_BLENDFACTORALPHA           	EQU	00002000h
D3DTEXOPCAPS_BLENDTEXTUREALPHAPM        	EQU	00004000h
D3DTEXOPCAPS_BLENDCURRENTALPHA          	EQU	00008000h
D3DTEXOPCAPS_PREMODULATE                	EQU	00010000h
D3DTEXOPCAPS_MODULATEALPHA_ADDCOLOR     	EQU	00020000h
D3DTEXOPCAPS_MODULATECOLOR_ADDALPHA     	EQU	00040000h
D3DTEXOPCAPS_MODULATEINVALPHA_ADDCOLOR  	EQU	00080000h
D3DTEXOPCAPS_MODULATEINVCOLOR_ADDALPHA  	EQU	00100000h
D3DTEXOPCAPS_BUMPENVMAP                 	EQU	00200000h
D3DTEXOPCAPS_BUMPENVMAPLUMINANCE        	EQU	00400000h
D3DTEXOPCAPS_DOTPRODUCT3                	EQU	00800000h
D3DTEXOPCAPS_MULTIPLYADD                	EQU	01000000h
D3DTEXOPCAPS_LERP                       	EQU	02000000h

;FVFCaps
D3DFVFCAPS_TEXCOORDCOUNTMASK    		EQU	0000ffffh 	;mask for texture coordinate count field
D3DFVFCAPS_DONOTSTRIPELEMENTS   		EQU	00080000h 	;Device prefers that vertex elements not be stripped
D3DFVFCAPS_PSIZE                		EQU	00100000h 	;Device can receive point size

;VertexProcessingCaps
D3DVTXPCAPS_TEXGEN              		EQU	00000001h 	;device can do texgen
D3DVTXPCAPS_MATERIALSOURCE7     		EQU	00000002h 	;device can do DX7-level colormaterialsource ops
D3DVTXPCAPS_DIRECTIONALLIGHTS   		EQU	00000008h 	;device can do directional lights
D3DVTXPCAPS_POSITIONALLIGHTS    		EQU	00000010h 	;device can do positional lights (includes point and spot) 
D3DVTXPCAPS_LOCALVIEWER         		EQU	00000020h 	;device can do local viewer
D3DVTXPCAPS_TWEENING            		EQU	00000040h 	;device can do vertex tweening
D3DVTXPCAPS_NO_VSDT_UBYTE4      		EQU	00000080h 	;device does not support D3DVSDT_UBYTE4