;***********************************************************************************************************
;   WIN32
;  Direct3D8
;     keYMax
;     mybox@aib.ru
;***********************************************************************************************************
	.686				;      686
	.MMX				;    MMX 
	.XMM				;    SSE 
	
	.MODEL FLAT, STDCALL	;   
					; STDCALL -    

	OPTION CASEMAP:none	;       
					;    . ;)
					
;===========================================================================================================
;         .
;===========================================================================================================
    INCLUDE		\masm32\include\windows.inc			; ,  ...    
    INCLUDE		\masm32\include\kernel32.inc   		;    ...
    INCLUDE		\masm32\include\user32.inc			;  ...
    INCLUDE		\masm32\include\gdi32.inc			;   ...
             
    INCLUDE		Include\d3d8.inc          			;!!!	             
                
    INCLUDELIB	\masm32\lib\kernel32.lib
    INCLUDELIB	\masm32\lib\user32.lib
    INCLUDELIB	\masm32\lib\gdi32.lib

    INCLUDELIB	Include\d3d8.lib	  			;!!!
    
; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    Init_Direct3D	PROTO						;!!!      	
    Destroy_Direct3D	PROTO						;!!!
    Render_Scene	PROTO						;!!!

.DATA ;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    szClassName 	db 	"MyClass", 0 				;    
    szAppName 	db 	" 3D   !", 0 		;    (          )
    
   ;WNDCLASSEX ------------------------------------------------
    cbSize            	dd	12*4					;  
    style             	dd	CS_HREDRAW or CS_VREDRAW 	;   
    lpfnWndProc       	dd	OFFSET WndProc			;    
    cbClsExtra        	dd	0					;     
    cbWndExtra        	dd	0					;   
    hInstance         	dd	400000h 				;     
    hIcon             	dd	0 					;     (  )
    hCursor           	dd	65553					;     (    ID   )
    hbrBackground    	dd	BLACK_PEN				;    
    lpszMenuName      	dd	0					;    
    lpszClassName     	dd	OFFSET szClassName	 	;     
    hIconSm           	dd	0 					;     (  -    )
    
.DATA? ;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    msg			MSG 	<>				;  
    hwnd             	HWND 	?  				; ID  
        
.CONST ;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    WIN_X		EQU	320
    WIN_Y		EQU	240

;------------------------------------------------------------------------------------------------------------------------------------------    
.CODE
;===========================================================================================================
;     .
;===========================================================================================================
Start:  							;                      

    invoke  	RegisterClassEx, addr cbSize          		;                
    
    invoke  	GetSystemMetrics, SM_CXFULLSCREEN     	;   
    push	eax
    invoke  	GetSystemMetrics, SM_CYFULLSCREEN     	;       
    sub		eax, WIN_Y 					;   x  y     
    shr		eax, 1
    pop		ebx
    sub		ebx, WIN_X
    shr		ebx, 1
  
    invoke  	CreateWindowEx, NULL , ADDR szClassName , ADDR szAppName , \
    		WS_SYSMENU , ebx ,  eax , WIN_X , WIN_Y , NULL , NULL , hInstance , NULL       
    mov     	 hwnd, eax    					
    
    invoke	ShowWindow, hwnd, SW_NORMAL		;    
    invoke	UpdateWindow, hwnd	 			;  
    invoke	SetFocus, hwnd 				;    
    
    invoke	Init_Direct3D							;!!!	 Direct3D
           
 msg_loop:
    invoke 	PeekMessageA, ADDR msg, 0 , 0 , 0 , PM_NOREMOVE		;!!!	
    test		eax, eax 							;!!!
    jne		message							;!!!	    ... 

    invoke	Render_Scene							;!!! 	...     
    jmp		msg_loop   							;!!!
   
    message:    								;!!!
    invoke  	GetMessage, ADDR msg , NULL , 0 ,  0 
    test		eax, eax				
    je        	end_loop

    invoke  	TranslateMessage, ADDR msg     												
    invoke  	DispatchMessage, ADDR msg      
    jmp     	msg_loop

 end_loop:
    mov 	eax, msg.wParam              			;     ,     
    								;    wParam  MSG. 
    invoke 	ExitProcess, eax
    ret
;===========================================================================================================                                     
 WndProc proc hWnd:HWND , uMsg:UINT, wParam:WPARAM, lParam:LPARAM                                          
;=========================================================
    
    cmp     uMsg, WM_CREATE	 			;    ,   
    je      wmCreate
            
    cmp     uMsg, WM_DESTROY	   			;    ,     .
    je      wmDestroy	
    			                 
    invoke  DefWindowProc, hWnd, uMsg, wParam, lParam  	;       , 
    ret                                                  			;    DefWindowProc   ,   .
    								;   API     .  
;-----------------------------------------------------------------------------------------------------------------------------------------                                                               
  wmDestroy:
;------------    
    invoke	Destroy_Direct3D				;!!!	        DirectX
    
    invoke  	PostQuitMessage, NULL     
    xor       	eax,eax                            
    ret                                         
;-----------------------------------------------------------------------------------------------------------------------------------------                                                               
  wmCreate:                                       
;-----------    
    xor       	eax, eax
    ret 
 WndProc endp
;===========================================================================================================
;    
;===========================================================================================================
Init_Direct3D proc	;  Direct3DDevice   WM_Create  ! (    :) )    
    
    .DATA?
    pd3d		DWORD ?								;!!! 	  Direct3D			
    pd3dDevice		DWORD	 ?								;!!! 	  Direct3DDevice		
    d3ddm		D3DDISPLAYMODE <>							;!!! 	   		
    d3dpp 		D3DPRESENT_PARAMETERS <>					;!!! 	    	
			
    .CODE													
    invoke	Direct3DCreate8, D3D_SDK_VERSION 						;   Direct3D8
    mov	pd3d, eax     									;    
    
    d3d8	GetAdapterDisplayMode, pd3d, D3DADAPTER_DEFAULT, ADDR d3ddm	;    
    												;       
    mov	d3dpp.Windowed, TRUE							;   							
    mov	d3dpp.SwapEffect, D3DSWAPEFFECT_FLIP					;    ,      
    mov	eax, d3ddm.Format								;     (   )
    mov	d3dpp.BackBufferFormat, eax 							;   
    												;   Direct3DDevice8
    d3d8	CreateDevice, pd3d, D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hwnd ,\
    		D3DCREATE_HARDWARE_VERTEXPROCESSING, ADDR d3dpp, ADDR pd3dDevice	 
    		    
    ret
Init_Direct3D endp
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Destroy_Direct3D proc

    d3dev8	Release, pd3dDevice	;    Direct3DDevice8  
    d3d8	Release, pd3d		;    Direct3D8   
    					;    Release    GDI    
    ret    
Destroy_Direct3D endp
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Render_Scene	proc
    
    .DATA
    Zvalue		dd 	1.0f    	;!!! 	   Z 	
    
    .DATA?
    Clearcolor		dd	?	;!!! 	    Direct3D
    
    .CODE    
    d3dev8	Clear, pd3dDevice, 0 , NULL , D3DCLEAR_TARGET, Clearcolor , Zvalue , 0 		;!!!	 
    inc		Clearcolor        
    d3dev8     	Present, pd3dDevice, NULL, NULL, NULL, NULL    					;!!!	       
        
    ret
Render_Scene	endp
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
end Start 
