;***********************************************************************************************************
;    Setup:          
; 				
;     keYMax
;     mybox@aib.ru 
;***********************************************************************************************************
	.686				;      686
	.MMX				;    MMX 
	.XMM				;    SSE 
	
	.MODEL FLAT, STDCALL	;      Win32
					; STDCALL -    

	OPTION CASEMAP:none	;       
					;    . ;)
					
;===========================================================================================================
;          
;===========================================================================================================
    INCLUDE		\masm32\include\windows.inc			; ,  ...    
    INCLUDE		\masm32\include\kernel32.inc   		;    ...
    INCLUDE		\masm32\include\user32.inc			;  ...
    INCLUDE		\masm32\include\gdi32.inc			;   ...
    INCLUDE		\masm32\include\shell32.inc			;   ...
    
             
    INCLUDE		\masm32\DirectX81\d3d8.inc			;    Direct3D8
                
    INCLUDELIB	\masm32\lib\kernel32.lib
    INCLUDELIB	\masm32\lib\user32.lib
    INCLUDELIB	\masm32\lib\gdi32.lib
    INCLUDELIB	\masm32\lib\shell32.lib    

    INCLUDELIB	\masm32\directx81\d3d8.lib	  		;   Direct3D8

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
    SetupDialog		PROTO :DWORD,:DWORD,:DWORD,:DWORD	;     Dialog.inc
    DW2A		PROTO :DWORD, :DWORD
        
.DATA ;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    szDialogName 	db	"SetupDialog", 0
    szAppName 	db	"Tutorial03.exe",0
    szFileName 	db	"Settings.ini", 0
    szOperation 	db	"open",0
    
   WinModeTable	dw	320,240, 640,480, 800,600, 1024,768, 1280,1024, 1600,1200 			;     
   WinModeStrTable	dd	OFFSET szMode1 , OFFSET szMode2 , OFFSET szMode3 , OFFSET szMode4 	;    
			dd	OFFSET szMode5 , OFFSET szMode6
   szMode1 		db	"320x240",0										;     
   szMode2 		db	"640x480",0   
   szMode3 		db	"800x600",0
   szMode4 		db	"1024x768",0
   szMode5 		db	"1280x1024",0
   szMode6 		db	"1600x1200",0  			
   
.DATA? ;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
    pd3d		dd 	?				;   Direct3D			    
    d3ddm		D3DDISPLAYMODE < ? >		;         		 
    d3dpp		D3DPRESENT_PARAMETERS < ? >	;    Direct3DDevice8
    WinStyle    		dd	?				;       
    
    cmbWindow		dd	?				; ID ComboBox  
    cmbFullScreen	dd	?				; ID ComboBox  
    cmbHerz		dd	?				; ID ComboBox 
        
    FullModeTable	dd	50 dup (?)			;      (    ).     4 
    FullModeBPPTable	db	50 dup (?)			;    .      
    FullModeHerzTable	db	50 dup (?)			;     .        
    FullModeStrBuffer	db	16 dup (?)			;       ComboBox  
    
    AppPath		db	260 dup (?)
    hfile		dd	?
    brr			dd	?
        
.CODE ;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Start:  									;                      
		
    invoke	DialogBoxParam, 400000h , ADDR szDialogName , \	;   
    		NULL , OFFSET SetupDialog, NULL        							
    invoke 	ExitProcess, 0 							;   
    ret
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
SetupDialog proc hDlg:HWND , iMsg:DWORD , wParam:WPARAM , lParam:LPARAM

    mov      eax, iMsg
   
    cmp      eax, WM_INITDIALOG 		;           EAX  1 
    je         wmInitDialog 			;             
   						;    
    cmp      eax, WM_COMMAND
    je         wmCommandDialog 
          
    xor eax, eax
    ret
    
;-----------------------------------------------------------------------------------------------------------------------------------------   
  wmInitDialog:
;--------------
   pushad								;         Win98
   invoke	CheckRadioButton, hDlg , 20 , 21 , 20 		;    " "    ""
   invoke	GetDlgItem, hDlg , 23 					;    ComboBox
   mov		cmbWindow,  eax
   invoke	GetDlgItem, hDlg , 22
   mov		cmbFullScreen,  eax
   invoke	GetDlgItem, hDlg , 24
   mov		cmbHerz,  eax  
   
   invoke	Direct3DCreate8, D3D_SDK_VERSION						;  Direct3D 			
   mov		pd3d, eax									;    
   
   d3d8	GetAdapterDisplayMode, pd3d, D3DADAPTER_DEFAULT, ADDR d3dpp	;       
   
   ;----------------------------------------------       
   lea		esi, d3dpp.BackBufferWidth
   mov		eax, [esi]			
   add		eax, [esi+4]				;     
   mov		ebx, [esi+12] 				;       
   mov		[esi+8], ebx
   mov		DWORD PTR [esi+12], 3 		;     BackBuffer
   xor		ebx, ebx   
   getNextMode:					;          
   push	ebx
   push	eax
   invoke	SendMessage, cmbWindow , CB_ADDSTRING , 0 , [WinModeStrTable + ebx*4]	;   ComboBox    
   pop		eax
   pop		ebx
   movzx	ecx, [WinModeTable+ebx*4]
   movzx	edx, [WinModeTable+ebx*4+2]
   add		ecx, edx   
   inc		ebx
   cmp		eax, ecx
   ja		getNextMode				
   
   ;    ComboBox             
   
   ;----------------------------------------------        				   	
   d3d8	GetAdapterModeCount, pd3d, D3DADAPTER_DEFAULT	;       
   dec		eax								;    1, ..     0

   lea		esi, FullModeTable
   xor		ebx, ebx   
   mov		edx, ebx
   mov		ecx, eax         
   
   getMode:		
   push	ecx
   
   push	esi								;    Direct3D  
   push	ebx								;  
   push	edx
   
   d3d8	EnumAdapterModes, pd3d, D3DADAPTER_DEFAULT, ecx, ADDR d3ddm	;     
   mov		eax, d3ddm.Width1							
   mov		ecx, d3ddm.Height
   mov		edi, eax
   add		edi, ecx
   add		edi, d3ddm.Format				;  ,    
   
   pop		edx
   pop		ebx
   pop		esi   
   
   cmp		edx, edi					;                  
   je		noAdd   
   mov		edx, d3ddm.RefreshRate			;          , 
   mov		BYTE PTR [FullModeHerzTable+ebx], dl	;    
   mov		edx, d3ddm.Format
   mov		[FullModeBPPTable+ebx], dl 
   push	edx
   push	edi
   pop		edx
   pop		edi
   
   mov		[esi+ebx*4], eax
   mov		[esi+ebx*4+2], ecx
   inc		ebx   
   
   push	ebx       
   push	esi
   push	edx
   
   ;----------------------------------------------       Combobox
   invoke	DW2A, eax, ADDR FullModeStrBuffer
   mov		BYTE PTR [ebx], 'x'
   inc		ebx
   invoke	DW2A, ecx, ebx
   mov		BYTE PTR [ebx], 'x'
   inc		ebx
   mov		ecx, 16
   cmp		edi, D3DFMT_X8R8G8B8
   jne		nextFormat
   mov		ecx, 32
   nextFormat:   
   cmp		edi, D3DFMT_A8R8G8B8
   jne		nextFormat2
   mov		ecx, 32
   nextFormat2:
   cmp		edi, D3DFMT_R8G8B8
   jne		exitCompare		
   mov		ecx, 24
   exitCompare:
   invoke	DW2A, ecx , ebx	;        : 1024x768x32
   mov		BYTE PTR [ebx], 0       	
   invoke	SendMessage, cmbFullScreen , CB_ADDSTRING , 0 , ADDR FullModeStrBuffer	
   	   
   pop		edx
   pop		esi
   pop		ebx  	
     
   noAdd:   	
   pop		ecx
   dec		ecx
   test		ecx, ecx
   jne		getMode		; LOOP    ..      
   
   ;    ComboBox          
   ;        
                  
   invoke	SendMessage, cmbWindow , CB_SETCURSEL , 0 , 0 				;    
   invoke	SendMessage, cmbFullScreen , CB_SETCURSEL , 0 , 0    			;    
   invoke	SendMessage, hDlg, WM_COMMAND , 22 + CBN_SELCHANGE shl 16  , 0    	;     ComboBox 
												;        
   popad			;         Win98
   xor		eax, eax
   inc		eax		;  1, ..    WM_INITDIALOG
   ret     
;------------------------------------------------------------------------------------------------------------------------------------------  
  wmCommandDialog:
;------------------------------------------
   movzx	eax, WORD PTR wParam	;     HIWORD  LOWORD  wParam
   mov		ecx, wParam			; HIWORD -     
  						; LOWORD - ID  
   xor		ebx, ebx
  
   cmp		eax, 10 				;     
   je	cmStartProgram
  
   cmp		eax, 12 				;     
   je	cmSaveData
   
   cmp		eax, 11 				;     
   je	cmCloseProgram
  
   cmp		eax, 20 				;    RadioButton " "
   je	cmRadioWin
   
   cmp		eax, 21 				;    RadioButton ""
   je	cmRadioFull
   
   cmp		ecx, 22 + CBN_SELCHANGE shl 16 	;      ComboBox  
   je	cmHerz				
  
   xor		eax, eax
   ret   
                    
		cmRadioFull:	;   ComboBox   
           	inc		ebx
   
		cmRadioWin: 
           	invoke		EnableWindow, cmbFullScreen , ebx		
           	invoke		EnableWindow, cmbHerz , ebx     
		xor		ebx, 1
		invoke		EnableWindow, cmbWindow , ebx  
		xor		eax, eax
		ret       
           
           	cmHerz:	;         ComboBox "" 
           	invoke		SendMessage, cmbHerz , CB_RESETCONTENT , 0 , 0           	
                    invoke		SendMessage, cmbFullScreen , CB_GETCURSEL , 0 , 0
                    movzx		ebx, BYTE PTR [FullModeHerzTable+eax]
           	invoke		DW2A, ebx , ADDR FullModeStrBuffer
           	invoke		SendMessage, cmbHerz , CB_ADDSTRING , 0 , ADDR FullModeStrBuffer
           	invoke		SendMessage, cmbHerz , CB_SETCURSEL , 0 , 0
           	xor		eax, eax
		ret 
           
		cmSaveData:	;      D3DPRESENT_PARAMETERS
		invoke		IsDlgButtonChecked, hDlg , 20 			;   RadioButton 
		test		eax, eax						;      
		je		EnableFull                   
                    invoke		SendMessage, cmbWindow , CB_GETCURSEL , 0 , 0
		lea		esi, WinModeTable
		shl		eax, 2
 		add		esi, eax		
 		xor		ecx, ecx
		mov		edx, ecx
  		push		[esi]   		
    		pop		cx							;     
                    pop		dx 		
                    mov		d3dpp.BackBufferWidth, ecx				;   
                    mov		d3dpp.BackBufferHeight, edx		
                    mov		d3dpp.Windowed, 1 					;       
                    mov		WinStyle, WS_SYSMENU				;   
                    jmp		Create                                        			;     
                    EnableFull:
                    invoke		SendMessage, cmbFullScreen , CB_GETCURSEL , 0 , 0
                    movzx		ebx, BYTE PTR [FullModeHerzTable+eax]
                    mov	    	d3dpp.FullScreen_RefreshRateInHz, ebx
                    movzx		ebx, BYTE PTR [FullModeBPPTable+eax]
                    mov		d3dpp.BackBufferFormat, ebx
                    lea		esi, FullModeTable
                    shl		eax, 2
 		add		esi, eax
 		push		[esi] 		
 		xor		ecx, ecx
		mov		edx, ecx
                    mov		d3dpp.Windowed, ecx
                    pop		cx
                    pop		dx
                    mov		d3dpp.BackBufferWidth, ecx
                    mov		d3dpp.BackBufferHeight, edx
                    mov		WinStyle, WS_POPUP
                    Create:	;          D3DPRESENT_PARAMETERS
                    mov		d3dpp.SwapEffect, D3DSWAPEFFECT_FLIP
                    invoke 	CreateFile , ADDR szFileName , GENERIC_WRITE, NULL, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL
		mov    	hfile, eax
		invoke 	WriteFile , hfile , ADDR d3dpp , 56 , ADDR brr , NULL
		invoke  	CloseHandle , hfile  
   		xor		eax, eax
   		ret
   		
   		cmStartProgram:   
   		invoke		EndDialog, hDlg , 0 					;      				
   		d3d8		Release, pd3d						;  Direct3D8

   		invoke 	GetModuleFileName , 0 , ADDR AppPath , 260 	;      SETUP

    		lea	 	edi,  AppPath						;      
    		lea 		edi, [edi+eax-6]              
  		@@:
    		mov		al,	[edi]                     
    		dec		edi                          
    		cmp		al,'\'                      
    		jne		@B
    		inc		edi
    		inc		edi
    		cld									;         
    		lea 		esi, szAppName
    		mov		ecx, SIZEOF szAppName
    		shr 		ecx, 2
    		rep 		movsd
    		mov		ecx, [SIZEOF szAppName ]
    		and		ecx, 3
    		rep 		movsb
 
    		invoke 	ShellExecute , NULL , ADDR szOperation , ADDR AppPath , NULL , NULL , SW_SHOWNORMAL 	;  
   		xor		eax, eax
   		ret
   		   		
		cmCloseProgram: 		
   		invoke		EndDialog, hDlg , 0  
   		d3d8		Release, pd3d			;  Direct3D8
   		xor		eax, eax
   		ret
      
SetupDialog endp
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DW2A proc dwValue:DWORD, lpBuffer:DWORD ;   EAX -  ,  EBX -   
						  ;     dw2a    masm32
    push	edx
    push	ecx
    push	esi
    push	edi
    		
    mov	eax, dwValue
    mov	edi, lpBuffer

    test		eax,eax
    jnz		sign
    
  zero:
    mov	word ptr [edi],30h
    ret    
  sign:
    jns		pos
    mov	byte ptr [edi],'-'
    neg		eax
    inc		edi
  pos:      
    mov	ecx,429496730
    mov	esi, edi

    nextDigit:
    mov	ebx,eax
    mul		ecx
    mov	eax,edx
    lea		edx,[edx*4+edx]
    add		edx,edx
    sub		ebx,edx
    add		bl,48
    mov	[edi],bl
    inc		edi
    cmp	eax, 0
    ja 		nextDigit
    mov 	byte ptr [edi], 0     
    push	edi
    
    nextMove:
    dec		edi
    mov	al, [esi]
    mov	ah, [edi]
    mov	[edi], al
    mov	[esi], ah
    inc		esi
    cmp	esi, edi
    jb		nextMove
    
    pop		eax
    mov	ebx, eax
    sub		eax, lpBuffer

    pop		edi
    pop		esi    
    pop		ecx
    pop		edx
    
    ret
DW2A endp
end Start 