;***********************************************************************************************************
;   WIN32
;  Direct3D8   
;    
;    
;     keYMax
;     mybox@aib.ru 
;***********************************************************************************************************
	.686				;      686
	.MMX				;    MMX 
	.XMM				;    SSE 
	
	.MODEL FLAT, STDCALL	;      Win32
					; STDCALL -    

	OPTION CASEMAP:none	;       
					;    . ;)
					
;===========================================================================================================
;          
;===========================================================================================================
    INCLUDE		\masm32\include\windows.inc			; ,  ...    
    INCLUDE		\masm32\include\kernel32.inc   		;    ...
    INCLUDE		\masm32\include\user32.inc			;  ...
    INCLUDE		\masm32\include\gdi32.inc			;   ...
             
    INCLUDE		\masm32\directx81\d3d8.inc			;    Direct3D8
                
    INCLUDELIB	\masm32\lib\kernel32.lib
    INCLUDELIB	\masm32\lib\user32.lib
    INCLUDELIB	\masm32\lib\gdi32.lib

    INCLUDELIB	\masm32\directx81\d3d8.lib	  		;   Direct3D8

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    Init_Direct3D	PROTO						;      	
    Destroy_Direct3D	PROTO						;
    Render_Scene	PROTO						;
    
.CONST ;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
.DATA ;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    szClassName 	db 	"MyClass", 0 				;    
    szAppName 	db 	" 3D   !", 0 		;    (          )
    szSettings 		db	"Settings.ini", 0 			;    
    szError 		db	"Settings.ini   !", 0
       
   ;WNDCLASSEX ------------------------------------------------ 
    cbSize            	dd	12*4					;  
    style             	dd	CS_HREDRAW or CS_VREDRAW 	;   
    lpfnWndProc       	dd	OFFSET WndProc			;    
    cbClsExtra        	dd	0					;     
    cbWndExtra        	dd	0					;   
    hInstance         	dd	400000h 				;     
    hIcon             	dd	0 					;     (  )
    hCursor           	dd	65553					;     (    ID   )
    hbrBackground    	dd	BLACK_PEN				;    
    lpszMenuName      	dd	0					;    
    lpszClassName     	dd	OFFSET szClassName	 	;     
    hIconSm           	dd	0 					;     (  -    )
                
.DATA? ;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    msg			MSG 	<>					;  
    hwnd             	HWND 	?  					; ID  
    hfile		dd	? 					; ID  
    brr			dd	?					;         
    
    d3dpp		D3DPRESENT_PARAMETERS	<?>		;    Direct3DDevice8				
    WindowStyle	dd	?
    
.CODE ;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

Start:  								;                      
    
    invoke 	CreateFile , ADDR szSettings , GENERIC_READ , FILE_SHARE_READ , NULL , OPEN_EXISTING , FILE_ATTRIBUTE_NORMAL , NULL    
    mov    	 hfile, eax
    inc		eax							;  EAX  -1
    jne		ok
    dec		eax
    invoke	MessageBox, 0 , ADDR szError , ADDR szAppName , MB_ICONERROR
    invoke 	ExitProcess, 0
    
    ok:    
    invoke	ReadFile , hfile , ADDR d3dpp , 56  , ADDR brr , NULL		;    
    invoke	CloseHandle , hfile 						;   
    
    invoke  	LoadCursor, NULL, IDC_ARROW			
    mov     	hCursor, eax					

    invoke  	RegisterClassEx, addr cbSize          		;                
                
    mov	eax, d3dpp.Windowed
    test		eax, eax
    je		FullMode
    invoke  	GetSystemMetrics, SM_CXSCREEN     	;   
    push	eax
    invoke  	GetSystemMetrics, SM_CYSCREEN     	;   
    mov	ecx, d3dpp.BackBufferHeight
    sub		eax, ecx 					;   x  y     
    shr		eax, 1
    pop		ebx
    mov	edx, d3dpp.BackBufferWidth
    sub		ebx, edx
    shr		ebx, 1
    jmp		Create
    FullMode:	
    xor		eax, eax
    mov	ebx, eax    
    
    Create:  
    invoke  	CreateWindowEx, NULL , ADDR szClassName , ADDR szAppName ,  \
                    WindowStyle , ebx ,  eax , edx , ecx , NULL , NULL , hInstance , NULL      
    mov     	 hwnd, eax    					
    
    invoke	ShowWindow, hwnd, SW_NORMAL			;     0,0   640x480
    invoke	UpdateWindow, hwnd	 				;  
    invoke	SetFocus, hwnd 					;    
    
    invoke	Init_Direct3D						;  Direct3D
           
 msg_loop:
    invoke 	PeekMessageA, ADDR msg, 0 , 0 , 0 , PM_NOREMOVE		;	
    test		eax, eax 							;
    jne		message							;     ... 

    invoke	Render_Scene							; ...     
    jmp		msg_loop   							;
   
 message:    									;
    invoke  	GetMessage, ADDR msg , NULL , 0 ,  0 
    test		eax, eax				
    je        	end_loop

    invoke  	TranslateMessage, ADDR msg     												
    invoke  	DispatchMessage, ADDR msg      
    jmp     	msg_loop

 end_loop:
    mov 	eax, msg.wParam              			;     ,     
    								;    wParam  MSG. 
    invoke 	ExitProcess, eax
    ret
;===========================================================================================================                                     
 WndProc proc hWnd:HWND , uMsg:UINT, wParam:WPARAM, lParam:LPARAM                                          
;=========================================================
                   
    cmp     uMsg, WM_CREATE	 			;    ,   
    je      wmCreate
            
    cmp     uMsg, WM_DESTROY	   			;    ,     .
    je      wmDestroy	
         			                 
    invoke  DefWindowProc, hWnd, uMsg, wParam, lParam  	;       , 
    ret                                                  			;    DefWindowProc   ,   .
    								;   API     .
;-----------------------------------------------------------------------------------------------------------------------------------------                                                               
  wmDestroy:
;------------    
    invoke	Destroy_Direct3D				;         DirectX
    
    invoke  	PostQuitMessage, NULL     
    xor       	eax,eax                            
    ret                                         
;-----------------------------------------------------------------------------------------------------------------------------------------                                                               
  wmCreate:                                       
;-----------    
    xor       	eax, eax
    ret 
 WndProc endp
;===========================================================================================================
;    
;===========================================================================================================
Init_Direct3D proc	;  Direct3DDevice   WM_Create  ! (    :) )    			

    .DATA?
    pd3d		dd 	?				;   Direct3D			
    pd3dDevice		dd	?				;   Direct3DDevice		
        
    .CODE														
    invoke	Direct3DCreate8, D3D_SDK_VERSION 		;   Direct3D8
    mov	pd3d, eax     					;    

    d3d8	CreateDevice, pd3d, D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hwnd , \		;   Direct3DDevice8
                    D3DCREATE_SOFTWARE_VERTEXPROCESSING, ADDR d3dpp , ADDR pd3dDevice                    
    ret
Init_Direct3D endp
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Destroy_Direct3D proc 

    d3dev8	Release, pd3dDevice		;  Direct3DDevice8  
    d3d8	Release, pd3d			;  Direct3D8   

    ret    
Destroy_Direct3D endp
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Render_Scene	proc
   
    .DATA
    Zvalue		dd 	1.0f    				;    Z 
    
    .DATA?
    clearcolor		dd	?		 		;     Direct3D
    
    .CODE
    d3dev8	TestCooperativeLevel, pd3dDevice		;  
    cmp	eax, D3DERR_DEVICELOST			;     
    jne		noreset    					;
    ret								;
    noreset:    							;
    cmp	eax, D3DERR_DEVICENOTRESET		;         
    jne		noreset2					;
    d3dev8	Reset, pd3dDevice, ADDR d3dpp		;
    noreset2:    						;

    d3dev8	Clear, pd3dDevice, 0 , NULL , D3DCLEAR_TARGET, clearcolor , Zvalue , 0 		;  
    inc		clearcolor        
    d3dev8     	Present, pd3dDevice, NULL, NULL, NULL, NULL    					;        

    ret
Render_Scene	endp
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
end Start 
