;========================================================================== 
;  File:   	d3d8.h ( MASM32 release version  27  2003  )
;  Content:	Direct3D include file
;
;      eYMax  
;          mybox@aib.ru
;         h  inc
;
;        MICROSOFT DIRECTX SDK 8.1
;     (       ;)
;=============================================================================

include d3d8types.inc
include d3d8caps.inc

;------------------------------------------------------------------------------
;    
;------------------------------------------------------------------------------
 STDMETHOD  MACRO  name, argl :VARARG
  
  LOCAL @tmp_a                     	;   
  LOCAL @tmp_b

  @tmp_a	TYPEDEF PROTO argl     ; 
  @tmp_b	TYPEDEF PTR @tmp_a     ;   
  name		@tmp_b		?

 ENDM
;------------------------------------------------------------------------------
;   Direct3D8
;------------------------------------------------------------------------------
 d3d8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [IDirect3D8Vtbl. func][eax], this
  ELSE
       INVOKE [IDirect3D8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM
;------------------------------------------------------------------------------
;   Direct3DDevice8
;------------------------------------------------------------------------------
 d3dev8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [IDirect3DDevice8Vtbl. func][eax], this
  ELSE
       INVOKE [IDirect3DDevice8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM
;------------------------------------------------------------------------------
;   Direct3DSwapChain8
;------------------------------------------------------------------------------
 d3dsc8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [IDirect3DSwapChain8Vtbl. func][eax], this
  ELSE
       INVOKE [IDirect3DSwapChain8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM 
;------------------------------------------------------------------------------
;   Direct3DResource8
;------------------------------------------------------------------------------
 d3dres8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [IDirect3DResource8Vtbl. func][eax], this
  ELSE
       INVOKE [IDirect3DResource8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM 
;------------------------------------------------------------------------------
;   Direct3DBaseTexture8
;------------------------------------------------------------------------------
 d3dbtex8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [IDirect3DBaseTexture8Vtbl. func][eax], this
  ELSE
       INVOKE [IDirect3DBaseTexture8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM 
;------------------------------------------------------------------------------
;   Direct3DTexture8
;------------------------------------------------------------------------------
 d3dtex8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [IDirect3DTexture8Vtbl. func][eax], this
  ELSE
       INVOKE [IDirect3DTexture8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM 
;------------------------------------------------------------------------------
;   Direct3DVolumeTexture8
;------------------------------------------------------------------------------
 d3dvtex8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [IDirect3DVolumeTexture8Vtbl. func][eax], this
  ELSE
       INVOKE [IDirect3DVolumeTexture8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM 
;------------------------------------------------------------------------------
;   Direct3DCubeTexture8
;------------------------------------------------------------------------------
 d3dctex8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [IDirect3DCubeTexture8Vtbl. func][eax], this
  ELSE
       INVOKE [IDirect3DCubeTexture8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM 
;------------------------------------------------------------------------------
;   Direct3DVertexBuffer8
;------------------------------------------------------------------------------
 d3dvb8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [IDirect3DVertexBuffer8Vtbl. func][eax], this
  ELSE
       INVOKE [IDirect3DVertexBuffer8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM
;------------------------------------------------------------------------------
;   Direct3DIndexBuffer8
;------------------------------------------------------------------------------
 d3dib8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [IDirect3DIndexBuffer8Vtbl. func][eax], this
  ELSE
       INVOKE [IDirect3DIndexBuffer8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM
;------------------------------------------------------------------------------
;   Direct3DSurface8
;------------------------------------------------------------------------------
 d3dsur8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [IDirect3DSurface8Vtbl. func][eax], this
  ELSE
       INVOKE [IDirect3DSurface8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM
;------------------------------------------------------------------------------
;   Direct3DVolume8
;------------------------------------------------------------------------------
 d3dvol8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [IDirect3DVolume8Vtbl. func][eax], this
  ELSE
       INVOKE [IDirect3DVolume8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM
 

DIRECT3D_VERSION	EQU	0800h
D3D_SDK_VERSION 	EQU	220

EXTERNDEF  C IID_IDirect3D8:GUID 		
EXTERNDEF  C IID_IDirect3DDevice8:GUID		
EXTERNDEF  C IID_IDirect3DResource8:GUID	
EXTERNDEF  C IID_IDirect3DBaseTexture8:GUID	
EXTERNDEF  C IID_IDirect3DTexture8:GUID		
EXTERNDEF  C IID_IDirect3DCubeTexture8:GUID	
EXTERNDEF  C IID_IDirect3DVolumeTexture8:GUID	
EXTERNDEF  C IID_IDirect3DVertexBuffer8:GUID	
EXTERNDEF  C IID_IDirect3DIndexBuffer8:GUID	
EXTERNDEF  C IID_IDirect3DSurface8:GUID		
EXTERNDEF  C IID_IDirect3DVolume8:GUID		
EXTERNDEF  C IID_IDirect3DSwapChain8:GUID	

;DLL Function for creating a Direct3D8 object. This object supports
;enumeration and allows the creation of Direct3DDevice8 objects.
;Pass the value of the constant D3D_SDK_VERSION to this function, so
;that the run-time can validate that your application was compiled
;against the right headers.

	Direct3DCreate8 PROTO :UINT

;==============================================================================
;  Direct3D8    
;==============================================================================
IDirect3D8Vtbl	STRUC

    ;IUnknown methods

    STDMETHOD	QueryInterface, 		:PTR IDirect3D8, :PTR, :PTR PTR
    STDMETHOD	AddRef, 			:PTR IDirect3D8
    STDMETHOD	Release, 			:PTR IDirect3D8

    ;IDirect3D8 methods

    STDMETHOD	RegisterSoftwareDevice, 	:PTR IDirect3D8, :PTR PTR
    STDMETHOD	GetAdapterCount, 		:PTR IDirect3D8
    STDMETHOD	GetAdapterIdentifier, 		:PTR IDirect3D8, :UINT, :DWORD, :PTR D3DADAPTER_IDENTIFIER8
    STDMETHOD	GetAdapterModeCount,		:PTR IDirect3D8, :UINT
    STDMETHOD	EnumAdapterModes,		:PTR IDirect3D8, :UINT, :UINT, :PTR D3DDISPLAYMODE
    STDMETHOD	GetAdapterDisplayMode, 		:PTR IDirect3D8, :UINT, :PTR D3DDISPLAYMODE
    STDMETHOD	CheckDeviceType,		:PTR IDirect3D8, :UINT, :DWORD, :DWORD, :DWORD, :BOOL
    STDMETHOD	CheckDeviceFormat,		:PTR IDirect3D8, :UINT, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
    STDMETHOD	CheckDeviceMultiSampleType,	:PTR IDirect3D8, :UINT, :DWORD, :DWORD, :BOOL, :DWORD
    STDMETHOD	CheckDepthStencilMatch,		:PTR IDirect3D8, :UINT, :DWORD, :DWORD, :DWORD, :DWORD
    STDMETHOD	GetDeviceCaps, 			:PTR IDirect3D8, :UINT, :DWORD, :PTR D3DCAPS8
    STDMETHOD	GetAdapterMonitor, 		:PTR IDirect3D8, :UINT
    STDMETHOD	CreateDevice, 			:PTR IDirect3D8, :UINT, :DWORD, :HWND, :DWORD, :PTR D3DPRESENT_PARAMETERS, :PTR PTR IDirect3DDevice8    

IDirect3D8Vtbl	ENDS

;==============================================================================
;  Direct3DDevice8    
;==============================================================================
IDirect3DDevice8Vtbl	STRUC

    ;IUnknown methods

    STDMETHOD	QueryInterface, 		:PTR IDirect3DDevice8, :PTR, :PTR PTR
    STDMETHOD	AddRef, 			:PTR IDirect3DDevice8
    STDMETHOD	Release, 			:PTR IDirect3DDevice8

    ;IDirect3DDevice8 methods

    STDMETHOD 	TestCooperativeLevel, 		:PTR IDirect3DDevice8   
    STDMETHOD   GetAvailableTextureMem,		:PTR IDirect3DDevice8 
    STDMETHOD	ResourceManagerDiscardBytes,	:PTR IDirect3DDevice8, :DWORD
    STDMETHOD	GetDirect3D,			:PTR IDirect3DDevice8, :PTR PTR IDirect3D8        
    STDMETHOD	GetDeviceCaps, 			:PTR IDirect3DDevice8, :PTR D3DCAPS8
    STDMETHOD	GetDisplayMode, 		:PTR IDirect3DDevice8, :PTR D3DDISPLAYMODE
    STDMETHOD	GetCreationParameters,		:PTR IDirect3DDevice8, :PTR D3DDEVICE_CREATION_PARAMETERS
    STDMETHOD	SetCursorProperties, 		:PTR IDirect3DDevice8, :UINT, :UINT, :PTR IDirect3DSurface8
    STDMETHOD	SetCursorPosition, 		:PTR IDirect3DDevice8, :UINT, :UINT, :DWORD
    STDMETHOD	ShowCursor, 			:PTR IDirect3DDevice8, :BOOL
    STDMETHOD   CreateAdditionalSwapChain,	:PTR IDirect3DDevice8, :PTR D3DPRESENT_PARAMETERS, :PTR PTR IDirect3DSwapChain8
    STDMETHOD 	Reset, 				:PTR IDirect3DDevice8, :PTR D3DPRESENT_PARAMETERS
    STDMETHOD	Present,			:PTR IDirect3DDevice8, :PTR RECT, :PTR RECT, :HWND, :PTR RGNDATA
    STDMETHOD	GetBackBuffer,			:PTR IDirect3DDevice8, :UINT, :DWORD, :PTR PTR IDirect3DSurface8
    STDMETHOD	GetRasterStatus,		:PTR IDirect3DDevice8, :PTR D3DRASTER_STATUS
    STDMETHOD	SetGammaRamp,			:PTR IDirect3DDevice8, :DWORD, :PTR D3DGAMMARAMP
    STDMETHOD   GetGammaRamp,			:PTR IDirect3DDevice8, :PTR D3DGAMMARAMP
    STDMETHOD	CreateTexture,			:PTR IDirect3DDevice8, :UINT, :UINT, :UINT, :DWORD, :DWORD, :DWORD, :PTR PTR IDirect3DTexture8
    STDMETHOD	CreateVolumeTexture,		:PTR IDirect3DDevice8, :UINT, :UINT, :UINT, :UINT, :DWORD, :DWORD, :DWORD, :PTR PTR IDirect3DVolumeTexture8
    STDMETHOD	CreateCubeTexture,		:PTR IDirect3DDevice8, :UINT, :UINT, :DWORD, :DWORD, :DWORD, :PTR PTR IDirect3DCubeTexture8
    STDMETHOD	CreateVertexBuffer,		:PTR IDirect3DDevice8, :UINT, :DWORD, :DWORD, :DWORD, :PTR PTR IDirect3DVertexBuffer8
    STDMETHOD	CreateIndexBuffer,		:PTR IDirect3DDevice8, :UINT, :DWORD, :DWORD, :DWORD, :PTR PTR IDirect3DIndexBuffer8
    STDMETHOD	CreateRenderTarget,		:PTR IDirect3DDevice8, :UINT, :UINT, :DWORD, :DWORD, :BOOL, :PTR PTR IDirect3DSurface8
    STDMETHOD	CreateDepthStencilSurface,	:PTR IDirect3DDevice8, :UINT, :UINT, :DWORD, :DWORD, :PTR PTR IDirect3DSurface8
    STDMETHOD	CreateImageSurface,		:PTR IDirect3DDevice8, :UINT, :UINT, :DWORD, :PTR PTR IDirect3DSurface8
    STDMETHOD	CopyRects,			:PTR IDirect3DDevice8, :PTR IDirect3DSurface8, :PTR RECT, :UINT, :PTR IDirect3DSurface8, :PTR POINT
    STDMETHOD	UpdateTexture,			:PTR IDirect3DDevice8, :PTR IDirect3DBaseTexture8, :PTR IDirect3DBaseTexture8
    STDMETHOD	GetFrontBuffer,			:PTR IDirect3DDevice8, :PTR IDirect3DSurface8
    STDMETHOD	SetRenderTarget,		:PTR IDirect3DDevice8, :PTR IDirect3DSurface8, :PTR IDirect3DSurface8
    STDMETHOD	GetRenderTarget,		:PTR IDirect3DDevice8, :PTR PTR IDirect3DSurface8 
    STDMETHOD	GetDepthStencilSurface,		:PTR IDirect3DDevice8, :PTR PTR IDirect3DSurface8 
    STDMETHOD	BeginScene,			:PTR IDirect3DDevice8
    STDMETHOD	EndScene,			:PTR IDirect3DDevice8
    STDMETHOD	Clear,				:PTR IDirect3DDevice8, :DWORD, :PTR D3DRECT, :DWORD, :DWORD, :REAL4, :DWORD
    STDMETHOD	SetTransform,			:PTR IDirect3DDevice8, :DWORD, :PTR D3DMATRIX
    STDMETHOD	GetTransform,			:PTR IDirect3DDevice8, :DWORD, :PTR D3DMATRIX
    STDMETHOD	MultiplyTransform,		:PTR IDirect3DDevice8, :DWORD, :PTR D3DMATRIX
    STDMETHOD	SetViewport,			:PTR IDirect3DDevice8, :PTR D3DVIEWPORT8
    STDMETHOD	GetViewport,			:PTR IDirect3DDevice8, :PTR D3DVIEWPORT8
    STDMETHOD	SetMaterial,			:PTR IDirect3DDevice8, :PTR D3DMATERIAL8
    STDMETHOD 	GetMaterial,			:PTR IDirect3DDevice8, :PTR D3DMATERIAL8
    STDMETHOD	SetLight,			:PTR IDirect3DDevice8, :DWORD, :PTR D3DLIGHT8
    STDMETHOD	GetLight,			:PTR IDirect3DDevice8, :DWORD, :PTR D3DLIGHT8
    STDMETHOD	LightEnable,			:PTR IDirect3DDevice8, :DWORD, :BOOL
    STDMETHOD	GetLightEnable,			:PTR IDirect3DDevice8, :DWORD, :PTR BOOL
    STDMETHOD	SetClipPlane,			:PTR IDirect3DDevice8, :DWORD, :PTR REAL4
    STDMETHOD	GetClipPlane,			:PTR IDirect3DDevice8, :DWORD, :PTR REAL4
    STDMETHOD	SetRenderState,			:PTR IDirect3DDevice8, :DWORD, :DWORD
    STDMETHOD	GetRenderState,			:PTR IDirect3DDevice8, :DWORD, :PTR DWORD
    STDMETHOD	BeginStateBlock,		:PTR IDirect3DDevice8
    STDMETHOD	EndStateBlock,			:PTR IDirect3DDevice8, :PTR DWORD
    STDMETHOD	ApplyStateBlock,		:PTR IDirect3DDevice8, :DWORD
    STDMETHOD	CaptureStateBlock,		:PTR IDirect3DDevice8, :DWORD
    STDMETHOD	DeleteStateBlock,		:PTR IDirect3DDevice8, :DWORD
    STDMETHOD	CreateStateBlock,		:PTR IDirect3DDevice8, :DWORD, :PTR DWORD
    STDMETHOD	SetClipStatus,			:PTR IDirect3DDevice8, :PTR D3DCLIPSTATUS8
    STDMETHOD	GetClipStatus,			:PTR IDirect3DDevice8, :PTR D3DCLIPSTATUS8
    STDMETHOD	GetTexture,			:PTR IDirect3DDevice8, :DWORD, :PTR PTR IDirect3DBaseTexture8
    STDMETHOD	SetTexture,			:PTR IDirect3DDevice8, :DWORD, :PTR PTR IDirect3DBaseTexture8
    STDMETHOD	GetTextureStageState,		:PTR IDirect3DDevice8, :DWORD, :DWORD, :PTR DWORD
    STDMETHOD	SetTextureStageState,		:PTR IDirect3DDevice8, :DWORD, :DWORD, :DWORD
    STDMETHOD	ValidateDevice,			:PTR IDirect3DDevice8, :PTR DWORD
    STDMETHOD	GetInfo,			:PTR IDirect3DDevice8, :DWORD, :PTR, :DWORD
    STDMETHOD	SetPaletteEntries,		:PTR IDirect3DDevice8, :UINT, :PTR PALETTEENTRY
    STDMETHOD	GetPaletteEntries,		:PTR IDirect3DDevice8, :UINT, :PTR PALETTEENTRY
    STDMETHOD	SetCurrentTexturePalette,	:PTR IDirect3DDevice8, :UINT
    STDMETHOD	GetCurrentTexturePalette,	:PTR IDirect3DDevice8, :UINT
    STDMETHOD	DrawPrimitive,			:PTR IDirect3DDevice8, :DWORD, :UINT, :UINT
    STDMETHOD	DrawIndexedPrimitive,		:PTR IDirect3DDevice8, :DWORD, :UINT, :UINT, :UINT, :UINT
    STDMETHOD	DrawPrimitiveUP,		:PTR IDirect3DDevice8, :DWORD, :UINT, :PTR, :UINT
    STDMETHOD	DrawIndexedPrimitiveUP,		:PTR IDirect3DDevice8, :DWORD, :UINT, :UINT, :UINT, :PTR, :DWORD, :PTR, :UINT
    STDMETHOD	ProcessVertices,		:PTR IDirect3DDevice8, :UINT, :UINT, :UINT, :PTR IDirect3DVertexBuffer8, :DWORD
    STDMETHOD	CreateVertexShader,		:PTR IDirect3DDevice8, :PTR DWORD, :PTR DWORD, :PTR DWORD, :DWORD
    STDMETHOD	SetVertexShader,		:PTR IDirect3DDevice8, :DWORD
    STDMETHOD	GetVertexShader,		:PTR IDirect3DDevice8, :PTR DWORD
    STDMETHOD	DeleteVertexShader,		:PTR IDirect3DDevice8, :DWORD
    STDMETHOD	SetVertexShaderConstant,	:PTR IDirect3DDevice8, :DWORD, :PTR, :DWORD
    STDMETHOD	GetVertexShaderConstant,	:PTR IDirect3DDevice8, :DWORD, :PTR, :DWORD
    STDMETHOD	GetVertexShaderDeclaration,	:PTR IDirect3DDevice8, :DWORD, :PTR, :PTR DWORD
    STDMETHOD	GetVertexShaderFunction,	:PTR IDirect3DDevice8, :DWORD, :PTR, :PTR DWORD
    STDMETHOD	SetStreamSource,		:PTR IDirect3DDevice8, :UINT, :PTR IDirect3DVertexBuffer8, :UINT
    STDMETHOD	GetStreamSource,		:PTR IDirect3DDevice8, :UINT, :PTR PTR IDirect3DVertexBuffer8, :PTR UINT
    STDMETHOD	SetIndices,			:PTR IDirect3DDevice8, :PTR IDirect3DIndexBuffer8, :UINT
    STDMETHOD	GetIndices,			:PTR IDirect3DDevice8, :PTR PTR IDirect3DIndexBuffer8, :PTR UINT
    STDMETHOD	CreatePixelShader,		:PTR IDirect3DDevice8, :PTR DWORD, :PTR DWORD
    STDMETHOD	SetPixelShader,			:PTR IDirect3DDevice8, :DWORD
    STDMETHOD	GetPixelShader,			:PTR IDirect3DDevice8, :PTR DWORD
    STDMETHOD	DeletePixelShader,		:PTR IDirect3DDevice8, :DWORD
    STDMETHOD	SetPixelShaderConstant,		:PTR IDirect3DDevice8, :DWORD, :PTR, :DWORD
    STDMETHOD	GetPixelShaderConstant,		:PTR IDirect3DDevice8, :DWORD, :PTR, :DWORD
    STDMETHOD	GetPixelShaderFunction,		:PTR IDirect3DDevice8, :DWORD, :PTR, :PTR DWORD
    STDMETHOD	DrawRectPatch,			:PTR IDirect3DDevice8, :UINT, :PTR REAL4, :PTR D3DRECTPATCH_INFO
    STDMETHOD	DrawTriPatch,			:PTR IDirect3DDevice8, :UINT, :PTR REAL4, :PTR D3DTRIPATCH_INFO
    STDMETHOD	DeletePatch,			:PTR IDirect3DDevice8, :UINT

IDirect3DDevice8Vtbl	ENDS

;==============================================================================
;  Direct3DSwapChain8    
;==============================================================================
IDirect3DSwapChain8Vtbl STRUC 

    ;IUnknown methods

    STDMETHOD	QueryInterface, 		:PTR IDirect3DSwapChain8, :PTR, :PTR PTR
    STDMETHOD	AddRef, 			:PTR IDirect3DSwapChain8
    STDMETHOD	Release, 			:PTR IDirect3DSwapChain8

    ;IDirect3DSwapChain8 methods

    STDMETHOD	Present,			:PTR IDirect3DSwapChain8, :PTR RECT, :PTR RECT, :HWND, :PTR RGNDATA
    STDMETHOD	GetBackBuffer,			:PTR IDirect3DSwapChain8, :UINT, :DWORD, :PTR PTR IDirect3DSurface8

IDirect3DSwapChain8Vtbl ENDS

;==============================================================================
;  Direct3DResource8    
;==============================================================================
IDirect3DResource8Vtbl STRUC 

    ;IUnknown methods

    STDMETHOD	QueryInterface, 		:PTR IDirect3DResource8, :PTR, :PTR PTR
    STDMETHOD	AddRef, 			:PTR IDirect3DResource8
    STDMETHOD	Release, 			:PTR IDirect3DResource8

    ;IDirect3DResource8 methods

    STDMETHOD	GetDevice,			:PTR IDirect3DResource8, :PTR PTR IDirect3DDevice8
    STDMETHOD	SetPrivateData,			:PTR IDirect3DResource8, :PTR, :PTR, :DWORD, :DWORD
    STDMETHOD	GetPrivateData,			:PTR IDirect3DResource8, :PTR, :PTR, :PTR DWORD
    STDMETHOD	FreePrivateData,		:PTR IDirect3DResource8, :PTR
    STDMETHOD	SetPriority,			:PTR IDirect3DResource8, :DWORD
    STDMETHOD	GetPriority,			:PTR IDirect3DResource8
    STDMETHOD	PreLoad,			:PTR IDirect3DResource8
    STDMETHOD 	GetType,			:PTR IDirect3DResource8

IDirect3DResource8Vtbl ENDS

;==============================================================================
;  Direct3DBaseTexture8    
;==============================================================================
IDirect3DBaseTexture8Vtbl STRUC

    ;IUnknown methods

    STDMETHOD	QueryInterface, 		:PTR IDirect3DBaseTexture8, :PTR, :PTR PTR
    STDMETHOD	AddRef, 			:PTR IDirect3DBaseTexture8
    STDMETHOD	Release, 			:PTR IDirect3DBaseTexture8

    ;IDirect3DResource8 methods

    STDMETHOD	GetDevice,    			:PTR IDirect3DBaseTexture8, :PTR PTR IDirect3DDevice8
    STDMETHOD	SetPrivateData,			:PTR IDirect3DBaseTexture8, :PTR, :PTR, :DWORD, :DWORD
    STDMETHOD	GetPrivateData,			:PTR IDirect3DBaseTexture8, :PTR, :PTR, :PTR DWORD
    STDMETHOD	FreePrivateData,		:PTR IDirect3DBaseTexture8, :PTR
    STDMETHOD	SetPriority,			:PTR IDirect3DBaseTexture8, :DWORD
    STDMETHOD	GetPriority,			:PTR IDirect3DBaseTexture8
    STDMETHOD	PreLoad,			:PTR IDirect3DBaseTexture8
    STDMETHOD	GetType,			:PTR IDirect3DBaseTexture8
    STDMETHOD	SetLOD,				:PTR IDirect3DBaseTexture8, :DWORD
    STDMETHOD	GetLOD,				:PTR IDirect3DBaseTexture8
    STDMETHOD	GetLevelCount,			:PTR IDirect3DBaseTexture8

IDirect3DBaseTexture8Vtbl ENDS

;==============================================================================
;  Direct3DTexture8    
;==============================================================================
IDirect3DTexture8Vtbl STRUC

    ;IUnknown methods

    STDMETHOD	QueryInterface, 	:PTR IDirect3DTexture8, :PTR, :PTR PTR
    STDMETHOD	AddRef, 		:PTR IDirect3DTexture8
    STDMETHOD	Release, 		:PTR IDirect3DTexture8

    ;IDirect3DBaseTexture8 methods

    STDMETHOD	GetDevice,    		:PTR IDirect3DTexture8, :PTR PTR IDirect3DDevice8
    STDMETHOD	SetPrivateData,		:PTR IDirect3DTexture8, :PTR, :PTR, :DWORD, :DWORD
    STDMETHOD	GetPrivateData,		:PTR IDirect3DTexture8, :PTR, :PTR, :PTR DWORD
    STDMETHOD	FreePrivateData,	:PTR IDirect3DTexture8, :PTR
    STDMETHOD	SetPriority,		:PTR IDirect3DTexture8, :DWORD
    STDMETHOD	GetPriority,		:PTR IDirect3DTexture8
    STDMETHOD	PreLoad,		:PTR IDirect3DTexture8
    STDMETHOD	GetType,		:PTR IDirect3DTexture8
    STDMETHOD	SetLOD,			:PTR IDirect3DTexture8, :DWORD
    STDMETHOD	GetLOD,			:PTR IDirect3DTexture8
    STDMETHOD	GetLevelCount,		:PTR IDirect3DTexture8
    STDMETHOD	GetLevelDesc,		:PTR IDirect3DTexture8, :UINT, :PTR D3DSURFACE_DESC
    STDMETHOD	GetSurfaceLevel,	:PTR IDirect3DTexture8, :UINT, :PTR PTR IDirect3DSurface8
    STDMETHOD	LockRect,		:PTR IDirect3DTexture8, :UINT, :PTR D3DLOCKED_RECT, :PTR RECT, :DWORD
    STDMETHOD	UnlockRect,		:PTR IDirect3DTexture8, :UINT 
    STDMETHOD	AddDirtyRect,		:PTR IDirect3DTexture8, :PTR RECT

IDirect3DTexture8Vtbl ENDS

;==============================================================================
;  Direct3DVolumeTexture8    
;==============================================================================
IDirect3DVolumeTexture8Vtbl STRUC

    ;IUnknown methods

    STDMETHOD	QueryInterface, 	:PTR IDirect3DVolumeTexture8, :PTR, :PTR PTR
    STDMETHOD	AddRef, 		:PTR IDirect3DVolumeTexture8
    STDMETHOD	Release, 		:PTR IDirect3DVolumeTexture8    

    ;IDirect3DBaseTexture8 methods

    STDMETHOD	GetDevice,    		:PTR IDirect3DVolumeTexture8 , :PTR PTR IDirect3DDevice8
    STDMETHOD	SetPrivateData,		:PTR IDirect3DVolumeTexture8 , :PTR, :PTR, :DWORD, :DWORD
    STDMETHOD	GetPrivateData,		:PTR IDirect3DVolumeTexture8 , :PTR, :PTR, :PTR DWORD
    STDMETHOD	FreePrivateData,	:PTR IDirect3DVolumeTexture8 , :PTR
    STDMETHOD	SetPriority,		:PTR IDirect3DVolumeTexture8 , :DWORD
    STDMETHOD	GetPriority,		:PTR IDirect3DVolumeTexture8 
    STDMETHOD	PreLoad,		:PTR IDirect3DVolumeTexture8 
    STDMETHOD	GetType,		:PTR IDirect3DVolumeTexture8 
    STDMETHOD	SetLOD,			:PTR IDirect3DVolumeTexture8 , :DWORD
    STDMETHOD	GetLOD,			:PTR IDirect3DVolumeTexture8 
    STDMETHOD	GetLevelCount,		:PTR IDirect3DVolumeTexture8 
    STDMETHOD	GetLevelDesc,		:PTR IDirect3DVolumeTexture8, :UINT, :PTR D3DVOLUME_DESC
    STDMETHOD	GetVolumeLevel,		:PTR IDirect3DVolumeTexture8, :UINT, :PTR PTR IDirect3DVolume8
    STDMETHOD	LockBox,		:PTR IDirect3DVolumeTexture8, :UINT, :PTR D3DLOCKED_BOX, :PTR D3DBOX, :DWORD
    STDMETHOD	UnlockBox,		:PTR IDirect3DVolumeTexture8, :UINT
    STDMETHOD	AddDirtyBox,		:PTR IDirect3DVolumeTexture8, :PTR D3DBOX

IDirect3DVolumeTexture8Vtbl ENDS

;==============================================================================
;  Direct3DCubeTexture8    
;==============================================================================
IDirect3DCubeTexture8Vtbl	STRUC

    ;IUnknown methods

    STDMETHOD	QueryInterface, 	:PTR IDirect3DCubeTexture8, :PTR, :PTR PTR
    STDMETHOD	AddRef, 		:PTR IDirect3DCubeTexture8
    STDMETHOD	Release, 		:PTR IDirect3DCubeTexture8   

    ;IDirect3DBaseTexture8 methods

    STDMETHOD	GetDevice,    		:PTR IDirect3DCubeTexture8, :PTR PTR IDirect3DDevice8
    STDMETHOD	SetPrivateData,		:PTR IDirect3DCubeTexture8, :PTR, :PTR, :DWORD, :DWORD
    STDMETHOD	GetPrivateData,		:PTR IDirect3DCubeTexture8, :PTR, :PTR, :PTR DWORD
    STDMETHOD	FreePrivateData,	:PTR IDirect3DCubeTexture8, :PTR
    STDMETHOD	SetPriority,		:PTR IDirect3DCubeTexture8, :DWORD
    STDMETHOD	GetPriority,		:PTR IDirect3DCubeTexture8 
    STDMETHOD	PreLoad,		:PTR IDirect3DCubeTexture8
    STDMETHOD	GetType,		:PTR IDirect3DCubeTexture8
    STDMETHOD	SetLOD,			:PTR IDirect3DCubeTexture8, :DWORD
    STDMETHOD	GetLOD,			:PTR IDirect3DCubeTexture8
    STDMETHOD	GetLevelCount,		:PTR IDirect3DCubeTexture8
    STDMETHOD	GetLevelDesc,		:PTR IDirect3DCubeTexture8, :UINT, :PTR D3DSURFACE_DESC
    STDMETHOD	GetCubeMapSurface,	:PTR IDirect3DCubeTexture8, :DWORD, :UINT, :PTR PTR IDirect3DSurface8
    STDMETHOD	LockRect,		:PTR IDirect3DCubeTexture8, :DWORD, :UINT, :PTR D3DLOCKED_RECT, :PTR RECT, :DWORD
    STDMETHOD	UnlockRect,		:PTR IDirect3DCubeTexture8, :DWORD, :UINT
    STDMETHOD	AddDirtyRect,		:PTR IDirect3DCubeTexture8, :DWORD, :PTR RECT

IDirect3DCubeTexture8Vtbl	ENDS

;==============================================================================
;  Direct3DVertexBuffer8    
;==============================================================================    
IDirect3DVertexBuffer8Vtbl	STRUC

    ;IUnknown methods

    STDMETHOD	QueryInterface, 	:PTR IDirect3DVertexBuffer8, :PTR, :PTR PTR
    STDMETHOD	AddRef, 		:PTR IDirect3DVertexBuffer8
    STDMETHOD	Release, 		:PTR IDirect3DVertexBuffer8 

    ;IDirect3DResource8 methods

    STDMETHOD	GetDevice,    		:PTR IDirect3DVertexBuffer8, :PTR PTR IDirect3DDevice8
    STDMETHOD	SetPrivateData,		:PTR IDirect3DVertexBuffer8, :PTR, :PTR, :DWORD, :DWORD
    STDMETHOD	GetPrivateData,		:PTR IDirect3DVertexBuffer8, :PTR, :PTR, :PTR DWORD
    STDMETHOD	FreePrivateData,	:PTR IDirect3DVertexBuffer8, :PTR
    STDMETHOD	SetPriority,		:PTR IDirect3DVertexBuffer8, :DWORD
    STDMETHOD	GetPriority,		:PTR IDirect3DVertexBuffer8  
    STDMETHOD	PreLoad,		:PTR IDirect3DVertexBuffer8 
    STDMETHOD	GetType,		:PTR IDirect3DVertexBuffer8 
    STDMETHOD	Lock1,			:PTR IDirect3DVertexBuffer8, :UINT, :UINT, :PTR BYTE, :DWORD 
    STDMETHOD	Unlock,			:PTR IDirect3DVertexBuffer8
    STDMETHOD	GetDesc,		:PTR IDirect3DVertexBuffer8, :PTR D3DVERTEXBUFFER_DESC

IDirect3DVertexBuffer8Vtbl	ENDS

;==============================================================================
; Direct3DIndexBuffer8     
;==============================================================================    
IDirect3DIndexBuffer8Vtbl	STRUC

    ;IUnknown methods

    STDMETHOD	QueryInterface, 	:PTR IDirect3DIndexBuffer8, :PTR, :PTR PTR
    STDMETHOD	AddRef, 		:PTR IDirect3DIndexBuffer8
    STDMETHOD	Release, 		:PTR IDirect3DIndexBuffer8

    ;IDirect3DResource8 methods

    STDMETHOD	GetDevice,		:PTR IDirect3DIndexBuffer8, :PTR PTR IDirect3DDevice8
    STDMETHOD	SetPrivateData,		:PTR IDirect3DIndexBuffer8, :PTR, :PTR, :DWORD, :DWORD
    STDMETHOD	GetPrivateData,		:PTR IDirect3DIndexBuffer8, :PTR, :PTR, :PTR DWORD
    STDMETHOD	FreePrivateData,	:PTR IDirect3DIndexBuffer8, :PTR
    STDMETHOD	SetPriority,		:PTR IDirect3DIndexBuffer8, :DWORD
    STDMETHOD	GetPriority,		:PTR IDirect3DIndexBuffer8
    STDMETHOD	PreLoad,		:PTR IDirect3DIndexBuffer8	
    STDMETHOD	GetType,		:PTR IDirect3DIndexBuffer8
    STDMETHOD	Lock1,			:PTR IDirect3DIndexBuffer8, :UINT, :UINT, :PTR PTR BYTE, :DWORD
    STDMETHOD	Unlock,			:PTR IDirect3DIndexBuffer8
    STDMETHOD	GetDesc,		:PTR IDirect3DIndexBuffer8, :PTR D3DINDEXBUFFER_DESC

IDirect3DIndexBuffer8Vtbl	ENDS

;==============================================================================
; Direct3DSurface8     
;==============================================================================    
IDirect3DSurface8Vtbl	STRUC

    ;IUnknown methods

    STDMETHOD	QueryInterface, 	:PTR IDirect3DSurface8, :PTR, :PTR PTR
    STDMETHOD	AddRef, 		:PTR IDirect3DSurface8
    STDMETHOD	Release, 		:PTR IDirect3DSurface8

    ;IDirect3DSurface8 methods

    STDMETHOD	GetDevice,		:PTR IDirect3DSurface8, :PTR PTR IDirect3DDevice8
    STDMETHOD	SetPrivateData,		:PTR IDirect3DSurface8, :PTR, :PTR, :DWORD, :DWORD
    STDMETHOD	GetPrivateData,		:PTR IDirect3DSurface8, :PTR, :PTR, :PTR DWORD
    STDMETHOD	FreePrivateData,	:PTR IDirect3DSurface8, :PTR
    STDMETHOD	GetContainer,		:PTR IDirect3DSurface8, :PTR, :PTR PTR
    STDMETHOD	GetDesc,		:PTR IDirect3DSurface8, :PTR D3DSURFACE_DESC
    STDMETHOD	LockRect,    		:PTR IDirect3DSurface8, :PTR D3DLOCKED_RECT, :PTR RECT, :DWORD
    STDMETHOD	UnlockRect,		:PTR IDirect3DSurface8

IDirect3DSurface8Vtbl	ENDS

;==============================================================================
; Direct3DVolume8     
;==============================================================================    
IDirect3DVolume8Vtbl	STRUC

    ;IUnknown methods

    STDMETHOD	QueryInterface, 	:PTR IDirect3DVolume8, :PTR, :PTR PTR
    STDMETHOD	AddRef, 		:PTR IDirect3DVolume8
    STDMETHOD	Release, 		:PTR IDirect3DVolume8

    ;IDirect3DVolume8 methods

    STDMETHOD	GetDevice,		:PTR IDirect3DVolume8, :PTR PTR IDirect3DDevice8
    STDMETHOD	SetPrivateData,		:PTR IDirect3DVolume8, :PTR, :PTR, :DWORD, :DWORD
    STDMETHOD	GetPrivateData,		:PTR IDirect3DVolume8, :PTR, :PTR, :PTR DWORD
    STDMETHOD	FreePrivateData,	:PTR IDirect3DVolume8, :PTR
    STDMETHOD	GetContainer,		:PTR IDirect3DVolume8, :PTR, :PTR PTR
    STDMETHOD	GetDesc,		:PTR IDirect3DVolume8, :PTR D3DVOLUME_DESC
    STDMETHOD	LockBox,		:PTR IDirect3DVolume8, :PTR D3DLOCKED_BOX, :PTR D3DBOX, :DWORD
    STDMETHOD	UnlockBox,		:PTR IDirect3DVolume8

IDirect3DVolume8Vtbl	ENDS

;******************************************************************************
; Flags for SetPrivateData method on all D3D8 interfaces
;
; The passed pointer is an IUnknown ptr. The SizeOfData argument to SetPrivateData
; must be set to sizeof(IUnknown*). Direct3D will call AddRef through this
; pointer and Release when the private data is destroyed. The data will be
; destroyed when another SetPrivateData with the same GUID is set, when
; FreePrivateData is called, or when the D3D8 object is freed.
;******************************************************************************

  D3DSPD_IUNKNOWN					EQU	00000001h

; Parameter for IDirect3D8 Enum and GetCaps8 functions to get the info for
; the current mode only.
;------------------------------------------------------------------------------
  D3DCURRENT_DISPLAY_MODE				EQU   	00EFFFFFh

; Flags for IDirect3D8::CreateDevice's BehaviorFlags
;------------------------------------------------------------------------------
  D3DCREATE_FPU_PRESERVE     				EQU    	00000002h
  D3DCREATE_MULTITHREADED       			EQU    	00000004h
  D3DCREATE_PUREDEVICE             			EQU     00000010h
  D3DCREATE_SOFTWARE_VERTEXPROCESSING  			EQU   	00000020h
  D3DCREATE_HARDWARE_VERTEXPROCESSING   		EQU  	00000040h
  D3DCREATE_MIXED_VERTEXPROCESSING       		EQU 	00000080h
  D3DCREATE_DISABLE_DRIVER_MANAGEMENT    		EQU	00000100h

; Parameter for IDirect3D8::CreateDevice's iAdapter
;------------------------------------------------------------------------------
  D3DADAPTER_DEFAULT               			EQU   	00000000h

; Flags for IDirect3D8::EnumAdapters
;------------------------------------------------------------------------------
  D3DENUM_NO_WHQL_LEVEL        				EQU    	00000002h

; Maximum number of back-buffers supported in DX8
;------------------------------------------------------------------------------
  D3DPRESENT_BACK_BUFFERS_MAX          			EQU   	00000003h

; Flags for IDirect3DDevice8::SetGammaRamp
;------------------------------------------------------------------------------
  D3DSGR_NO_CALIBRATION    				EQU   	00000000h
  D3DSGR_CALIBRATE      				EQU  	00000001h

; Flags for IDirect3DDevice8::SetCursorPosition
;------------------------------------------------------------------------------
  D3DCURSOR_IMMEDIATE_UPDATE    			EQU   	00000001h

;******************************************************************************
; Flags for DrawPrimitive/DrawIndexedPrimitive
;   Also valid for Begin/BeginIndexed
;   Also valid for VertexBuffer::CreateVertexBuffer
;******************************************************************************

;         ( MAKE_HRESULT( 1, 0x876, code ) )	
;   code = 2072   : 8 876 0818h
;        
; Direct3D Errors 
;------------------------------------------------------------------------------
  D3D_OK  EQU	S_OK 	;        .   = 0
					       
  D3DERR_WRONGTEXTUREFORMAT		  EQU	088760818h	;2072
  D3DERR_UNSUPPORTEDCOLOROPERATION	  EQU   088760819h	;2073
  D3DERR_UNSUPPORTEDCOLORARG		  EQU   08876081ah	;2074
  D3DERR_UNSUPPORTEDALPHAOPERATION        EQU	08876081bh	;2075
  D3DERR_UNSUPPORTEDALPHAARG              EQU	08876081ch	;2076
  D3DERR_TOOMANYOPERATIONS                EQU	08876081dh	;2077
  D3DERR_CONFLICTINGTEXTUREFILTER         EQU	08876081eh	;2078
  D3DERR_UNSUPPORTEDFACTORVALUE           EQU	08876081fh	;2079
  D3DERR_CONFLICTINGRENDERSTATE           EQU	088760821h	;2081
  D3DERR_UNSUPPORTEDTEXTUREFILTER         EQU	088760822h	;2082
  D3DERR_CONFLICTINGTEXTUREPALETTE        EQU	088760826h	;2086
  D3DERR_DRIVERINTERNALERROR              EQU	088760827h	;2087

  D3DERR_NOTFOUND                         EQU	088760866h	;2150
  D3DERR_MOREDATA                         EQU	088760867h	;2151
  D3DERR_DEVICELOST                       EQU	088760868h	;2152
  D3DERR_DEVICENOTRESET                   EQU	088760869h	;2153
  D3DERR_NOTAVAILABLE                     EQU	08876086ah	;2154
  D3DERR_OUTOFVIDEOMEMORY                 EQU	08876017ch	;380
  D3DERR_INVALIDDEVICE                    EQU	08876086bh	;2155
  D3DERR_INVALIDCALL                      EQU	08876086ch	;2156
  D3DERR_DRIVERINVALIDCALL                EQU	08876086dh	;2157