;========================================================================== 
;  File:   	d3dx8math.h ( MASM32 Beta version)
;  Content:	Direct3D include file
;
;      eYMax  
;          mybox@aib.ru
;         h  inc
;
;        MICROSOFT DIRECTX SDK 8.1
;     (       ;)
;=============================================================================

;include d3dx8.inc

;--------------------------------------------------------------------------------
;    
;--------------------------------------------------------------------------------
 STDMETHOD  MACRO  name, argl :VARARG
  
  LOCAL @tmp_a                     	;   
  LOCAL @tmp_b

  @tmp_a	TYPEDEF PROTO argl     ; 
  @tmp_b	TYPEDEF PTR @tmp_a     ;   
  name		@tmp_b		?

 ENDM
;--------------------------------------------------------------------------------
;   D3DXMatrixStack
;--------------------------------------------------------------------------------
 d3dms8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [ID3DXMatrixStackVtbl. func][eax], this
  ELSE
       INVOKE [ID3DXMatrixStackVtbl. func][eax], this, arglist
  ENDIF

 ENDM

;=============================================================================
; General purpose utilities
;=============================================================================
D3DX_PI		EQU  	3.141592654f
D3DX_1BYPI 	EQU	0.318309886f
;===========================================================================
; Vectors
;===========================================================================
D3DXVECTOR2	STRUC
    x	REAL4	?
    y   REAL4	?
D3DXVECTOR2	ENDS

D3DXVECTOR3	STRUC
    x	REAL4	?
    y   REAL4	?
    z   REAl4	?
D3DXVECTOR3	ENDS

D3DXVECTOR4	STRUC
    x	REAL4	?
    y   REAL4	?
    z   REAl4	?
    w	REAL4	?
D3DXVECTOR4	ENDS

D3DXMATRIX	STRUC
    _11		REAL4	?
    _12		REAL4	?
    _13		REAL4	?
    _14		REAL4	?
    _21		REAL4	?
    _22		REAL4	?
    _23		REAL4	?
    _24		REAL4	?
    _31		REAL4	?
    _32		REAL4	?
    _33		REAL4	?
    _34		REAL4	?
    _41		REAL4	?
    _42		REAL4	?
    _43		REAL4	?
    _44		REAL4	?    
D3DXMATRIX	ENDS
;===========================================================================
;    Quaternions
;===========================================================================
D3DXQUATERNION	STRUC
    x	REAL4	?
    y   REAL4	?
    z   REAl4	?
    w	REAL4	?
D3DXQUATERNION	ENDS
;===========================================================================
; Planes
;===========================================================================
D3DXPLANE	STRUC
    a	REAL4	?
    b   REAL4	?
    c1   REAl4	?
    d	REAL4	?
D3DXPLANE	ENDS
;===========================================================================
; Colors
;===========================================================================
;D3DXCOLOR( FLOAT r, FLOAT g, FLOAT b, FLOAT a );
;===========================================================================
;D3DX math functions:
;
; NOTE:
;  * All these functions can take the same object as in and out parameters.
;
;  * Out parameters are typically also returned as return values, so that
;    the output of one function may be used as a parameter to another.
;===========================================================================

D3DXVec2Length PROTO :DWORD		;( CONST D3DXVECTOR2 *pV );

;FLOAT D3DXVec2LengthSq
;    ( CONST D3DXVECTOR2 *pV );

;FLOAT D3DXVec2Dot
;    ( CONST D3DXVECTOR2 *pV1, CONST D3DXVECTOR2 *pV2 );

;// Z component of ((x1,y1,0) cross (x2,y2,0))
;FLOAT D3DXVec2CCW
;   ( CONST D3DXVECTOR2 *pV1, CONST D3DXVECTOR2 *pV2 );

;D3DXVECTOR2* D3DXVec2Add
;    ( D3DXVECTOR2 *pOut, CONST D3DXVECTOR2 *pV1, CONST D3DXVECTOR2 *pV2 );;;

;D3DXVECTOR2* D3DXVec2Subtract
;    ( D3DXVECTOR2 *pOut, CONST D3DXVECTOR2 *pV1, CONST D3DXVECTOR2 *pV2 );

;// Minimize each component.  x = min(x1, x2), y = min(y1, y2)
;D3DXVECTOR2* D3DXVec2Minimize
;    ( D3DXVECTOR2 *pOut, CONST D3DXVECTOR2 *pV1, CONST D3DXVECTOR2 *pV2 );

;// Maximize each component.  x = max(x1, x2), y = max(y1, y2)
;D3DXVECTOR2* D3DXVec2Maximize
;    ( D3DXVECTOR2 *pOut, CONST D3DXVECTOR2 *pV1, CONST D3DXVECTOR2 *pV2 );

;D3DXVECTOR2* D3DXVec2Scale
;    ( D3DXVECTOR2 *pOut, CONST D3DXVECTOR2 *pV, FLOAT s );

;// Linear interpolation. V1 + s(V2-V1)
;D3DXVECTOR2* D3DXVec2Lerp
;    ( D3DXVECTOR2 *pOut, CONST D3DXVECTOR2 *pV1, CONST D3DXVECTOR2 *pV2,
;      FLOAT s );
;
;// non-inline
;#ifdef __cplusplus
;extern "C" {
;#endif

;D3DXVECTOR2* WINAPI D3DXVec2Normalize
;    ( D3DXVECTOR2 *pOut, CONST D3DXVECTOR2 *pV );;

;// Hermite interpolation between position V1, tangent T1 (when s == 0)
;// and position V2, tangent T2 (when s == 1).
;D3DXVECTOR2* WINAPI D3DXVec2Hermite
;    ( D3DXVECTOR2 *pOut, CONST D3DXVECTOR2 *pV1, CONST D3DXVECTOR2 *pT1,
;      CONST D3DXVECTOR2 *pV2, CONST D3DXVECTOR2 *pT2, FLOAT s );

;// CatmullRom interpolation between V1 (when s == 0) and V2 (when s == 1)
;D3DXVECTOR2* WINAPI D3DXVec2CatmullRom
;    ( D3DXVECTOR2 *pOut, CONST D3DXVECTOR2 *pV0, CONST D3DXVECTOR2 *pV1,
;      CONST D3DXVECTOR2 *pV2, CONST D3DXVECTOR2 *pV3, FLOAT s );

;// Barycentric coordinates.  V1 + f(V2-V1) + g(V3-V1)
;D3DXVECTOR2* WINAPI D3DXVec2BaryCentric
;    ( D3DXVECTOR2 *pOut, CONST D3DXVECTOR2 *pV1, CONST D3DXVECTOR2 *pV2,
;      CONST D3DXVECTOR2 *pV3, FLOAT f, FLOAT g);

;// Transform (x, y, 0, 1) by matrix.
;D3DXVECTOR4* WINAPI D3DXVec2Transform
;    ( D3DXVECTOR4 *pOut, CONST D3DXVECTOR2 *pV, CONST D3DXMATRIX *pM );

;// Transform (x, y, 0, 1) by matrix, project result back into w=1.
;D3DXVECTOR2* WINAPI D3DXVec2TransformCoord
;    ( D3DXVECTOR2 *pOut, CONST D3DXVECTOR2 *pV, CONST D3DXMATRIX *pM );

;// Transform (x, y, 0, 0) by matrix.
;D3DXVECTOR2* WINAPI D3DXVec2TransformNormal
;    ( D3DXVECTOR2 *pOut, CONST D3DXVECTOR2 *pV, CONST D3DXMATRIX *pM );

;#ifdef __cplusplus
;}
;#endif


;//--------------------------
;// 3D Vector
;//--------------------------

;// inline

;FLOAT D3DXVec3Length
;    ( CONST D3DXVECTOR3 *pV );

;FLOAT D3DXVec3LengthSq
;    ( CONST D3DXVECTOR3 *pV );

;FLOAT D3DXVec3Dot
;    ( CONST D3DXVECTOR3 *pV1, CONST D3DXVECTOR3 *pV2 );

;D3DXVECTOR3* D3DXVec3Cross
;    ( D3DXVECTOR3 *pOut, CONST D3DXVECTOR3 *pV1, CONST D3DXVECTOR3 *pV2 );

;D3DXVECTOR3* D3DXVec3Add
;    ( D3DXVECTOR3 *pOut, CONST D3DXVECTOR3 *pV1, CONST D3DXVECTOR3 *pV2 );

;D3DXVECTOR3* D3DXVec3Subtract
;    ( D3DXVECTOR3 *pOut, CONST D3DXVECTOR3 *pV1, CONST D3DXVECTOR3 *pV2 );

;// Minimize each component.  x = min(x1, x2), y = min(y1, y2), ...
;D3DXVECTOR3* D3DXVec3Minimize
;    ( D3DXVECTOR3 *pOut, CONST D3DXVECTOR3 *pV1, CONST D3DXVECTOR3 *pV2 );

;// Maximize each component.  x = max(x1, x2), y = max(y1, y2), ...
;D3DXVECTOR3* D3DXVec3Maximize
;    ( D3DXVECTOR3 *pOut, CONST D3DXVECTOR3 *pV1, CONST D3DXVECTOR3 *pV2 );

;D3DXVECTOR3* D3DXVec3Scale
;    ( D3DXVECTOR3 *pOut, CONST D3DXVECTOR3 *pV, FLOAT s);

;// Linear interpolation. V1 + s(V2-V1)
;D3DXVECTOR3* D3DXVec3Lerp
;    ( D3DXVECTOR3 *pOut, CONST D3DXVECTOR3 *pV1, CONST D3DXVECTOR3 *pV2,
;      FLOAT s );

;// non-inline
;#ifdef __cplusplus
;extern "C" {
;#endif

;D3DXVECTOR3* WINAPI D3DXVec3Normalize
;   ( D3DXVECTOR3 *pOut, CONST D3DXVECTOR3 *pV );

;// Hermite interpolation between position V1, tangent T1 (when s == 0)
;// and position V2, tangent T2 (when s == 1).
;D3DXVECTOR3* WINAPI D3DXVec3Hermite
;    ( D3DXVECTOR3 *pOut, CONST D3DXVECTOR3 *pV1, CONST D3DXVECTOR3 *pT1,
;      CONST D3DXVECTOR3 *pV2, CONST D3DXVECTOR3 *pT2, FLOAT s );

;// CatmullRom interpolation between V1 (when s == 0) and V2 (when s == 1)
;D3DXVECTOR3* WINAPI D3DXVec3CatmullRom
;    ( D3DXVECTOR3 *pOut, CONST D3DXVECTOR3 *pV0, CONST D3DXVECTOR3 *pV1,
;      CONST D3DXVECTOR3 *pV2, CONST D3DXVECTOR3 *pV3, FLOAT s );

;// Barycentric coordinates.  V1 + f(V2-V1) + g(V3-V1)
;D3DXVECTOR3* WINAPI D3DXVec3BaryCentric
;    ( D3DXVECTOR3 *pOut, CONST D3DXVECTOR3 *pV1, CONST D3DXVECTOR3 *pV2,
;      CONST D3DXVECTOR3 *pV3, FLOAT f, FLOAT g);

;// Transform (x, y, z, 1) by matrix.
;D3DXVECTOR4* WINAPI D3DXVec3Transform
;    ( D3DXVECTOR4 *pOut, CONST D3DXVECTOR3 *pV, CONST D3DXMATRIX *pM );

;// Transform (x, y, z, 1) by matrix, project result back into w=1.
;D3DXVECTOR3* WINAPI D3DXVec3TransformCoord
;    ( D3DXVECTOR3 *pOut, CONST D3DXVECTOR3 *pV, CONST D3DXMATRIX *pM );

;// Transform (x, y, z, 0) by matrix.  If you transforming a normal by a 
;// non-affine matrix, the matrix you pass to this function should be the 
;// transpose of the inverse of the matrix you would use to transform a coord.
;D3DXVECTOR3* WINAPI D3DXVec3TransformNormal
;    ( D3DXVECTOR3 *pOut, CONST D3DXVECTOR3 *pV, CONST D3DXMATRIX *pM );

;// Project vector from object space into screen space
;D3DXVECTOR3* WINAPI D3DXVec3Project
;    ( D3DXVECTOR3 *pOut, CONST D3DXVECTOR3 *pV, CONST D3DVIEWPORT8 *pViewport,
;      CONST D3DXMATRIX *pProjection, CONST D3DXMATRIX *pView, CONST D3DXMATRIX *pWorld);

;// Project vector from screen space into object space
;D3DXVECTOR3* WINAPI D3DXVec3Unproject
;    ( D3DXVECTOR3 *pOut, CONST D3DXVECTOR3 *pV, CONST D3DVIEWPORT8 *pViewport,
;      CONST D3DXMATRIX *pProjection, CONST D3DXMATRIX *pView, CONST D3DXMATRIX *pWorld);

;#ifdef __cplusplus
;}
;#endif



;//--------------------------
;// 4D Vector
;//--------------------------

;// inline

;FLOAT D3DXVec4Length
;    ( CONST D3DXVECTOR4 *pV );

;FLOAT D3DXVec4LengthSq
;    ( CONST D3DXVECTOR4 *pV );

;FLOAT D3DXVec4Dot
;    ( CONST D3DXVECTOR4 *pV1, CONST D3DXVECTOR4 *pV2 );

;D3DXVECTOR4* D3DXVec4Add
;    ( D3DXVECTOR4 *pOut, CONST D3DXVECTOR4 *pV1, CONST D3DXVECTOR4 *pV2);

;D3DXVECTOR4* D3DXVec4Subtract
;    ( D3DXVECTOR4 *pOut, CONST D3DXVECTOR4 *pV1, CONST D3DXVECTOR4 *pV2);

;// Minimize each component.  x = min(x1, x2), y = min(y1, y2), ...
;D3DXVECTOR4* D3DXVec4Minimize
;    ( D3DXVECTOR4 *pOut, CONST D3DXVECTOR4 *pV1, CONST D3DXVECTOR4 *pV2);

;// Maximize each component.  x = max(x1, x2), y = max(y1, y2), ...
;D3DXVECTOR4* D3DXVec4Maximize
;    ( D3DXVECTOR4 *pOut, CONST D3DXVECTOR4 *pV1, CONST D3DXVECTOR4 *pV2);

;D3DXVECTOR4* D3DXVec4Scale
;    ( D3DXVECTOR4 *pOut, CONST D3DXVECTOR4 *pV, FLOAT s);

;// Linear interpolation. V1 + s(V2-V1)
;D3DXVECTOR4* D3DXVec4Lerp
;    ( D3DXVECTOR4 *pOut, CONST D3DXVECTOR4 *pV1, CONST D3DXVECTOR4 *pV2,
;      FLOAT s );

;// non-inline
;#ifdef __cplusplus
;extern "C" {
;#endif

;// Cross-product in 4 dimensions.
;D3DXVECTOR4* WINAPI D3DXVec4Cross
;    ( D3DXVECTOR4 *pOut, CONST D3DXVECTOR4 *pV1, CONST D3DXVECTOR4 *pV2,
;      CONST D3DXVECTOR4 *pV3);

;D3DXVECTOR4* WINAPI D3DXVec4Normalize
;    ( D3DXVECTOR4 *pOut, CONST D3DXVECTOR4 *pV )

;// Hermite interpolation between position V1, tangent T1 (when s == 0)
;// and position V2, tangent T2 (when s == 1).
;D3DXVECTOR4* WINAPI D3DXVec4Hermite
;    ( D3DXVECTOR4 *pOut, CONST D3DXVECTOR4 *pV1, CONST D3DXVECTOR4 *pT1,
;      CONST D3DXVECTOR4 *pV2, CONST D3DXVECTOR4 *pT2, FLOAT s );

;// CatmullRom interpolation between V1 (when s == 0) and V2 (when s == 1)
;D3DXVECTOR4* WINAPI D3DXVec4CatmullRom
;    ( D3DXVECTOR4 *pOut, CONST D3DXVECTOR4 *pV0, CONST D3DXVECTOR4 *pV1,
;      CONST D3DXVECTOR4 *pV2, CONST D3DXVECTOR4 *pV3, FLOAT s );

;// Barycentric coordinates.  V1 + f(V2-V1) + g(V3-V1)
;D3DXVECTOR4* WINAPI D3DXVec4BaryCentric
;    ( D3DXVECTOR4 *pOut, CONST D3DXVECTOR4 *pV1, CONST D3DXVECTOR4 *pV2,
;      CONST D3DXVECTOR4 *pV3, FLOAT f, FLOAT g);

;// Transform vector by matrix.
;D3DXVECTOR4* WINAPI D3DXVec4Transform
;    ( D3DXVECTOR4 *pOut, CONST D3DXVECTOR4 *pV, CONST D3DXMATRIX *pM );

;#ifdef __cplusplus
;}
;#endif


;//--------------------------
;// 4D Matrix
;//--------------------------

;// inline

D3DXMatrixIdentity PROTO :DWORD

;D3DXMATRIX* D3DXMatrixIdentity
;    ( D3DXMATRIX *pOut );

;BOOL D3DXMatrixIsIdentity
;    ( CONST D3DXMATRIX *pM );


;// non-inline
;#ifdef __cplusplus
;extern "C" {
;#endif

;FLOAT WINAPI D3DXMatrixfDeterminant
;    ( CONST D3DXMATRIX *pM );

;D3DXMATRIX* WINAPI D3DXMatrixTranspose
;    ( D3DXMATRIX *pOut, CONST D3DXMATRIX *pM );

;// Matrix multiplication.  The result represents the transformation M2
;// followed by the transformation M1.  (Out = M1 * M2)
;D3DXMATRIX* WINAPI D3DXMatrixMultiply
;    ( D3DXMATRIX *pOut, CONST D3DXMATRIX *pM1, CONST D3DXMATRIX *pM2 );

;// Matrix multiplication, followed by a transpose. (Out = T(M1 * M2))
;D3DXMATRIX* WINAPI D3DXMatrixMultiplyTranspose
;    ( D3DXMATRIX *pOut, CONST D3DXMATRIX *pM1, CONST D3DXMATRIX *pM2 );

;// Calculate inverse of matrix.  Inversion my fail, in which case NULL will
;// be returned.  The determinant of pM is also returned it pfDeterminant
;// is non-NULL.
;D3DXMATRIX* WINAPI D3DXMatrixInverse
;    ( D3DXMATRIX *pOut, FLOAT *pDeterminant, CONST D3DXMATRIX *pM );

;// Build a matrix which scales by (sx, sy, sz)
;D3DXMATRIX* WINAPI D3DXMatrixScaling
;    ( D3DXMATRIX *pOut, FLOAT sx, FLOAT sy, FLOAT sz );

;// Build a matrix which translates by (x, y, z)
;D3DXMATRIX* WINAPI D3DXMatrixTranslation
;    ( D3DXMATRIX *pOut, FLOAT x, FLOAT y, FLOAT z );

;// Build a matrix which rotates around the X axis
;D3DXMATRIX* WINAPI D3DXMatrixRotationX
;    ( D3DXMATRIX *pOut, FLOAT Angle );


D3DXMatrixRotationY PROTO :DWORD, :DWORD

;// Build a matrix which rotates around the Y axis
;D3DXMATRIX* WINAPI D3DXMatrixRotationY
;    ( D3DXMATRIX *pOut, FLOAT Angle );

;// Build a matrix which rotates around the Z axis
;D3DXMATRIX* WINAPI D3DXMatrixRotationZ
;    ( D3DXMATRIX *pOut, FLOAT Angle );

;// Build a matrix which rotates around an arbitrary axis
;D3DXMATRIX* WINAPI D3DXMatrixRotationAxis
;    ( D3DXMATRIX *pOut, CONST D3DXVECTOR3 *pV, FLOAT Angle );

;// Build a matrix from a quaternion
;D3DXMATRIX* WINAPI D3DXMatrixRotationQuaternion
;    ( D3DXMATRIX *pOut, CONST D3DXQUATERNION *pQ);

;// Yaw around the Y axis, a pitch around the X axis,
;// and a roll around the Z axis.
;D3DXMATRIX* WINAPI D3DXMatrixRotationYawPitchRoll
;    ( D3DXMATRIX *pOut, FLOAT Yaw, FLOAT Pitch, FLOAT Roll );


;// Build transformation matrix.  NULL arguments are treated as identity.
;// Mout = Msc-1 * Msr-1 * Ms * Msr * Msc * Mrc-1 * Mr * Mrc * Mt
;D3DXMATRIX* WINAPI D3DXMatrixTransformation
;    ( D3DXMATRIX *pOut, CONST D3DXVECTOR3 *pScalingCenter,
;      CONST D3DXQUATERNION *pScalingRotation, CONST D3DXVECTOR3 *pScaling,
;      CONST D3DXVECTOR3 *pRotationCenter, CONST D3DXQUATERNION *pRotation,
;      CONST D3DXVECTOR3 *pTranslation);

;// Build affine transformation matrix.  NULL arguments are treated as identity.
;// Mout = Ms * Mrc-1 * Mr * Mrc * Mt
;D3DXMATRIX* WINAPI D3DXMatrixAffineTransformation
;    ( D3DXMATRIX *pOut, FLOAT Scaling, CONST D3DXVECTOR3 *pRotationCenter,
;      CONST D3DXQUATERNION *pRotation, CONST D3DXVECTOR3 *pTranslation);

;// Build a lookat matrix. (right-handed)
;D3DXMATRIX* WINAPI D3DXMatrixLookAtRH
;    ( D3DXMATRIX *pOut, CONST D3DXVECTOR3 *pEye, CONST D3DXVECTOR3 *pAt,
;      CONST D3DXVECTOR3 *pUp );

D3DXMatrixLookAtLH PROTO :DWORD, :DWORD, :DWORD, :DWORD

;// Build a lookat matrix. (left-handed)
;D3DXMATRIX* WINAPI D3DXMatrixLookAtLH
;    ( D3DXMATRIX *pOut, CONST D3DXVECTOR3 *pEye, CONST D3DXVECTOR3 *pAt,
;      CONST D3DXVECTOR3 *pUp );

;// Build a perspective projection matrix. (right-handed)
;D3DXMATRIX* WINAPI D3DXMatrixPerspectiveRH
;    ( D3DXMATRIX *pOut, FLOAT w, FLOAT h, FLOAT zn, FLOAT zf );

;// Build a perspective projection matrix. (left-handed)
;D3DXMATRIX* WINAPI D3DXMatrixPerspectiveLH
;    ( D3DXMATRIX *pOut, FLOAT w, FLOAT h, FLOAT zn, FLOAT zf );

;// Build a perspective projection matrix. (right-handed)
;D3DXMATRIX* WINAPI D3DXMatrixPerspectiveFovRH
;    ( D3DXMATRIX *pOut, FLOAT fovy, FLOAT Aspect, FLOAT zn, FLOAT zf );

D3DXMatrixPerspectiveFovLH PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD

;// Build a perspective projection matrix. (left-handed)
;D3DXMATRIX* WINAPI D3DXMatrixPerspectiveFovLH
;    ( D3DXMATRIX *pOut, FLOAT fovy, FLOAT Aspect, FLOAT zn, FLOAT zf );

;// Build a perspective projection matrix. (right-handed)
;D3DXMATRIX* WINAPI D3DXMatrixPerspectiveOffCenterRH
;    ( D3DXMATRIX *pOut, FLOAT l, FLOAT r, FLOAT b, FLOAT t, FLOAT zn,
;      FLOAT zf );

;// Build a perspective projection matrix. (left-handed)
;D3DXMATRIX* WINAPI D3DXMatrixPerspectiveOffCenterLH
;    ( D3DXMATRIX *pOut, FLOAT l, FLOAT r, FLOAT b, FLOAT t, FLOAT zn,
;      FLOAT zf );

;// Build an ortho projection matrix. (right-handed)
;D3DXMATRIX* WINAPI D3DXMatrixOrthoRH
;    ( D3DXMATRIX *pOut, FLOAT w, FLOAT h, FLOAT zn, FLOAT zf );

;// Build an ortho projection matrix. (left-handed)
;D3DXMATRIX* WINAPI D3DXMatrixOrthoLH
;    ( D3DXMATRIX *pOut, FLOAT w, FLOAT h, FLOAT zn, FLOAT zf );

;// Build an ortho projection matrix. (right-handed)
;D3DXMATRIX* WINAPI D3DXMatrixOrthoOffCenterRH
;    ( D3DXMATRIX *pOut, FLOAT l, FLOAT r, FLOAT b, FLOAT t, FLOAT zn,
;      FLOAT zf );

;// Build an ortho projection matrix. (left-handed)
;D3DXMATRIX* WINAPI D3DXMatrixOrthoOffCenterLH
;    ( D3DXMATRIX *pOut, FLOAT l, FLOAT r, FLOAT b, FLOAT t, FLOAT zn,
;      FLOAT zf );

;// Build a matrix which flattens geometry into a plane, as if casting
;// a shadow from a light.
;D3DXMATRIX* WINAPI D3DXMatrixShadow
;    ( D3DXMATRIX *pOut, CONST D3DXVECTOR4 *pLight,
;      CONST D3DXPLANE *pPlane );

;// Build a matrix which reflects the coordinate system about a plane
;D3DXMATRIX* WINAPI D3DXMatrixReflect
;    ( D3DXMATRIX *pOut, CONST D3DXPLANE *pPlane );

;#ifdef __cplusplus
;}
;#endif


;//--------------------------
;// Quaternion
;//--------------------------

;// inline

;FLOAT D3DXQuaternionLength
;    ( CONST D3DXQUATERNION *pQ );

;// Length squared, or "norm"
;FLOAT D3DXQuaternionLengthSq
;    ( CONST D3DXQUATERNION *pQ );

;FLOAT D3DXQuaternionDot
;    ( CONST D3DXQUATERNION *pQ1, CONST D3DXQUATERNION *pQ2 );

;// (0, 0, 0, 1)
;D3DXQUATERNION* D3DXQuaternionIdentity
;    ( D3DXQUATERNION *pOut );

;BOOL D3DXQuaternionIsIdentity
;    ( CONST D3DXQUATERNION *pQ );

;// (-x, -y, -z, w)
;D3DXQUATERNION* D3DXQuaternionConjugate
;    ( D3DXQUATERNION *pOut, CONST D3DXQUATERNION *pQ );


;// non-inline
;#ifdef __cplusplus
;extern "C" {
;#endif

;// Compute a quaternin's axis and angle of rotation. Expects unit quaternions.
;void WINAPI D3DXQuaternionToAxisAngle
;    ( CONST D3DXQUATERNION *pQ, D3DXVECTOR3 *pAxis, FLOAT *pAngle );

;// Build a quaternion from a rotation matrix.
;D3DXQUATERNION* WINAPI D3DXQuaternionRotationMatrix
;    ( D3DXQUATERNION *pOut, CONST D3DXMATRIX *pM);

;// Rotation about arbitrary axis.
;D3DXQUATERNION* WINAPI D3DXQuaternionRotationAxis
;    ( D3DXQUATERNION *pOut, CONST D3DXVECTOR3 *pV, FLOAT Angle );

;// Yaw around the Y axis, a pitch around the X axis,
;// and a roll around the Z axis.
;D3DXQUATERNION* WINAPI D3DXQuaternionRotationYawPitchRoll
;    ( D3DXQUATERNION *pOut, FLOAT Yaw, FLOAT Pitch, FLOAT Roll );

;// Quaternion multiplication.  The result represents the rotation Q2
;// followed by the rotation Q1.  (Out = Q2 * Q1)
;D3DXQUATERNION* WINAPI D3DXQuaternionMultiply
;    ( D3DXQUATERNION *pOut, CONST D3DXQUATERNION *pQ1,
;      CONST D3DXQUATERNION *pQ2 );

;D3DXQUATERNION* WINAPI D3DXQuaternionNormalize
;    ( D3DXQUATERNION *pOut, CONST D3DXQUATERNION *pQ );

;// Conjugate and re-norm
;D3DXQUATERNION* WINAPI D3DXQuaternionInverse
;    ( D3DXQUATERNION *pOut, CONST D3DXQUATERNION *pQ );

;// Expects unit quaternions.
;// if q = (cos(theta), sin(theta) * v); ln(q) = (0, theta * v)
;D3DXQUATERNION* WINAPI D3DXQuaternionLn
;    ( D3DXQUATERNION *pOut, CONST D3DXQUATERNION *pQ );

;// Expects pure quaternions. (w == 0)  w is ignored in calculation.
;// if q = (0, theta * v); exp(q) = (cos(theta), sin(theta) * v)
;D3DXQUATERNION* WINAPI D3DXQuaternionExp
;    ( D3DXQUATERNION *pOut, CONST D3DXQUATERNION *pQ );
      
;// Spherical linear interpolation between Q1 (t == 0) and Q2 (t == 1).
;// Expects unit quaternions.
;D3DXQUATERNION* WINAPI D3DXQuaternionSlerp
;    ( D3DXQUATERNION *pOut, CONST D3DXQUATERNION *pQ1,
;      CONST D3DXQUATERNION *pQ2, FLOAT t )

;// Spherical quadrangle interpolation.
;// Slerp(Slerp(Q1, C, t), Slerp(A, B, t), 2t(1-t))
   D3DXQuaternionSquad		PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :REAL4	

											;Setup control points for spherical quadrangle interpolation
											;from Q1 to Q2.  The control points are chosen in such a way 
											;to ensure the continuity of tangents with adjacent segments.
   D3DXQuaternionSquadSetup	PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD	
											;Barycentric interpolation.
											;Slerp(Slerp(Q1, Q2, f+g), Slerp(Q1, Q3, f+g), g/(f+g))
   D3DXQuaternionBaryCentric	PROTO :DWORD, :DWORD, :DWORD, :DWORD, :REAL4, :REAl4	
;--------------------------
;Plane
;--------------------------					;ax + by + cz + dw
   D3DXPlaneDot		     PROTO :DWORD, :DWORD		
								;ax + by + cz + d
   D3DXPlaneDotCoord	     PROTO :DWORD, :DWORD		
								;ax + by + cz
   D3DXPlaneDotNormal	     PROTO :DWORD, :DWORD		
								;Normalize plane (so that |a,b,c| == 1)
   D3DXPlaneNormalize	     PROTO :DWORD, :DWORD		
								;Find the intersection between a plane and a line.  If the line is
								;parallel to the plane, NULL is returned.
   D3DXPlaneIntersectLine    PROTO :DWORD, :DWORD, :DWORD, :DWORD
								;Construct a plane from a point and a normal
   D3DXPlaneFromPointNormal  PROTO :DWORD, :DWORD, :DWORD	
								;Construct a plane from 3 points
   D3DXPlaneFromPoints	     PROTO :DWORD, :DWORD, :DWORD, :DWORD 
								;Transform a plane by a matrix.  The vector (a,b,c) must be normal.
								;M should be the inverse transpose of the transformation desired.
   D3DXPlaneTransform	     PROTO :DWORD, :DWORD, :DWORD	
								;Color
								;(1-r, 1-g, 1-b, a)
   D3DXColorNegative	     PROTO :DWORD, :DWORD	
   D3DXColorAdd		     PROTO :DWORD, :DWORD, :DWORD	
   D3DXColorSubtract 	     PROTO :DWORD, :DWORD, :DWORD	
   D3DXColorScale 	     PROTO :DWORD, :DWORD, :REAl4	
								;(r1*r2, g1*g2, b1*b2, a1*a2)
   D3DXColorModulate 	     PROTO :DWORD, :DWORD, :DWORD	
								;Linear interpolation of r,g,b, and a. C1 + s(C2-C1)
   D3DXColorLerp 	     PROTO :DWORD, :DWORD, :DWORD, :REAL4 
								;Interpolate r,g,b between desaturated color and color.
								;DesaturatedColor + s(Color - DesaturatedColor)
   D3DXColorAdjustSaturation PROTO :DWORD, :DWORD, :REAL4
								;Interpolate r,g,b between 50% grey and color.  Grey + s(Color - Grey)
   D3DXColorAdjustContrast   PROTO :DWORD, :DWORD, :REAl4	
								;Calculate Fresnel term given the cosine of theta (likely obtained by
								;taking the dot of two normals), and the refraction index of the material.
   D3DXFresnelTerm 	     PROTO :REAL4, :REAL4		

;===========================================================================
;    Matrix Stack
;===========================================================================
D3DXCreateMatrixStack	PROTO :DWORD, :DWORD   

EXTERNDEF  C IID_ID3DXMatrixStack:GUID

ID3DXMatrixStackVtbl	STRUC
    ;IUnknown methods
    STDMETHOD	QueryInterface, 	:PTR ID3DXMatrixStack, :PTR, :PTR PTR
    STDMETHOD	AddRef, 		:PTR ID3DXMatrixStack
    STDMETHOD	Release, 		:PTR ID3DXMatrixStack
    ;ID3DXMatrixStack methods
    					;Pops the top of the stack, returns the current top
    					;*after* popping the top.
    STDMETHOD	Pop1,			:PTR ID3DXMatrixStack
    					;Pushes the stack by one, duplicating the current matrix.
    STDMETHOD	Push1,			:PTR ID3DXMatrixStack
    					;Loads identity in the current matrix.
    STDMETHOD	LoadIdentity,		:PTR ID3DXMatrixStack
    					;Loads the given matrix into the current matrix
    STDMETHOD	LoadMatrix,		:PTR ID3DXMatrixStack, :PTR D3DXMATRIX
    					;Right-Multiplies the given matrix to the current matrix.
    					;(transformation is about the current world origin)
    STDMETHOD	MultMatrix,		:PTR ID3DXMatrixStack, :PTR D3DXMATRIX
    					;Left-Multiplies the given matrix to the current matrix
    					;(transformation is about the local origin of the object)
    STDMETHOD	MultMatrixLocal,	:PTR ID3DXMatrixStack, :PTR D3DXMATRIX
    					;Right multiply the current matrix with the computed rotation
    					;matrix, counterclockwise about the given axis with the given angle.
    					;(rotation is about the current world origin)
    STDMETHOD	RotateAxis,		:PTR ID3DXMatrixStack, :PTR D3DXVECTOR3, :REAL4
    					;Left multiply the current matrix with the computed rotation
    					;matrix, counterclockwise about the given axis with the given angle.
    					;(rotation is about the local origin of the object)
    STDMETHOD	RotateAxisLocal,	:PTR ID3DXMatrixStack, :PTR D3DXVECTOR3, :REAL4
    					;Right multiply the current matrix with the computed rotation
    					;matrix. All angles are counterclockwise. (rotation is about the
    					;current world origin)
    					;The rotation is composed of a yaw around the Y axis, a pitch around
    					;the X axis, and a roll around the Z axis.
    STDMETHOD	RotateYawPitchRoll,	:PTR ID3DXMatrixStack, :REAL4, :REAL4, :REAL4
    					;Left multiply the current matrix with the computed rotation
    					;matrix. All angles are counterclockwise. (rotation is about the
    					;local origin of the object)
    					;The rotation is composed of a yaw around the Y axis, a pitch around
    					;the X axis, and a roll around the Z axis.
    STDMETHOD	RotateYawPitchRollLocal,:PTR ID3DXMatrixStack, :REAL4, :REAL4, :REAL4
    					;Right multiply the current matrix with the computed scale
    					;matrix. (transformation is about the current world origin)
    STDMETHOD	Scale,			:PTR ID3DXMatrixStack, :REAL4, :REAL4, :REAL4
					;Left multiply the current matrix with the computed scale
    					;matrix. (transformation is about the local origin of the object)
    STDMETHOD	ScaleLocal,		:PTR ID3DXMatrixStack, :REAL4, :REAL4, :REAL4
    					;Right multiply the current matrix with the computed translation
    					;matrix. (transformation is about the current world origin)
    STDMETHOD	Translate,		:PTR ID3DXMatrixStack, :REAL4, :REAL4, :REAL4
    					;Left multiply the current matrix with the computed translation
    					;matrix. (transformation is about the local origin of the object)
    STDMETHOD	TranslateLocal,		:PTR ID3DXMatrixStack, :REAL4, :REAL4, :REAL4
    					;Obtain the current matrix at the top of the stack
    STDMETHOD	GetTop,			:PTR ID3DXMatrixStack

ID3DXMatrixStackVtbl	ENDS