;***********************************************************************************************************
;   3.      
;                 .   .
;     keYMax
;     mybox@aib.ru 
;***********************************************************************************************************
   .686                  ;      686
   .MMX                  ;    MMX 
   .XMM                  ;    SSE 
	
   .MODEL FLAT, STDCALL  ;      Win32
                         ; STDCALL -    

   OPTION CASEMAP:none   ;       
                         ;    . ;)
					
;===========================================================================================================
;          
;===========================================================================================================
   INCLUDE       \masm32\include\windows.inc     ; ,  ...    
   INCLUDE       \masm32\include\kernel32.inc    ;    ...
   INCLUDE       \masm32\include\user32.inc      ;  ...
   INCLUDE       \masm32\include\gdi32.inc       ;   ...
             
   INCLUDE       include\d3d8.inc                ;    Direct3D8
   INCLUDE       include\d3dx8math.inc           ;   
                
   INCLUDELIB    \masm32\lib\kernel32.lib
   INCLUDELIB    \masm32\lib\user32.lib
   INCLUDELIB    \masm32\lib\gdi32.lib

   INCLUDELIB    include\d3d8.lib                ;   Direct3D8
   INCLUDELIB    include\d3dx8d.lib

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

   Init_Direct3D         PROTO                               ;      
   Destroy_Direct3D      PROTO                               ; 
   Set_Render_Parameters PROTO                               ;
   
   Init_Scene            PROTO :DWORD                        ; 
   Render_Scene          PROTO                               ;
   Animate_Scene         PROTO                               ;    
    
   SetupDialog           PROTO :DWORD,:DWORD,:DWORD,:DWORD   ;     Dialog.asm
   DW2A                  PROTO :DWORD,:DWORD
        
.CONST ;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
.DATA ;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    szClassName    db  "MyClass", 0                          ;    
    szAppName      db  "Direct X 8.1  MASM32:  4 !", 0  ;    (          )
    szDialogName   db  "SetupDialog", 0
       
   ;WNDCLASSEX ------------------------------------------------ 
    cbSize         dd  12*4                       ;  
    style          dd  CS_HREDRAW or CS_VREDRAW   ;   
    lpfnWndProc    dd  OFFSET WndProc             ;    
    cbClsExtra     dd  0                          ;     
    cbWndExtra     dd  0                          ;   
    hInstance      dd  400000h                    ;     
    hIcon          dd  0                          ;     (  )
    hCursor        dd  65553                      ;     (    ID   )
    hbrBackground  dd  BLACK_PEN                  ;    
    lpszMenuName   dd  0                          ;    
    lpszClassName  dd  OFFSET szClassName         ;     
    hIconSm        dd  0                          ;     (  -    )
                         
.DATA? ;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    msg            MSG  <?>                       ;  
    hwnd           HWND ?                         ; ID      
        
.CODE ;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

Start:                                                        ;                      
   invoke  LoadCursor, NULL, IDC_ARROW			
   mov     hCursor, eax
		
   invoke  DialogBoxParam, hInstance , ADDR szDialogName , \  ;   
           NULL , OFFSET SetupDialog, NULL 
    
   invoke  ShowWindow, hwnd, SW_NORMAL                        ;  
   invoke  UpdateWindow, hwnd                                 ;  
   invoke  SetFocus, hwnd                                     ;    

   invoke  Init_Direct3D                                      ;  Direct3D
           
 msg_loop:
   invoke  PeekMessageA, ADDR msg, 0 , 0 , 0 , PM_NOREMOVE	  ;	
   test    eax, eax                                           ;
   jne     message                                            ;     ... 

   invoke  Render_Scene                                       ; ...     
   jmp     msg_loop                                           ;
   
 message:                                                     ;
   invoke  GetMessage, ADDR msg , NULL , 0 ,  0 
   test    eax, eax				
   je      end_loop

   invoke  TranslateMessage, ADDR msg     												
   invoke  DispatchMessage, ADDR msg      
   jmp     msg_loop

 end_loop:
   mov     eax, msg.wParam            ;     ,     
                                      ;    wParam  MSG. 
   invoke  ExitProcess, eax
   ret
;===========================================================================================================                                     
 WndProc proc hWnd:HWND , uMsg:UINT, wParam:WPARAM, lParam:LPARAM                                          
;=========================================================
   
   cmp     uMsg, WM_KEYDOWN           ;    ,       .
   je      wmKeydown
                   
   cmp     uMsg, WM_CREATE            ;    ,   
   je    wmCreate
            
   cmp     uMsg, WM_DESTROY           ;    ,     .
   je    wmDestroy	
         			                 
   invoke  DefWindowProc, hWnd, uMsg, wParam, lParam  ;       , 
   ret                                                ;    DefWindowProc   ,   .
                                                      ;   API     .
;-----------------------------------------------------------------------------------------------------------------------------------------                                                               
  wmDestroy:
;------------    
   invoke  Destroy_Direct3D                           ;         DirectX

   invoke  PostQuitMessage, NULL     
   xor     eax,eax                            
   ret                                         
;-----------------------------------------------------------------------------------------------------------------------------------------                                                               
  wmCreate:                                       
;-----------    
   xor     eax, eax 
   ret 
;-----------------------------------------------------------------------------------------------------------------------------------------    
  wmKeydown:
;-----------
   mov     eax, wParam
   cmp     eax, 27                                    ; 27 -   ESC
   jne     noExit
   invoke  SendMessage, hWnd , WM_CLOSE , NULL, NULL  ;       
   noExit:
   xor     eax,eax
   ret     
       
 WndProc endp
;===========================================================================================================
;    
;===========================================================================================================

INCLUDE  Dialog.asm  ;      SetupDialog  DW2A
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Init_Scene proc pd3dDev:DWORD
      
  .CONST
    
   D3DFVF_CUSTOMVERTEX equ D3DFVF_XYZ OR D3DFVF_DIFFUSE   ;      
   
  .DATA                                                  
                                                         
   xplus           dd 0.105f                              ;    X                             
   yplus           dd 0.0f                                ;    Y
   shiftx          dd 0.105f                              ;    X
   shifty          dd -0.105f                             ;    Y
   
   Text            dd 10001001100011001000100011001001b   ;  6*4  
                   dd 10001010010100001101100010101001b   ;       
                   dd 10101010010011001010100010101001b   
                   dd 10101010010000101000100011001001b
                   dd 10101011110100101000100010101001b                   
                   dd 01010010010011001000101010100110b                    
                   
   ;CountVertex     dd 24*360                             ;  
   CountData       dd (24*4)*360+24*4                     ;    
   CountPrimitive  dd 360*2+2                             ;  
   
   Vertices        dd 0.0f ,  0.0f , 0.0f , 0d1d0e7h      ;   (    )
                   dd 0.0f ,  0.1f , 0.0f , 0d1d0e7h      ; 4*4   
                   dd 0.1f , 0.1f , 0.0f , 0d1d0e7h       ; 12*4   
                                                          ; 24*4   
                   dd 0.0f , 0.0f , 0.0f , 0d1d0e7h
                   dd 0.1f ,  0.1f , 0.0f , 0d1d0e7h
                   dd 0.1f , 0.0f , 0.0f , 0d1d0e7h
   
   Fon             dd -1.0f ,  -6.0f , 1.5f , 0f1f0e7h    ;  - 2   
                   dd -1.0f ,  2.0f , 1.5f , 0b1b0a7h     ;   
                   dd 9.0f , 2.0f , 1.5f , 0f1f0e7h 

                   dd -1.0f , -6.0f , 1.5f , 0f1f0e7h 
                   dd 9.0f ,  2.0f , 1.5f , 0f1f0e7h 
                   dd 9.0f , -6.0f , 1.5f , 0FFFFFFh
  .DATA?
   pd3dVertexBuffer  dd  ?                                ;   VertexBuffer
   pLockBuffer       dd  ?                                ;    Vertex 
          
  .CODE               
      
   d3dev8  CreateVertexBuffer, pd3dDev, CountData, D3DUSAGE_WRITEONLY, D3DFVF_CUSTOMVERTEX , \
           D3DPOOL_MANAGED, ADDR pd3dVertexBuffer
            
   d3dvb8  Lock1, pd3dVertexBuffer, NULL, NULL, ADDR pLockBuffer, NULL
   
   lea     esi, Fon                             ;    2  
   mov     edi, pLockBuffer           
   mov     ecx, 24
   rep     movsd   

   push    edi
   mov     esi, edi                             ;     36                      
   push    10                                   ;  10  
   pop     ecx                                  ;     36*10 
   nextVertices3:                               ;     2 
   xor     ebx, ebx     
   push    ecx
   push    36
   pop     ecx
   nextVertices2:
   push    ecx
   lea     edi, Vertices
   push    6
   pop     ecx
   nextVertex:
   fld     DWORD PTR [edi]
   fadd    xplus
   fstp    DWORD PTR [esi]  
   fld     DWORD PTR [edi+4]
   fadd    yplus
   fstp    DWORD PTR [esi+4]
   push    DWORD PTR [edi+8]
   pop     DWORD PTR [esi+8]
   mov     eax, DWORD PTR [edi+12]   
   sub     eax, ebx
   mov     DWORD PTR [esi+12], eax     
   add     esi, 16
   add     edi, 16
   loop    nextVertex
   add     ebx, 00030303h
   fld     xplus
   fadd    shiftx
   fstp    xplus
   pop     ecx
   loop    nextVertices2
   push    shiftx
   pop     xplus
   fld     yplus
   fadd    shifty
   fstp    yplus   
   pop     ecx
   dec     ecx
   jnz     nextVertices3
   
   pop     esi                              ;  
   add     esi, 96*74
   lea     edi, Text
   push    6
   pop     ecx
   nextVert2:
   mov     ebx, 00FF0000h
   push    ecx
   mov     eax, [edi]
   push    32
   pop     ecx
   nextVert:
   shl     eax, 1 
   jnc     noMovColor
   mov     DWORD PTR [esi+12], ebx
   mov     DWORD PTR [esi+28], ebx
   mov     DWORD PTR [esi+44], ebx
   mov     DWORD PTR [esi+60], ebx
   mov     DWORD PTR [esi+76], ebx 
   mov     DWORD PTR [esi+92], ebx
   noMovColor:
   add     esi, 96
   sub     ebx, 00040000h
   loop    nextVert
   add     esi, 96*4
   add     edi, 4
   pop     ecx
   loop    nextVert2
       
   d3dvb8  Unlock, pd3dVertexBuffer
    
   ret
Init_Scene endp
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Init_Direct3D proc    ;  Direct3DDevice   WM_Create  ! (    :) )    			

  .DATA                
   ;-------------------------------------------  
   
   EyeVector    D3DVECTOR  <0.0f, 0.0f, -2.6f>  ;    
   LookAtVector D3DVECTOR  <3.0f, -1.0f, 3.0f>  ;    
   UpVector     D3DVECTOR  <0.0f, 2.0f, -0.8f>  ;  .   0.0,1.0,0.0
   
   FieldOfView    dd  0.7853981635f             ;        (D3DX_PI/4)
   AspectRatio    dd  NULL                      ; AspectRatio
   NearViewPlanZ  dd  1.0f                      ;   
   FarViewPlanZ   dd  10.0f                     ;   
         
  .DATA?
   pd3dDevice        dd  ?                      ;   Direct3DDevice
   
   WorldMatrix       D3DMATRIX  <?>             ;  
   ViewMatrix        D3DMATRIX  <?>             ;   
   ProjectionMatrix  D3DMATRIX  <?>             ;  
   
  .CODE    ;          Direct3D  SetupDialog  
           
   d3d8    CreateDevice, pd3d, D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hwnd , \  ;   Direct3DDevice8
           D3DCREATE_SOFTWARE_VERTEXPROCESSING, ADDR d3dpp, ADDR pd3dDevice             
   
   fild    d3dpp.BackBufferWidth    ;    
   fild    d3dpp.BackBufferHeight
   fdiv    
   fstp    AspectRatio
     
   invoke  D3DXMatrixRotationY, ADDR WorldMatrix, NULL   
   invoke  D3DXMatrixLookAtLH, ADDR ViewMatrix, ADDR EyeVector, ADDR LookAtVector, ADDR UpVector
   invoke  D3DXMatrixPerspectiveFovLH, ADDR ProjectionMatrix, FieldOfView, AspectRatio, NearViewPlanZ, FarViewPlanZ
   
   invoke  Init_Scene, pd3dDevice         
   invoke  Set_Render_Parameters
         
   ret
Init_Direct3D endp
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Destroy_Direct3D proc

   d3dev8  Release, pd3dVertexBuffer  ;  Vertex 
   d3dev8  Release, pd3dDevice        ;  Direct3DDevice8  
   d3d8    Release, pd3d              ;  Direct3D8   
    
   ret    
Destroy_Direct3D endp
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Set_Render_Parameters proc
   
   d3dev8  SetTransform, pd3dDevice, D3DTS_WORLD, ADDR WorldMatrix            ;    
   d3dev8  SetTransform, pd3dDevice, D3DTS_VIEW, ADDR ViewMatrix   
   d3dev8  SetTransform, pd3dDevice, D3DTS_PROJECTION, ADDR ProjectionMatrix
   
   d3dev8  SetRenderState, pd3dDevice, D3DRS_CULLMODE, D3DCULL_NONE           ; .   
   d3dev8  SetRenderState, pd3dDevice, D3DRS_LIGHTING, NULL                   ; . 
   d3dev8  SetRenderState, pd3dDevice, D3DRS_ZENABLE, D3DZB_TRUE              ; . Z 
   
   d3dev8  SetVertexShader, pd3dDevice, D3DFVF_CUSTOMVERTEX                   ;   
   d3dev8  SetStreamSource, pd3dDevice, 0 , pd3dVertexBuffer, 16              ;  
                                                                              ; 16 -    1     
   ret   
Set_Render_Parameters endp
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Render_Scene proc
  
  .DATA
   Zvalue      dd  1.0f
   clearcolor  dd  0                                       ;     Direct3D
    
  .CODE
   d3dev8  TestCooperativeLevel, pd3dDevice                ;  
   cmp     eax, D3DERR_DEVICELOST                          ;     
   jne     noreset                                         ;
   ret                                                     ;
   noreset:                                                ;
   cmp     eax, D3DERR_DEVICENOTRESET                      ;         
   jne     noreset2                                        ;
   d3dev8  Reset, pd3dDevice, ADDR d3dpp.BackBufferWidth   ;
   invoke  Set_Render_Parameters
   noreset2:                                               ;
   
   invoke  Animate_Scene
   
   d3dev8  Clear, pd3dDevice, 0 , NULL , D3DCLEAR_TARGET or D3DCLEAR_ZBUFFER , 0 , Zvalue , 0  ;  
   d3dev8  DrawPrimitive, pd3dDevice, D3DPT_TRIANGLELIST, 0 , CountPrimitive                   ;  
   d3dev8  Present, pd3dDevice, NULL, NULL, NULL, NULL                                         ;        

   ret
Render_Scene	endp
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Animate_Scene proc
   
   .DATA    
    x                 dd 0.1f
    x2                dd 0.0f
    z                 dd 0.0f
    zcoeff            dd 0.3f    
    zcorrect          dd 10.0f    
    sinx              dd 0.0f
   
   .DATA?
    checktime         dd ?
    color             db ?
    colorshift        db ?
    flag              dd ?
       
   .CODE

   invoke  GetTickCount             ;   
   mov     ebx, checktime           ;
   add     ebx, 50                  ;    
   cmp     eax, ebx                 ;
   jb      noColor                  ;     ,  
   mov     checktime, eax           ;
   
   cmp     flag, 1                  ;   ,  
   je      goDec                    ;       
   inc     color                    ;  
   cmp     color, 164
   jb      noxorFlag                ;      
   xor     flag, 1                  ;     
   noxorFlag:                       ;
   jmp     exitt                    ;
   goDec:                           ;
   dec     color                    ;
   cmp     color, 0                 ;
   ja      exitt                    ;
   xor     flag, 1                  ;
   add     colorshift, 8            ;
   cmp     colorshift, 24           ;
   jb      noincshift               ;
   mov     colorshift, 0            ;
   noincshift:

   exitt:

   d3dvb8  Lock1, pd3dVertexBuffer, NULL, CountData, ADDR pLockBuffer, NULL  ;  Vertex 
   
   mov     esi, pLockBuffer          ;   
   add     esi, 28
   movzx   eax, color
   movzx   ecx, colorshift
   shl     eax, cl
   mov     [esi], eax
   
   mov     edi, pLockBuffer          ;   Z  
   add     edi, 104
   fld     x2
   fadd    x
   fst     x2
   fstp    z
   push    36
   pop     ecx
   column:
   push    ecx   
   fld     z                        ;     Sin
   fsub    zcoeff
   fst     z
   fsin    
   fdiv    zcorrect
   fstp    sinx
   push    sinx
   pop     eax
   push    edi                      ;   Z
   push    10
   pop     ecx
   row:
   mov     DWORD PTR [edi], eax
   mov     DWORD PTR [edi+16], eax
   mov     DWORD PTR [edi+32], eax
   mov     DWORD PTR [edi+48], eax
   mov     DWORD PTR [edi+64], eax
   mov     DWORD PTR [edi+80], eax   
   add     edi, 96*36 
   loop    row
   pop     edi
   add     edi, 96   
   pop     ecx
   loop    column

   d3dvb8  Unlock, pd3dVertexBuffer        ;  Vertex 
   noColor:
   ret
Animate_Scene endp
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
end Start 
