;***********************************************************************************************************
;      SetupDialog  DW2A
;     keYMax
;     mybox@aib.ru 
;***********************************************************************************************************
SetupDialog proc hDlg:HWND , iMsg:DWORD , wParam:WPARAM , lParam:LPARAM

  .DATA    
   WinModeTable       dw 320,240,640,480,800,600,1024,768   ;     
                      dw 1280,1024,1600,1200
                      
   WinModeStrTable    dd OFFSET szMode1 , OFFSET szMode2    ;    
                      dd OFFSET szMode3 , OFFSET szMode4
                      dd OFFSET szMode5 , OFFSET szMode6
                      
   szMode1            db "320x240",0                        ;     
   szMode2            db "640x480",0   
   szMode3            db "800x600",0
   szMode4            db "1024x768",0
   szMode5            db "1280x1024",0
   szMode6            db "1600x1200",0  			

   ZBufferFormatTable db D3DFMT_D16                         ;  Z 
                      db D3DFMT_D16_LOCKABLE   
                      db D3DFMT_D24X8              
                      db D3DFMT_D32
                          
   ZBufferStrTable    dd OFFSET szZMode1 , OFFSET szZMode2  ;    
                      dd OFFSET szZMode3 , OFFSET szZMode4 
                      
   szZMode1           db "16 bit",0                         ;    Z 
   szZMode2           db "16 bit lock",0
   szZMode3           db "24 bit",0
   szZMode4           db "32 bit",0
         
   szDoubleBuffer     db "",0
   szTripleBuffer     db "",0
               
  .DATA?  				
    pd3d               dd ?                         ;   Direct3D			    
    d3ddm              D3DDISPLAYMODE < ? >         ;         		 
    d3dpp              D3DPRESENT_PARAMETERS < ? >  ;    Direct3DDevice8
       
    cmbHerz            dd ?                         ; ID ComboBox     
    cmbFullScreen      dd ?                         ; ID ComboBox  
    cmbWindow          dd ?                         ; ID ComboBox  
    cmbBackBuffer      dd ?                         ; ID ComboBox  BackBuffer
    cmbZBuffer         dd ?                         ; ID ComboBox  Z     
            
    FullModeTable      dd 50 dup (?)                ;      (    ).     4 
    FullModeBPPTable   db 50 dup (?)                ;    .      
    FullModeHerzTable  db 50 dup (?)                ;     .        
    FullModeStrBuffer  db 16 dup (?)                ;       ComboBox  
        
    rct                RECT <?>
     
  .CODE
    mov     eax, iMsg
   
    cmp     eax, WM_INITDIALOG                      ;           EAX  1 
    je     wmInitDialog                             ;             
                                                    ;    
    cmp     eax, WM_COMMAND
    je     wmCommandDialog 
          
    xor eax, eax
    ret
    
;-----------------------------------------------------------------------------------------------------------------------------------------   
  wmInitDialog:
;--------------
   pushad				         ;         Win98
   invoke  CheckRadioButton, hDlg , 20 , 21 , 20 ;    " "    ""
   
   lea     esi, cmbHerz                          ;    ComboBox
   push    5
   pop     ecx
   getId:
   push    ecx
   push    esi
   invoke  GetDlgItem, hDlg , ecx
   pop     esi
   pop     ecx
   mov     [esi+ecx*4-4],  eax
   loop    getId
            
   invoke  Direct3DCreate8, D3D_SDK_VERSION      ;  Direct3D 			
   mov     pd3d, eax                             ;    
   
   d3d8    GetAdapterDisplayMode, pd3d, D3DADAPTER_DEFAULT, ADDR d3dpp  ;       
   
   ;----------------------------------------------       
   lea     esi, d3dpp.BackBufferWidth
   mov     eax, [esi]			
   add     eax, [esi+4]                          ;     
   mov     ebx, [esi+12]                         ;       
   mov     [esi+8], ebx
   xor     ebx, ebx   
   
   getNextMode:                                  ;          
   push    ebx
   push    eax
   invoke  SendMessage, cmbWindow , CB_ADDSTRING , 0 , [WinModeStrTable + ebx*4] ;   ComboBox    
   pop     eax
   pop     ebx
   movzx   ecx, [WinModeTable+ebx*4]
   movzx   edx, [WinModeTable+ebx*4+2]
   add     ecx, edx   
   inc     ebx
   cmp     eax, ecx
   ja      getNextMode				
   
   ;    ComboBox             
   
   ;----------------------------------------------------        				   	
   d3d8	GetAdapterModeCount, pd3d, D3DADAPTER_DEFAULT  ;       
   dec    eax                                            ;    1, ..     0

   lea    esi, FullModeTable
   xor    ebx, ebx   
   mov    edx, ebx
   mov    ecx, eax         
   
   getMode:		
   push   ecx
   
   push   esi                                            ;    Direct3D  
   push   ebx                                            ;  
   push   edx
   
   d3d8   EnumAdapterModes, pd3d, D3DADAPTER_DEFAULT, ecx, ADDR d3ddm	;     
   mov    eax, d3ddm.Width1							
   mov    ecx, d3ddm.Height
   mov    edi, eax
   add    edi, ecx
   add    edi, d3ddm.Format                              ;  ,    
   
   pop    edx
   pop    ebx
   pop    esi   
   
   cmp    edx, edi                                       ;                  
   je     noAdd   
   mov    edx, d3ddm.RefreshRate                         ;          , 
   mov    BYTE PTR [FullModeHerzTable+ebx], dl           ;    
   mov    edx, d3ddm.Format
   mov    [FullModeBPPTable+ebx], dl 
   push   edx
   push   edi
   pop    edx
   pop    edi
   
   mov    [esi+ebx*4], eax
   mov    [esi+ebx*4+2], ecx
   inc    ebx   
   
   push   ebx       
   push   esi
   push   edx
   
   ;----------------------------------------------       Combobox
   invoke  DW2A, eax, ADDR FullModeStrBuffer
   mov     BYTE PTR [ebx], 'x'
   inc     ebx
   invoke  DW2A, ecx, ebx
   mov     BYTE PTR [ebx], 'x'
   inc     ebx
   push    16
   pop     ecx
   cmp     edi, D3DFMT_X8R8G8B8
   jne     nextFormat
   push    32
   pop     ecx
   nextFormat:   
   cmp     edi, D3DFMT_A8R8G8B8
   jne     nextFormat2
   push    32
   pop     ecx
   nextFormat2:
   cmp     edi, D3DFMT_R8G8B8
   jne     exitCompare
   push    24
   pop     ecx
   exitCompare:
   invoke  DW2A, ecx , ebx    ;        : 1024x768x32
   mov     BYTE PTR [ebx], 0       	
   invoke  SendMessage, cmbFullScreen , CB_ADDSTRING , 0 , ADDR FullModeStrBuffer	
   	   
   pop     edx
   pop     esi
   pop     ebx  	
     
   noAdd:   	
   pop     ecx
   dec     ecx
   test    ecx, ecx
   jne     getMode            ; LOOP    ..       128 
   
   ;    ComboBox          
   ;        
      
   invoke  SendMessage, cmbBackBuffer , CB_ADDSTRING , 0 , ADDR szDoubleBuffer   ;    ComboBox BackBuffer
   invoke  SendMessage, cmbBackBuffer , CB_ADDSTRING , 0 , ADDR szTripleBuffer   
   
   lea     esi, cmbHerz       ;       ComboBox
   push    3
   pop     ecx
   setSel:
   push    ecx
   push    esi
   invoke  SendMessage, [esi+ecx*4] , CB_SETCURSEL , 0 , 0
   pop     esi
   pop     ecx
   loop    setSel
   

   invoke  SendMessage, hDlg, WM_COMMAND ,  2 + CBN_SELCHANGE shl 16  , 0 ;     ComboBox 
                                                                          ;      Z 
                                                                                                                                                      
   popad                      ;         Win98
   xor    eax, eax
   inc    eax                 ;  1, ..    WM_INITDIALOG
   ret     
;------------------------------------------------------------------------------------------------------------------------------------------  
  wmCommandDialog:
;------------------------------------------    
   movzx  eax, WORD PTR wParam  ;     HIWORD  LOWORD  wParam
   mov    ecx, wParam           ; HIWORD -     
                                ; LOWORD - ID  
   xor    edx, edx
						
   cmp    eax, 10               ;     
   je     cmCloseDialog
   
   cmp    eax, 11               ;     
   je     cmCloseProgram
  
   cmp    eax, 20               ;    RadioButton " "
   je     cmRadioWin
   
   cmp    eax, 21               ;    RadioButton ""
   je     cmRadioFull
   
   cmp    ecx, 2 + CBN_SELCHANGE shl 16 ;      ComboBox  
   je     cmHerzZBuffer				
         
   xor    eax, eax
   ret   
                    
      cmRadioFull:  ;   ComboBox   
     ;------------
      inc     edx
   
      cmRadioWin:
     ;------------
      push    edx
      push    edx
      invoke  EnableWindow, cmbFullScreen , edx		
      pop     edx
      invoke  EnableWindow, cmbHerz , edx
      pop     edx
      
      xor     edx, 1
      invoke  EnableWindow, cmbWindow , edx  
      xor     eax, eax
      ret       
           
      cmHerzZBuffer: ;         ComboBox "" 
     ;-------------- 
      pushad     
      invoke  SendMessage, cmbHerz , CB_RESETCONTENT , 0 , 0           	
      invoke  SendMessage, cmbFullScreen , CB_GETCURSEL , 0 , 0
      movzx   ebx, BYTE PTR [FullModeHerzTable+eax]      
      push    eax
      invoke  DW2A, ebx , ADDR FullModeStrBuffer
      invoke  SendMessage, cmbHerz , CB_ADDSTRING , 0 , ADDR FullModeStrBuffer
      invoke  SendMessage, cmbHerz , CB_SETCURSEL , 0 , 0
      
      invoke  SendMessage, cmbZBuffer , CB_RESETCONTENT , 0 , 0
      pop     eax
      movzx   ebx, BYTE PTR [FullModeBPPTable+eax]
      lea     esi, ZBufferFormatTable
      lea     edi, ZBufferStrTable
      xor     ecx, ecx
      checkZFormat:
      push    ebx      
      push    edi
      push    esi
      push    ecx
      movzx   edx, BYTE PTR [esi+ecx]
      push    edx
      d3d8    CheckDepthStencilMatch, pd3d, D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, ebx, ebx, edx
      pop     edx
      pop     ecx
      test    eax, eax
      jne     noAddStr
      push    ecx
      push    edx
      invoke  SendMessage, cmbZBuffer , CB_ADDSTRING , 0 , [edi+ecx*4]    
      pop     edx
      push    edx
      invoke  SendMessage, cmbZBuffer , CB_SETITEMDATA , eax , edx
      pop     edx
      pop     ecx
      noAddStr:
      pop     esi
      pop     edi
      pop     ebx      
      inc     ecx
      cmp     ecx, 4
      jne     checkZFormat
      invoke  SendMessage, cmbZBuffer , CB_SETCURSEL , 0 , 0
      
      ;invoke  DW2A, eax , ADDR FullModeStrBuffer   
      ;invoke  MessageBox, NULL, ADDR FullModeStrBuffer, ADDR FullModeStrBuffer, NULL 

      popad      
      xor     eax, eax
      ret 
           
      cmCloseDialog: ;      D3DPRESENT_PARAMETERS
     ;--------------
      pushad
      invoke  RegisterClassEx, addr cbSize                       ;                                         
      
      invoke  SendMessage, cmbBackBuffer , CB_GETCURSEL , 0 , 0
      inc     eax
      inc     eax 
      mov     d3dpp.BackBufferCount, eax                         ;   BackBuffer       
      mov     d3dpp.SwapEffect, D3DSWAPEFFECT_FLIP               ;   
      mov     d3dpp.EnableAutoDepthStencil, TRUE                 ;  Z 
      invoke  SendMessage, cmbZBuffer , CB_GETCURSEL , 0 , 0     
      invoke  SendMessage, cmbZBuffer , CB_GETITEMDATA , eax , 0
      mov     d3dpp.AutoDepthStencilFormat, eax                  ;   Z 
                  
      invoke  IsDlgButtonChecked, hDlg , 20                      ;   RadioButton 
      test    eax, eax                                           ;      
      je      EnableFull
      invoke  SendMessage, cmbWindow , CB_GETCURSEL , 0 , 0
      lea     esi, WinModeTable
      shl     eax, 2
      add     esi, eax		
      xor     ecx, ecx
      mov     edx, ecx
      push    [esi]   		
      pop     cx                                                 ;     
      pop     dx 		 
      mov     ebx, d3dpp.BackBufferWidth                         ;        
      mov     eax, d3dpp.BackBufferHeight
      sub     eax, edx                                           ;   x  y     
      shr     eax, 1
      sub     ebx, ecx
      shr     ebx, 1
      mov     d3dpp.Windowed, 1                                  ;       
      mov     esi, WS_SYSMENU or WS_VISIBLE                      ;   
      jmp     Create
      EnableFull:
      invoke  SendMessage, cmbFullScreen , CB_GETCURSEL , 0 , 0
      movzx   ebx, BYTE PTR [FullModeHerzTable+eax]
      mov     d3dpp.FullScreen_RefreshRateInHz, ebx
      movzx   ebx, BYTE PTR [FullModeBPPTable+eax]
      mov     d3dpp.BackBufferFormat, ebx 
      mov     d3dpp.FullScreen_PresentationInterval, 1 ;D3DPRESENT_INTERVAL_IMMEDIATE      
      lea     esi, FullModeTable
      shl     eax, 2
      add     esi, eax
      push    [esi] 		
      xor     ecx, ecx
      mov     edx, ecx
      mov     eax, ecx
      mov     ebx, ecx
      mov     d3dpp.Windowed, ecx
      pop     cx
      pop     dx
      mov     esi, WS_POPUP or WS_VISIBLE
      Create:	;          D3DPRESENT_PARAMETERS
      invoke  CreateWindowEx, NULL , ADDR szClassName , ADDR szAppName ,  \
              esi , ebx ,  eax , ecx , edx , NULL , NULL , hInstance , NULL      
      mov     hwnd , eax
      invoke  GetClientRect, hwnd, ADDR rct       
      push    rct.right
      pop     d3dpp.BackBufferWidth
      push    rct.bottom
      pop     d3dpp.BackBufferHeight
      invoke  EndDialog, hDlg , 0     		
      
      popad
      xor     eax, eax
      ret
   		
      cmCloseProgram: 		
     ;---------------
      d3d8    Release, pd3d                       ;  Direct3D8            
      invoke  EndDialog, hDlg , 0                 ;          
      invoke  ExitProcess, 0                      ;    
      xor     eax, eax
      ret
      
SetupDialog endp
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DW2A proc dwValue:DWORD, lpBuffer:DWORD ; :  EAX -  ,  EBX -   
                                        ;      dw2a   masm32
   push    edx
   push    ecx
   push    esi
   push    edi
    		
   mov     eax, dwValue
   mov     edi, lpBuffer

   test    eax,eax
   jnz     sign
    
  zero:
   mov     word ptr [edi],30h
   ret    
  sign:
   jns     pos
   mov     byte ptr [edi],'-'
   neg     eax
   inc     edi
  pos:      
   mov     ecx,429496730
   mov     esi, edi

  nextDigit:
   mov     ebx,eax
   mul     ecx
   mov     eax,edx
   lea     edx,[edx*4+edx]
   add     edx,edx
   sub     ebx,edx
   add     bl,48
   mov     [edi],bl
   inc     edi
   cmp     eax, 0
   ja      nextDigit
   mov     byte ptr [edi], 0     
   push    edi
    
  nextMove:
   dec     edi
   mov     al, [esi]
   mov     ah, [edi]
   mov     [edi], al
   mov     [esi], ah
   inc     esi
   cmp     esi, edi
   jb      nextMove
    
   pop     eax
   mov     ebx, eax
   sub     eax, lpBuffer

   pop     edi
   pop     esi    
   pop     ecx
   pop     edx
    
   ret
DW2A endp