;========================================================================== 
;  File:   	d3dx8core.h ( MASM32 beta version  20  2003  )
;  Content:	Direct3D include file
;
;      eYMax  
;
;        MICROSOFT DIRECTX SDK 8.1
;     (       ;)
;=============================================================================

;--------------------------------------------------------------------------------
;    
;--------------------------------------------------------------------------------
 STDMETHOD  MACRO  name, argl :VARARG
  
  LOCAL @tmp_a                     	;   
  LOCAL @tmp_b

  @tmp_a	TYPEDEF PROTO argl     ; 
  @tmp_b	TYPEDEF PTR @tmp_a     ;   
  name		@tmp_b		?

 ENDM
 
;  ID3DXBuffer: The buffer object is used by D3DX to return arbitrary size data.
;  -----------------------------------------------------------------------------
;  GetBufferPointer 	- Returns a pointer to the beginning of the buffer.
;  GetBufferSize 	- Returns the size of the buffer, in bytes.

;EXTERNDEF  C IID_ID3DXBuffer:GUID	
;-------------------------------------------------------------------------------
;   Direct3DXBuffer8
;-------------------------------------------------------------------------------
 d3dxbuf8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [ID3DXBuffer8Vtbl. func][eax], this
  ELSE
       INVOKE [ID3DXBuffer8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM
 
;===============================================================================
; ID3DXBuffer8Vtbl     
;===============================================================================
 ID3DXBuffer8Vtbl	STRUC

    ;IUnknown methods
    
    STDMETHOD	QueryInterface, 	:PTR ID3DXBuffer, :PTR, :PTR PTR
    STDMETHOD	AddRef, 		:PTR ID3DXBuffer
    STDMETHOD	Release, 		:PTR ID3DXBuffer
    
    ;ID3DXBuffer8 methods
    
    STDMETHOD	GetBufferPointer,	:PTR ID3DXBuffer
    STDMETHOD	GetBufferSize,		:PTR ID3DXBuffer
    
 ID3DXBuffer8Vtbl	ENDS

; ID3DXFont: Font objects contain the textures and resources needed to render
;                 a specific font on a specific device.
; ------------------------------------------------------------------------------
; Begin 	- Prepartes device for drawing text.  This is optional.. if DrawText
;           	is called outside of Begin/End, it will call Begin and End for you.
;
; DrawText 	- Draws formatted text on a D3D device.  Some parameters are 
;    	        	surprisingly similar to those of GDIs DrawText function.  See GDI 
;    	        	documentation for a detailed description of these parameters.
;
; End 		- Restores device state to how it was when Begin was called.
;
; OnLostDevice,  	- Call OnLostDevice() on this object before calling Reset() on the
; OnResetDevice   	device, so that this object can release any stateblocks and video
;    			memory resources.  After Reset(), the call OnResetDevice().

;--------------------------------------------------------------------------------
;   Direct3DXFont8
;--------------------------------------------------------------------------------
 d3dxfont8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [ID3DXFont8Vtbl. func][eax], this
  ELSE
       INVOKE [ID3DXFont8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM
 
;EXTERNDEF  C IID_ID3DXFont:GUID
;===============================================================================
;  Direct3DXFont8    
;===============================================================================
 ID3DXFont8Vtbl	STRUC
    
    ;IUnknown methods
    
    STDMETHOD	QueryInterface, 	:PTR ID3DXFont, :PTR, :PTR PTR
    STDMETHOD	AddRef, 		:PTR ID3DXFont
    STDMETHOD	Release, 		:PTR ID3DXFont
    
    ;ID3DXFont8 methods
    
    STDMETHOD	GetDevice, 		:PTR ID3DXFont, :PTR PTR
    STDMETHOD	GetLogFont,		:PTR ID3DXFont    
    STDMETHOD	Begin,			:PTR ID3DXFont
    STDMETHOD	DrawTextA,		:PTR ID3DXFont, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD 
    STDMETHOD	DrawTextW,		:PTR ID3DXFont, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD 
    STDMETHOD	End1,			:PTR ID3DXFont    
    STDMETHOD	OnLostDevice,		:PTR ID3DXFont    
    STDMETHOD	OnResetDevice,	:PTR ID3DXFont       
    
 ID3DXFont8Vtbl	ENDS

 D3DXCreateFont		PROTO :DWORD, :DWORD, :DWORD ;( LPDIRECT3DDEVICE8   pDevice, HFONT hFont, LPD3DXFONT* ppFont)
 D3DXCreateFontIndirect	PROTO :DWORD, :DWORD, :DWORD ;( LPDIRECT3DDEVICE8   pDevice, HFONT hFont, LPD3DXFONT* ppFont)

;  ID3DXSprite: This object intends to provide an easy way to drawing sprites using D3D.
; ------------------------------------------------------------------------------
; Begin 		- Prepares device for drawing sprites
;
; Draw, 		- Draws a sprite in screen-space.  Before transformation, the sprite is
; DrawAffine, 		the size of SrcRect, with its top-left corner at the origin (0,0).  
; DrawTransform 	The color and alpha channels are modulated by Color.
;
; End 			- Restores device state to how it was when Begin was called.
;
; OnLostDevice,  	- Call OnLostDevice() on this object before calling Reset() on the
; OnResetDevice    	device, so that this object can release any stateblocks and video
;			memory resources.  After Reset(), the call OnResetDevice().

;--------------------------------------------------------------------------------
;   Direct3DXSprite8
;--------------------------------------------------------------------------------
 d3dxspr8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [ID3DXSprite8Vtbl. func][eax], this
  ELSE
       INVOKE [ID3DXSprite8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM

;EXTERNDEF  C IID_ID3DXSprite:GUID
;===============================================================================
;  Direct3DXSprite8    
;===============================================================================
 ID3DXSprite8Vtbl	STRUC
    
    ;IUnknown methods
    
    STDMETHOD	QueryInterface, 	:PTR ID3DXSprite, :PTR, :PTR PTR
    STDMETHOD	AddRef, 		:PTR ID3DXSprite
    STDMETHOD	Release, 		:PTR ID3DXSprite
    
    ;ID3DXFont8 methods
    
    STDMETHOD	GetDevice,		:PTR ID3DXSprite, :PTR PTR
    STDMETHOD	Begin,			:PTR ID3DXSprite
    STDMETHOD	Draw,			:PTR ID3DXSprite, :PTR , :PTR, :PTR, :PTR, :REAL4, :PTR, :DWORD
    STDMETHOD	DrawTransform,	:PTR ID3DXSprite, :PTR, :PTR, :PTR, :DWORD
    STDMETHOD	End1,			:PTR ID3DXSprite
    STDMETHOD	OnLostDevice,		:PTR ID3DXSprite
    STDMETHOD	OnResetDevice,	:PTR ID3DXSprite
        
 ID3DXSprite8Vtbl	ENDS

 D3DXCreateSprite PROTO :DWORD, :DWORD; (LPDIRECT3DDEVICE8   pDevice, LPD3DXSPRITE* ppSprite);

; ID3DXRenderToSurface: This object abstracts rendering to surfaces.  
; These surfaces do not necessarily need to be render targets.  If they are not,
; a compatible render target is used, and the result copied into surface at end scene.
; ------------------------------------------------------------------------------
; BeginScene, 		- Call BeginScene() and EndScene() at the beginning and ending of your
; EndScene     	scene.  These calls will setup and restore render targets, viewports, 
;    			etc.. 
;
; OnLostDevice, 	- Call OnLostDevice() on this object before calling Reset() on the
; OnResetDevice     	device, so that this object can release any stateblocks and video
;    			memory resources.  After Reset(), the call OnResetDevice().

 D3DXRTS_DESC STRUC

  Width1			UINT		?
  Height		UINT		?
  Format		DWORD	?;D3DFORMAT	?          
  DepthStencil		BOOL		?
  DepthStencilFormat	DWORD	?;D3DFORMAT	?

 D3DXRTS_DESC ENDS
;--------------------------------------------------------------------------------
;   Direct3DXRenderToSurface8
;--------------------------------------------------------------------------------
 d3dxrts8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [ID3DXRenderToSurface8Vtbl. func][eax], this
  ELSE
       INVOKE [ID3DXRenderToSurface8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM

;EXTERNDEF  C IID_ID3DXRenderToSurface:GUID
;===============================================================================
;  Direct3DXSprite8    
;===============================================================================
 ID3DXRenderToSurface8Vtbl	STRUC
    
    ;IUnknown methods
    
    STDMETHOD	QueryInterface, 	:PTR ID3DXRenderToSurface, :PTR, :PTR PTR
    STDMETHOD	AddRef, 		:PTR ID3DXRenderToSurface
    STDMETHOD	Release, 		:PTR ID3DXRenderToSurface
    
    ;ID3DXRenderToSurface methods
    
    STDMETHOD	GetDevice,		:PTR ID3DXRenderToSurface, :PTR PTR
    STDMETHOD	GetDesc,		:PTR ID3DXRenderToSurface, :PTR
    STDMETHOD	BeginScene,		:PTR ID3DXRenderToSurface, :DWORD, :PTR
    STDMETHOD	EndScene,		:PTR ID3DXRenderToSurface
    STDMETHOD	OnLostDevice,		:PTR ID3DXRenderToSurface
    STDMETHOD	OnResetDevice,	:PTR ID3DXRenderToSurface

 ID3DXRenderToSurface8Vtbl	ENDS

 D3DXCreateRenderToSurface	PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD

; ID3DXRenderToEnvMap: This object abstracts rendering to environment maps.  
; These surfaces do not necessarily need to be render targets.  If they are not, a 
; compatible render target is used, and the result copied into the
; environment map at end scene.
; ------------------------------------------------------------------------------
; BeginCube,  		- This function initiates the rendering of the environment map.  As
; BeginSphere,   	parameters, you pass the textures in which will get filled in with
; BeginHemisphere,	the resulting environment map.
; BeginParabolic   
;
; Face 			- Call this function to initiate the drawing of each face.  For each 
;    			environment map, you will call this six times.. once for each face 
;    			in D3DCUBEMAP_FACES.
;
; End 			- This will restore all render targets, and if needed compose all the
;			rendered faces into the environment map surfaces.
;
; OnLostDevice, 	- Call OnLostDevice() on this object before calling Reset() on the
; OnResetDevice	device, so that this object can release any stateblocks and video
;			memory resources.  After Reset(), the call OnResetDevice().

 D3DXRTE_DESC STRUC

    Size1				UINT        	?
    Format			DWORD	?;D3DFORMAT	?
    DepthStencil		BOOL		?
    DepthStencilFormat	DWORD	?;D3DFORMAT	?
    
 D3DXRTE_DESC ENDS

;--------------------------------------------------------------------------------
;   Direct3DXRenderToEnvMap8
;--------------------------------------------------------------------------------
 d3dxrte8  MACRO  func, this, arglist :VARARG

  mov   eax , [this]
  mov   eax , [eax]

  IFB <arglist>
       INVOKE [ID3DXRenderToEnvMap8Vtbl. func][eax], this
  ELSE
       INVOKE [ID3DXRenderToEnvMap8Vtbl. func][eax], this, arglist
  ENDIF

 ENDM

;EXTERNDEF  C IID_ID3DXRenderToEnvMap:GUID
;===============================================================================
;  Direct3DXSprite8    
;===============================================================================
 ID3DXRenderToEnvMap8Vtbl	STRUC
    
    ;IUnknown methods
    
    STDMETHOD	QueryInterface, 	:PTR ID3DXRenderToEnvMap, :PTR, :PTR PTR
    STDMETHOD	AddRef, 		:PTR ID3DXRenderToEnvMap
    STDMETHOD	Release, 		:PTR ID3DXRenderToEnvMap

    ;ID3DXRenderToEnvMap methods
    
    STDMETHOD	GetDevice,		:PTR ID3DXRenderToEnvMap, :PTR
    STDMETHOD	GetDesc,		:PTR ID3DXRenderToEnvMap, :PTR
    STDMETHOD	BeginCube,		:PTR ID3DXRenderToEnvMap, :DWORD
    STDMETHOD	BeginSphere,		:PTR ID3DXRenderToEnvMap, :DWORD
    STDMETHOD	BeginHemisphere,	:PTR ID3DXRenderToEnvMap, :DWORD, :DWORD
    STDMETHOD	BeginParabolic,		:PTR ID3DXRenderToEnvMap, :DWORD, :DWORD
    STDMETHOD	Face,			:PTR ID3DXRenderToEnvMap, :DWORD
    STDMETHOD	End1,			:PTR ID3DXRenderToEnvMap

    STDMETHOD	OnLostDevice,		:PTR ID3DXRenderToEnvMap
    STDMETHOD	OnResetDevice,	:PTR ID3DXRenderToEnvMap
    
 ID3DXRenderToEnvMap8Vtbl	ENDS

 D3DXCreateRenderToEnvMap PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD

; Shader assemblers:
;-------------------------------------------------------------------------------
; D3DXASM flags:	D3DXASM_DEBUG - Generate debug info.
;			D3DXASM_SKIPVALIDATION - 
;   			Do not validate the generated code against known capabilities and
;			constraints.  This option is only recommended when assembling shaders
;			you KNOW will work.  (ie. have assembled before without this option.)

 D3DXASM_DEBUG		EQU	00000001h	;(1 << 0)
 D3DXASM_SKIPVALIDATION  	EQU	00000002h	;(1 << 1)

; D3DXAssembleShader: Assembles an ascii description of a vertex or pixel shader into 
; binary form.
; ------------------------------------------------------------------------------
; Parameters: 	pSrcFile 		- Source file name
;  	   	hSrcModule		- Module handle. if NULL, current module will be used.
;		pSrcResource		- Resource name in module
;		pSrcData		- Pointer to source code
;		SrcDataLen		- Size of source code, in bytes
;  		Flags			- D3DXASM_xxx flags
;  		ppConstants		- Returns an ID3DXBuffer object containing constant declarations.
;  		ppCompiledShader	- Returns an ID3DXBuffer object containing the object code.
;  		ppCompilationErrors	- Returns an ID3DXBuffer object containing ascii error messages

 D3DXAssembleShaderFromFileA		PROTO :DWORD, :DWORD, :DWORD,:DWORD, :DWORD, :DWORD
 D3DXAssembleShaderFromFileW		PROTO :DWORD, :DWORD, :DWORD,:DWORD, :DWORD, :DWORD
 D3DXAssembleShaderFromResourceA 		PROTO :DWORD, :DWORD, :DWORD,:DWORD, :DWORD, :DWORD
 D3DXAssembleShaderFromResourceW 	PROTO :DWORD, :DWORD, :DWORD,:DWORD, :DWORD, :DWORD
 D3DXAssembleShader 				PROTO :DWORD, :DWORD, :DWORD,:DWORD, :DWORD, :DWORD

; Misc APIs:
; D3DXGetErrorString: Returns the error string for given an hresult.  Interprets all D3DX and
; D3D hresults.
; ------------------------------------------------------------------------------
; Parameters: 	hr 		- The error code to be deciphered.
; 		pBuffer		- Pointer to the buffer to be filled in.
;		BufferLen	- Count of characters in buffer.  Any error message longer than this
;      				length will be truncated to fit.

 D3DXGetErrorStringA 	PROTO :DWORD, :DWORD, :DWORD
 D3DXGetErrorStringW 	PROTO :DWORD, :DWORD, :DWORD