;***********************************************************************************************************
;   5.      .
;                 .   .
;     keYMax
;     mybox@aib.ru 
;***********************************************************************************************************
   .686                  ;      686
   .MMX                  ;    MMX 
   .XMM                  ;    SSE 
	
   .MODEL FLAT, STDCALL  ;      Win32
                         ; STDCALL -    

   OPTION CASEMAP:none   ;       
                         ;    . ;)
					
;===========================================================================================================
;          
;===========================================================================================================
   INCLUDE       \masm32\include\windows.inc     ; ,  ...    
   INCLUDE       \masm32\include\kernel32.inc    ;    ...
   INCLUDE       \masm32\include\user32.inc      ;  ...
   INCLUDE       \masm32\include\gdi32.inc       ;   ...
   INCLUDE       \masm32\include\winmm.inc       ;  timeGetTime
             
   INCLUDE       \masm32\Directx81\d3d8.inc      ;    Direct3D8
   INCLUDE       include\d3dx8math.inc           ;    
   INCLUDE       include\d3dx8core.inc           ;                  
                
   INCLUDELIB    \masm32\lib\kernel32.lib
   INCLUDELIB    \masm32\lib\user32.lib
   INCLUDELIB    \masm32\lib\gdi32.lib
   INCLUDELIB    \masm32\lib\winmm.lib
  
   INCLUDELIB    \masm32\Directx81\d3d8.lib      ;   Direct3D8
   INCLUDELIB    \masm32\Directx81\d3dx8d.lib    ;    D3DX...

; ::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

   Init_Direct3D         PROTO                               ;      
   Destroy_Direct3D      PROTO                               ; 
   
   Init_Scene            PROTO :DWORD
   Render_Scene          PROTO
   Animate_Scene         PROTO                             
   Set_Render_Parameters PROTO
   
   Init_Font             PROTO :DWORD
   Draw_AllText          PROTO 
   DrawText_Effect       PROTO :DWORD
    
   SetupDialog           PROTO :DWORD,:DWORD,:DWORD,:DWORD   ;     Dialog.asm
   DW2A                  PROTO :DWORD,:DWORD
        
.CONST ;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
.DATA ;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    szClassName    db  "MyClass", 0                          ;    
    szAppName      db  "DirectX 8.1  MASM32:  5 !", 0   ;    (          )
    szDialogName   db  "SetupDialog", 0
       
   ;WNDCLASSEX ------------------------------------------------ 
    cbSize         dd  12*4                       ;  
    style          dd  CS_HREDRAW or CS_VREDRAW   ;   
    lpfnWndProc    dd  OFFSET WndProc             ;    
    cbClsExtra     dd  0                          ;     
    cbWndExtra     dd  0                          ;   
    hInstance      dd  400000h                    ;     
    hIcon          dd  0                          ;     (  )
    hCursor        dd  0                          ;     (    ID   )
    hbrBackground  dd  BLACK_PEN                  ;    
    lpszMenuName   dd  0                          ;    
    lpszClassName  dd  OFFSET szClassName         ;     
    hIconSm        dd  0                          ;     (  -    )
                             
.DATA? ;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

    msg            MSG  <?>                       ;  
    hwnd           HWND ?                         ; ID      
            
.CODE ;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Start:                                                        ;                      
				
   invoke  DialogBoxParam, hInstance , ADDR szDialogName , \  ;   
           NULL , OFFSET SetupDialog, NULL 
                        
   invoke  Init_Direct3D                                      ;  Direct3D
   
   invoke  ShowCursor, SW_HIDE                                ;  
           
 msg_loop:
   invoke  PeekMessageA, ADDR msg, 0 , 0 , 0 , PM_REMOVE      ;	
   test    eax, eax                                           ;
   jne     message                                            ;     ... 
                                                              ;
   invoke  Render_Scene                                       ; ...     
   jmp     msg_loop                                           ;
                                                              ;
 message:                                                     ;
   mov     eax, DWORD PTR msg.message                         ;
   cmp     eax, WM_QUIT                                       ;
   je      end_loop                                           ;
                                                              ;
   invoke  TranslateMessage, ADDR msg                         ;
   invoke  DispatchMessage, ADDR msg                          ;
   jmp     msg_loop                                           ;

 end_loop:
   mov     eax, msg.wParam            ;     ,     
                                      ;    wParam  MSG. 
   invoke  ExitProcess, eax
   ret
;===========================================================================================================                                     
 WndProc proc hWnd:HWND , uMsg:UINT, wParam:WPARAM, lParam:LPARAM                                          
;=========================================================
   
   cmp     uMsg, WM_KEYDOWN           ;    ,       .
   je      wmKeydown
                   
   cmp     uMsg, WM_CREATE            ;    ,   
   je    wmCreate
            
   cmp     uMsg, WM_DESTROY           ;    ,     .
   je    wmDestroy	
         			                 
   invoke  DefWindowProc, hWnd, uMsg, wParam, lParam  ;       , 
   ret                                                ;    DefWindowProc   ,   .
                                                      ;   API     .
;-----------------------------------------------------------------------------------------------------------------------
  wmDestroy:
;------------    
   invoke  Destroy_Direct3D                           ;         DirectX

   invoke  PostQuitMessage, NULL     
   xor     eax,eax                            
   ret                                         
;-----------------------------------------------------------------------------------------------------------------------
  wmCreate:                                       
;-----------    
   xor     eax, eax 
   ret 
;-----------------------------------------------------------------------------------------------------------------------
  wmKeydown:
;-----------
   mov     eax, wParam
   
   cmp     eax, VK_ESCAPE                              ; 27 -   ESC
   je      exit
   
   xor     eax,eax
   ret     
  
 exit:
   invoke  SendMessage, hWnd , WM_CLOSE , NULL, NULL  ;       
   xor     eax,eax
   ret     
       
 WndProc endp
;===========================================================================================================
;    
;===========================================================================================================
INCLUDE  Dialog.asm  ;      SetupDialog  DW2A
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Init_Font proc pd3dDev:DWORD

  .DATA 
   ;LOGFONT ------------------------------;  
   lfHeight          dd 0                 ;  
   lfWidth           dd 0                 ; 
   lfEscapement      dd 0                 ;
   lfOrientation     dd 0                 ;
   lfWeight          dd FW_BOLD           ;
   lfItalic          db 0                 ;
   lfUnderline       db 0                 ;
   lfStrikeOut       db 0                 ;
   lfCharSet         db DEFAULT_CHARSET   ;   
   lfOutPrecision    db 0                 ;
   lfClipPrecision   db 0                 ;
   lfQuality         db 0                 ;
   lfPitchAndFamily  db 0                 ;
   lfFontName        db "verdana",0       ;  
    
   fontsize_coeff    dd 16.0f             ;     
          
  .DATA?
   pd3dFont          dd ?                 ;     
   pd3dFont2         dd ?                 ;    
    
   TextLeft          dd ?                 ;    
   TextUp            dd ?                 ;
   TextRight         dd ?                 ;
   TextBottom        dd ?                 ; 
             
   AutorX            dd ?                 ;      
   AutorY            dd ?                 ; 
   
   InfoX             dd ?                 ;  X  
      
  .CODE
   mov     lfHeight, 16      
   invoke  D3DXCreateFontIndirect, pd3dDev, ADDR lfHeight , ADDR pd3dFont2   ;    FPS      
    
   fild    d3dpp.BackBufferWidth       ;     
   fdiv    fontsize_coeff              ;
   fistp   lfHeight                    ;
                       
   invoke  D3DXCreateFontIndirect, pd3dDev, ADDR lfHeight , ADDR pd3dFont    ;     
         
   mov     eax, d3dpp.BackBufferHeight ;  
   mov     TextBottom, eax             ;
   push    eax                         ;
   sub     eax, 20                     ;
   mov     AutorY, eax                 ;
   pop     eax                         ;
   sub     eax, lfHeight               ;
   mov     InfoX, eax                  ;
                                       ;
   mov     eax, d3dpp.BackBufferWidth  ;
   mov     TextRight, eax              ;
   sub     eax, 60                     ;
   mov     AutorX, eax                 ;
    
   ret
Init_Font endp
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Init_Direct3D proc    ;  Direct3DDevice   WM_Create  ! (    :) )    			
   
   .DATA                
   ;--------------------------------------------     
   EyeVector    D3DVECTOR  <0.0f, 3.7f, -9.35f> ;    
   LookAtVector D3DVECTOR  <0.0f, 6.0f, 0.0f>   ;    
   UpVector     D3DVECTOR  <0.0f, 1.0f, 0.0f>   ;  .   0.0,1.0,0.0
   
   FieldOfView    dd  1.7953981635f             ;        (D3DX_PI/4)
   AspectRatio    dd  0                         ; AspectRatio
   NearViewPlanZ  dd  1.0f                      ;   
   FarViewPlanZ   dd  100.0f                    ;   
         
  .DATA?
   pd3dDevice        dd  ?                      ;   Direct3DDevice
   
   WorldMatrix       D3DMATRIX  <?>             ;  
   ViewMatrix        D3DMATRIX  <?>             ;   
   ProjectionMatrix  D3DMATRIX  <?>             ;  
          
  .CODE    ;          Direct3D  SetupDialog  
           
   d3d8    CreateDevice, pd3d, D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, hwnd , \  ;   Direct3DDevice8
           D3DCREATE_SOFTWARE_VERTEXPROCESSING, ADDR d3dpp, ADDR pd3dDevice             
   
   fild    d3dpp.BackBufferWidth    ;    
   fidiv   d3dpp.BackBufferHeight
   fstp    AspectRatio
   
   invoke  D3DXMatrixLookAtLH, ADDR ViewMatrix, ADDR EyeVector, ADDR LookAtVector, ADDR UpVector
   invoke  D3DXMatrixPerspectiveFovLH, ADDR ProjectionMatrix, FieldOfView, AspectRatio, NearViewPlanZ, FarViewPlanZ
   
   invoke  Init_Scene, pd3dDevice                    
   invoke  Init_Font, pd3dDevice
   invoke  Set_Render_Parameters

   ret
Init_Direct3D endp
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Init_Scene proc pd3dDev:DWORD

  .CONST
    
   D3DFVF_CUSTOMVERTEX equ D3DFVF_XYZ OR D3DFVF_DIFFUSE   ;      
   
  .DATA 
                                                                                                               
   xstart          dd -6.35f                              ;    X                             
   ystart          dd  8.0f                               ;    Y
   zstart          dd  2.5f                               ;    Z
   shiftx          dd  0.9f                              ;    X
   shifty          dd -0.9f                              ;    Y
   xcoord          dd -6.35f                              ;   2  X
   
   CountData       dd (24*4)*58+(24*4)*6                  ;    
   CountPrimitive  dd 128                                 ;  
    
   Vertices        dd   0.0f ,  0.0f ,   1.0f , 0FF3020h  ;   (    )
                   dd   0.0f ,  0.7f ,   1.0f , 0FF3020h  ; 4*4   
                   dd   0.7f ,  0.7f ,   1.0f , 0FF3020h  ; 12*4   
                                                          ; 24*4   
                   dd   0.0f ,  0.0f ,   1.0f , 0FF3020h  ;
                   dd   0.7f ,  0.7f ,   1.0f , 0FF3020h  ;
                   dd   0.7f ,  0.0f ,   1.0f , 0FF3020h  ;
      
   Fon             dd -15.0f ,  0.0f ,   2.5f , 0cfcfcfh  ; 
                   dd   0.0f ,  0.0f ,  12.5f , 0afafafh  ; 
                   dd  15.0f ,  0.0f ,   2.5f , 0cfcfcfh  ;
                                                          ;
                   dd -15.0f ,  0.0f ,   2.5f , 0cfcfcfh  ;
                   dd  15.0f ,  0.0f ,   2.5f , 0cfcfcfh  ;
                   dd   0.0f ,  0.0f , -12.5f , 0cfcfcfh  ;
                   
                   dd -15.0f ,  0.0f ,   2.5f , 0F0F0F0h  ; 
                   dd   0.0f , 15.0f ,  12.5f , 0F0F0F0h  ; 
                   dd   0.0f ,  0.0f ,  12.5f , 0afafafh  ;
                                                          ;
                   dd -15.0f ,  0.0f ,   2.5f , 0F0F0F0h  ;
                   dd -15.0f , 15.0f ,   2.5f , 0FFFFFFh  ;
                   dd   0.0f , 15.0f ,  12.5f , 0F0F0F0h  ;
                   
                   dd   0.0f ,  0.0f ,  12.5f , 0afafafh  ; 
                   dd   0.0f , 15.0f ,  12.5f , 0F0F0F0h  ; 
                   dd  15.0f ,  0.0f ,   2.5f , 0F0F0F0h  ;
                                                          ;
                   dd   0.0f , 15.0f ,  12.5f , 0F0F0F0h  ;
                   dd  15.0f , 15.0f ,   2.5f , 0FFFFFFh  ;
                   dd  15.0f ,  0.0f ,   2.5f , 0F0F0F0h  ;
                   
                   dd   0.0f ,  0.0f , -12.5f , 0DEDEDEh  ;  2
                   dd   0.0f , 15.0f , -12.5f , 0DEDEDEh  ; 
                   dd -15.0f ,  0.0f ,   2.5f , 0DEDEDEh  ;
                                                          ;
                   dd -15.0f ,  0.0f ,   2.5f , 0DEDEDEh  ;
                   dd   0.0f , 15.0f , -12.5f , 0DEDEDEh  ;
                   dd -15.0f , 15.0f ,   2.5f , 0DEDEDEh  ;
                  
                   dd  15.0f ,  0.0f ,   2.5f , 0E9E9E9h  ;  2
                   dd   0.0f , 15.0f , -12.5f , 0E9E9E9h  ; 
                   dd   0.0f ,  0.0f , -12.5f , 0E9E9E9h  ;
                                                          ;
                   dd  15.0f ,  0.0f ,   2.5f , 0E9E9E9h  ;
                   dd  15.0f , 15.0f ,   2.5f , 0E9E9E9h  ;
                   dd   0.0f , 15.0f , -12.5f , 0E9E9E9h  ;
                                                            
                   dd -15.0f , 15.0f ,   2.5f , 0F0F0F0h  ; 
                   dd   0.0f , 15.0f ,  12.5f , 0F0F0F0h  ; 
                   dd  15.0f , 15.0f ,   2.5f , 0F0F0F0h  ;
                                                          ;
                   dd -15.0f , 15.0f ,   2.5f , 0F0F0F0h  ;
                   dd  15.0f , 15.0f ,   2.5f , 0F0F0F0h  ;
                   dd   0.0f , 15.0f , -12.5f , 0F0F0F0h  ;
  
   Text            db  0,1,1,1,1,1,0,0,1,1,1,1,1,1,1
                   db  1,1,0,0,0,1,1,0,1,1,0,0,0,0,0
                   db  1,1,0,0,0,1,1,0,1,1,0,0,0,0,0
                   db  1,1,0,0,0,1,1,0,1,1,1,1,1,1,0
                   db  1,1,0,0,0,1,1,0,0,0,0,0,0,1,1
                   db  1,1,0,0,0,1,1,0,1,1,0,0,0,1,1
                   db  0,1,1,1,1,1,0,0,0,1,1,1,1,1,0
                   
  .DATA?
   pd3dVertexBuffer  dd ?     ;   VertexBuffer
   pLockBuffer       dd ?     ;    Vertex 
   
   start_time        dd ?     ;   

  .CODE               
      
   d3dev8  CreateVertexBuffer, pd3dDev, CountData, D3DUSAGE_WRITEONLY, D3DFVF_CUSTOMVERTEX , \
           D3DPOOL_MANAGED, ADDR pd3dVertexBuffer;
            
   d3dvb8  Lock1, pd3dVertexBuffer, NULL, NULL, ADDR pLockBuffer, NULL
   
   lea     esi, Fon                             ;    12  
   mov     edi, pLockBuffer           
   mov     ecx, 12*12
   rep     movsd   
   
   lea     edx, Text      
   mov     esi, edi                             ;                          
   push    7                                    ;   
   pop     ecx                                  ;    
   nextVertices3:                              
   xor     ebx, ebx     
   push    ecx
   push    15
   pop     ecx
   nextVertices2:
   push    ecx
   lea     edi, Vertices
   push    6
   pop     ecx
   nextVertex:
   fld     DWORD PTR [edi]
   fadd    xstart
   fstp    DWORD PTR [esi]  
   fld     DWORD PTR [edi+4]
   fadd    ystart
   fstp    DWORD PTR [esi+4]
   push    zstart
   pop     DWORD PTR [esi+8]
   mov     eax, DWORD PTR [edi+12]   
   sub     eax, ebx
   mov     DWORD PTR [esi+12], eax           
   cmp     BYTE PTR [edx], 1
   jne     no_add     
   add     esi, 16
   no_add:
   add     edi, 16
   loop    nextVertex
   inc     edx
   add     ebx, 0030000h
   fld     xstart
   fadd    shiftx
   fstp    xstart   
   pop     ecx
   loop    nextVertices2
   push    xcoord
   pop     xstart
   fld     ystart
   fadd    shifty
   fstp    ystart   
   pop     ecx
   dec     ecx
   jnz     nextVertices3
      
   d3dvb8  Unlock, pd3dVertexBuffer
   
   invoke  timeGetTime                      ;   
   mov     start_time, eax
        
   ret
Init_Scene endp 
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Set_Render_Parameters proc
   
   d3dev8  SetTransform, pd3dDevice, D3DTS_WORLD, ADDR WorldMatrix            ;    
   d3dev8  SetTransform, pd3dDevice, D3DTS_VIEW, ADDR ViewMatrix   
   d3dev8  SetTransform, pd3dDevice, D3DTS_PROJECTION, ADDR ProjectionMatrix
   
   d3dev8  SetRenderState, pd3dDevice, D3DRS_CULLMODE, D3DCULL_NONE           ; .   
   d3dev8  SetRenderState, pd3dDevice, D3DRS_LIGHTING, NULL                   ; . 
   d3dev8  SetRenderState, pd3dDevice, D3DRS_ZENABLE, D3DZB_TRUE              ; . Z 
   
   d3dev8  SetVertexShader, pd3dDevice, D3DFVF_CUSTOMVERTEX                   ;   
   d3dev8  SetStreamSource, pd3dDevice, 0 , pd3dVertexBuffer, 16              ;  
                                                                              ; 16 -    1     
   ret   
Set_Render_Parameters endp
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Render_Scene proc
  
  .DATA
   Zvalue      dd  1.0f                                    ;    Z 
   clearcolor  dd  0                                       ;     Direct3D
             
  .CODE
   d3dev8  TestCooperativeLevel, pd3dDevice                ;  
   cmp     eax, D3DERR_DEVICELOST                          ;     
   jne     noreset                                         ;
   ret                                                     ;
                                                           ;
   noreset:                                                ;
   cmp     eax, D3DERR_DEVICENOTRESET                      ;         
   jne     noreset2                                        ;
   
   d3dxfont8 OnLostDevice, pd3dFont                        ;                                                               ;
   d3dev8  Reset, pd3dDevice, ADDR d3dpp.BackBufferWidth   ;                                                              ;
   d3dxfont8 OnResetDevice, pd3dFont                       ;     
                                                           ;
   invoke  Set_Render_Parameters                           ;   
                                                           ;
   noreset2:                                               ;
   
   invoke  Animate_Scene                                   ;  
   
   d3dev8  Clear, pd3dDevice, 0 , NULL , D3DCLEAR_TARGET or D3DCLEAR_ZBUFFER , clearcolor , Zvalue , 0  ;     
   d3dev8  DrawPrimitive, pd3dDevice, D3DPT_TRIANGLELIST, 0 , CountPrimitive                            ;  
   invoke  Draw_AllText 
   d3dev8  Present, pd3dDevice, NULL, NULL, NULL, NULL     ;        

   ret
Render_Scene endp
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Animate_Scene proc
                
   .DATA    ;------------------         
    scene_rotate_divider  dd 2000.0f    
    scene_sin_coeff       dd 3.5f      
        
   .DATA?         
    Scene_rotate_angle    dd ?
    
   .DATA    ;------------------    
    camera_move_divider   dd 800.0f
    camera_x              dd 0.0f
    camera_y              dd 0.0f
    camera_z              dd -9.35f
    
   .DATA? 
    checktime             dd ?
        
   .CODE
   
   invoke  timeGetTime
   mov     checktime, eax
               
   fild    checktime
   fdiv    scene_rotate_divider
   fsin
   fmul    scene_sin_coeff
   fchs   
   fstp    Scene_rotate_angle 
            
   invoke  D3DXMatrixRotationY, ADDR WorldMatrix, Scene_rotate_angle
   d3dev8  SetTransform, pd3dDevice, D3DTS_WORLD, ADDR WorldMatrix 
   
   fild    checktime
   fdiv    camera_move_divider
   fcos
   fstp    camera_x        
   invoke  D3DXMatrixLookAtLH, ADDR ViewMatrix, ADDR EyeVector, ADDR LookAtVector, ADDR camera_x
   d3dev8  SetTransform, pd3dDevice, D3DTS_VIEW, ADDR ViewMatrix
   ret
            
Animate_Scene endp
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Draw_AllText proc
  .DATA   
   szInfo      db "DIRECTX 8.1",0 
   szInfo2     db "MASM32",0   
   szInfo3     db " 5!",0 
   szInfo4     db " ",0 
      
   szAutor     db "keYMax",0
   
   info0       dd OFFSET szInfo, 11, 010000000h                             
   info1       dd OFFSET szInfo, 11, 010000000h 
   info2       dd OFFSET szInfo2, 6, 010000000h 
   info3       dd OFFSET szInfo3, 7, 010000000h 
   info4       dd OFFSET szInfo4, 20, 010000000h 
   info5       dd OFFSET szInfo, 11, 010000000h 
   
   table       dd OFFSET info0, OFFSET info1, OFFSET info2, OFFSET info3
               dd OFFSET info4
  
   flag        dd 0
      
   .DATA?
   fps         dd ?
   fpscheck    dd ?
   fpsbuf      db 20 dup (?)
   
   check_time_text dd ?
                   
  .CODE
   d3dxfont8 Begin, pd3dFont
   
   invoke  timeGetTime                        ;  FPS   
   mov     check_time_text, eax               ;
   mov     edx, fpscheck                      ;
   add     edx, 1000                          ;
   cmp     edx, eax                           ;
   ja      @F                                 ;
   mov     fpscheck, eax                      ;
   invoke  DW2A, fps, ADDR fpsbuf             ;
   xor     eax, eax                           ;
   mov     fps, eax                           ;
   @@:                                        ;
   inc     fps                                ;
   xor     eax, eax
   mov     TextLeft, 5
   mov     TextUp, eax
   d3dxfont8 DrawTextA, pd3dFont2, ADDR fpsbuf, -1 , ADDR TextLeft , DT_NOCLIP , 030000000h          
   mov     TextUp, 0
   push    AutorX
   pop     TextLeft 
   d3dxfont8 DrawTextA, pd3dFont2, ADDR szAutor, 6 , ADDR TextLeft , DT_NOCLIP , 030000000h          
    
   mov     TextLeft, 10
   push    InfoX
   pop     TextUp
            
   mov     eax, flag
   invoke  DrawText_Effect, [table+eax*4]
       
   cmp     flag, 5
   jne     nxnt
   mov     flag, 1
   nxnt:
     
   d3dxfont8 End1, pd3dFont   
   ret
Draw_AllText endp
;:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
DrawText_Effect proc pStruct:DWORD
 
 .DATA
 
 
 .DATA?
 
  check      dd ?
  check2     dd ?
  
  string     db 25 dup (?)
  colortext  dd ?
    
 .CODE
   mov     eax, check_time_text  
   
   mov     edx, start_time 
   add     edx, 4200
   cmp     edx, eax
   ja      exit_text
   
   mov     esi, pStruct   
   push    eax
   mov     edx, check                         ;
   add     edx, 7000                          ;
   cmp     edx, eax                           ;
   ja      @F                                 ;
   mov     check, eax                         ;
   
   push    DWORD PTR [esi+8]
   pop     colortext
   lea     edi, string
   mov     ebx, [esi+12]
   xor     eax, eax
   mov     ecx, [esi+16]
   aq:   
   mov     dl, BYTE PTR [ebx+eax]
   sub     dl, 10
   sub     dl, al
   mov     BYTE PTR [edi+eax], dl
   inc     eax
   loop    aq
   inc     flag
   @@:
   
   pop     eax
   mov     edx, check2                        ;
   add     edx, 30                            ;
   cmp     edx, eax                           ;
   ja      @F                                 ;
   mov     check2, eax                        ;
   
   mov     edx, [esi]
   lea     edi, string
   
   mov     ecx, [esi+4]
   next_letter:
   mov     al, BYTE PTR [edx]
   mov     ah, BYTE PTR [edi]
   cmp     al, ah 
   je      no_dec
   jb      decc
   inc     BYTE PTR [edi]   
   jmp     no_dec
   decc:   
   dec     BYTE PTR [edi]
   no_dec:
   inc     edi   
   inc     edx
   loop    next_letter
   @@:
   
   d3dxfont8 DrawTextA, pd3dFont, ADDR string , [esi+4] , ADDR TextLeft, DT_NOCLIP, colortext
   exit_text:
   
   ret
DrawText_Effect endp
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
Destroy_Direct3D proc

   d3dev8  Release, pd3dVertexBuffer  ;  Vertex 
   d3dxfont8 Release, pd3dFont2       ;  
   d3dxfont8 Release, pd3dFont        ;  
   d3dev8  Release, pd3dDevice        ;  Direct3DDevice8  
   d3d8    Release, pd3d              ;  Direct3D8   
    
   ret    
Destroy_Direct3D endp
;::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
EndCode:
end Start 
