;-----------------------------------------------------------------------------
; File: ServiceDX.asm
;
; Desc: Service of DirectX
;
; Note: 1.It is not a compilable project. It is only a sample!
;       2.It is not the English. It is Russian English!
;
; Copyright (c) 2001 Serge Vetroff (http://www.assembler.ru)
;-----------------------------------------------------------------------------
;##############################################################################
include @struct.inc
include windows.inc
include directx.inc
include settings.inc
include globals.inc
;*****************************************************************************
; Name: List_DX_Modes
; Desc: Listing of DirectX screen modes
;       If DirectX is not available - returns FALSE
;-----------------------------------------------------------------------------
.data?
  modes_buffer		dd ?
  modes_number		dd ?
.code
List_DX_Modes PROC
 @<;Clear variables>,<mov modes_buffer,0>,<mov modes_number,0>
 @<;Create list modes buffer>,<invoke GlobalAlloc,GPTR,MODES_BUFFER_SIZE>,<or eax,eax>,<jz bad>,<mov modes_buffer,eax>
 @<;Create a DirectDraw object>,<invoke DirectDrawCreate,NULL,offset(lpDD),NULL>,<cmp eax,DD_OK>,<jne bad>
 @<;Enum modes>,<enum_modes_callback PROTO :DWORD,:DWORD>,<push modes_buffer>,<IDirectDraw lpDD,EnumDisplayModes,NULL,NULL,NULL,offset(enum_modes_callback)>,<pop modes_buffer>,<cmp eax,DD_OK>,<jne bad>,<cmp modes_number,0>,<jne ok>
 @<;Incorrect Exit>,<bad:>,<invoke Message_Box,0>,<mov eax,FALSE>,<jmp exit>
 @<;OK, truncate modes buffer>,<ok:>,<mov eax,MODE_SIZE>,<mul modes_number>,<invoke GlobalReAlloc,modes_buffer,eax,NULL>,<call sort_the_modes>,<invoke Set_Current_Mode,640,480,16>,<mov eax,TRUE>
 @<;Release interface>,<exit:>,<push eax>,<cmp lpDD,0>,<je @F>,<IDirectDraw lpDD,Release>,<mov lpDD,0>,<@@:>,<pop eax>
 ret
List_DX_Modes ENDP
;.............................................................................
; Name: enum_modes_callback
; Desc: Enumeration of display modes for DirectDraw 1.0
;. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .
enum_modes_callback PROC USES esi edi ebx ecx lpDDSurfaceDesc,lpContext
 @<;Check if buffer of modes is overloaded>,<mov eax,DDENUMRET_CANCEL>,<cmp modes_number,MODES_MAX_NUMBER>,<je exit>
 @<;Test of flags of DDSURFACEDESC>,<mov eax,lpDDSurfaceDesc>,<mov eax,[eax+DDSURFACEDESC.dwFlags]>,<mov ebx,DDSD_HEIGHT OR DDSD_WIDTH OR DDSD_PIXELFORMAT>,<and eax,ebx>,<cmp eax,ebx>,<jne ok>
 @<;Test of flags of DDSURFACEDESC.ddpfPixelFormat>,<mov eax,lpDDSurfaceDesc>,<test dword ptr[eax+DDSURFACEDESC.ddpfPixelFormat.dwFlags],DDPF_RGB>,<jz ok>
 ;Copy current mode to modes buffer
 @<mov ebx,lpDDSurfaceDesc>,<mov edx,modes_buffer>
 @<mov eax,[ebx+DDSURFACEDESC.dwWidth]>,<mov [edx+MODE_DESCRIPTION.mwidth],ax>
 @<mov eax,[ebx+DDSURFACEDESC.dwHeight]>,<mov [edx+MODE_DESCRIPTION.mheight],ax>
 @<mov eax,[ebx+DDSURFACEDESC.ddpfPixelFormat.dwRGBBitCount]>,<mov [edx+MODE_DESCRIPTION.bpp],al>
 @<;Inc the buffer ptr and counter>,<inc modes_number>,<add modes_buffer,MODE_SIZE>
 @<;Exit from procedure>,<ok:>,<mov eax,DDENUMRET_OK>,<exit:>,<ret>
enum_modes_callback ENDP
;.............................................................................
; Name: sort_the_modes
; Desc: Sort modes in the modes_buffer
;. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .
sort_the_modes PROC
 @<;edx-number of sorting positions>,<mov edx,modes_number>,<jz exit>,<dec edx>,<jz exit>
 @<;Next pass>,<mov edi,1>,<next_pass:>,<or edi,edi>,<jz exit>,<mov esi,modes_buffer>,<xor ecx,ecx>,<xor edi,edi>
  @<;Next step in a pass>,<next_step:>,<cmp ecx,edx>,<je next_pass>
   @<;Compare resolution>,<mov eax,[esi]>,<cmp eax,[esi+MODE_SIZE]>,<ja exchange>,<jne @F>
    @<;Compare depth>,<mov al,[esi+MODE_DESCRIPTION.bpp]>,<cmp al,[esi+(MODE_SIZE+MODE_DESCRIPTION.bpp)]>,<jbe @F>
     @<;Exchange positions>,<exchange:>,<mov eax,[esi]>,<xchg eax,[esi+MODE_SIZE]>,<mov [esi],eax>,<mov al,[esi+MODE_DESCRIPTION.bpp]>,<xchg al,[esi+(MODE_SIZE+MODE_DESCRIPTION.bpp)]>,<mov [esi+MODE_DESCRIPTION.bpp],al>
     @<;It will be not the last pass>,<inc edi>
  @<@@:>,<add esi,MODE_SIZE>,<inc ecx>,<jmp next_step>
 @<exit:>,<ret>
sort_the_modes ENDP
;*****************************************************************************
; Name: Set_Current_Mode
; Desc: Set the variable "current_mode" to the specified mode
;. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .
Set_Current_Mode PROC USES esi swidth,sheight,sbpp
 @<xor edx,edx>,<mov esi,modes_buffer>,<mov ecx,modes_number>
 @@:
  @<mov eax,swidth>,<cmp [esi.MODE_DESCRIPTION.mwidth],ax>,<jne notthis>
  @<mov eax,sheight>,<cmp [esi.MODE_DESCRIPTION.mheight],ax>,<jne notthis>
  @<mov eax,sbpp>,<cmp [esi.MODE_DESCRIPTION.bpp],al>,<je found>
  @<notthis:>,<inc edx>,<add esi,MODE_SIZE>
 @<dec ecx>,<jnz @B>
 ;The mode is not found
  @<mov current_mode,0>,<mov esi,modes_buffer>,<xor eax,eax>
  @<mov al,[esi.MODE_DESCRIPTION.bpp]>,<mov screen_depth,eax>,<mov ax,[esi.MODE_DESCRIPTION.mwidth]>,<mov screen_width,eax>,<mov ax,[esi.MODE_DESCRIPTION.mheight]>,<mov screen_height,eax>,<jmp exit>
 @<;The mode is found>,<found:>,<mov current_mode,edx>
 @<exit:>,<ret>
Set_Current_Mode ENDP
;*****************************************************************************
; Name: Destroy_Modes_List
; Desc: Releases memory for list of modes
;-----------------------------------------------------------------------------
Destroy_Modes_List PROC
 @<@if(modes_buffer)>,<invoke GlobalFree,modes_buffer>,<@endif>
 ret
Destroy_Modes_List ENDP
;*****************************************************************************
; Name: Get_DX_Device_Mode_Txt
; Desc: Returns pointer to the buffer with mode in text impression ("800 x 600 x 16",0)
;       If mode_num is more than number of modes returns 0.
;-----------------------------------------------------------------------------
Get_DX_Device_Mode_Txt PROC USES esi edi mode_num
 @<;Get mode structure>,<Get_DX_Device_Mode PROTO :DWORD>,<invoke Get_DX_Device_Mode,mode_num>,<or eax,eax>,<jz exit>,<mov esi,eax>
 @<mov edi,uniblock>
 @<;print width>,<xor edx,edx>,<mov dx,[esi+MODE_DESCRIPTION.mwidth]>,<print_num PROTO :DWORD,:DWORD>,<invoke print_num,edx,edi>,<mov edi,eax>,<mov dword ptr[edi],0207820h>,<add edi,3>
 @<;print height>,<xor edx,edx>,<mov dx,[esi+MODE_DESCRIPTION.mheight]>,<invoke print_num,edx,edi>,<mov edi,eax>,<mov dword ptr[edi],0207820h>,<add edi,3>
 @<;print bpp>,<xor edx,edx>,<mov dl,[esi+MODE_DESCRIPTION.bpp]>,<invoke print_num,edx,edi>,<mov byte ptr[eax],0>
 @<;exit>,<mov eax,uniblock>,<exit:>,<ret>
Get_DX_Device_Mode_Txt ENDP
;*****************************************************************************
; Name: Get_DX_Device_Mode
; Desc: Returns pointer to the MODE_DESCRIPTION structure of specified mode
;       If mode_num is more than number of modes returns 0.
;-----------------------------------------------------------------------------
Get_DX_Device_Mode PROC USES esi mode_num
 @<;Test if mode_num is incorrect>,<xor eax,eax>,<mov edx,mode_num>,<cmp edx,modes_number>,<jae exit>
 @<;Calculate position of modes_buffer>,<mov eax,MODE_SIZE>,<mul mode_num>,<add eax,modes_buffer>
 @<exit:>,<ret>
Get_DX_Device_Mode ENDP

;##############################################################################
end


