#!/usr/bin/env perl
#!/usr/bin/perl -T

# WWW interface for CW beacon, web_cw_beacon.cgi

## Start user config
#
# file that holds message to be transmitted
$file = "/tmp/.cw_beacon";
# log message and speed, writable by httpd daemon
$Log = "/var/log/cw_beacon.log";
# default message
$def = "v v de CALL/b GRID li qsl via EMAIL";
# maximum length of user message
$message_len = 64;
#
## End user config

sub error {
my ($message) = @_;
             
print <<End_of_Error;
Content-type: text/html
Status: 500 CGI Error
<html>
<head><title>CGI Error</title></head>
<body>
<h1>Oops! Error</h1>
<hr>
$message
<hr>
</body>
</html>
End_of_Error
}

# Setup
#
select STDOUT;
$| = 1;

# Print MIME
#
print "Content-type:text/html\n\n";

# Read enviroment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
	@pairs = split(/&/, $buffer);
		foreach $pair (@pairs) {
    		  ($name, $value) = split(/=/, $pair);
    		  $value =~ tr/+/ /;
    		  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    		  $FORM{$name} = $value;
}

$speed   = $FORM{'speed'};
$message = $FORM{'message'};
$delay   = $FORM{'delay'};
$atten   = $FORM{'att'};
$antenna = $FORM{'ant'};

# Print HTML
#
print "<html><head><title>Results</title></head>".
      "<body bgcolor=\"#000000\" text=\"#11AAFF\">".
      "<font size=\"4\">";

open F, ">>$Log" || error "Can't open $Log: $!\n";
	print F $ENV{'REMOTE_ADDR'}, "\t$message\t$speed\n"; 
close F;      

# Allow a-z A-Z 0-9 / * . - , ?
# Convert uppercase to lowercast
# Keep length to 20 characters or less
#
$message =~ tr/a-zA-Z0-9\/*\.\-\,? //csd;
$message =~ tr/A-Z/a-z/;

# FCC's seven dirty word filter
#
$message =~ s/(shit|piss|fuck|cunt|cocksucker|motherfucker|tits)//g;
$message =~ s/(bitch|twat|pussy|ass|fart)//g;

if (!$message) {
        $message = $def;
}

# Allow 5 - 50 wpm, default 12 wpm
#
$speed =~ tr/0-9//csd;

if (!$speed || $speed < 5 || $speed > 50) {
        $speed = 12;
}

# Delay between characters 1 - 5, default 1
#
$delay =~ tr/1-5//csd;

if (!$delay || $delay > 5) {
        $delay = 1;
}

# Select antenna
#
($ante, $des) = split ":", $antenna;
$ante =~ tr/0-9//csd;

if ($ante == 1) {
	$ant = 0; # default antenna
}

elsif ($ante == 2) {
        $ant = 4; # selected antenna
}

if (!$ante) {
	$ant = 0; # else use default antenna
}

# Select attenuation
#

if ($atten eq "on") {
	$att = 2; # attenuator selected
}

elsif ($atten eq "off") {
	$att = 0; # default full power
}

if (!$atten) {
	$att = 0; # else use full power
}
 
if ((length $message) > $message_len) {
	print "<center><b>Message to long. Try again</center></b><br><p>";
        $des = $message = "";
	$atten = $ante = $speed = $delay = 0;
}

if (-T $file) {
     print "<center><b>Currently in use. Try again later.</center></b><br><p>";
     $des = $message = "";
     $atten = $ante = $speed = $delay = 0;
}

else {
	open F, ">$file" || error "Can't open $file: $!\n";
        	print F "$speed\n$delay\n$att\n$ant\n$message";
	close F;
}

print <<END_OF_FILE; 
<font size="4">
<b>Message that will be sent: </b></font>$message<br>
<font size="4">
<b>CW speed: </b></font>$speed wpm<br>
<font size="4">
<b>Delay: </b></font>$delay<br>
<font size="4">
<b>Antenna: </b></font>$ante : $des<br>
<font size="4">
<b>Attenuator: </b></font>$atten<br>
</body></html>
END_OF_FILE
