#!/usr/bin/env perl
#!/usr/bin/perl -T

# WWW interface for CW beacon, beacon.main.cgi

## Setup user config
#
# file that holds current beacon status
$file = "/usr/local/etc/beacon.status";
# your callsign
$call = "CALL";
# default message
$def = "v v de CALL/b GRID li qsl via EMAIL";
# enter antenna 1 description (default antenna)
$ant1 = "Vertical 1/2 wave dipole";
# enter antenna 2 description
$ant2 = "Horizontal 1/2 wave dipole";
#
## End user config

# Setup
#
select STDOUT;
$| = 1;

# Print MIME
#
print "Content-type:text/html\n\n";

open F, $file or print "Can't open $file: $!\n";
	while (<F>) {	
		($status, $freq) = split /\|/;
	}
close F;

# Check current beacon status
#
if (!$status) {
	$status = "off";
}

if (!$freq) {
	$freq = "0.0";
}

$call =~ tr/a-z/A-Z/;

print <<END_OF_FILE;
<html><head><title>Web Controlled 6 meter Amatuer Radio CW Beacon</title></head>
<body bgcolor="#000000" text="#11AAFF">
<font size="6" color="#AA11FF">

<center>Control the $call 6 meter CW beacon via this webpage</center><br><p>
<font size="4" color="#11AAFF">
<center>You can control the CW speed, power, antenna and send your own message.
</center>
<center>When no user message is present, the beacon sends:
<b>$def</b></center><br>

<table width="600" border="0">
<form action="../../cgi-bin/web_cw_beacon.cgi" method="post">

<tr>
<td valign="left"><b>Enter message (20 characters max):</b></td>
<td valign="right"><input type="text" name="message" size="20" value=""></td>
</tr>

<tr>
<td valign="left"><b>Choose a delay (between characters):</b></td>
<td valign="right"><select name="delay"><option selected>1<option>2<option>3<option>4<option>5</select>
</tr>

<tr>
<td valign="left"><b>Choose an antenna:</b></td>
<td valign="right"><select name="ant"><option selected>1 : $ant1<option>2 : $ant2</select>
</tr>

<tr>
<td valign="left"><b>Select output power attenuation (3 dB):</b></td>
<td valign="right"><select name="att"><option selected>off<option>on</select>
</tr>

<tr>
<td valign="left"><b>CW speed (5 to 50 wpm):</b></td>
<td valign="right"><input type="text" name="speed" size="2" value=""></td>
</tr>

<tr>
<td><input type="submit" value="Submit"></td>
<td><input type="reset" value="Clear"></td>
</tr>

</form>
</table>
<p>
<hr>
<center><b>Current beacon status: $status @ $freq MHz</b></center<br><p>
</hr>
<center><a href="../beacon/50.txt">List of other 6 meter beacons</a><br></center>
</body>
</html>
END_OF_FILE
