#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Environmental Factor Analysis, environmental.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;

my $pic = "pics/path.png";

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $elv = $FORM{'elv'};
my $elv_val = $FORM{'elv_val'};

my $temp = $FORM{'temp'};
my $temp_val = $FORM{'temp_val'};

my $rh = $FORM{'rh'};

my $baro = $FORM{'baro'};

# Clean up user input data
#
$elv =~ tr/0-9.//csd;
$elv_val =~ tr/a-z//csd;

if (!$elv) {
  $elv = 198.12; $elv_val = "meters"; # 198 meters AMSL
}

$temp =~ tr/0-9.-//csd;
$temp_val =~ tr/a-z//csd;

if (!$temp) {
  $temp = 27; $temp_val = "celsius"; # 27 degrees celsius
}

$rh =~ tr/0-9.//csd;

if (!$rh) {
  $rh = 50; # 50% relative humidity
}

$baro =~ tr/0-9.//csd;

if (!$baro) {
  $baro = 30; # 30 inches of mercury
}

# Start calculations
#

# Elevation AMSL
#
if ($elv_val =~ /meters/i) {
  $elv = $elv * 3.2808399; # m to ft
}

# F to Umm C & K
#
if ($temp_val =~ /fahrenheit/i) {
  $temp_c = (5 / 9) * ($temp - 32);
}
else {
  $temp_c = $temp;
}

$temp_k = 273.15 + $temp_c;

# Atmospheric pressure from inches of mercury to millibars with sea level
# correction.
#
$p = (33.86 * $baro) - ($elv * 0.025);

# Vapor pressure calculations
#
# Saturation vapor pressure, millibars
#
$es = exp(1.805 + (0.0738 * $temp_c) - (0.000298 * ($temp_c ** 2)));

# Partial vapor pressure, millibars
#
$e = ($rh / 100) * $es;

# Index of refraction
#
$N = ((77.6 * $p) / $temp_k) + ((373000 * $e) / $temp_k ** 2);

# Effective Earth radius factor
#
$k = 1 / (1 - 0.04665 * exp(0.005577 * $N));

# Climate factor
#
$climate = (((1.8 * $temp_c) + 32) / 50) * 0.25;

# Make all pretty
#
$elv_m = sprintf "%.3f", $elv * 0.3048;
$elv = sprintf "%.3f", $elv;

$temp_c = sprintf "%.3f", $temp_c;
$temp_f = sprintf "%.3f", (1.8 * $temp_c) + 32;

$rh = sprintf "%.3f", $rh;
$baro = sprintf "%.3f", $baro;

$ep = sprintf "%.3f", $e;
$N = sprintf "%.3f", $N;
$k = sprintf "%.3f", $k;

$climate = sprintf "%.3f", $climate;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Environmental Factor Analysis Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>Environmental Factor Analysis Results</h2>
</center>

<hr noshade>
<center><img src="$pic" alt="[path]"></center>

<hr noshade>
<pre>
            $b Site elevation (AMSL) : $e$elv_m$b meters ($e$elv$b feet) $e
                 $b Site temperature : $e$temp_c$b celsius ($e$temp_f$b fahrenheit) $e
           $b Site relative humidity : $e$rh$b % $e
         $b Site barometric pressure : $e$baro$b inches of mercury $e
<br>
           $p Partial vapor pressure : $e$ep$p millibars $e
        $p Radio index of refraction : $e$N
                   $p Climate factor : $e$climate
$p Effective Earth radius factor (K) : $e$k
</pre>

<hr noshade size="5">

<blockquote>
<p>The radio index of refraction will change with the weather.&nbsp;&nbsp;On more humid days, the value will be greater; on cooler days it will be considerably less.</p>

<p>This calculation assumes K is constant over the whole radio path; that no unusual weather conditions have stratified the air, creating inversions or negative refractive conditions and that the two radio sites are at about the same elevation.&nbsp;&nbsp;These assumptions hold true only for short paths under average or &quot;normal&quot; atmospheric conditions and may not apply at all times.&nbsp;&nbsp;A more accurate determination of the refractive properties over a radio path require data from several points along the radio path.</p>

<p>The curvature of the Earth along any point on the radio path by be calculated as:
<pre>
C = (d<sub>1</sub> * (d - d<sub>1</sub>)) / (1.5 * k)

where
C  = curvature depression in feet
d  = total path distance
k  = effective Earth radius factor
d<sub>1</sub> = a point some distance from the transmitter site, in miles
</pre>

You can plot these points on a chart, as seen in the picture, and the resulting curved line represents the radio path for a designated effecitive Earth radius.</p>
</blockquote>

<p><font size="-1">Calculated on $date GMT</font></p>

</body>
</html>
EOF
