#!/usr/bin/perl -T 
#!/usr/local/bin/perl -T

## --> Antenna Isolation Calculator, isolation.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2002 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $first = $FORM{'first'};
my $first_val = $FORM{'first_val'};

my $second = $FORM{'second'};
my $second_val = $FORM{'second_val'};

my $frq = $FORM{'frq'};
my $frq_val = $FORM{'frq_val'};

my $sep = $FORM{'sep'};
my $sep_val = $FORM{'sep_val'};

# Clean up user input data
#
$first =~ tr/0-9.//csd;

if (!$first) {
  $first = 0; $first_val = "dBd";
}

$second =~ tr/0-9.//csd;

if (!$second) {
  $second = 0; $second_val = "dBd";
}

$frq =~ tr/0-9.//csd;

if (!$frq) {
  $frq = 450; $frq_val = "MHz";
}

$sep =~ tr/0-9.//csd;

if (!$sep) {
  $sep = 10; $sep_val = "feet";
}

# Start calculations
#

# Convert frequency to MHz / wavelength in meters
#
if ($frq_val eq "GHz") {
  $frq_mhz = $frq * 1000;
}
else {
  $frq_mhz = $frq;
}

$wav_m = (2.99792458E+12 / $frq_mhz) / 1E+10;
$wav_ft = $wav_m * 3.2808399;

# Convert separation to feet
#
if ($sep_val eq "meters") {
  $sep_ft = $sep * 3.2808399;
}
else {
  $sep_ft = $sep;
}

# Convert antenna gains to dBd
#
if ($first_val eq "dBi") {
  $first_gain = $first - 2.15;
}
else {
  $first_gain = $first;
}

if ($second_val eq "dBi") {
  $second_gain = $second - 2.15;
}
else {
  $second_gain = $second;
} 

# Horizontal separation
#
$hor_iso = 20 * log10($sep_ft / $wav_ft) - $first_gain - $second_gain + 17.7;

# Vertical separation
#
$ver_iso = 28 + 40 * log10($sep_ft / $wav_ft);

# Make all pretty
#
$ver_iso = sprintf "%.2f", $ver_iso;
$hor_iso = sprintf "%.2f", $hor_iso;

$first_gain = sprintf "%.2f", $first_gain;
$second_gain = sprintf "%.2f", $second_gain;
$first_gaindbi = sprintf "%.2f", $first_gain + 2.15;
$second_gaindbi = sprintf "%.2f", $second_gain + 2.15;

$sep_ft = sprintf "%.2f", $sep_ft;
$sep_m = sprintf "%.2f", $sep_ft * 0.3048;

$frq_mhz = sprintf "%.4f", $frq_mhz;
$frq_ghz = sprintf "%.4f", $frq_mhz / 1000;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Antenna Isolation Calculator Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>Antenna Isolation Calculator Results</h2>
</center>

<hr noshade>
<pre>
  $b Operating frequency : $e$frq_mhz$b MHz ($e$frq_ghz$b GHz) $e
<br>
   $b First antenna gain : $e$first_gain$b dBd ($e$first_gaindbi$b dBi) $e
  $b Second antenna gain : $e$second_gain$b dBd ($e$second_gaindbi$b dBi) $e
   $b Antenna separation : $e$sep_m$b meters ($e$sep_ft$b feet) $e
<br>
$p Horizontal isolation  : $e$hor_iso$p dB $e
  $p  Vertical isolation : $e$ver_iso$p dB $e
<br>
</pre>

<hr noshade size="5">

<blockquote>
<ul>
<li>Real world results are for omni-directional antennas and will vary greatly.</li>

<li>Nearby towers/masts/antennas will effect the results.</li>
</ul>
</blockquote>

<p><font size="-1">Calculated on $date GMT</font></p>
</body>
</html>
EOF
