#!/usr/bin/perl -T
#!/usr/local/bin/perl -T

## --> Parabolic Reflector Gain / Focal Point Calculator, parabolic.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2000 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
use Math::Complex;
select STDOUT;
$| = 1;

# Print MIME
#
print "Content-type:text/html\n\n";

# Read environment
#
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
@pairs = split(/&/, $buffer);
foreach $pair (@pairs) {
  ($name, $value) = split(/=/, $pair);
  $value =~ tr/+/ /;
  $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
  $FORM{$name} = $value;
}

my $ill = $FORM{'ill'};

my $ref_dia = $FORM{'ref_dia'};
my $ref_dia_val = $FORM{'ref_dia_val'};

my $ref_dep = $FORM{'ref_dep'};
my $ref_dep_val = $FORM{'ref_dep_val'};

my $frq = $FORM{'frq'};
my $frq_val = $FORM{'frq_val'};

# Clean up user input data
#
$ill =~ tr/0-9.//csd;

if (!$ill) {
  $ill = 0.6; # 0.6 illumination factor
}

$ref_dia =~ tr/0-9.//csd;
$ref_dia_val =~ tr/a-z//csd;

if (!$ref_dia) {
  $ref_dia = 30; $ref_dia_val = "centimeters"; # 30 centimeters diameter
}

$ref_dep =~ tr/0-9.//csd;
$ref_dep_val =~ tr/a-z//csd;

if (!$ref_dep) {
  $ref_dep = 15; $ref_dep_val = "centimeters"; # 15 centimeters deep
}

$frq =~ tr/0-9.//csd;
$frq_val =~ tr/a-zA-Z//csd;

if (!$frq) {
  $frq = 2450; $frq_val = "MHz"; # 2450.0 MHz
}

# Start calculations
#

# Reflector diameter
#
if ($ref_dia_val =~ /inches/i) {
  $dia = $ref_dia * 2.54; # in to cm
}
elsif ($ref_dia_val =~ /centimeters/i) {
  $dia = $ref_dia; # cm to cm
}

# Reflector depth
#
if ($ref_dep_val =~ /inches/i) {
  $dep = $ref_dep * 2.54; # in to cm
}
elsif ($ref_dep_val =~ /centimeters/i) {
  $dep = $ref_dep; # cm to cm
}

# Frequncy
#
if ($frq_val =~ /mhz/i) {
  $wav = (2.99793E+12 / $frq) / 1E+08; # wav to cm
  $theta = 70 / (($dia / 30.48) * ($frq / 1000));
}
elsif ($frq_val =~ /ghz/i) {
  $wav = (2.99793E+09 / $frq) / 1E+08; # wav to cm
  $theta = 70 / (($dia / 30.48) * $frq);
}

# Start calculations
#
$gain = (20 * (log10 ($dia / $wav))) + ((10 * (log10 $ill)) + 9.938);
$foc = ($dia ** 2) / (16 * $dep);

# Near-field and Fresnel radiation distance in cm
#
$near =  0.62 * sqrt (($dia ** 3) / $wav);
$fresnel = 2 * (($dia ** 2) / $wav);

# Make all pretty
#
$ill = sprintf "%.3f", $ill;

$dia_in = sprintf "%.3f", $dia / 2.54;
$dia = sprintf "%.3f", $dia;

$dep_in = sprintf "%.3f", $dep / 2.54;
$dep = sprintf "%.3f", $dep;

$gain = sprintf "%.3f", $gain;

$foc_in = sprintf "%.3f", $foc / 2.54;
$foc = sprintf "%.3f", $foc;

$theta = sprintf "%.3f", $theta;

$near_ft = sprintf "%.3f", $near / 30.48;
$near = sprintf "%.3f", $near / 100;

$fresnel_ft = sprintf "%.3f", $fresnel / 30.48;
$fresnel = sprintf "%.3f", $fresnel / 100;

$date = scalar gmtime;

# Draw me a web page
#
$b = "<font color=\"blue\">";
$p = "<font color=\"purple\">";
$e = "</font>";

print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Parabolic Reflector Analysis Results</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center>
<h2>Parabolic Reflector Analysis Results</h2>
</center>

<hr noshade>
<pre>
$b Illumination factor : $e$ill
$b Operating frequency : $e$frq $b$frq_val $e
<br>
 $b Reflector diameter : $e$dia$b centimeters ($e$dia_in$b inches) $e
    $b Reflector depth : $e$dep$b centimeters ($e$dep_in$b inches) $e
        $b Focal point : $e$foc$b centimeters ($e$foc_in$b inches) $e
<br>
   $p Approximate gain : $e$gain$p dBi $e
     $p 3 dB beamwidth : $e$theta$p degrees $e
<br>
</pre>

<blockquote>
<p>The near-field radiation distance extends to $near meters ($near_ft feet) in front of the antenna.</p>

<p>The Fresnel radiation zone extends from the near-field region out to $fresnel meters ($fresnel_ft feet) in front of the antenna.</p>
</blockquote>

<hr noshade size="5">

<blockquote>
<ul>
<li>Focal point is measured from the bottom of the reflector.</li>

<li>Radiation fields are measured from the front of a transmitting antenna.</li>

<li>Far-field radiation extends from the Fresnel radiation zone out to infinity, or the receive site.</li>
</ul>
</blockquote>

<p><font size="-1">Calculated on $date GMT</font></p>
</body>
</html>
EOF
