#!/usr/bin/perl 

## --> Wireless Network Link Analysis, wireless.main.cgi
## --> Green Bay Professional Packet Radio, www.gbppr.org

## This file Copyright 2003 <contact@gbppr.org> under the GPL.
## NO WARRANTY.  Please send bug reports / patches.

# Setup
#
select STDOUT;
$| = 1;

# User stuff
#
my $pic = "pics/link_view.png";
my $cli_pic = "pics/gbppr-usa-climate.jpg";
my $tmp_pic = "pics/gbppr-usa-temp.jpg";
my $form = "./wireless.cgi";

# Print MIME
#
print "Content-type:text/html\n\n";

# Draw me a web page
#
print <<EOF;
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 3.2//EN">
<html>
<head>
<title>Wireless Network Link Analysis</title>
</head>
<body bgcolor="#D3D3D3" text="#000000" link="blue">
<center><font face="Verdana, Arial, Helvetica"><h2>Wireless Network Link Analysis</h2></font></center>

<center><p>A service of <a href="http://www.gbppr.org">Green Bay Professional Packet Radio</a>&nbsp;&reg;</p></center>

<hr noshade>
<center><img src="$pic" alt="[link view]"></center>
<hr noshade>

<center>
<br>
<table border="2" cellpadding="2">
<tr>
<td colspan="10" bgcolor="yellow" align="center"><font size="4"><b>Transmitter Specifications</b></font></td>
</tr>
</table>
<br>
</center>

<form action="$form" method="post">
<table border="0">
<tr>
<td align="right"><b>Highest Transmitted Frequency&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="frq" size="10" value="2467">
<select name="frq_val">
<option selected>MHz</option>
<option>GHz</option>
</select></td>
</tr>

<tr>
<td align="right"><b>Transmitter RF Power Output&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="pwr_out" size="10" value="20">
<select name="pwr_out_val">
<option selected>dBm</option>
<option>milliWatts</option>
<option>Watts</option>
<option>dBW</option>
<option>kiloWatts</option>
<option>dBk</option>
</select></td>
</tr>
</table>

<center>
<br>
<table border="2" cellpadding="2">
<tr>
<td colspan="10" bgcolor="yellow" align="center"><font size="4"><b>Transmitter Cable &amp; Antenna Specifications</b></font></td>
</tr>
</table>
<br>
</center>

<table border="0">
<tr>
<td align="right"><b>Transmitter Site Name&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="tx_name" size="32" value="TX Site Name"></td>
</tr>

<tr>
<td align="right"><b>Transmitter External Cable Type&nbsp;&nbsp;</b></td>
<td align="left"><select name="tx_cab">
<option selected>Times Microwave LMR-400</option>
<option>Times Microwave LMR-400 UltraFlex</option>
<option>Times Microwave LMR-500</option>
<option>Times Microwave LMR-600</option>
<option>Times Microwave LMR-900</option>
<option>Times Microwave LMR-1200</option>
<option>Times Microwave LMR-1700</option>
<option>Andrew Heliax LDF4-50A</option>
<option>Andrew Heliax LDF5-50A</option>
<option>Andrew Heliax LDF6-50A</option>
<option>Andrew Heliax LDF7-50A</option>
<option>Belden 9913 (RG-8)</option>
<option>Belden 8267 (RG-213)</option>
<option>Belden 9258 (RG-8X)</option>
<option>Belden 8240 (RG-58)</option>
<option>Crap RG-8</option>
<option>Other</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td align="right"><b>If </b>Other<b>, Transmitter Cable Loss Specification&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="tx_cab_other" size="5" value="0"> dB&nbsp;&nbsp;
<input type="radio" name="chia1" value="meters">&nbsp;per 100 meters&nbsp;&nbsp;
<input type="radio" name="chia1" value="feet" checked>&nbsp;per 100 feet</td>
</tr>

<tr>
<td align="right"><b>Transmitter External Cable Length&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="tx_len" size="5" value="15">
<select name="tx_len_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>

<tr>
<td align="right"><b>Transmitter Antenna Peak Gain&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="tx_ant_gain" size="5" value="24">
<select name="tx_ant_val">
<option selected>dBi</option>
<option>dBd</option>
</select></td>
</tr>

<tr>
<td align="right"><b>Transmitter Antenna Radome Loss<sup>1</sup>&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="tx_radome" size="5" value="0"> dB</td>
</tr>

<tr>
<td align="right"><b>Transmitter Site Ground Elevation (AMSL)&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="tx_elv" size="5" value="180">
<select name="tx_elv_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>

<tr>
<td align="right"><b>Transmitter Antenna Height (AGL)<sup>2</sup>&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="tx_ant_ht" size="5" value="14">
<select name="tx_ant_ht_val">
<option selected>meters</option>
<option>feet</option>
</select>&nbsp;&nbsp;Center-of-Radiation</td>
</tr>
</table>

<table border="0">
<tr>
<td align="right"><b>Total Number of Transmitter Cable Connectors/Adapters&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="con_tx" size="5" value="2"></td>
</tr>

<tr>
<td align="right"><b>Miscellaneous Transmitter Cable Losses&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="tx_misc_cab_loss" size="5" value="0"> dB&nbsp;&nbsp;
<select name="null">
<option selected>-- EXAMPLES --</option>
<option>2-port splitter, 3.5 dB loss</option>
<option>4-port splitter, 6.5 dB loss</option>
<option>PolyPhaser, 0.2 dB loss</option>
<option>Right angle N adapter, 0.5 dB loss</option>
<option>DC injector, 0.2 dB loss</option>
<option>Isolator, 0.8 dB loss</option>
<option>Filter, 2 dB loss</option>
<option>RF branching loss</option>
<option>Transmit only attenuator pad</option>
<option>Flex jumpers</option>
<option>Standby switches</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td align="right"><b>Miscellaneous Transmitter Gains, After Cable Loss&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="tx_misc_gain" size="5" value="0"> dB&nbsp;&nbsp;
<select name="null">
<option selected>-- EXAMPLES --</option>
<option>Tower top power amplifier, 20 dB gain</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td align="right"><b>Miscellaneous Transmitter Path Losses<sup>3</sup>&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="tx_misc_loss" size="5" value="0"> dB&nbsp;&nbsp;
<select name="null">
<option selected> -- EXAMPLES --</option>
<option>Tree absorption, 0.15-0.4 dB/meter @ 1 GHz</option>
<option>Tree absorption, 0.25-0.5 dB/meter @ 2.4 GHz</option>
<option>Tree absorption, 0.4-0.6 dB/meter @ 3.3 GHz</option>
<option>Tree absorption, 0.5-1.5 dB/meter @ 5.8 GHz</option>
<option>Tree absorption, 1.0-2.0 dB/meter @ 10 GHz</option>
<option>Slight antenna mis-alignment loss, 0.5 dB</option>
<option>90&deg; antenna polarization mismatch, 20 dB</option>
<option>75&deg; antenna polarization mismatch, 12 dB</option>
<option>60&deg; antenna polarization mismatch, 6 dB</option>
<option>45&deg; antenna polarization mismatch, 3 dB</option>
<option>30&deg; antenna polarization mismatch, 1.3 dB</option>
<option>15&deg; antenna polarization mismatch, 0.3 dB</option>
<option>Linear to circular antenna polarization mismatch, 3 dB</option>
<option>Knife edge diffraction</option>
</select></td>
</tr>
</table>

<center>
<br>
<table border="2" cellpadding="2">
<tr>
<td colspan="10" bgcolor="yellow" align="center"><font size="4"><b>Receiver Cable &amp; Antenna Specifications</b></font></td>
</tr>
</table>
<br>
</center>

<table border="0">
<tr>
<td align="right"><b>Receiver Site Name&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="rx_name" size="32" value="RX Site Name"></td>
</tr>

<tr>
<td align="right"><b>Receiver External Cable Type&nbsp;&nbsp;</b></td>
<td align="left"><select name="rx_cab">
<option selected>Times Microwave LMR-400</option>
<option>Times Microwave LMR-400 UltraFlex</option>
<option>Times Microwave LMR-500</option>
<option>Times Microwave LMR-600</option>
<option>Times Microwave LMR-900</option>
<option>Times Microwave LMR-1200</option>
<option>Times Microwave LMR-1700</option>
<option>Andrew Heliax LDF4-50A</option>
<option>Andrew Heliax LDF5-50A</option>
<option>Andrew Heliax LDF6-50A</option>
<option>Andrew Heliax LDF7-50A</option>
<option>Belden 9913 (RG-8)</option>
<option>Belden 8267 (RG-213)</option>
<option>Belden 9258 (RG-8X)</option>
<option>Belden 8240 (RG-58)</option>
<option>Crap RG-8</option>
<option>Other</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td align="right"><b>If </b>Other<b>, Enter the Receiver Cable Loss Specification&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="rx_cab_other" size="5" value="0">dB&nbsp;&nbsp;&nbsp;&nbsp;
<input type="radio" name="chia2" value="meters">&nbsp;per 100 meters&nbsp;&nbsp;
<input type="radio" name="chia2" value="feet" checked>&nbsp;per 100 feet</td>
</tr>

<tr>
<td align="right"><b>Receiver External Cable Length&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="rx_len" size="5" value="15">
<select name="rx_len_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>

<tr>
<td align="right"><b>Receiver Antenna Peak Gain&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="rx_ant_gain" size="5" value="12">
<select name="rx_ant_val">
<option selected>dBi</option>
<option>dBd</option>
</select></td>
</tr>

<tr>
<td align="right"><b>Receiver Antenna Radome Loss<sup>1</sup>&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="rx_radome" size="5" value="0"> dB</td>
</tr>

<tr>
<td align="right"><b>Receiver Site Ground Elevation (AMSL)&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="rx_elv" size="5" value="186">
<select name="rx_elv_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>

<tr>
<td align="right"><b>Receiver Antenna Height (AGL)<sup>2</sup>&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="rx_ant_ht" size="5" value="19">
<select name="rx_ant_ht_val">
<option selected>meters</option>
<option>feet</option>
</select>&nbsp;&nbsp;Center-of-Radiation</td>
</tr>
</table>

<table border="0">
<tr>
<td align="left"><i>Following <font color="red">FOUR</font> questions are for vertical space diversity systems only</i></td>
</tr>

<tr>
<td align="right"><b><font color="red">Receiver Vertical Diversity Antenna Height (AGL)<sup>2</sup>&nbsp;&nbsp;</font></b></td>
<td align="left"><input type="text" name="rx_div_ant_ht" size="5" value="0">
<select name="rx_div_ant_ht_val">
<option selected>meters</option>
<option>feet</option>
</select>&nbsp;&nbsp;Center-of-Radiation</td>
</tr>

<tr>
<td align="right"><b><font color="red">Receiver Diversity Antenna Peak Gain&nbsp;&nbsp;</font></b></td>
<td align="left"><input type="text" name="rx_div_ant_gain" size="5" value="0">
<select name="rx_div_ant_val">
<option selected>dBi</option>
<option>dBd</option>
</select></td>
</tr>

<tr>
<td align="right"><b><font color="red">Receiver Diversity Antenna External Cable Length<sup>4</sup>&nbsp;&nbsp;</font></b></td>
<td align="left"><input type="text" name="rx_div_len" size="5" value="0">
<select name="rx_div_len_val">
<option selected>meters</option>
<option>feet</option>
</select></td>
</tr>

<tr>
<td align="right"><b><font color="red">Miscellaneous Receiver Diversity Antenna Losses&nbsp;&nbsp;</font></b>
<td align="left"><input type="text" name="rx_div_misc_cab_loss" size="5" value="0"> dB&nbsp;&nbsp;
<select name="null">
<option selected> -- EXAMPLES --</option>
<option>Radome loss, 0.5 dB</option>
<option>Connector loss, 0.25 dB</option>
<option>PolyPhaser, 0.2 dB loss</option>
<option>Filter, 2 dB loss</option>
<option>Flex jumpers</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td align="right"><b>Total Number of Receiver Cable Connectors/Adapters&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="con_rx" size="5" value="2"></td>
</tr>

<tr>
<td align="right"><b>Miscellaneous Receiver Cable Losses&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="rx_misc_cab_loss" size="5" value="0"> dB&nbsp;&nbsp;
<select name="null">
<option selected> -- EXAMPLES --</option>
<option>2-port splitter, 3.5 dB loss</option>
<option>4-port splitter, 6.5 dB loss</option>
<option>PolyPhaser, 0.2 dB loss</option>
<option>Right angle N adapter, 0.5 dB loss</option>
<option>DC injector, 0.2 dB loss</option>
<option>Isolator, 0.8 dB loss</option>
<option>Filter, 2 dB loss</option>
<option>RF branching loss</option>
<option>Flex jumpers</option>
<option>Standby switches</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td align="right"><b>Miscellaneous Receiver Gains, Before Cable Loss&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="rx_misc_gain" size="5" value="0"> dB&nbsp;&nbsp;
<select name="null">
<option selected>-- EXAMPLES --</option>
<option>Tower top receive pre-amplifier, 17 dB gain</option>
</select></td>
</tr>

<tr>
<td align="right"><b>Receiver Threshold (sensitivity)&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="BER" size="5" value="-90">
<select name="BER_val">
<option selected>dBm</option>
<option>microVolts</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td align="left"><i>Following <font color="green">THREE</font> questions are for digital data systems only</i></td>
</tr>

<tr>
<td align="right"><b><font color="green">Receiver Dispersive Fade Margin (DFM)<sup>5</sup>&nbsp;&nbsp;</font></b></td>
<td align="left"><input type="text" name="dfm" size="5" value="0"> dB</td>
</tr>

<tr>
<td align="right"><b><font color="green">Receiver External Interference Fade Margin (EIFM)<sup>6</sup>&nbsp;&nbsp;</font></b></td>
<td align="left"><input type="text" name="eifm" size="5" value="0"> dB</td>
</tr>

<tr>
<td align="right"><b><font color="green">Receiver Adjacent Channel Interference Fade Margin (AIFM)<sup>7</sup>&nbsp;&nbsp;</font></b></td>
<td align="left"><input type="text" name="aifm" size="5" value="0"> dB</td>
</tr>
</table>

<center>
<br>
<table border="2" cellpadding="2">
<tr>
<td colspan="10" bgcolor="yellow" align="center"><font size="4"><b>Transmitter/Receiver Antenna Distance &amp; Environmental Specifications</b></font></td>
</tr>
</table>
<br>
</center>

<table border="0">
<tr>
<td align="right"><b>Would You Like to Calculate the Climate Factor?&nbsp;&nbsp;</b></td> 
<td align="left"><input type="radio" name="chia4" value="yes">Yes&nbsp;&nbsp;
<input type="radio" name="chia4" value="no" checked>No</td>
</tr>

<tr>
<td align="right"><b>If </b>No<b>, Choose the <a href="$cli_pic">Climate Factor</a>&nbsp;&nbsp;</b></td>
<td align="left"><select name="climate">
<option>0.25 : Mountainous, very rough, very dry but non-reflective</option>
<option selected>1 : Average terrain, with some roughness</option>
<option>2 : Great lakes area</option>
<option>4 : Very smooth terrain, over water or flat desert, non-coastal</option>
<option>6 : Very smooth terrain, over water or flat desert, coastal</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td align="right"><b><i>If </b>Yes<b>, Answer the Following <font color="red">TWO</font> Questions</i></b></td>
</tr>

<tr>
<td align="right"><font color="red"><b>Average Terrain Roughness<sup>8</sup>&nbsp;&nbsp;</b></font></td>
<td align="left"><input type="text" name="rough" size="5" value="15">
<select name="rough_val">
<option selected>meters</option>
<option>feet</option>
</select>&nbsp;&nbsp;Deviation of Elevations</td>
</tr>

<tr>
<td align="right"><font color="red"><b>Local Area Humidity Type&nbsp;&nbsp;</b></font></td>
<td align="left"><select name="rough_hum">
<option>Coastal, very humid areas</option>
<option>Non-coastal, humid areas</option>
<option selected>Average or temperate areas</option>
<option>Dry areas</option>
</select></td>
</tr>
</table>

<br>

<table border="0">
<tr>
<td align="right"><b>Would You Like to Calculate the Effective Earth Radius, K Factor?&nbsp;&nbsp;</b></td>
<td align="left"><input type="radio" name="chia3" value="yes">Yes&nbsp;&nbsp;
<input type="radio" name="chia3" value="no" checked>No</td>
</tr>

<tr>
<td align="right"><b><b>If </b>No<b>, Select the Effective Earth Radius, K Factor&nbsp;&nbsp;</b></td>
<td align="left"><select name="k">
<option>5/12</option>
<option>1/2</option>
<option>2/3</option>
<option>1.0</option>
<option>7/6</option>
<option selected>4/3</option>
<option>5/3</option>
<option>2.0</option>
<option>4.0</option>
<option>Infinity</option>
</select></td>
</tr>

<table border="0">
<tr>
<td align="right"><b><i>If </b>Yes<b>, Answer the Following <font color="green"><i>TWO</i></font> Questions</i></b></td>
</tr>

<tr>
<td align="right"><font color="green"><b>Average Annual Relative Humidity&nbsp;&nbsp;</b></font></td>
<td align="left"><input type="text" name="rh" size="5" value="50"> percent</td>
</tr>

<tr>
<td align="right"><font color="green"><b>Average Annual Barometric Pressure&nbsp;&nbsp;</b></font></td>
<td align="left"><input type="text" name="baro" size="5" value="30"> inches of mercury</td>
</tr>
</table>

<br>

<table border="0">
<tr>
<td align="right"><b>Average Annual <a href="$tmp_pic">Temperature</a>&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="temp" size="5" value="8">
<select name="temp_val">
<option selected>celsius</option>
<option>fahrenheit</option>
</select></td>
</tr>

<tr>
<td align="right"><b>Enter a <a href="pics/rain_rate.html">Precipitation Rate</a>&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="rate" size="5" value="0"> mm/hour</td>
</tr>

<tr>
<td align="right"><b>Select the Urban Environment Factor&nbsp;&nbsp;</b></td>
<td align="left"><select name="envy">
<option selected>Urban - Small City</option>
<option>Urban - Large City</option>
<option>Urban Indoor - Large City</option>
<option>Suburban</option>
<option>Rural Indoor - Quasi Open</option>
<option>Rural Country Side - Quasi Open</option>
<option>Rural Desert - Open</option>
</select></td>
</tr>

<tr>
<td align="right"><b>Select the N <sup>th</sup> Fresnel Zone to Calculate&nbsp;&nbsp;</b></td>
<td align="left"><select name="nth">
<option>0.3</option>
<option>0.4</option>
<option>0.5</option>
<option>0.7</option>
<option>0.8</option>
<option>0.9</option>
<option selected>1.0</option>
<option>2.0</option>
<option>3.0</option>
<option>4.0</option>
<option>5.0</option>
<option>6.0</option>
<option>7.0</option>
<option>8.0</option>
<option>9.0</option>
</select></td>
</tr>
</table>

<br>

<table border="0">
<tr>
<td align="right"><b>Would You Like to Calculate the Path Distance Based on Latitude &amp; Longitude?&nbsp;&nbsp;</b></td>
<td align="left"><input type="radio" name="chia" value="yes">Yes&nbsp;&nbsp;
<input type="radio" name="chia" value="no" checked>No</td>
</tr>

<tr>
<td align="right"><b>If </b>No<b>, Enter the Distance Between Antenna Sites&nbsp;&nbsp;</b></td>
<td align="left"><input type="text" name="dist" size="5" value="10">
<select name="dist_val">
<option selected>kilometers</option>
<option>miles</option>
</select></td>
</tr>
</table>

<table border="0">
<tr>
<td align="right"><i><b>If </b>Yes<b>, Answer the Following <font color="purple">FOUR</font> Questions</b></i></td>
</tr>

<tr>
<td align="right"><font color="purple"><b>Transmitter Site Latitude&nbsp;&nbsp;</b></font></td>
<td align="left"><input type="text" name="LAT1_D" size="4" value="">&nbsp;&deg;&nbsp;
<input type="text" name="LAT1_M" size="4" value="">&nbsp;'&nbsp;
<input type="text" name="LAT1_S" size="4" value="">&nbsp;&quot;&nbsp;&nbsp;Positive is North</td>
</tr>

<tr>
<td align="right"><font color="purple"><b>Transmitter Site Longitude&nbsp;&nbsp;</b></font></td>
<td align="left"><input type="text" name="LON1_D" size="4" value="">&nbsp;&deg;&nbsp;
<input type="text" name="LON1_M" size="4" value="">&nbsp;'&nbsp;
<input type="text" name="LON1_S" size="4" value="">&nbsp;&quot;&nbsp;&nbsp;Negative is West</td>
</tr>

<tr>
<td align="right"><font color="purple"><b>Receiver Site Latitude&nbsp;&nbsp;</b></font></td>
<td align="left"><input type="text" name="LAT2_D" size="4" value="">&nbsp;&deg;&nbsp;
<input type="text" name="LAT2_M" size="4" value="">&nbsp;'&nbsp;
<input type="text" name="LAT2_S" size="4" value="">&nbsp;&quot;&nbsp;&nbsp;Positive is North</td>
</tr>

<tr>
<td align="right"><font color="purple"><b>Receiver Site Longitude&nbsp;&nbsp;</b></font></td>
<td align="left"><input type="text" name="LON2_D" size="4" value="">&nbsp;&deg;&nbsp;
<input type="text" name="LON2_M" size="4" value="">&nbsp;'&nbsp;
<input type="text" name="LON2_S" size="4" value="">&nbsp;&quot;&nbsp;&nbsp;Negative is West</td>
</tr>
</table>

<hr noshade>

<center>
<table>
<tr>
<td><input type="submit" value="Submit"></td>
<td><input type="reset" value="Clear"></td>
</tr>
</table>
</center>
</form>

<hr noshade size="5">

<p><b><u>Notes</u></b></p>

<blockquote>
<p><b>AGL</b>&nbsp;&nbsp;Above Ground Level.&nbsp;&nbsp;Height above common ground to the midpoint of the radiating antenna.</p>

<p><b>AMSL</b>&nbsp;&nbsp;Above Mean Sea Level.&nbsp;&nbsp;Height referenced above sea level, or zero elevation.</p>


<ol>
<li>For sealed Yagi antennas, radome loss is usually taken into account in the antenna's specified gain.</li>

<p></p>

<li>Antenna height and diversity antenna height should be measured from the antenna's center-of-radiation, usually the midpoint of the antenna.</li>

<p></p>

<li>Miscellaneous path losses are caused by ground reflections, atmospheric absorption, interference, rain/fog, billboards, vegetation, knife-edge diffraction, small farm animals, etc.</li>

<p></p>

<li>Diversity antenna cable type is assumed the same as the main receiver's.</li>

<p></p>

<li>Dispersive fade margin is provided by your radio's manufacturer, and is determined by the type of modulation, effectiveness of any equalization in the receive path, and the multipath signal's time delay.&nbsp;&nbsp;Dispersive fade margin characterizes the radio's robustness to dispersive (spectrum-distoring) fades.</li>

<p></p>

<li>External interference fade margin is receiver threshold degradation due to interference from external systems.</li>

<p></p>

<li>Adjacent channel interference fade margin accounts for receiver threshold degradation due to interference from adjacent channel transmitters in one's own system.</li>

<p></p>

<li>Example standard deviation of the terrain elevations: 6 meters - for smooth and over-water terrain, 15 meters - for average terrain with some roughness, 43 meters - for mountainous or very rough terrain.</li>

<p></p>

<li>The K Factor accounts for refraction of radio waves close to the surface of the Earth.&nbsp;&nbsp;For antenna towers less than a couple of thousand feet above the surface, a K Factor of <tt>4/3</tt> is usually adequate for most line-of-sight calculations over average terrain.&nbsp;&nbsp;A K Factor of <tt>1.0</tt> is equal to the true Earth radius, a K Factor of <tt>Infinity</tt> is equal to a flat Earth.</li>
</ol>
</blockquote>
</body>
</html>
EOF
