// 
// AMD Expanded Debugging utility for Windows
//   The application is used to control some of the secret MSR registers,
//   internally used by the AMD-series processors for specifying hidden
//   debugging features.
//
//
// Author:  j00ru//vx
// Date:    2010-11-23
// E-mail:  j00ru.vx@gmail.com
// WWW:     http://j00ru.vexillium.org/
//
// Version: 0.0.1
// Module:  Kernel-mode device driver (header)
//
// Note: Special thanks to Czernobyl (http://www.czerno.tk/) for taking the time
//       to actually discover and reverse engineer the yet unknown processor 
//       internals.
//
// References:
//   1) http://www.woodmann.com/forum/showthread.php?13891
//      The original forum post, where Czarnobyl shared initial information related
//      to the mystery mechanism.
//
//   2) http://www.czerno.tk/
//      Czernobyl's home-page, with a brief description of the current progress state.
//
//   3) http://hardware.slashdot.org/story/10/11/12/047243/Hidden-Debug-Mode-Found-In-AMD-Processors
//      A slashdot article regarding the issue, blocking the woodmann forums for about a day.
//
//   4) http://cbid.softnology.biz/html/undocmsrs.html
//      Undocumented Machine-Specific Registers: internal names of the MSR registers, which
//      are not publicly known or taken advantage of.
//
//
// Known bugs:
//   1) The code is only compatible with the x86 (32-bit) AMD architecture.
//   2) ?
//
//
// License:
//
//   Permission is hereby granted to use, copy, modify, and distribute this source code, 
//   or portions hereof, documentation and executables, for any purpose, without fee, 
//   subject to the following restrictions:
//   
//   1. The origin of this source code must not be misrepresented.
//  
//   2. Altered versions must be plainly marked as such and must not be misrepresented 
//      as being the original source.
//  
//   3. This Copyright notice may not be removed or altered from any source or altered 
//      source distribution.
//   
//   This software is provided "AS IS". The author does not guarantee that this program works 
//   or is bug-free. The author takes no responsibility for any damage caused by this program.
//   Use at your own risk.
//

#ifndef _IOCTLCMD_H
#define _IOCTLCMD_H

#define AMDDBG_VERSION "v0.0.1"


/****************************************************************************
 * Constants ****************************************************************
 ****************************************************************************/

/* The file-system name of the kernel module
 */
CONST CHAR DriverFileName[] = "AMD_dbg.sys";


/* The symbolic filenames used by the user-mode client application
 * to communicate with the kernel module
 */
CONST WCHAR DriverName[]    = L"\\Device\\AMD_dbg";
CONST WCHAR DosDeviceName[] = L"\\DosDevices\\AMD_dbg";

/* Constant, secret MSR identifiers
 */
CONST ULONG MSR_CONTROL_ID      = 0xC0011024;
CONST ULONG MSR_DATA_MATCH_ID   = 0xC0011025;
CONST ULONG MSR_DATA_MASK_ID    = 0xC0011026;
CONST ULONG MSR_ADDRESS_MASK_ID = 0xC0011027;

CONST ULONG MSR_TERMINATOR_ID   = 0xFFFFFFFF;


/****************************************************************************
 * Custom structures ********************************************************
 ****************************************************************************/
struct tagMSR
{
  ULONG MsrControl;
  ULONG MsrDataMatch;
  ULONG MsrDataMask;
  ULONG MsrAddressMask;
};

struct tagSingleMSR
{
  ULONG MsrRegister;
  ULONG MsrValue;
};


/****************************************************************************
 * IOCTL message definitions ************************************************
 ****************************************************************************/
#define IOCTL_QUERY_VERSION \
CTL_CODE(FILE_DEVICE_UNKNOWN, 0x880, METHOD_NEITHER, FILE_ANY_ACCESS)
#define IOCTL_FINISH \
CTL_CODE(FILE_DEVICE_UNKNOWN, 0x881, METHOD_NEITHER, FILE_ANY_ACCESS)

#define IOCTL_GET_SECRET_MSR \
CTL_CODE(FILE_DEVICE_UNKNOWN, 0x882, METHOD_NEITHER , FILE_ANY_ACCESS)
#define IOCTL_SET_SECRET_MSR \
CTL_CODE(FILE_DEVICE_UNKNOWN, 0x883, METHOD_NEITHER , FILE_ANY_ACCESS)
#define IOCTL_SET_SINGLE_MSR \
CTL_CODE(FILE_DEVICE_UNKNOWN, 0x884, METHOD_NEITHER , FILE_ANY_ACCESS)


NTSTATUS
HandleQueryVersion(
	PVOID,
	PVOID,
	ULONG,
	ULONG
);

NTSTATUS
HandleFinish(
	PVOID,
	PVOID,
	ULONG,
	ULONG
);

NTSTATUS
HandleGetMSR(
	PVOID,
	PVOID,
	ULONG,
	ULONG
);

NTSTATUS
HandleSetMSR(
	PVOID,
	PVOID,
	ULONG,
	ULONG
);

NTSTATUS
HandleSetSingleMSR(
	PVOID,
	PVOID,
	ULONG,
	ULONG
);

#endif


