/*
*  Interactive disassembler (IDA).
*  Adobe Flash ActionScript2 processor module
*  Marian RADU <marianra@microsoft.com>
*/

#ifndef __INSTRS_HPP
#define __INSTRS_HPP

#include "../idaidp.hpp"

extern instruc_t Instructions[];

enum nameNum ENUM_SIZE(uint16)
{
    SWFACTION_NULL = 0, 
    SWFACTION_END, 

    /* v3 actions */
    SWFACTION_NEXTFRAME, 
    SWFACTION_PREVFRAME, 
    SWFACTION_PLAY, 
    SWFACTION_STOP, 
    SWFACTION_TOGGLEQUALITY, 
    SWFACTION_STOPSOUNDS, 
    SWFACTION_GOTOFRAME,      /* >= 0x80 means record has args */
    SWFACTION_GETURL, 
    SWFACTION_WAITFORFRAME, 
    SWFACTION_SETTARGET, 
    SWFACTION_GOTOLABEL, 

    /* v4 actions */
    SWFACTION_ADD, 
    SWFACTION_SUBTRACT, 
    SWFACTION_MULTIPLY, 
    SWFACTION_DIVIDE, 
    SWFACTION_EQUALS, 
    SWFACTION_LESSTHAN, 
    SWFACTION_AND, 
    SWFACTION_OR, 
    SWFACTION_NOT, 
    SWFACTION_STRINGEQ, 
    SWFACTION_STRINGLENGTH, 
    SWFACTION_STRINGEXTRACT, 
    SWFACTION_POP, 
    SWFACTION_TOINT, 
    SWFACTION_GETVARIABLE, 
    SWFACTION_SETVARIABLE, 
    SWFACTION_SETTARGET2, 
    SWFACTION_STRINGCONCAT, 
    SWFACTION_GETPROPERTY, 
    SWFACTION_SETPROPERTY, 
    SWFACTION_CLONESPRITE, 
    SWFACTION_REMOVESPRITE, 
    SWFACTION_TRACE, 
    SWFACTION_STARTDRAGMOVIE, 
    SWFACTION_STOPDRAGMOVIE, 
    SWFACTION_STRINGLESSTHAN, 
    SWFACTION_RANDOM, 
    SWFACTION_MBSTRINGLENGTH, 
    SWFACTION_CHARTOASCII, 
    SWFACTION_ASCIITOCAHR, 
    SWFACTION_GETTIMER, 
    SWFACTION_MBSTRINGEXTRACT, 
    SWFACTION_MBCHARTOASCII, 
    SWFACTION_MBASCIITOCHAR, 
    SWFACTION_WAITFORFRAME2, 
    SWFACTION_PUSH, 
    SWFACTION_JUMP, 
    SWFACTION_GETURL2, 
    SWFACTION_BRANCHIFTRUE, 
    SWFACTION_CALLFRAME, 
    SWFACTION_GOTOFRAME2, 

    /* v5 actions */
    SWFACTION_DELETE, 
    SWFACTION_DELETE2, 
    SWFACTION_DEFINELOCAL, 
    SWFACTION_CALL, 
    SWFACTION_RETURN, 
    SWFACTION_MODULO, 
    SWFACTION_NEWOBJECT, 
    SWFACTION_VAR, 
    SWFACTION_INITARRAY, 
    SWFACTION_INITOBJECT, 
    SWFACTION_TYPEOF, 
    SWFACTION_TARGETPATH, 
    SWFACTION_ENUMERATE, 
    SWFACTION_ADD2, 
    SWFACTION_LESS2, 
    SWFACTION_EQUALS2, 
    SWFACTION_TONUMBER, 
    SWFACTION_TOSTRING, 
    SWFACTION_PUSHDUPLICATE, 
    SWFACTION_STACKSWAP, 
    SWFACTION_GETMEMBER, 
    SWFACTION_SETMEMBER, 
    SWFACTION_INCREMENT, 
    SWFACTION_DECREMENT, 
    SWFACTION_CALLMETHOD, 
    SWFACTION_NEWMETHOD, 
    SWFACTION_BITWISEAND, 
    SWFACTION_BITWISEOR, 
    SWFACTION_BITWISEXOR, 
    SWFACTION_SHIFTLEFT, 
    SWFACTION_SHIFTRIGHT, 
    SWFACTION_SHIFTRIGHT2, 
    SWFACTION_STOREREGISTER, 
    SWFACTION_CONSTANTPOOL, 
    SWFACTION_WITH, 
    SWFACTION_DEFINEFUNCTION, 

    /* v6 actions */
    SWFACTION_INSTANCEOF, 
    SWFACTION_ENUMERATE2, 
    SWFACTION_STRICTEQUALS, 
    SWFACTION_GREATER, 
    SWFACTION_STRINGGREATER, 
    SWFACTION_STRICTMODE, 

    /* v7 actions */
    SWFACTION_CAST, 
    SWFACTION_IMPLEMENTS, 
    SWFACTION_EXTENDS, 
    SWFACTION_DEFINEFUNCTION2, 
    SWFACTION_TRY, 
    SWFACTION_THROW, 

    /* FlashLite */
    SWFACTION_FSCOMMAND2, 

    SWFACTION_LAST
};

#endif
