﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace D3DLookingGlassLoader
{
    public partial class Loader : Form
    {
        [DllImport("user32.dll", CharSet = CharSet.Auto, CallingConvention = CallingConvention.StdCall)]
        public static extern int SetWindowsHookEx(int idHook, IntPtr lpfn, IntPtr hInstance, int threadId);

        [DllImport("user32.dll", CharSet = CharSet.Auto, CallingConvention = CallingConvention.StdCall)]
        public static extern bool UnhookWindowsHookEx(int idHook);

        [DllImport("user32.dll", CharSet = CharSet.Auto, CallingConvention = CallingConvention.StdCall)]
        public static extern int CallNextHookEx(int idHook, int nCode, IntPtr wParam, IntPtr lParam);

        [DllImport("D3DLookingGlass.dll", CharSet = CharSet.Auto, CallingConvention = CallingConvention.StdCall)]
        public static extern int CBTProc(int idHook, int nCode, IntPtr wParam, IntPtr lParam);

        [DllImport("D3DLookingGlass.dll", CharSet = CharSet.Auto, CallingConvention = CallingConvention.StdCall)]
        public static extern void Binder();

        [DllImport("kernel32.dll", CharSet = CharSet.Auto, CallingConvention = CallingConvention.StdCall)]
        public static extern IntPtr GetModuleHandle(string lpModuleName);

        [DllImport("kernel32.dll", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.StdCall)]
        public static extern IntPtr GetProcAddress(IntPtr hModule, string lpFunction);

        [DllImport("kernel32.dll", CharSet = CharSet.Auto, CallingConvention = CallingConvention.StdCall)]
        public static extern int GetModuleFileNameW(IntPtr hModule, string lpFunctionName, int nBufferSize);

        int hhook = 0;

        public Loader()
        {
            InitializeComponent();
        }

        private void AttemptToLoadSettings()
        {
            try
            {
                IntPtr module_handle = GetModuleHandle("D3DLookingGlass.dll");
                string dll_path = new string('\0', 1024);
                GetModuleFileNameW(module_handle, dll_path, 1024);
                char[] nulls = new char[1];
                nulls[0] = '\0';
                string settings_path = dll_path.Trim(nulls) + ".settings"; // Perhaps somebody cal suggest a better way to do this
                System.IO.FileStream settings = System.IO.File.Open(settings_path, System.IO.FileMode.Open, System.IO.FileAccess.Read, System.IO.FileShare.ReadWrite);
                byte[] bytes = new byte[4];
                settings.Read(bytes, 0, 4);
                UInt32 x = BitConverter.ToUInt32(bytes, 0);
                settings.Read(bytes, 0, 4);
                UInt32 y = BitConverter.ToUInt32(bytes, 0);
                settings.Close();

                cmbResolution.Text = x + "x" + y;
            }
            catch (Exception e)
            {
                cmbResolution.SelectedIndex = 0;
            }
        }

        private void UpdateSettings() {
            UInt32 x = 0;
            UInt32 y = 0;
            
            switch (cmbResolution.Text)
            {
                case "640x480":
                    x = 640; y = 480;
                    break;
                case "800x600":
                    x = 800; y = 600;
                    break;
                case "1024x768":
                    x = 1024; y = 768;
                    break;
                case "1280x1024":
                    x = 1280; y = 1024;
                    break;
                case "1600x1200":
                    x = 1600; y = 1200;
                    break;
                case "1920x1200":
                    x = 1920; y = 1200;
                    break;
            }
            try
            {
                IntPtr module_handle = GetModuleHandle("D3DLookingGlass.dll");
                string dll_path = new string('\0', 1024);
                GetModuleFileNameW(module_handle, dll_path, 1024);
                char[] nulls = new char[1];
                nulls[0] = '\0';
                string settings_path = dll_path.Trim(nulls) + ".settings"; // Perhaps somebody cal suggest a better way to do this
                System.IO.FileStream settings = System.IO.File.Open(settings_path, System.IO.FileMode.OpenOrCreate, System.IO.FileAccess.Write, System.IO.FileShare.ReadWrite);
                settings.Write(BitConverter.GetBytes(x), 0, 4);
                settings.Write(BitConverter.GetBytes(y), 0, 4);
                settings.Close();
            }
            catch (Exception e)
            {
                // Do nothing
            }
        }

        private void cmdInstallHook_Click(object sender, EventArgs e)
        {
            // We get some nasty file permission bugs trying to write the settings
            // file while the DLL is live, so let's disable the settings options
            cmbResolution.Enabled = false;

            const int WH_CBT = 5;
            
            IntPtr module_handle = GetModuleHandle("D3DLookingGlass.dll");
            IntPtr function_address = GetProcAddress(module_handle, "CBTProc");
            hhook = SetWindowsHookEx(WH_CBT, function_address, module_handle, 0);
            lblStatus.Text = "Hook installed.";
        }

        private void cmdRemoveHook_Click(object sender, EventArgs e)
        {
            if (hhook != 0) UnhookWindowsHookEx(hhook);
            hhook = 0;
            lblStatus.Text = "Hook not installed.";

            cmbResolution.Enabled = true;
        }

        private void cmbResolution_SelectedIndexChanged(object sender, EventArgs e)
        {
            UpdateSettings();
        }

        private void Loader_Load(object sender, EventArgs e)
        {
            Binder();
            AttemptToLoadSettings();
        }

        private void chkHookCreateWindow_CheckedChanged(object sender, EventArgs e)
        {
            UpdateSettings();
        }

    }
}
