//////////////////////////////////////////////////////////////
//                                                          //
//  DLLInjection.h                                          //
//  Version 1.0                                             //
//  Greg Jenkins, November 2007                             //
//  Ring3 Circus (www.ring3circus.com)                      //
//  Creative Commons Attribution 3.0 Unported License       //
//                                                          //
//  Header for a user-mode DLL-based code injection class   //
//  for 32-bit Windows (XP and above)                       //
//                                                          //
//////////////////////////////////////////////////////////////

#pragma once

#ifndef WINVER
#define WINVER 0x0501 // Requires XP or later
#endif

#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0501
#endif	

#include <Windows.h>
#include <psapi.h>

#pragma comment(lib, "psapi.lib")

#include <string>
#include <vector>

// Typedefs and forward-declarations
typedef unsigned int HDLLHOOK;
struct DLLHook;

class DLLInjection {
public:
	DLLInjection(const char* absolute_dll_path);
	~DLLInjection();

	// Creates a thread from an exported function in the remote process and returns the exit code.
	// This call blocks. To spawn a thread asynchronously, use GetRemoteProcAddress & CreateRemoteThread.
	bool CallThreadProc(const char* thread_proc_name, void* parameter, DWORD timeout_ms, DWORD &exit_code);

	// Uses FindWindow to locate the owning process of the specified window.
	static DWORD GetProcessIDFromWindow(const char* class_name, const char* window_name);

	// Returns the address of an exported function belonging to the injected DLL, in the 
	// address-space of the target process.
	// If no module path is specified, the injected DLL is assumed.
	void* GetRemoteProcAddress(const char* proc_name);
	void* GetRemoteProcAddress(const char* proc_name, const char* module_path);

	// Base-address of injected DLL in remote process
	HMODULE GetRemoteModuleHandle(HMODULE local_handle);

	// Injects the DLL into the specified process.
	// The class only supports one DLL and one target at a time.
	HMODULE InjectDLL(DWORD process_id);

	// Hook an existing DLL function.
	// (if the function is less than five bytes long, the patch will overflow)
	//
	// existing_module_path - Full path of DLL containing the target function
	// existing_function_name - Name of the target function as exported by the target DLL
	// hook_function_name - Name of the hook function as exported by the injected DLL
	HDLLHOOK InstallDLLHook(const char* existing_module_path, const char* existing_function_name, const char* hook_function_name);

	// Hooks a function as compiled directly into a logical unit
	// This function scans all executable code in module_to_hook and redirects all relative calls to existing_function
	// so it is not foolproof. In particular, it is not a substitute for InstallIATHook and it can't deal with
	// polymorphic code, function-pointers or function indirection tables.
	//
	// existing_function - Linear address of the function. Make sure this is the address of the JMP in the case of indirect calls
	// hook_function_name - Name of the hook function as exported by the injected DLL
	HDLLHOOK InstallCodeHook(void* existing_function_address, const char* hook_function_name);

	// Removes all installed hooks of any type. 
	// This doesn't need to be called explicitly if calling RemoveDLL or destructing
	// If this returns false then any or all hooks may still exist and state is undefined
	// (To avoid this, remove all hooks using RemoveHook)
	bool RemoveAllHooks();

	// Removes the specified hook
	// If this returns false for any reason then the hook remains installed and presumably valid
	bool RemoveHook(HDLLHOOK handle);

	// Removes the DLL from the target process, uninstalling any unfreed hooks
	// This is automatically called upon destruction
	void RemoveDLL();

private:
	HDLLHOOK InstallHookByOffset(void* remote_address, DWORD offset);
	void UnloadAllTemporaryDLLs();

	HMODULE local_dll_handle;
	HANDLE process_handle;

	std::string dll_path;

	void* remote_base;
	std::vector<HMODULE> loaded_dlls;
	std::vector<DLLHook> hooks;
};