﻿using System;

namespace Communication.PipeServer
{
    public class Server
    {
        #region vars
        public delegate void MessageReceivedHandler(Client client, string message);
        public delegate void ConnectEvent(Client client);

        public event MessageReceivedHandler MessageReceived;
        public event ConnectEvent NewClient;
        #region DllImport
        [System.Runtime.InteropServices.DllImport("kernel32.dll", SetLastError = true)]
        public static extern Microsoft.Win32.SafeHandles.SafeFileHandle CreateNamedPipe(
           String pipeName,
           uint dwOpenMode,
           uint dwPipeMode,
           uint nMaxInstances,
           uint nOutBufferSize,
           uint nInBufferSize,
           uint nDefaultTimeOut,
           IntPtr lpSecurityAttributes);

        [System.Runtime.InteropServices.DllImport("kernel32.dll", SetLastError = true)]
        public static extern int ConnectNamedPipe(
           Microsoft.Win32.SafeHandles.SafeFileHandle hNamedPipe,
           IntPtr lpOverlapped);

        public const uint DUPLEX = (0x00000003);
        public const uint FILE_FLAG_OVERLAPPED = (0x40000000);
        public const int BUFFER_SIZE = 4096;
        #endregion ---DllImport---
        bool running;

        string pipeName = "\\\\.\\pipe\\Spike0001";
        System.Threading.Thread listenThread;
        System.Collections.Generic.List<Client> clients;
        public string PipeName
        {
            get { return this.pipeName; }
            set { this.pipeName = value; }
        }
        public bool Running
        {
            get { return this.running; }
        }
        #endregion ---vars---

        #region sub Class
        public class Client
        {
            public Client()
            {
            }
            public Microsoft.Win32.SafeHandles.SafeFileHandle handle;
            public System.IO.FileStream stream;
            public bool isDead = false;

            public void doDie()
            {
                    die();
            }
public            delegate void fireEvent();
      public      event fireEvent die;

            string _name;
            public string Name
            {
                get { return _name; }
                set { _name = value; }
            }

            string _appName;
            public string AppName
            {
                get { return _appName; }
                set { _appName = value; }
            }
            string _hackUsed;
            public string HackUsed
            {
                get { return _hackUsed; }
                set { _hackUsed = value; }
            }

            int _pid;
            public int PID
            {
                get { return _pid; }
                set { _pid = value; }
            }

            string _userName;
            public string UserName
            {
                get { return _userName; }
                set { _userName = value; }
            }
      


            string _commands;
            public string Commands
            {
                get { return _commands; }
                set { _commands = value; }
            }
            
            string _assemblyName;
            public string AssemblyName
            {
                get { return _assemblyName; }
                set { _assemblyName = value; }
            }
            public System.Collections.Generic.List<string> _messages = new System.Collections.Generic.List<string>();
            public int MessageCount
            {
                get { return _messages.Count; }
            }
            string _exePath;
            public string ExePath
            {
                get { return _exePath; }
                set { _exePath = value; }
            }
        }
        #endregion ---sub Class---

        #region con
        public Server()
        {
            this.clients = new System.Collections.Generic.List<Client>();
        }
        #endregion ---con---

        #region Start
        /// <summary>
        /// Starts the pipe server
        /// </summary>
        public void Start()
        {
            //start the listening thread
            this.listenThread = new System.Threading.Thread(new System.Threading.ThreadStart(ListenForClients));
            this.listenThread.Start();
            listenThread.IsBackground = true;
            this.running = true;
        }
        #endregion ---Start---

        #region com
        /// <summary>
        /// Listens for client connections
        /// </summary>
        private void ListenForClients()
        {
            while (true)
            {
                Microsoft.Win32.SafeHandles.SafeFileHandle clientHandle =
                CreateNamedPipe(
                     this.pipeName,
                     DUPLEX | FILE_FLAG_OVERLAPPED,
                     0,
                     255,
                     BUFFER_SIZE,
                     BUFFER_SIZE,
                     0,
                     IntPtr.Zero);

                //could not create named pipe
                if (clientHandle.IsInvalid)
                    return;

                int success = ConnectNamedPipe(clientHandle, IntPtr.Zero);

                //could not connect client
                if (success == 0)
                    return;

                Client client = new Client();
                client.handle = clientHandle;

                lock (clients)
                    this.clients.Add(client);

                System.Threading.Thread readThread = new System.Threading.Thread(new System.Threading.ParameterizedThreadStart(Read));
                readThread.Start(client);
                readThread.IsBackground = true;

                if (NewClient != null)
                    NewClient(client);
            }
        }

        /// <summary>
        /// Reads incoming data from connected clients
        /// </summary>
        /// <param name="clientObj"></param>
        private void Read(object clientObj)
        {
            Client client = (Client)clientObj;
            client.stream = new System.IO.FileStream(client.handle, System.IO.FileAccess.ReadWrite, BUFFER_SIZE, true);
            byte[] buffer = new byte[BUFFER_SIZE];
            System.Text.ASCIIEncoding encoder = new System.Text.ASCIIEncoding();

            while (true)
            {
                int bytesRead = 0;

                try
                {
                    bytesRead = client.stream.Read(buffer, 0, BUFFER_SIZE);
                }
                catch
                {
                    //read error has occurred
                    break;
                }

                //client has disconnected
                if (bytesRead == 0)
                    break;

                string message = encoder.GetString(buffer, 0, bytesRead);

                //fire message received event
                if (this.MessageReceived != null)
                    this.MessageReceived(client, message);

                // add message to the list
                client._messages.Add(message);
                if (client._messages.Count > 100)
                    client._messages.RemoveAt(0);
            }

            //clean up resources
            client.stream.Close();
            client.handle.Close();
            lock (this.clients)
                this.clients.Remove(client);
        }

        /// <summary>
        /// Sends a message to all connected clients
        /// </summary>
        /// <param name="message">the message to send</param>
        public void SendMessage(string message)
        {
            lock (this.clients)
            {
                System.Text.ASCIIEncoding encoder = new System.Text.ASCIIEncoding();
                byte[] messageBuffer = encoder.GetBytes(message);
                foreach (Client client in this.clients)
                {
                    client.stream.Write(messageBuffer, 0, messageBuffer.Length);
                    client.stream.Flush();

                }
            }
        }
        public void SendMessage(string message, Client client)
        {
            lock (this.clients)
            {
                if (!client.isDead)
                {
                    try
                    {
                        System.Text.ASCIIEncoding encoder = new System.Text.ASCIIEncoding();
                        byte[] messageBuffer = encoder.GetBytes(message);
                        client.stream.Write(messageBuffer, 0, messageBuffer.Length);
                        client.stream.Flush();
                    }
                    catch
                    {
                        System.Text.ASCIIEncoding encoder = new System.Text.ASCIIEncoding();
                        byte[] messageBuffer = encoder.GetBytes(message);
                        for (int i = 10; i > 0; i--)
                        {
                            try
                            {
                                client.stream.Write(messageBuffer, 0, messageBuffer.Length);
                                return;
                            }
                            catch
                            {
                            }
                        }
                        client.isDead = true;
                        client.doDie();
                    }
                }
            }
        }
        #endregion ---com---
    }
}