﻿using System;
using System.Collections.Generic;
using System.Text;

namespace GUIHack.BOL.DataDef
{
    public partial class TreeNodeWithData : System.Windows.Forms.TreeNode, IComparable
    {
        public object myDataObject;
        public object myDataObjectAccess;
        bool FilledIN = false;

        public delegate void callExpand();
        public event callExpand BeforeExpand;

        #region con
        // Summary:
        //     Initializes a new instance of the System.Windows.Forms.TreeNode class.
        public TreeNodeWithData()
        { }

        //
        // Summary:
        //     Initializes a new instance of the System.Windows.Forms.TreeNode class with
        //     the specified label text.
        //
        // Parameters:
        //   text:
        //     The label System.Windows.Forms.TreeNode.Text of the new tree node.
        public TreeNodeWithData(string text)
            : base(text)
        { }
        public TreeNodeWithData(string text, object myDataObjectIN)
            : base(text)
        { myDataObject = myDataObjectIN; }
        public TreeNodeWithData(string text, object myDataObjectIN, object myDataObjectAccessIN)
            : base(text)
        { myDataObject = myDataObjectIN;
        myDataObjectAccess = myDataObjectAccessIN;
        }

        //
        // Summary:
        //     Initializes a new instance of the System.Windows.Forms.TreeNode class using
        //     the specified serialization information and context.
        //
        // Parameters:
        //   serializationInfo:
        //     A System.Runtime.Serialization.SerializationInfo containing the data to deserialize
        //     the class.
        //
        //   context:
        //     The System.Runtime.Serialization.StreamingContext containing the source and
        //     destination of the serialized stream.
        protected TreeNodeWithData(System.Runtime.Serialization.SerializationInfo serializationInfo, System.Runtime.Serialization.StreamingContext context)
            : base(serializationInfo, context)
        { }

        //
        // Summary:
        //     Initializes a new instance of the System.Windows.Forms.TreeNode class with
        //     the specified label text and child tree nodes.
        //
        // Parameters:
        //   text:
        //     The label System.Windows.Forms.TreeNode.Text of the new tree node.
        //
        //   children:
        //     An array of child System.Windows.Forms.TreeNode objects.
        public TreeNodeWithData(string text, TreeNodeWithData[] children)
            : base(text, children)
        { }

        //
        // Summary:
        //     Initializes a new instance of the System.Windows.Forms.TreeNode class with
        //     the specified label text and images to display when the tree node is in a
        //     selected and unselected state.
        //
        // Parameters:
        //   text:
        //     The label System.Windows.Forms.TreeNode.Text of the new tree node.
        //
        //   imageIndex:
        //     The index value of System.Drawing.Image to display when the tree node is
        //     unselected.
        //
        //   selectedImageIndex:
        //     The index value of System.Drawing.Image to display when the tree node is
        //     selected.
        public TreeNodeWithData(string text, int imageIndex, int selectedImageIndex)
            : base(text, imageIndex, selectedImageIndex)
        { }
        //
        // Summary:
        //     Initializes a new instance of the System.Windows.Forms.TreeNode class with
        //     the specified label text, child tree nodes, and images to display when the
        //     tree node is in a selected and unselected state.
        //
        // Parameters:
        //   text:
        //     The label System.Windows.Forms.TreeNode.Text of the new tree node.
        //
        //   imageIndex:
        //     The index value of System.Drawing.Image to display when the tree node is
        //     unselected.
        //
        //   selectedImageIndex:
        //     The index value of System.Drawing.Image to display when the tree node is
        //     selected.
        //
        //   children:
        //     An array of child System.Windows.Forms.TreeNode objects.
        public TreeNodeWithData(string text, int imageIndex, int selectedImageIndex, TreeNodeWithData[] children)
            : base(text, imageIndex, selectedImageIndex, children)
        { }
        #endregion ---con---

        // Implement IComparable CompareTo method - provide default sort order.
        int IComparable.CompareTo(object obj)
        {
            if (obj is TreeNodeWithData)
            {
                TreeNodeWithData tn = (TreeNodeWithData)obj;
                if (this.Level * 100000 + this.Index > tn.Level * 100000 + tn.Index)
                    return 1;
                if (this.Level * 100000 + this.Index < tn.Level * 100000 + tn.Index)
                    return -1;
                else
                    return 0;
            }
            else
            {
                return 0;
            }
        }

        public void DoExpend()
        {
            if(FilledIN)
                return;

            FilledIN = true;
            if (BeforeExpand != null)
                this.BeforeExpand();
            
        }
    }
}
