﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace CodeAccess
{
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        //[STAThread]
        static void Main()
        {
            // load comLink to server
            bool runGUI;

            // is this inside another app
            if (System.AppDomain.CurrentDomain.FriendlyName.StartsWith("CodeAccess"))
                runGUI = true;
            else
                runGUI = false;

                Communication.comLink_CodeAccess myComLink = new Communication.comLink_CodeAccess();
            if (runGUI)
            {
                // this is the base app
                // the GUI is for testing
                System.Windows.Forms.Application.EnableVisualStyles();
                System.Windows.Forms.Application.SetCompatibleTextRenderingDefault(false);
                System.Windows.Forms.Application.Run(new frm_CodeAccess());
            }
            else
            {
                // this is inside another app
                System.Threading.Thread processThread = new System.Threading.Thread(new System.Threading.ThreadStart(delegate
                {
                    //Communication.comLink_CodeAccess myComLink = new Communication.comLink_CodeAccess();
                    System.Windows.Forms.Application.Run(new frm_CodeAccess());
//                  System.Windows.Forms.Application.Run();
                }));
                processThread.SetApartmentState(System.Threading.ApartmentState.STA);
                processThread.IsBackground = true;
                processThread.Start();

                // let the thread spin up
                System.Threading.Thread.SpinWait(500);
            } 
        }
    }
}
