﻿// ver 1.1
namespace SQL_DEFEND.TwitterCNC.BOL
{
    public class oAuthTwitter : OAuthBase
    {
        public oAuthTwitter(string Token, string TokenSecret, string PIN, string ConsumerKey, string ConsumerSecret)
        {
            loadKeys(Token, TokenSecret, PIN, ConsumerKey, ConsumerSecret);

        }
        /// <summary>
        /// keys for SQLAttack
        /// account BlackHat2010
        /// </summary>
        public void loadKeys(string Token, string TokenSecret, string PIN, string ConsumerKey, string ConsumerSecret)
        {
            // token from
            // http://gametree.org/2010/02/coding-the-tweet-redux/
            this.Token = Token;
            this.TokenSecret = TokenSecret;
            this.PIN = PIN;
            this.ConsumerKey = ConsumerKey;
            this.ConsumerSecret = ConsumerSecret;
        }

        private string _consumerKey = "";
        private string _consumerSecret = "";
        private string _pin = "";
        private string _token = "";
        private string _tokenSecret = "";
        private string k__BackingField;
        public const string ACCESS_TOKEN = "http://twitter.com/oauth/access_token";
        public const string AUTHORIZE = "http://twitter.com/oauth/authorize";
        public const string REQUEST_TOKEN = "http://twitter.com/oauth/request_token";

        public void AccessTokenGet(string authToken, string PIN)
        {
            this.Token = authToken;
            this._pin = PIN;
            string query = this.oAuthWebRequest(Method.GET, "http://twitter.com/oauth/access_token", string.Empty);
            if (query.Length > 0)
            {
                System.Collections.Specialized.NameValueCollection values = System.Web.HttpUtility.ParseQueryString(query);
                if (values["oauth_token"] != null)
                {
                    this.Token = values["oauth_token"];
                }
                if (values["oauth_token_secret"] != null)
                {
                    this.TokenSecret = values["oauth_token_secret"];
                }
            }
        }

        public string AuthorizationLinkGet()
        {
            string str = null;
            string query = this.oAuthWebRequest(Method.GET, "http://twitter.com/oauth/request_token", string.Empty);
            if (query.Length > 0)
            {
                System.Collections.Specialized.NameValueCollection values = System.Web.HttpUtility.ParseQueryString(query);
                if (values["oauth_token"] != null)
                {
                    this.OAuthToken = values["oauth_token"];
                    str = "http://twitter.com/oauth/authorize?oauth_token=" + values["oauth_token"];
                }
            }
            return str;
        }

        public string oAuthWebRequest(Method method, string url, string postData)
        {
            string normalizedUrl = "";
            string normalizedRequestParameters = "";
            if (method == Method.POST)
            {
                if (postData.Length > 0)
                {
                    System.Collections.Specialized.NameValueCollection values = System.Web.HttpUtility.ParseQueryString(postData);
                    postData = "";
                    foreach (string str4 in values.AllKeys)
                    {
                        if (postData.Length > 0)
                        {
                            postData = postData + "&";
                        }
                        values[str4] = System.Web.HttpUtility.UrlDecode(values[str4]);
                        values[str4] = base.UrlEncode(values[str4]);
                        postData = postData + str4 + "=" + values[str4];
                    }
                    if (url.IndexOf("?") > 0)
                    {
                        url = url + "&";
                    }
                    else
                    {
                        url = url + "?";
                    }
                    url = url + postData;
                }
            }
            else if ((method == Method.GET) && !string.IsNullOrEmpty(postData))
            {
                url = url + "?" + postData;
            }
            System.Uri uri = new System.Uri(url);
            string nonce = this.GenerateNonce();
            string timeStamp = this.GenerateTimeStamp();
            string str = base.GenerateSignature(uri, this.ConsumerKey, this.ConsumerSecret, this.Token, this.TokenSecret, method.ToString(), timeStamp, nonce, this.PIN, out normalizedUrl, out normalizedRequestParameters);
            normalizedRequestParameters = normalizedRequestParameters + "&oauth_signature=" + System.Web.HttpUtility.UrlEncode(str);
            if (method == Method.POST)
            {
                postData = normalizedRequestParameters;
                normalizedRequestParameters = "";
            }
            if (normalizedRequestParameters.Length > 0)
            {
                normalizedUrl = normalizedUrl + "?";
            }
            return this.WebRequest(method, normalizedUrl + normalizedRequestParameters, postData);
        }

        public void Reset()
        {
            string str;
            string str2;
            string str3;
            string str4;
            this.PIN = str = string.Empty;
            this.TokenSecret = str2 = str;
            this.Token = str3 = str2;
            this.OAuthToken = str4 = str3;
            this.ConsumerKey = this.ConsumerSecret = str4;
        }

        public string WebRequest(Method method, string url, string postData)
        {
            System.Net.HttpWebRequest webRequest = null;
            System.IO.StreamWriter writer = null;
            string str = "";
            webRequest = System.Net.WebRequest.Create(url) as System.Net.HttpWebRequest;
            webRequest.Method = method.ToString();
            webRequest.ServicePoint.Expect100Continue = false;
            if (method == Method.POST)
            {
                webRequest.ContentType = "application/x-www-form-urlencoded";
                writer = new System.IO.StreamWriter(webRequest.GetRequestStream());
                try
                {
                    writer.Write(postData);
                }
                catch
                {
                    throw;
                }
                finally
                {
                    writer.Close();
                    writer = null;
                }
            }
            str = this.WebResponseGet(webRequest);
            webRequest = null;
            return str;
        }

        public string WebResponseGet(System.Net.HttpWebRequest webRequest)
        {
            System.IO.StreamReader reader = null;
            string str = "";
            try
            {
                reader = new System.IO.StreamReader(webRequest.GetResponse().GetResponseStream());
                str = reader.ReadToEnd();
            }
            catch
            {
                throw;
            }
            finally
            {
                webRequest.GetResponse().GetResponseStream().Close();
                reader.Close();
                reader = null;
            }
            return str;
        }

        public string ConsumerKey
        {
            get
            {
                return this._consumerKey;
            }
            set
            {
                this._consumerKey = value;
            }
        }

        public string ConsumerSecret
        {
            get
            {
                return this._consumerSecret;
            }
            set
            {
                this._consumerSecret = value;
            }
        }

        public string OAuthToken
        {
            get
            {
                return this.k__BackingField;
            }
            set
            {
                this.k__BackingField = value;
            }
        }

        public string PIN
        {
            get
            {
                return this._pin;
            }
            set
            {
                this._pin = value;
            }
        }

        public string Token
        {
            get
            {
                return this._token;
            }
            set
            {
                this._token = value;
            }
        }

        public string TokenSecret
        {
            get
            {
                return this._tokenSecret;
            }
            set
            {
                this._tokenSecret = value;
            }
        }

        public enum Method
        {
            GET,
            POST
        }
    }
}