﻿using System;

namespace HackButtons
{
    public static partial class spike
    {
        public static class LeetConvert
        {
            #region vars
            public delegate void d();
            delegate void d1(System.Windows.Forms.Control controlIN);
            #endregion ---vars---

            #region get Objects
            public static System.Windows.Forms.Control[] getAllGUIObjectsOnAllForms()
            {
                System.Runtime.Serialization.ObjectIDGenerator myObjectIDGenerator = new System.Runtime.Serialization.ObjectIDGenerator();
                return getAllGUIObjectsOnAllForms(myObjectIDGenerator);
            }
            static System.Windows.Forms.Control[] getAllGUIObjectsOnAllForms(System.Runtime.Serialization.ObjectIDGenerator myObjectIDGeneratorIN)
            {
                System.Collections.Generic.List<System.Windows.Forms.Control> formList = new System.Collections.Generic.List<System.Windows.Forms.Control>();

                foreach (System.Windows.Forms.Control aform in System.Windows.Forms.Application.OpenForms)
                {
                    formList.AddRange(getAllGUIObjects(aform, myObjectIDGeneratorIN));
                }
                return formList.ToArray();
            }
            static System.Windows.Forms.Control[] getAllGUIObjects(System.Windows.Forms.Control conIN)
            {
                System.Runtime.Serialization.ObjectIDGenerator myObjectIDGenerator = new System.Runtime.Serialization.ObjectIDGenerator();
                return getAllGUIObjects(conIN, myObjectIDGenerator);
            }
            static System.Windows.Forms.Control[] getAllGUIObjects(System.Windows.Forms.Control conIN, System.Runtime.Serialization.ObjectIDGenerator myObjectIDGeneratorIN)
            {
                System.Collections.Generic.List<System.Windows.Forms.Control> formList = new System.Collections.Generic.List<System.Windows.Forms.Control>();

                bool newObject;
                myObjectIDGeneratorIN.GetId(conIN, out newObject);
                if (newObject)
                {
                    formList.Add(conIN);
                    getAllGUIObjects(conIN, myObjectIDGeneratorIN, formList);

                }
                return formList.ToArray();
            }
            static void getAllGUIObjects(System.Windows.Forms.Control conIN, System.Runtime.Serialization.ObjectIDGenerator myObjectIDGeneratorIN, System.Collections.Generic.List<System.Windows.Forms.Control> formList)
            {
                bool newObject;
                foreach (System.Windows.Forms.Control c in conIN.Controls)
                {
                    // see if this object has been added
                    myObjectIDGeneratorIN.GetId(c, out newObject);
                    if (newObject == true)
                    {
                        formList.Add(c);
                        getAllGUIObjects(c, myObjectIDGeneratorIN, formList);
                    }
                }
            }

            #endregion ---get Objects---
            public static MulticastDelegate Load(System.Windows.Forms.Control controlIN)
            {
                System.Runtime.Serialization.ObjectIDGenerator ObjectIDGenerator = new System.Runtime.Serialization.ObjectIDGenerator();
                bool connect;
                ObjectIDGenerator.GetId(controlIN, out connect);
                while (controlIN.Parent != null)
                    controlIN = controlIN.Parent;

                System.Collections.Generic.List<System.Windows.Forms.Control> controls = new System.Collections.Generic.List<System.Windows.Forms.Control>();

                // loop and add all sub controls
                d1 grabSubControls = null;
                grabSubControls = new d1(delegate(System.Windows.Forms.Control sub_controlIN)
                {
                    foreach (System.Windows.Forms.Control con in sub_controlIN.Controls)
                    {
                        ObjectIDGenerator.GetId(con, out connect);
                        if (connect)
                        {
                            controls.Add(con);
                            grabSubControls(con);
                        }
                    }
                });
                grabSubControls(controlIN);

                d m = null;
                foreach (System.Windows.Forms.Control contr in controls)
                {
                    try
                    {
                        m = ConvertToLeet(contr) as d + m;
                    }
                    catch { }
                }

                return m;
            }

            public static MulticastDelegate Load()
            {
                System.Runtime.Serialization.ObjectIDGenerator ObjectIDGenerator = new System.Runtime.Serialization.ObjectIDGenerator();

                System.Collections.Generic.List<System.Windows.Forms.Control> controls = new System.Collections.Generic.List<System.Windows.Forms.Control>();

                controls.AddRange(getAllGUIObjectsOnAllForms());

                d m = null;
                foreach (System.Windows.Forms.Control contr in controls)
                {
                    m = ConvertToLeet(contr) as d + m;
                }

                return m;
            }

            #region ConvertToLeet
            public static string ConvertToLeet(string textIN)
            {
                System.Text.StringBuilder sb = new System.Text.StringBuilder(textIN.Length * 2);
                foreach (char c in textIN)
                {

                    #region LeetSwitch
                    //4bcd3f9h1j|<|mn0pqr$7uv\/\/xyz
                    switch (c)
                    {
                        case 'A':
                        case 'a':
                            sb.Append('4');
                            break;
                        case 'B':
                        case 'b':
                            sb.Append(@"/3");
                            break;
                        case 'C':
                        case 'c':
                            sb.Append('(');
                            break;
                        case 'D':
                        case 'd':
                            sb.Append("[)");
                            break;
                        case 'E':
                        case 'e':
                            sb.Append('3');
                            break;
                        case 'F':
                        case 'f':
                            sb.Append("|=");
                            break;
                        case 'G':
                        case 'g':
                            sb.Append('9');
                            break;
                        case 'H':
                        case 'h':
                            sb.Append("]-[");
                            break;
                        case 'I':
                        case 'i':
                            sb.Append("!");
                            break;
                        case 'K':
                        case 'k':
                            sb.Append("|<");
                            break;
                        case 'L':
                        case 'l':
                            sb.Append("1");
                            break;
                        case 'M':
                        case 'm':
                            sb.Append("|v|");
                            break;
                        case 'N':
                        case 'n':
                            sb.Append(@"/\/");
                            break;
                        case 'o':
                        case 'O':
                            sb.Append('0');
                            break;
                        case 'P':
                        case 'p':
                            sb.Append("|>");
                            break;
                        case 'Q':
                        case 'q':
                            sb.Append("()_");
                            break;
                        case 'R':
                        case 'r':
                            sb.Append(@"/2");
                            break;
                        case 's':
                        case 'S':
                            sb.Append('$');
                            break;
                        case 'T':
                        case 't':
                            sb.Append('7');
                            break;
                        case 'U':
                        case 'u':
                            sb.Append("|_|");
                            break;
                        case 'V':
                        case 'v':
                            sb.Append(@"\/");
                            break;
                        case 'W':
                        case 'w':
                            sb.Append(@"\/\/");
                            break;
                        case 'X':
                        case 'x':
                            sb.Append("><");
                            break;
                        case 'Y':
                        case 'y':
                            sb.Append(@"`/");
                            break;
                        case 'Z':
                        case 'z':
                            sb.Append("7_");
                            break;
                        case '.':
                            sb.Append(',');
                            break;
                        default:
                            sb.Append(c);
                            break;
                    }
                    #endregion ---LeetSwitch---
                }
                return sb.ToString();
            }
            public static Delegate ConvertToLeet(System.Windows.Forms.Control controlIN)
            {
                string oldText = controlIN.Text;

                controlIN.Invoke((d)delegate
                {
                    controlIN.Text = ConvertToLeet(controlIN.Text);
                });

                d doStopDrag;
                doStopDrag = new d(delegate
                {
                    controlIN.Invoke((d)delegate
                    {
                        controlIN.Text = oldText;
                    });
                });

                return doStopDrag;
            }
            #endregion ---ConvertToLeet---
         }
    }
}