﻿using System;

namespace HackButtons.Payload
{
    public static class MouseTarget
    {
        #region vars
        [System.Runtime.InteropServices.DllImport("user32.dll")]
        static extern IntPtr WindowFromPoint(POINT Point);

        [System.Runtime.InteropServices.DllImport("user32.dll")]
        static extern uint GetWindowThreadProcessId(IntPtr hWnd, out int lpdwProcessId);

        public delegate void TargetSpot(System.Drawing.Point spotIN);
        public static event TargetSpot newSpot;

        public delegate void SelectTarget(System.Windows.Forms.Control itemIN);
        public static event SelectTarget newTarget;

        public delegate void newTargetProcess(System.Diagnostics.Process procIN, int appID);
        public static event newTargetProcess targetApplicationEvent;

        #region POINT
        [System.Runtime.InteropServices.StructLayout(System.Runtime.InteropServices.LayoutKind.Sequential)]
        public struct POINT
        {
            public int X;
            public int Y;


            public POINT(int x, int y)
            {
                this.X = x;
                this.Y = y;
            }

            public static implicit operator System.Drawing.Point(POINT p)
            {
                return new System.Drawing.Point(p.X, p.Y);
            }

            public static implicit operator POINT(System.Drawing.Point p)
            {
                return new POINT(p.X, p.Y);
            }

        }
        #endregion ---POINT---
        #endregion ---vars---

        #region functions
        public static void GrabTargetFlipOn()
        {
            // get mouse location
            System.Drawing.Point mouseSpot = System.Windows.Forms.Control.MousePosition;

            // get control under mouse location
            System.Windows.Forms.Control targetControl = GetControlFromPoint(mouseSpot);

            System.Collections.Generic.List<System.Windows.Forms.Control> controlListBuffer = new System.Collections.Generic.List<System.Windows.Forms.Control>();

            // flip it all on
            foreach (System.Windows.Forms.Control cont in targetControl.Controls)
            {
                if (cont.Enabled == false)
                    controlListBuffer.Add(cont);
                cont.Enabled = true;
            }

            // update the form
            targetControl.Update();

            GrabTarget(targetControl, mouseSpot);

            // make what was off -> off
            foreach (System.Windows.Forms.Control cont in controlListBuffer)
            {
                cont.Enabled = false;
            }
        }

        public static System.Windows.Forms.Control GrabTarget()
        {
            try
            {
                // get mouse location
                System.Drawing.Point mouseSpot = System.Windows.Forms.Control.MousePosition;
             
                // get control under mouse location
                System.Windows.Forms.Control targetControl = GetControlFromPoint(mouseSpot);

               return GrabTarget(targetControl, mouseSpot);
            }
            catch(System.Exception e)
            {
       //         System.Windows.Forms.MessageBox.Show("grabTarget fail #089iou00");
                throw new System.Exception("grabTarget fail #987u9890  : From:" +e.Message );
            }
        }

        public static System.Windows.Forms.Control GrabTarget(System.Windows.Forms.Control targetControlIN, System.Drawing.Point mouseSpotIN)
        {
            try
            {
                // fire event
                if (newTarget != null)
                    newTarget(targetControlIN);

                // fire event
                if (newSpot != null)
                    newSpot(mouseSpotIN);

                if (targetApplicationEvent != null)
                {
                    string targetApplication = string.Empty;
                    int targetApplicationID = -1;
                    System.Diagnostics.Process aProcess = null;

                    // get process from mouse location
                    IntPtr hWnd = GetHandelFromPoint(mouseSpotIN);
                    aProcess = GetApplicationFromHandel(hWnd);
                    if (aProcess != null)
                    {
                        // get data from process
                        targetApplication = aProcess.MainModule.ModuleName;
                        targetApplicationID = aProcess.Id;

                        // fire event
                        if (targetApplicationEvent != null)
                            targetApplicationEvent(aProcess, targetApplicationID);
                    }
                }
                return targetControlIN;
            }
            catch (System.Exception e)
            {
                string h = e.Message;
                //                System.Windows.Forms.MessageBox.Show("grabTarget fail #98dfh78gdfh");
                throw new System.Exception("grabTarget fail #98dfh78gdfh");
            }
        }

        public static System.Windows.Forms.Control GetControlFromPoint(System.Drawing.Point locationIN)
        {
            IntPtr hWnd = GetHandelFromPoint(locationIN);
          
            if (hWnd == IntPtr.Zero)
            {
                System.Windows.Forms.MessageBox.Show("point convert to GUI #87tf8g7");
                return null;
            }
            return GetControlFromHandel(hWnd);
        }

        private static System.Diagnostics.Process GetApplicationFromHandel(IntPtr hWnd)
        {
            int procId;
            GetWindowThreadProcessId(hWnd, out procId);
            System.Diagnostics.Process proc = System.Diagnostics.Process.GetProcessById(procId);

            if (proc == null)
            {
                System.Windows.Forms.MessageBox.Show("get Process fail #9sd89f7gbu9rfg");
                return null;
            }
            return proc;
        }

        private static IntPtr GetHandelFromPoint(System.Drawing.Point locationIN)
        {
            IntPtr hWnd = WindowFromPoint(locationIN);
          
            if (hWnd == IntPtr.Zero)
            {
                System.Windows.Forms.MessageBox.Show("point convert to GUI #58ujkyjk");
                return IntPtr.Zero;
            }
            return hWnd;
        }

        private static System.Windows.Forms.Control GetControlFromHandel(IntPtr itemIN)
        {
            System.Windows.Forms.Control targetControl = System.Windows.Forms.Control.FromHandle(itemIN);

            if (targetControl == null)
            {
                targetControl = System.Windows.Forms.Form.FromHandle(itemIN);

                if (targetControl == null)
                {
                    return null;
                }
            }
            return targetControl;
        }
        #endregion ---functions---

        #region access GUI
        public static System.Windows.Forms.Form getParentForm(System.Windows.Forms.Control objIN)
        {
            return getParent(objIN) as System.Windows.Forms.Form;
        }
        public static System.Windows.Forms.Control getParent(System.Windows.Forms.Control objIN)
        {
            if (objIN is System.Windows.Forms.Form)
            {
                return objIN;
            }
            else
            {
                return getParent(objIN.Parent);
            }
        }
        #endregion ---access GUI---
    }
}