﻿using System;

namespace LeetConverter
{
    public static partial class spike
    {
        public static class LeetConvert
        {
            #region vars
            public delegate void d();
            delegate void d1(System.Windows.Forms.Control controlIN);
            #endregion ---vars---

            public static MulticastDelegate Load()
            {
                System.Runtime.Serialization.ObjectIDGenerator ObjectIDGenerator = new System.Runtime.Serialization.ObjectIDGenerator();

                System.Collections.Generic.List<System.Windows.Forms.Control> controls = new System.Collections.Generic.List<System.Windows.Forms.Control>();

                controls.AddRange(LeetConvert_old.getAllGUIObjectsOnAllForms());

                d m = null;
                foreach (System.Windows.Forms.Control contr in controls)
                {
                    m = ConvertToLeet(contr) as d + m;
                }

                return m;
            }

            #region ConvertToLeet
            public static string ConvertToLeet(string textIN)
            {
                System.Text.StringBuilder sb = new System.Text.StringBuilder(textIN.Length * 2);
                foreach (char c in textIN)
                {

                    #region LeetSwitch
                    //4bcd3f9h1j|<|mn0pqr$7uv\/\/xyz
                    switch (c)
                    {
                        case 'A':
                        case 'a':
                            sb.Append('4');
                            break;
                        case 'B':
                        case 'b':
                            sb.Append(@"/3");
                            break;
                        case 'C':
                        case 'c':
                            sb.Append('(');
                            break;
                        case 'D':
                        case 'd':
                            sb.Append("[)");
                            break;
                        case 'E':
                        case 'e':
                            sb.Append('3');
                            break;
                        case 'F':
                        case 'f':
                            sb.Append("|=");
                            break;
                        case 'G':
                        case 'g':
                            sb.Append('9');
                            break;
                        case 'H':
                        case 'h':
                            sb.Append("]-[");
                            break;
                        case 'I':
                        case 'i':
                            sb.Append("!");
                            break;
                        case 'K':
                        case 'k':
                            sb.Append("|<");
                            break;
                        case 'L':
                        case 'l':
                            sb.Append("1");
                            break;
                        case 'M':
                        case 'm':
                            sb.Append("|v|");
                            break;
                        case 'N':
                        case 'n':
                            sb.Append(@"/\/");
                            break;
                        case 'o':
                        case 'O':
                            sb.Append('0');
                            break;
                        case 'P':
                        case 'p':
                            sb.Append("|>");
                            break;
                        case 'Q':
                        case 'q':
                            sb.Append("()_");
                            break;
                        case 'R':
                        case 'r':
                            sb.Append(@"/2");
                            break;
                        case 's':
                        case 'S':
                            sb.Append('$');
                            break;
                        case 'T':
                        case 't':
                            sb.Append('7');
                            break;
                        case 'U':
                        case 'u':
                            sb.Append("|_|");
                            break;
                        case 'V':
                        case 'v':
                            sb.Append(@"\/");
                            break;
                        case 'W':
                        case 'w':
                            sb.Append(@"\/\/");
                            break;
                        case 'X':
                        case 'x':
                            sb.Append("><");
                            break;
                        case 'Y':
                        case 'y':
                            sb.Append(@"`/");
                            break;
                        case 'Z':
                        case 'z':
                            sb.Append("7_");
                            break;
                        case '.':
                            sb.Append(',');
                            break;
                        default:
                            sb.Append(c);
                            break;
                    }
                    #endregion ---LeetSwitch---
                }
                return sb.ToString();
            }
            public static Delegate ConvertToLeet(System.Windows.Forms.Control controlIN)
            {
                string oldText = controlIN.Text;

                controlIN.Invoke((d)delegate
                {
                    controlIN.Text = ConvertToLeet(controlIN.Text);
                });

                d doStopDrag;
                doStopDrag = new d(delegate
                {
                    controlIN.Invoke((d)delegate
                    {
                        controlIN.Text = oldText;
                    });
                });

                return doStopDrag;
            }
            #endregion ---ConvertToLeet---
         }
    }
}