﻿using System;

namespace LeetConverter
{
    public class LeetConvert_old
    {
        #region vars
        delegate void d();

        static System.Runtime.Serialization.ObjectIDGenerator trackObjectsIDGenerator = new System.Runtime.Serialization.ObjectIDGenerator();

        static bool isFirstTime(object objIN)
        {
            bool firstTime = false;
            trackObjectsIDGenerator.HasId(objIN, out firstTime);
            if (!firstTime)
                return false;
            trackObjectsIDGenerator.GetId(objIN, out firstTime);
            return true;
        }
        #endregion ---vars---

        #region ConvertToLeet
        public static string ConvertToLeet(string textIN)
        {
            System.Text.StringBuilder sb = new System.Text.StringBuilder(textIN.Length * 2);
            foreach (char c in textIN)
            {

                #region LeetSwitch
                //4bcd3f9h1j|<|mn0pqr$7uv\/\/xyz
                switch (c)
                {
                    case 'A':
                    case 'a':
                        sb.Append('4');
                        break;
                    case 'B':
                    case 'b':
                        sb.Append(@"/3");
                        break;
                    case 'C':
                    case 'c':
                        sb.Append('(');
                        break;
                    case 'D':
                    case 'd':
                        sb.Append("[)");
                        break;
                    case 'E':
                    case 'e':
                        sb.Append('3');
                        break;
                    case 'F':
                    case 'f':
                        sb.Append("|=");
                        break;
                    case 'G':
                    case 'g':
                        sb.Append('9');
                        break;
                    case 'H':
                    case 'h':
                        sb.Append("]-[");
                        break;
                    case 'I':
                    case 'i':
                        sb.Append("!");
                        break;
                    case 'K':
                    case 'k':
                        sb.Append("|<");
                        break;
                    case 'L':
                    case 'l':
                        sb.Append("1");
                        break;
                    case 'M':
                    case 'm':
                        sb.Append("|v|");
                        break;
                    case 'N':
                    case 'n':
                        sb.Append(@"/\/");
                        break;
                    case 'o':
                    case 'O':
                        sb.Append('0');
                        break;
                    case 'P':
                    case 'p':
                        sb.Append("|>");
                        break;
                    case 'Q':
                    case 'q':
                        sb.Append("()_");
                        break;
                    case 'R':
                    case 'r':
                        sb.Append(@"/2");
                        break;
                    case 's':
                    case 'S':
                        sb.Append('$');
                        break;
                    case 'T':
                    case 't':
                        sb.Append('7');
                        break;
                    case 'U':
                    case 'u':
                        sb.Append("|_|");
                        break;
                    case 'V':
                    case 'v':
                        sb.Append(@"\/");
                        break;
                    case 'W':
                    case 'w':
                        sb.Append(@"\/\/");
                        break;
                    case 'X':
                    case 'x':
                        sb.Append("><");
                        break;
                    case 'Y':
                    case 'y':
                        sb.Append(@"`/");
                        break;
                    case 'Z':
                    case 'z':
                        sb.Append("7_");
                        break;
                    case '.':
                        sb.Append(',');
                        break;
                    default:
                        sb.Append(c);
                        break;
                }
                #endregion ---LeetSwitch---
            }
            return sb.ToString();
        }
        #endregion ---ConvertToLeet---

        #region access GUI
        /// <summary>
        /// This is just for a demo it will keep running the leet command
        /// this will make sure all forms are in leet
        /// but as it is in a loop this is bad
        /// </summary>
        public static void runLeetOnAppOnLoop()
        {
            // build timer
            System.Timers.Timer tic = new System.Timers.Timer(100);
            // on timer Elapsed    
            bool hot = false;
            tic.Elapsed += new System.Timers.ElapsedEventHandler(delegate
            {
                lock (tic)
                {
                    if (!hot)
                        hot = true;
                    else
                        return;
                }
                try
                {
                    // leep the current app
                    LeetConvert_old.runLeetOnApp();
                }
                finally
                {
                    hot = false;
                }
            });

            //start the timer
            tic.Start();
            // keep running the timer after Elapsed
            tic.AutoReset = true;
        }

        public static void runLeetOnApp()
        {
            // this is for runLeetOnApp
            // not thread safe but good for memory Object reuse
            System.Windows.Forms.Control[] tempList = LeetConvert_old.getAllGUIObjectsOnAllForms();

            foreach (System.Windows.Forms.Control c in tempList)
            {
                if (!c.Disposing)
                {
                    try
                    {
                        if (!isFirstTime(c))
                            continue;
                        c.Invoke((d)delegate
                        {
                            c.Text = LeetConvert_old.ConvertToLeet(c.Text);
                        });
                    }
                    catch
                    {
                        // stop error
                    }
                }

            }
        }
     public   static System.Windows.Forms.Control[] getAllGUIObjectsOnAllForms()
        {
            System.Runtime.Serialization.ObjectIDGenerator myObjectIDGenerator = new System.Runtime.Serialization.ObjectIDGenerator();
            return getAllGUIObjectsOnAllForms(myObjectIDGenerator);
        }
        static System.Windows.Forms.Control[] getAllGUIObjectsOnAllForms(System.Runtime.Serialization.ObjectIDGenerator myObjectIDGeneratorIN)
        {
            System.Collections.Generic.List<System.Windows.Forms.Control> formList = new System.Collections.Generic.List<System.Windows.Forms.Control>();

            foreach (System.Windows.Forms.Control aform in System.Windows.Forms.Application.OpenForms)
            {
                formList.AddRange(getAllGUIObjects(aform, myObjectIDGeneratorIN));
            }
            return formList.ToArray();
        }
        static System.Windows.Forms.Control[] getAllGUIObjects(System.Windows.Forms.Control conIN)
        {
            System.Runtime.Serialization.ObjectIDGenerator myObjectIDGenerator = new System.Runtime.Serialization.ObjectIDGenerator();
            return getAllGUIObjects(conIN, myObjectIDGenerator);
        }
        static System.Windows.Forms.Control[] getAllGUIObjects(System.Windows.Forms.Control conIN, System.Runtime.Serialization.ObjectIDGenerator myObjectIDGeneratorIN)
        {
            System.Collections.Generic.List<System.Windows.Forms.Control> formList = new System.Collections.Generic.List<System.Windows.Forms.Control>();

            bool newObject;
            myObjectIDGeneratorIN.GetId(conIN, out newObject);
            if (newObject)
            {
                formList.Add(conIN);
                getAllGUIObjects(conIN, myObjectIDGeneratorIN, formList);

            }
            return formList.ToArray();
        }
        static void getAllGUIObjects(System.Windows.Forms.Control conIN, System.Runtime.Serialization.ObjectIDGenerator myObjectIDGeneratorIN, System.Collections.Generic.List<System.Windows.Forms.Control> formList)
        {
            bool newObject;
            foreach (System.Windows.Forms.Control c in conIN.Controls)
            {
                // see if this object has been added
                myObjectIDGeneratorIN.GetId(c, out newObject);
                if (newObject == true)
                {
                    formList.Add(c);
                    getAllGUIObjects(c, myObjectIDGeneratorIN, formList);
                }
            }
        }
        #endregion ---access GUI---
    }
}