﻿using System;

namespace LeetConverter
{
    public class Load
    {
        public Load()
        {
            Program.Main();
        }
    }
    static class Program
    {
        static void appDomainName()
        {
            string name = System.Reflection.Assembly.GetCallingAssembly().FullName;
            System.Windows.Forms.MessageBox.Show(name);
        }

        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        //[STAThread]
       public static void Main()
        {

            // load comLink to server
            bool runGUI;

            // is this inside another app
            if (System.AppDomain.CurrentDomain.FriendlyName.StartsWith("LeetConverter"))
            {
                // this is the base app
                Communication.comLink_Leet myComLink = new Communication.comLink_Leet();
                // the GUI is for testing
                System.Windows.Forms.Application.EnableVisualStyles();
                System.Windows.Forms.Application.SetCompatibleTextRenderingDefault(false);
                System.Windows.Forms.Application.Run(new LeetConverter.Testing.fm_LeetConverter());
            }
            else
            {
                // this is inside another app
                System.Threading.Thread processThread = new System.Threading.Thread(new System.Threading.ThreadStart(delegate
                {
                    Communication.comLink_Leet myComLink = new Communication.comLink_Leet();
                    System.Windows.Forms.Application.EnableVisualStyles();
                    System.Windows.Forms.Application.SetCompatibleTextRenderingDefault(false);
                    System.Windows.Forms.Application.Run(new LeetConverter.Testing.fm_LeetConverter());
                }));
                processThread.IsBackground = true;
                processThread.Start();

                // let the thread spin up
                System.Threading.Thread.SpinWait(500);
            }
        }
    }
}
