﻿using System;
using System.Windows.Forms;

namespace Injector
{
    public partial class MainUI : Form
    {
        #region GUI Init stuff
        public void updateText()
        {
            tb_pathToFiles.Text = System.Environment.NewLine + "dll:" + dllPath;
        }

        public int testME = 0;
        private Button Bn_FindDll;
        private Button bn_Inject;
        private TextBox tb_AppName;
        private Injector.Tools.spike.pictureBoxTarget pictureBoxTarget1;
        private System.ComponentModel.IContainer components;
        private TextBox tb_appID;
        private SplitContainer splitContainer2;
        private SplitContainer splitContainer1;
        public static string sApplication = String.Empty;
        private Label label1;
        private CheckBox cb_overrideTarget;
        private ListBox listBox_processTargets;
        private Button bn_refreshProcessList;
        private TextBox tb_pathToFiles;

        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(MainUI));
            this.Bn_FindDll = new System.Windows.Forms.Button();
            this.bn_Inject = new System.Windows.Forms.Button();
            this.tb_AppName = new System.Windows.Forms.TextBox();
            this.tb_appID = new System.Windows.Forms.TextBox();
            this.splitContainer1 = new System.Windows.Forms.SplitContainer();
            this.cb_overrideTarget = new System.Windows.Forms.CheckBox();
            this.tb_pathToFiles = new System.Windows.Forms.TextBox();
            this.label1 = new System.Windows.Forms.Label();
            this.splitContainer2 = new System.Windows.Forms.SplitContainer();
            this.listBox_processTargets = new System.Windows.Forms.ListBox();
            this.bn_refreshProcessList = new System.Windows.Forms.Button();
            this.pictureBoxTarget1 = new Injector.Tools.spike.pictureBoxTarget();
            this.splitContainer1.Panel1.SuspendLayout();
            this.splitContainer1.Panel2.SuspendLayout();
            this.splitContainer1.SuspendLayout();
            this.splitContainer2.Panel1.SuspendLayout();
            this.splitContainer2.Panel2.SuspendLayout();
            this.splitContainer2.SuspendLayout();
            this.SuspendLayout();
            // 
            // Bn_FindDll
            // 
            this.Bn_FindDll.Font = new System.Drawing.Font("Microsoft Sans Serif", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.Bn_FindDll.Location = new System.Drawing.Point(118, 5);
            this.Bn_FindDll.Name = "Bn_FindDll";
            this.Bn_FindDll.Size = new System.Drawing.Size(48, 25);
            this.Bn_FindDll.TabIndex = 0;
            this.Bn_FindDll.Text = "DLL";
            this.Bn_FindDll.UseVisualStyleBackColor = true;
            this.Bn_FindDll.Click += new System.EventHandler(this.BtnBrowseDll_Click);
            // 
            // bn_Inject
            // 
            this.bn_Inject.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(204)))), ((int)(((byte)(204)))), ((int)(((byte)(204)))));
            this.bn_Inject.Font = new System.Drawing.Font("Microsoft Sans Serif", 14.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.bn_Inject.ForeColor = System.Drawing.SystemColors.ActiveCaptionText;
            this.bn_Inject.Location = new System.Drawing.Point(7, 24);
            this.bn_Inject.Name = "bn_Inject";
            this.bn_Inject.Size = new System.Drawing.Size(81, 43);
            this.bn_Inject.TabIndex = 1;
            this.bn_Inject.Text = "Inject";
            this.bn_Inject.UseVisualStyleBackColor = false;
            this.bn_Inject.Click += new System.EventHandler(this.BtnInject_Click);
            // 
            // tb_AppName
            // 
            this.tb_AppName.Location = new System.Drawing.Point(8, 54);
            this.tb_AppName.Multiline = true;
            this.tb_AppName.Name = "tb_AppName";
            this.tb_AppName.Size = new System.Drawing.Size(91, 35);
            this.tb_AppName.TabIndex = 2;
            this.tb_AppName.Text = "Target App(Drag Target)";
            this.tb_AppName.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            // 
            // tb_appID
            // 
            this.tb_appID.BackColor = System.Drawing.SystemColors.WindowText;
            this.tb_appID.ForeColor = System.Drawing.SystemColors.Menu;
            this.tb_appID.Location = new System.Drawing.Point(59, 19);
            this.tb_appID.Name = "tb_appID";
            this.tb_appID.Size = new System.Drawing.Size(40, 20);
            this.tb_appID.TabIndex = 19;
            this.tb_appID.Text = "000000";
            this.tb_appID.TextAlign = System.Windows.Forms.HorizontalAlignment.Center;
            this.tb_appID.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.tb_appID_KeyPress);
            // 
            // splitContainer1
            // 
            this.splitContainer1.Dock = System.Windows.Forms.DockStyle.Fill;
            this.splitContainer1.Location = new System.Drawing.Point(0, 0);
            this.splitContainer1.Name = "splitContainer1";
            // 
            // splitContainer1.Panel1
            // 
            this.splitContainer1.Panel1.BackColor = System.Drawing.Color.Gray;
            this.splitContainer1.Panel1.Controls.Add(this.bn_Inject);
            // 
            // splitContainer1.Panel2
            // 
            this.splitContainer1.Panel2.BackColor = System.Drawing.SystemColors.ActiveCaption;
            this.splitContainer1.Panel2.Controls.Add(this.cb_overrideTarget);
            this.splitContainer1.Panel2.Controls.Add(this.tb_AppName);
            this.splitContainer1.Panel2.Controls.Add(this.tb_appID);
            this.splitContainer1.Panel2.Controls.Add(this.pictureBoxTarget1);
            this.splitContainer1.Size = new System.Drawing.Size(206, 102);
            this.splitContainer1.SplitterDistance = 93;
            this.splitContainer1.TabIndex = 20;
            // 
            // cb_overrideTarget
            // 
            this.cb_overrideTarget.AutoSize = true;
            this.cb_overrideTarget.Location = new System.Drawing.Point(7, 0);
            this.cb_overrideTarget.Name = "cb_overrideTarget";
            this.cb_overrideTarget.Size = new System.Drawing.Size(78, 17);
            this.cb_overrideTarget.TabIndex = 2;
            this.cb_overrideTarget.Text = "Any Target";
            this.cb_overrideTarget.UseVisualStyleBackColor = true;
            this.cb_overrideTarget.CheckedChanged += new System.EventHandler(this.cb_overrideTarget_CheckedChanged);
            // 
            // tb_pathToFiles
            // 
            this.tb_pathToFiles.Location = new System.Drawing.Point(12, 33);
            this.tb_pathToFiles.Multiline = true;
            this.tb_pathToFiles.Name = "tb_pathToFiles";
            this.tb_pathToFiles.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
            this.tb_pathToFiles.Size = new System.Drawing.Size(184, 67);
            this.tb_pathToFiles.TabIndex = 6;
            // 
            // label1
            // 
            this.label1.AutoSize = true;
            this.label1.Location = new System.Drawing.Point(9, 12);
            this.label1.Name = "label1";
            this.label1.Size = new System.Drawing.Size(103, 13);
            this.label1.TabIndex = 5;
            this.label1.Text = "Select what to inject";
            // 
            // splitContainer2
            // 
            this.splitContainer2.Location = new System.Drawing.Point(-1, 1);
            this.splitContainer2.Name = "splitContainer2";
            this.splitContainer2.Orientation = System.Windows.Forms.Orientation.Horizontal;
            // 
            // splitContainer2.Panel1
            // 
            this.splitContainer2.Panel1.Controls.Add(this.splitContainer1);
            // 
            // splitContainer2.Panel2
            // 
            this.splitContainer2.Panel2.BackColor = System.Drawing.Color.FromArgb(((int)(((byte)(192)))), ((int)(((byte)(255)))), ((int)(((byte)(255)))));
            this.splitContainer2.Panel2.Controls.Add(this.Bn_FindDll);
            this.splitContainer2.Panel2.Controls.Add(this.tb_pathToFiles);
            this.splitContainer2.Panel2.Controls.Add(this.label1);
            this.splitContainer2.Size = new System.Drawing.Size(206, 209);
            this.splitContainer2.SplitterDistance = 102;
            this.splitContainer2.TabIndex = 21;
            // 
            // listBox_processTargets
            // 
            this.listBox_processTargets.FormattingEnabled = true;
            this.listBox_processTargets.Location = new System.Drawing.Point(211, 25);
            this.listBox_processTargets.Name = "listBox_processTargets";
            this.listBox_processTargets.Size = new System.Drawing.Size(164, 186);
            this.listBox_processTargets.TabIndex = 22;
            this.listBox_processTargets.SelectedIndexChanged += new System.EventHandler(this.listBox_processTargets_SelectedIndexChanged);
            // 
            // bn_refreshProcessList
            // 
            this.bn_refreshProcessList.Location = new System.Drawing.Point(237, 1);
            this.bn_refreshProcessList.Name = "bn_refreshProcessList";
            this.bn_refreshProcessList.Size = new System.Drawing.Size(125, 23);
            this.bn_refreshProcessList.TabIndex = 23;
            this.bn_refreshProcessList.Text = "Refresh Process List";
            this.bn_refreshProcessList.UseVisualStyleBackColor = true;
            this.bn_refreshProcessList.Click += new System.EventHandler(this.bn_refreshProcessList_Click);
            // 
            // pictureBoxTarget1
            // 
            this.pictureBoxTarget1.Location = new System.Drawing.Point(21, 19);
            this.pictureBoxTarget1.Name = "pictureBoxTarget1";
            this.pictureBoxTarget1.Size = new System.Drawing.Size(32, 29);
            this.pictureBoxTarget1.TabIndex = 18;
            // 
            // MainUI
            // 
            this.ClientSize = new System.Drawing.Size(374, 209);
            this.Controls.Add(this.bn_refreshProcessList);
            this.Controls.Add(this.listBox_processTargets);
            this.Controls.Add(this.splitContainer2);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.Fixed3D;
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.Name = "MainUI";
            this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
            this.Text = "Injector";
            this.Load += new System.EventHandler(this.MainUI_Load);
            this.splitContainer1.Panel1.ResumeLayout(false);
            this.splitContainer1.Panel2.ResumeLayout(false);
            this.splitContainer1.Panel2.PerformLayout();
            this.splitContainer1.ResumeLayout(false);
            this.splitContainer2.Panel1.ResumeLayout(false);
            this.splitContainer2.Panel2.ResumeLayout(false);
            this.splitContainer2.Panel2.PerformLayout();
            this.splitContainer2.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion ---GUI stuff---

        #region vars
        string dllPath = string.Empty;
        string exePath = string.Empty;
        System.Diagnostics.Process procTarget;
        #endregion ---vars---

        #region dll Import
        [System.Runtime.InteropServices.DllImport("kernel32.dll", SetLastError = true, CallingConvention = System.Runtime.InteropServices.CallingConvention.Winapi)]
        [return: System.Runtime.InteropServices.MarshalAs(System.Runtime.InteropServices.UnmanagedType.Bool)]
        private static extern bool IsWow64Process(
             [System.Runtime.InteropServices.In] IntPtr hProcess,
             [System.Runtime.InteropServices.Out] out bool wow64Process
             );
        #endregion ---dll Imort---
 
        #region con
        public MainUI()
        {
            InitializeComponent();

            if (IntPtr.Size == 4)
                dllPath = "slater32.dll";
            if (IntPtr.Size == 8)
                dllPath = "slater64.dll";
            exePath = "slate.exe";


            updateText();
        }

        private void MainUI_Load(object sender, EventArgs e)
        {
            //TaskInfo ti = new TaskInfo("This report displays the number {0}.", 42);
            //System.Threading.ThreadPool.QueueUserWorkItem(new wa
            //System.Threading.Thread t = new System.Threading.Thread(new System.Threading.ThreadStart(delegate
            //{
            //    InjectAuto.AutoInject();
            //}));
            //t.ApartmentState = System.Threading.ApartmentState.MTA;
            //t.Start();

            // find target .NET apps
            InitPrrocessTargets();

            if (IntPtr.Size == 4)
                this.Text += "-32";
            if (IntPtr.Size == 8)
                this.Text += "-64";

            pictureBoxTarget1.myWindowTarget.targetApplicationEvent += new Injector.Tools.spike.TargetWindow.newTargetProcess(delegate(System.Diagnostics.Process procIN)
            {
                try
                {
                    string s = string.Empty;
                    procTarget = procIN;
                    s = procIN.ProcessName;
                    if (s != null && s.Contains("."))
                        s = s.Substring(0, s.LastIndexOf("."));
                    tb_AppName.Text = s;
                    tb_appID.Text = procIN.Id.ToString();
                }
                catch (System.Exception ex)
                {
                    throw new System.Exception("error: targetApplicationEvent #65f67g8h78 " + ex.Message);
                }
            });

            this.Activate();
        }
        #endregion ---con---

        #region BtnBrowseDll
        private void BtnBrowseDll_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "Dynamic Link Library|*.dll";
            ofd.FileOk += new System.ComponentModel.CancelEventHandler(dll_FileOk);
            ofd.ShowDialog();
        }
        #endregion ---BtnBrowseDll---

        #region BtnInject
        private void BtnInject_Click(object sender, EventArgs e)
        {
            if (System.Diagnostics.Process.GetProcessesByName(tb_AppName.Text).Length > 0)
            {
                string currentDIR = System.IO.Directory.GetCurrentDirectory();
                string dllToRun ;

                if (!dllPath.Contains("\\"))
                    dllToRun = currentDIR + "\\" + dllPath;
                else
                    dllToRun = dllPath;
           

                if (!System.IO.File.Exists(dllPath))
                {
                    System.Windows.Forms.MessageBox.Show("File not found: " + dllToRun);
                }

                if (!InjectorCore.DoInject(tb_AppName.Text, dllToRun, true))
                    MessageBox.Show("injecting Fail #89gh9fb");

                this.Close();
            }
            else
                System.Windows.Forms.MessageBox.Show("Could not find process:" + tb_AppName.Text);
        }
        #endregion ---BtnInject----

        #region FileDialogs
        private void dll_FileOk(object sender, System.ComponentModel.CancelEventArgs e)
        {
            OpenFileDialog ofd = (OpenFileDialog)sender;
            dllPath = ofd.FileName;
            updateText();

            //now dispose of the object
            ofd.Dispose();
        }
 
        #endregion ---FileDialogs---

        #region GUI
        #region cb_overrideTarget
        private void cb_overrideTarget_CheckedChanged(object sender, EventArgs e)
        {
            pictureBoxTarget1.myWindowTarget.overRideManagedCheck = cb_overrideTarget.Checked;
        }
        #endregion ---cb_overrideTarget---

        #region tb_appID_KeyPress
        /// <summary>
        /// this is used if someone types in the PID
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void tb_appID_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == System.Environment.NewLine[0])
            {
                try
                {
                    System.Diagnostics.Process aProcess = System.Diagnostics.Process.GetProcessById(int.Parse(tb_appID.Text));
                    pictureBoxTarget1.myWindowTarget.CheckApp(aProcess, true);
                    e.Handled = true;
                }
                catch
                {
                    System.Windows.Forms.MessageBox.Show("sorry PID:" + tb_appID.Text + " not found");
                }
            }
        }
        #endregion ---tb_appID_KeyPress---

        #region processListBox

        // this is for the process ListBox
        private void bn_refreshProcessList_Click(object sender, EventArgs e)
        {
            listBox_processTargets.Items.Clear();
            InitPrrocessTargets();
        }
        private void InitPrrocessTargets()
        {
            // get all .NET processes
            foreach (System.Diagnostics.Process proc in InjectorCore.FindEveryDotNetProces())
            {
                listBox_processTargets.Items.Add(new aProcess(proc));
            }
        }
        private void listBox_processTargets_SelectedIndexChanged(object sender, EventArgs e)
        {
            aProcess proc = listBox_processTargets.SelectedItem as aProcess;
            if (proc != null)
            {
                tb_appID.Text = proc.PID.ToString();
                tb_AppName.Text = proc.name;
            }
        }
        public class aProcess
        {
            readonly System.Diagnostics.Process myProc;
            public aProcess(System.Diagnostics.Process procIN)
            {
                myProc = procIN;
            }
            public string name { get { return myProc.ProcessName; } }
            public int PID
            { get { return myProc.Id; } }
            public override string ToString()
            {
                return myProc.ProcessName + "  PID: " + myProc.Id;
            }
        }
        #endregion ---processListBox---
        #endregion ---GUI---
    }
}