﻿using System;

namespace Injector.Tools.spike
{
    public partial class pictureBoxTarget : System.Windows.Forms.UserControl
    {
        public TargetWindow myWindowTarget = new TargetWindow();
        System.Drawing.Image myImage_AppNoCross;
        System.Windows.Forms.Cursor myImage_CursorCross;
        System.Drawing.Image myImage_AppCross;
        public delegate void newTargetForm(System.Windows.Forms.Form targetIN);
        public delegate void newTargetControl(System.Windows.Forms.Control targetIN);
        public delegate void tryLock();
        public event newTargetForm targetForm;
        public event newTargetControl targetControl;
        public event tryLock targetTry;

        #region con
        public pictureBoxTarget()
        {
            InitializeComponent();

            myImage_AppNoCross = global::Injector32.Properties.Resources.app_no_cross;
            System.IO.Stream s = new System.IO.MemoryStream(global::Injector32.Properties.Resources.cross);
            myImage_CursorCross = new System.Windows.Forms.Cursor(s);
            myImage_AppCross = global::Injector32.Properties.Resources.app_cross;
            Init();
        }

        private void Init()
        {
            myWindowTarget.targetWindowEvent += new TargetWindow.newTargetWindows(delegate(System.Windows.Forms.Control targetIN)
            {
                if (targetIN is System.Windows.Forms.Form)
                {
                    if (targetForm != null)
                    {
                        targetForm(targetIN as System.Windows.Forms.Form);
                    }
                }
                else
                {
                    if (targetIN is System.Windows.Forms.Control)
                        if (targetControl != null)
                        {
                            targetControl(targetIN);
                        }
                }
            });
        }
        #endregion ---con---

      
        private void pb_myPictureBox_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            if (e.Button == System.Windows.Forms.MouseButtons.Left)
            {
                myWindowTarget.dragging = true;
                myWindowTarget.active = true;
                this.Cursor = myImage_CursorCross;
                pb_myPictureBox.Image = myImage_AppNoCross;
            }
        }
        private void pb_myPictureBox_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            myWindowTarget.MouseUpdate(true);
        }
        private void pb_myPictureBox_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
        {
            myWindowTarget.dragging = false;
            myWindowTarget.active = true;

            if (targetTry != null)
                targetTry();

            this.Cursor = System.Windows.Forms.Cursors.Default;

            pb_myPictureBox.Image = myImage_AppCross;

            myWindowTarget.MouseUpdateToCurrentTarget();
            myWindowTarget.active = false;
        }
    }
}
