﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Injector.Tools.spike
{
  public  class TargetWindow
    {
        #region vars
        IntPtr hWndCurrent;

        public bool dragging = false;
        public bool active = false;


        public delegate void newTargetProcess(System.Diagnostics.Process procIN);
        public delegate void newTargetWindows(System.Windows.Forms.Control formIN);
        public event newTargetProcess targetApplicationEvent;
        public event newTargetWindows targetWindowEvent;
        public bool overRideManagedCheck = false;
        public System.Drawing.Point MousePosition
        {
            get
            {
                return System.Windows.Forms.Cursor.Position;
            }
        }

        #endregion ---vars---

        #region con
        public TargetWindow()
        {
        
        }
        #endregion ---con---

        #region fire mouse events
        public void MouseUpdate(bool silent)
        {
            if (!active)
                return;

            IntPtr hWnd = WindowsAppTarget.WindowFromPoint(MousePosition);
            try
            {
                System.Diagnostics.Process aProcess = null;
                if (hWnd == hWndCurrent || hWnd == IntPtr.Zero)
                {
                    return;
                }
                hWndCurrent = hWnd;

                if (dragging)
                {

                    if (hWnd != IntPtr.Zero)
                    {
                        try
                        {
                            if (silent == false)
                            {
                                // target window
                                if (targetWindowEvent != null)
                                {
                                    targetWindowEvent(System.Windows.Forms.Form.FromHandle(hWndCurrent));
                                }
                            }
                            if (targetApplicationEvent != null)
                            {
                                aProcess = WindowsAppTarget.GetApplication(hWnd);
                                CheckApp(aProcess, !silent);
                            }
                        }
                        catch
                        {
                            System.Windows.Forms.MessageBox.Show("Fail lock on");
                        }
                    }
                }
                else
                {
                    if (hWnd != IntPtr.Zero)
                    {
                        try
                        {
                            if (silent == false)
                            {
                                // target window
                                if (targetWindowEvent != null)
                                {
                                    targetWindowEvent(System.Windows.Forms.Form.FromHandle(hWndCurrent));
                                }
                            }
                            if (targetApplicationEvent != null)
                            {
                                aProcess = WindowsAppTarget.GetApplication(hWnd);
                                CheckApp(aProcess, !silent);
                            }
                        }
                        catch
                        {
                            System.Windows.Forms.MessageBox.Show("Fail lock on");
                        }
                    }
                }
            }
            catch
            {
                System.Windows.Forms.MessageBox.Show("Fail lock on to application");
            }
        }
    
        public void MouseUpdateToCurrentTarget()
        {
            MouseUpdate(false);
        }
      
        public void CheckApp(System.Diagnostics.Process aProcess, bool showError)
        {
            if (!overRideManagedCheck)
            {
                if (!WindowsAppTarget.IsManaged(aProcess))
                {
                    if (showError)
                    {
                        string processName = aProcess.ProcessName;
                        string processPID = aProcess.Id.ToString();
                        System.Windows.Forms.MessageBox.Show(WindowsAppTarget.getModules(aProcess), "Error: Denied -" + processName + "-  PID:" + processPID);
                    }
                    return;
                }
            }

            // send event
            if (aProcess != null)
            {
                if (targetApplicationEvent != null)
                {
                    try
                    {
                        targetApplicationEvent(aProcess);
                    }
                    catch
                    {
                        System.Windows.Forms.MessageBox.Show("Fail lock on");
                    }
                }
            }
        }

        #endregion ---fire mouse events---
    }
}
