﻿using System;
using System.Drawing;
using System.Windows.Forms;

namespace slate
{
    public partial class frm_slate : Form
    {
        #region vars
        // a list of suppoer files, to load if needed
        System.Collections.Generic.List<string> filesToLoad = new System.Collections.Generic.List<string>();
        #endregion ---vars---

        #region con
        public frm_slate()
        {
            InitializeComponent();
        }
        private void frm_slate_Load(object sender, EventArgs e)
        {
            this.Activate();
        }
        #endregion ---con---

        #region click button
        private void bn_pickDll_Click(object sender, EventArgs e)
        {
            System.Windows.Forms.OpenFileDialog ofd = new OpenFileDialog();
            ofd.Filter = "exe files (*.exe)|*.exe|dll files (*.dll)|*.dll|All files (*.*)|*.*";

            ofd.Title = "Select a dll/exe code base";

            //Present to the user
            if (ofd.ShowDialog() == DialogResult.OK)
                tb_codeBase.Text = ofd.FileName;
        }
        private void doAsmBuildEvent()
        {
            #region System.AppDomain.CurrentDomain.AssemblyResolve event
            // This is fired when the CLR tries to bind to the assembly and fails
            ResolveEventHandler Eve = new ResolveEventHandler(delegate(object sender, ResolveEventArgs args)
            {
                string nameOfFile = args.Name.Substring(0, args.Name.IndexOf(","));
                System.Reflection.Assembly am = null;
                foreach (string supportFile in filesToLoad)
                {
                    int start = supportFile.LastIndexOf("\\") + 1;
                    int end = supportFile.LastIndexOf(".") - start;
                    if (supportFile.Substring(start, end) == nameOfFile)
                    {
                        am = System.Reflection.Assembly.LoadFile(supportFile);
                    }
                }
                return am;
            });
            System.AppDomain.CurrentDomain.AssemblyResolve += Eve;

            #endregion ---System.AppDomain.CurrentDomain.AssemblyResolve event---

            this.FormClosing += new FormClosingEventHandler(delegate
            {
                System.AppDomain.CurrentDomain.AssemblyResolve -= Eve;

            });
        }
        private void bn_loadMain_Click(object sender, EventArgs e)
        {
            doAsmBuildEvent();

            if (listBox_supportDll_List.Items.Count == 0 && tb_codeBase.Text == string.Empty)
            {
                System.Windows.Forms.MessageBox.Show("select file to load");
                return;
            }

            foreach (string s in listBox_supportDll_List.Items)
            {
                if (!filesToLoad.Contains(s))
                    filesToLoad.Add(s);
            }

            System.Reflection.Assembly am = System.Reflection.Assembly.LoadFile(tb_codeBase.Text);

            System.Reflection.MethodInfo m = am.EntryPoint;

            int numParams = m.GetParameters().Length;
            object[] paramList = new object[numParams];

            int i = 0;
            foreach (System.Reflection.ParameterInfo p in m.GetParameters())
            {
                if (p.ParameterType.IsArray)
                {
                    switch (p.ParameterType.ToString())
                    {
                        case "System.String[]":
                            paramList[i] = new string[0];
                            break;
                        case "System.Int[]":
                            paramList[i] = new int[0];
                            break;
                    }
                }
                else
                    paramList[i] = p.DefaultValue;
            }

            if (paramList.Length == 0)
                paramList = null;

            System.Threading.Semaphore mu = new System.Threading.Semaphore(0, 1);

            System.Threading.ThreadPool.QueueUserWorkItem(new System.Threading.WaitCallback(
            delegate
            {
                System.Threading.Thread t = new System.Threading.Thread(new System.Threading.ThreadStart(
                delegate
                {
                    m.Invoke(null, paramList);
                }));

                t.Priority = System.Threading.ThreadPriority.AboveNormal;
                t.SetApartmentState(System.Threading.ApartmentState.STA);
                t.IsBackground = true;
                t.Start();
                System.Threading.Thread.Sleep(200);
                mu.Release();

            }), null);

            mu.WaitOne();

            if (!cb_keepOpen.Checked)
            {
                this.Close();
            }
        }

        private void bn_addSupportDll_Click(object sender, EventArgs e)
        {
            System.Windows.Forms.OpenFileDialog ofd = new OpenFileDialog();
            ofd.Multiselect = true;
            ofd.Filter = "dll files (*.dll)|*.dll|exe files (*.exe)|*.exe|All files (*.*)|*.*";

            ofd.Title = "Select a dll/exe code base";

            //Present to the user
            if (ofd.ShowDialog() == DialogResult.OK)
                foreach (string name in ofd.FileNames)
                    listBox_supportDll_List.Items.Add(name);
        }


        private void bn_resetFiles_Click(object sender, EventArgs e)
        {
            System.Reflection.Assembly.LoadFile("C:\\1.exe");
            try
            {
                tb_codeBase.Text = string.Empty;
                listBox_supportDll_List.Items.Clear();
            }
            catch
            {
                System.Windows.Forms.MessageBox.Show("Error on Reset Files Button #iufgivg");
            }

        }
        #endregion ---click button---

        #region DragDrop
        private void tb_codeBase_DragDrop(object sender, DragEventArgs e)
        {
            string[] files = (string[])e.Data.GetData(DataFormats.FileDrop);
            tb_codeBase.Text = string.Empty;
            foreach (string s in files)
            {
                tb_codeBase.Text = s;
            }
        }

        private void listBox_supportDll_List_DragDrop(object sender, DragEventArgs e)
        {
            string[] files = (string[])e.Data.GetData(DataFormats.FileDrop);
            listBox_supportDll_List.Text = string.Empty;
            foreach (string s in files)
            {
                listBox_supportDll_List.Items.Add(s);
            }
        }

        private void tb_codeBase_DragEnter(object sender, DragEventArgs e)
        {
            e.Effect = DragDropEffects.All;
            object j = e.Data;
        }

        private void listBox_supportDll_List_DragEnter(object sender, DragEventArgs e)
        {
            e.Effect = DragDropEffects.All;
            object j = e.Data;
        }
        #endregion ---DragDrop---
    }
}