#ifndef SLATER_H
#define SLATER_H

#include "MSCorEE.h"
#import "mscorlib.tlb" raw_interfaces_only
#include <sys\types.h>
#include <sys\stat.h>
#include <iostream>
#include <fstream>
#include <string>
#include "payload-slate.h"

using namespace std;

bool Bootstrap();

BOOL APIENTRY DllMain(HANDLE hModule, DWORD  ul_reason_for_call,  LPVOID lpReserved);

class CSafeArrayByteVector
{
private:
    SAFEARRAY* m_ar;
    bool m_locked;

public:
    CSafeArrayByteVector()
    {
        m_ar=NULL;
        m_locked=false;
    }
    ~CSafeArrayByteVector()
    {
        Clear();
    }

    BYTE* GetDataPtr()
    {
        if (!m_locked)
        {
            return NULL;
        }
        return (BYTE*)m_ar->pvData;
    }

    SAFEARRAY* GetSafeArray()
    {
        return m_ar;
    }

    BOOL Allocate(ULONG size);
    void Clear();
};


BOOL CSafeArrayByteVector::Allocate(ULONG size)
{
    Clear();
    m_ar=SafeArrayCreateVector(VT_UI1, 0, size);
    if (!m_ar)
    {
        return FALSE;
    }
    HRESULT hr;
    hr=SafeArrayLock(m_ar);
    if (FAILED(hr))
    {
        Clear();
        return FALSE;
    }
    m_locked=true;
    return TRUE;
}

void CSafeArrayByteVector::Clear()
{
    if (m_ar)
    {
        if (m_locked)
        {
            SafeArrayUnlock(m_ar);
            m_locked=false;
        }
        SafeArrayDestroy(m_ar);
        m_ar=NULL;
    }
}
 

#endif