; .
;
; o     .
;
Public CsBuildJcc
Public CsBuildJxx
Public CsBuildCall
Public CsBuild
Public GpBuildGraph

; +
;   .
;
; Ebx: PXX_BRANCH_HEADER
; Edi: @Buffer
;
CsBuildJcc proc C uses esi
	cld
	assume ebx:PXX_BRANCH_HEADER
	mov ecx,dword ptr [ebx + EhJccType]
	and ecx,JCC_TYPE_MASK
	cmp cl,15
	ja CsBuildError
	test dword ptr [ebx + EhJcxType],BRANCH_CX_FLAG
	jnz Jcx
	test dword ptr [ebx + EhBranchSize],BRANCH_SIZE_MASK
	.if Zero?	; Short
	   cmp dword ptr [ebx + EhBranchOffset],0FFH/2
	   ja CsBuildError
	   lea eax,[ecx + JCC_SHORT_OPCODE_BASE]
	   jmp jShort
	.endif
; Near
	mov byte ptr [edi],0FH
	inc edi
	lea eax,[ecx + JCC_NEAR_OPCODE_BASE]
	stosb
	test dword ptr [ebx + EhJccType],BRANCH_DELTA_SIGN
	mov eax,dword ptr [ebx + EhBranchOffset]
	.if Zero?
	   sub eax,6
	.else
	   not eax
	   sub eax,5
	.endif
	stosd
	jmp CsBuildSuccess
Jcx:
	cmp dword ptr [ebx + EhBranchOffset],0FFH/2
	ja CsBuildError
	test dword ptr [ebx + EhJccType],JCC_X16_MASK
	.if !Zero?
	      mov byte ptr [edi],PREFIX_ADDR_SIZE	; 0x67
	      inc edi
	.endif
	mov eax,dword ptr [ebx + EhJccType]
	and eax,JCC_TYPE_MASK
	cmp eax,4
	jnb CsBuildError
	add eax,JCX_OPCODE_BASE
jShort:
	stosb
	test dword ptr [ebx + EhJccType],BRANCH_DELTA_SIGN
	mov eax,dword ptr [ebx + EhBranchOffset]
	.if Zero?
	   sub al,2
	.else
	   test dword ptr [ebx + EhJccType],JCC_X16_MASK
	   setnz cl
	   add al,cl
	   not al
	   dec al
	.endif
	stosb
CsBuildSuccess::
	xor eax,eax
CsBuildExit::
	ret
CsBuildError::
	mov eax,STATUS_UNSUCCESSFUL
	jmp CsBuildExit
CsBuildJcc endp

; +
;   .
;
; Ebx: PXX_BRANCH_HEADER
; Edi: @Buffer
;
CsBuildJxx proc C uses esi
	cld
	assume ebx:PBRANCH_HEADER
	test dword ptr [ebx + EhBranchType],BRANCH_DEFINED_FLAG
	mov esi,[ebx].Address
	jnz @f
	invoke QueryOpcodeSize, Esi
	test eax,eax
	mov ecx,eax
	jz CsBuildError
	rep movsb
	jmp CsBuildSuccess
@@:
	test dword ptr [ebx + EhBranchSize],BRANCH_SIZE_MASK
	mov eax,dword ptr [ebx + EhBranchOffset]
	.if Zero?	; Short
	   cmp dword ptr [ebx + EhBranchOffset],0FFH/2
	   ja CsBuildError
	   mov byte ptr [edi],0EBH
	   inc edi
 	   test dword ptr [ebx + EhJccType],BRANCH_DELTA_SIGN
	   .if Zero?
	      sub al,2
	   .else
	      not al
	      dec al
	   .endif
	   stosb
	   jmp CsBuildSuccess
	.endif
; Near
	mov byte ptr [edi],0E9H
	inc edi
	test dword ptr [ebx + EhJccType],BRANCH_DELTA_SIGN
	.if Zero?
	   sub eax,5
	.else
	   not eax
	   sub eax,4
	.endif
	stosd
	jmp CsBuildSuccess
CsBuildJxx endp

; +
;   .
;
; Ebx: PXX_BRANCH_HEADER
; Edi: @Buffer
;
CsBuildCall proc C uses esi
	cld
	assume ebx:PCALL_HEADER
	test dword ptr [ebx + EhBranchType],BRANCH_DEFINED_FLAG
	mov esi,[ebx].Address
	jnz @f
	invoke QueryOpcodeSize, Esi
	test eax,eax
	mov ecx,eax
	jz CsBuildError
	rep movsb
	jmp CsBuildSuccess
@@:
	mov dword ptr [edi],0E8H
	inc edi
	test dword ptr [ebx + EhDisclosureFlag],DISCLOSURE_CALL_FLAG
	.if Zero?	; Closed
	; Recalc disp.
	   mov eax,dword ptr [ebx + EhBranchAddress]
	   sub eax,edi
	   sub eax,4
	   stosd
	   jmp CsBuildSuccess
	.endif
	test dword ptr [ebx + EhJccType],BRANCH_DELTA_SIGN
	mov eax,dword ptr [ebx + EhBranchOffset]
	.if Zero?
	   sub eax,5
	.else
	   not eax
	   sub eax,4
	.endif
	stosd
	jmp CsBuildSuccess
CsBuildCall endp

; +
; .
;
CsBuild proc uses ebx esi edi CsBase:PVOID, CsLimit:ULONG, OutBuffer:PVOID
	mov ebx,CsBase
	mov edi,OutBuffer
	cld
@@:
	and ebx,NOT(TYPE_MASK)
	mov eax,dword ptr [ebx + EhEntryType]
	mov esi,dword ptr [ebx + EhAddress]
	and eax,TYPE_MASK
	.if Zero?	; Line
	mov ecx,dword ptr [ebx + EhSize]
	rep movsb
	.else
	   dec eax
	   .if Zero?	; Call
	   invoke CsBuildCall
	   .else
	      test dword ptr [ebx + EhIdleBranch],BRANCH_IDLE_FLAG
	      jnz Next
	      dec eax
	      .if Zero?	; Jxx
  	         invoke CsBuildJxx
	      .else	; Jcc
	         invoke CsBuildJcc
	      .endif
	   .endif
	   test eax,eax
	   jnz @f
	.endif
Next:
	add ebx,ENTRY_HEADER_SIZE
	cmp CsLimit,ebx
	ja @b
@@:
	ret
CsBuild endp

; +
;    .
;
GpBuildGraph proc C
	test dword ptr [esp - X86_PAGE_SIZE],eax
	test dword ptr [esp - 2*X86_PAGE_SIZE],eax
	jmp GpBuildGraphInternal
GpBuildGraph endp

; +
;  .
;
GpBuildGraphInternal proc uses ebx esi GpBase:PVOID, GpLimit:PVOID, CsBase:PVOID, BuildBuffer:PVOID
Local GraphLimit:PVOID
Local CsLimit:PVOID
Local CxBuffer[CX_REPLACE_TABLE_LENGTH + CX_REPLACE_GRAPH_LENGTH]:BYTE
	Call SEH_Epilog_Reference
	Call SEH_Prolog
	mov eax,GpLimit
	mov esi,CsBase
	mov ebx,GpBase
	mov GraphLimit,eax
	mov CsLimit,esi
	invoke RwUnlinkJcxSelfBranches, Ebx, Eax
	invoke CxMorphGraph, addr CxBuffer, Ebx, addr GraphLimit
	test eax,eax
	jnz Exit
	invoke RwConvertRawTableToCrossTable, Ebx, addr CsLimit
	test eax,eax
	jnz Exit
	invoke CsMarkAndUnlinkIdleBranches, Esi, CsLimit
	test eax,eax
	jnz Exit
	invoke CsAdjustBranches, Esi, CsLimit
	test eax,eax
	jnz Exit
	invoke CsBuild, Esi, CsLimit, BuildBuffer
	jmp Exit
SEH_Epilog_Reference:
	%GET_CURRENT_GRAPH_ENTRY
Exit:
	Call SEH_Epilog
	ret
GpBuildGraphInternal endp