#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <dir.h>

#include "odbg\plugin106.h"  // ̊ɍ킹ăpXς
#include "resource.h"

#define HCW_SHOWCAPT    0
#define HCW_HIDECAPT    1
#define HCW_SNAPWIN     2
#define HCW_OPTIONS     40

#define PNAME   "Hide Caption"
#define PVERS   "v1.00"
#define ANAME   "Gigapede"

HINSTANCE  hinst;                // DLL instance
HWND       hwmain;               // Handle of main OllyDbg window
HWND       hwMDI;
HHOOK      hHook;

typedef struct _tagHIDECAPTWND {
  int processed;
  char capt[TEXTLEN];
} HIDECAPTWND, *LPHIDECAPTWND;

LPHIDECAPTWND pHCW;
static int hcwcount;
static int icount = 0;
static int iHideCaptOnStart, iNoThickFrame;

BOOL CALLBACK EnumChildProc(HWND hwnd, LPARAM lp);

void CheckWndStyle(DWORD style, const char *capt)
{
  char buf[TEXTLEN];

  memset(buf,0,sizeof(buf));
  Addtolist(0,1,"  %s Window has these styles",capt);
  if(style & WS_BORDER)
    strcat(buf," WS_BORDER");
  if(style & WS_CAPTION)
    strcat(buf," WS_CAPTION");
  if(style & WS_CHILD)
    strcat(buf," WS_CHILD");
  if(style & WS_CLIPCHILDREN)
    strcat(buf," WS_CLIPCHILDREN");
  if(style & WS_CLIPSIBLINGS)
    strcat(buf," WS_CLIPSIBLINGS");
  if(style & WS_DISABLED)
    strcat(buf," WS_DISABLED");
  if(style & WS_DLGFRAME)
    strcat(buf," WS_DLGFRAME");
  if(style & WS_GROUP)
    strcat(buf," WS_GROUP");
  if(style & WS_HSCROLL)
    strcat(buf," WS_HSCROLL");
  if(style & WS_MAXIMIZE)
    strcat(buf," WS_MAXIMIZE");
  if(style & WS_MAXIMIZEBOX)
    strcat(buf," WS_MAXIMIZEBOX");
  if(style & WS_MINIMIZE)
    strcat(buf," WS_MINIMIZE");
  if(style & WS_MINIMIZEBOX)
    strcat(buf," WS_MINIMIZEBOX");
  if(style & WS_OVERLAPPED)
    strcat(buf," WS_OVERLAPPED");
  if(style & WS_OVERLAPPEDWINDOW)
    strcat(buf," WS_OVERLAPPEDWINDOW");
  if(style & WS_POPUP)
    strcat(buf," WS_POPUP");
  if(style & WS_POPUPWINDOW)
    strcat(buf," WS_POPUPWINDOW");
  if(style & WS_SYSMENU)
    strcat(buf," WS_SYSMENU");
  if(style & WS_TABSTOP)
    strcat(buf," WS_TABSTOP");
  if(style & WS_THICKFRAME)
    strcat(buf," WS_THICKFRAME");
  if(style & WS_VISIBLE)
    strcat(buf," WS_VISIBLE");
  if(style & WS_VSCROLL)
    strcat(buf," WS_VSCROLL");

  Addtolist(0,1,buf);
}

LRESULT CALLBACK OptDlgProc(HWND hDlgWnd, UINT msg, WPARAM wp, LPARAM lp)
{

  switch (msg) {
  case WM_INITDIALOG:
    SendMessage(GetDlgItem(hDlgWnd, IDC_HIDECAPTONSTART), BM_SETCHECK, (WPARAM)iHideCaptOnStart, 0L);
    SendMessage(GetDlgItem(hDlgWnd, IDC_NOTHICKFRAME),    BM_SETCHECK, (WPARAM)iNoThickFrame   , 0L);
    return TRUE;

  case WM_COMMAND:
    switch (LOWORD(wp)) {
    case IDOK:
      iHideCaptOnStart = (IsDlgButtonChecked(hDlgWnd, IDC_HIDECAPTONSTART) == BST_CHECKED) ? 1 : 0;
      iNoThickFrame    = (IsDlgButtonChecked(hDlgWnd, IDC_NOTHICKFRAME   ) == BST_CHECKED) ? 1 : 0;
      EndDialog(hDlgWnd, IDOK);
      break;

    case IDCANCEL:
      EndDialog(hDlgWnd, IDCANCEL);
      break;

    default:
      return FALSE;
    }
  default:
    return FALSE;
  }
  return TRUE;
}

BOOL WINAPI DllEntryPoint(HINSTANCE hi,DWORD reason,LPVOID reserved) {
  if (reason==DLL_PROCESS_ATTACH)
    hinst=hi;                          // Mark plugin instance
  return 1;                            // Report success
};

extc int _export cdecl ODBG_Plugindata(char shortname[32]) {
  strcpy(shortname,PNAME);       // Name of plugin
  return PLUGIN_VERSION;
};

LRESULT CALLBACK CallWndRetProc(int code, WPARAM wp, LPARAM lp)
{
  int  i,iHit,iprocessed;
  POINT pt;
  RECT  rect;
  CWPRETSTRUCT *pCWP = (CWPRETSTRUCT*)lp;
  char capt[TEXTLEN];
  LONG style;

  if(code < 0) {
    return CallNextHookEx(hHook,code,wp,lp);
  }

  switch(pCWP->message) {
  case WM_CREATE:

    if(GetParent(pCWP->hwnd) == hwMDI) {
      GetWindowText(pCWP->hwnd,capt,TEXTLEN-1);
      iHit = 0;
      for(i=0; i<hcwcount; i++) {
        if(!stricmp(capt,pHCW[i].capt)) {
          pHCW[i].processed = 1;
          iHit = 1;
          break;
        }
      }
      if(iHit) {
        GetWindowRect(pCWP->hwnd,&rect);
        style = GetWindowLong(pCWP->hwnd,GWL_STYLE);
        if(style & WS_CAPTION) {
          style ^= WS_CAPTION;
          if(iNoThickFrame) {
            style ^= WS_THICKFRAME;
          }
          SetWindowLong(pCWP->hwnd,GWL_STYLE,style);

          pt.x = rect.left;
          pt.y = rect.top;
          ScreenToClient(hwMDI,&pt);
          MoveWindow(pCWP->hwnd,pt.x+1,pt.y+1,rect.right-rect.left-1,rect.bottom-rect.top-1,TRUE);
          MoveWindow(pCWP->hwnd,pt.x,pt.y,rect.right-rect.left,rect.bottom-rect.top,TRUE);
        }
      }
    }
    iprocessed = 0;
    for(i=0; i<hcwcount; i++) {
      iprocessed += pHCW[i].processed;
    }
    if(iprocessed == hcwcount) {
      UnhookWindowsHookEx(hHook);
      hHook = NULL;
    }
    break;
  default:
    break;
  }

  return CallNextHookEx(hHook,code,wp,lp);
}

extc int _export cdecl ODBG_Plugininit(int ollydbgversion,HWND hw,DWORD *features) {
  char key[TEXTLEN];
  int i;

  if(ollydbgversion<PLUGIN_VERSION) {
    return -1;
  }
  hwmain=hw;
  hwMDI = (HWND)Plugingetvalue(VAL_HWCLIENT);
  Addtolist(0, 0,PNAME" "PVERS"  by "ANAME);

  hcwcount         = Pluginreadintfromini(hinst,"Count",0);
  iHideCaptOnStart = Pluginreadintfromini(hinst,"Hide Caption On Start",0);
  iNoThickFrame    = Pluginreadintfromini(hinst,"No Thick Frame",0);
  if(hcwcount>0) {
    pHCW = (LPHIDECAPTWND)malloc(sizeof(HIDECAPTWND)*hcwcount);
    for(i=0; i<hcwcount; i++) {
      sprintf(key,"HCW%d",i);
      Pluginreadstringfromini(hinst,key,pHCW[i].capt,NULL);
    }
    if(iHideCaptOnStart) {
      hHook = SetWindowsHookEx(WH_CALLWNDPROCRET,CallWndRetProc,NULL,GetCurrentThreadId());
    }
  }

  return 0;
};

extc int _export cdecl ODBG_Pluginmenu(int origin,char data[4096],void *item) {
  switch (origin) {
  case PM_MAIN: // Plugin menu in main window
    strcpy(data,
           "0 &Show Caption,"
           "1 &Hide Caption,"
           "2 Snap current MDI window layout for &hide caption|"
           "40 Option|"
           "63 "PNAME" "PVERS" by "ANAME
           );
    return 1;
  default:
    break; // Any other window
  }
  return 0; // Window not supported by plugin
};

extc void _export cdecl ODBG_Pluginaction(int origin,int action,void *item)
{
  char *msg = "This operation registers the windows which is currently displayed as a window without their caption bar.\n"
              "Please make sure that only the window you want to hide a caption is/are displayed.\n"
              "There may be the window which cannot be seen in order to be covered in the backside.\n\n"
              "When application is loaded, this cannot hide the caption of the CPU window well.\n"
              "Please execute it without loading an application.\n\n"
              "Continue ?";
  char *title = "Caution";
  char sect[TEXTLEN],key[TEXTLEN],fpath[MAXPATH],*pdest;
  int i,id;

  switch(origin) {
  case PM_MAIN:
    switch (action) {
    case HCW_SHOWCAPT:
      EnumChildWindows(hwMDI,EnumChildProc,HCW_SHOWCAPT);
      break;
    case HCW_HIDECAPT:
      EnumChildWindows(hwMDI,EnumChildProc,HCW_HIDECAPT);
      break;
    case HCW_SNAPWIN:
      id = MessageBox(hwmain,msg,title,MB_YESNO | MB_ICONINFORMATION);
      if(id == IDNO) {
        return;
      }
      GetModuleFileName(NULL, fpath, MAXPATH-1);
      pdest = strrchr(fpath, '\\');
      pdest[1] = '\0';
      SetCurrentDirectory(fpath);
      strcat(fpath, "ollydbg.ini");
      sprintf(sect,"Plugin %s",PNAME);
      WritePrivateProfileString(sect, NULL, NULL, fpath);
      icount = 0;
      EnumChildWindows(hwMDI,EnumChildProc,HCW_SNAPWIN);
      hcwcount = Pluginreadintfromini(hinst,"Count",0);
      if(hcwcount>0) {
        if(pHCW) free(pHCW);
        pHCW = (LPHIDECAPTWND)malloc(sizeof(HIDECAPTWND)*hcwcount);
        for(i=0; i<hcwcount; i++) {
          sprintf(key,"HCW%d",i);
          Pluginreadstringfromini(hinst,key,pHCW[i].capt,NULL);
        }
      }
      break;
    case HCW_OPTIONS:
      id = DialogBox(hinst,MAKEINTRESOURCE(IDD_HIDECAPTOPT),hwmain,(DLGPROC)OptDlgProc);
      if(id == IDOK) {
        strcpy(key,"Hide Caption On Start");
        Pluginwriteinttoini(hinst,key,iHideCaptOnStart);
        strcpy(key,"No Thick Frame");
        Pluginwriteinttoini(hinst,key,iNoThickFrame);
      }
      break;
    default:
      break;
    }
  default:
    break;
  }
}

/*
extc int _export cdecl ODBG_Pluginshortcut(int origin,int ctrl,int alt,int shift,int key,void *item) {
  if (ctrl==1 && alt==0 && shift==1 && (key=='W' || key =='w')) {
    EnumChildWindows(hwMDI,EnumChildProc,HCW_SHOWHIDE);
    return 1;
  }
  return 0;                            // Shortcut not recognized
}
*/

extc void _export cdecl ODBG_Plugindestroy(void) {
  if(pHCW)
    free(pHCW);
  if(hHook)
    UnhookWindowsHookEx(hHook);
}

BOOL CALLBACK EnumChildProc(HWND hwnd, LPARAM lp)
{
  int i,iHit;
  char capt[TEXTLEN],key[TEXTLEN];
  LONG style;
  RECT rect;
  POINT pt;
  if(GetParent(hwnd) == hwMDI) {
    switch(lp) {
    case HCW_SNAPWIN:
      Pluginwriteinttoini(hinst,"Count",icount);
      sprintf(key,"HCW%d",icount);
      GetWindowText(hwnd,capt,TEXTLEN-1);

      Pluginwritestringtoini(hinst,key,capt);
      icount++;
      Pluginwriteinttoini(hinst,"Count",icount);
      break;
    case HCW_HIDECAPT:
      GetWindowText(hwnd,capt,TEXTLEN-1);
      if(hcwcount > 0) {
        iHit = 0;
        for(i=0; i<hcwcount; i++) {
          if(!strnicmp(capt,pHCW[i].capt,strlen(pHCW[i].capt))) {
            iHit = 1;
            break;
          }
        }
        if(iHit) {
          GetWindowRect(hwnd,&rect);
          style = GetWindowLong(hwnd,GWL_STYLE);
          if(style & WS_CAPTION) {
            style ^= WS_CAPTION;
          }
          if(iNoThickFrame) {
            if(style & WS_THICKFRAME) {
              style ^= WS_THICKFRAME;
            }
          }
          SetWindowLong(hwnd,GWL_STYLE,style);

          pt.x = rect.left;
          pt.y = rect.top;
          ScreenToClient((HWND)Plugingetvalue(VAL_HWCLIENT),&pt);
          MoveWindow(hwnd,pt.x+1,pt.y+1,rect.right-rect.left-1,rect.bottom-rect.top-1,TRUE);
          MoveWindow(hwnd,pt.x,pt.y,rect.right-rect.left,rect.bottom-rect.top,TRUE);
        }
      }
      break;

    case HCW_SHOWCAPT:
      GetWindowText(hwnd,capt,TEXTLEN-1);
      if(hcwcount > 0) {
        iHit = 0;
        for(i=0; i<hcwcount; i++) {
          if(!strnicmp(capt,pHCW[i].capt,strlen(pHCW[i].capt))) {
            iHit = 1;
            break;
          }
        }
        if(iHit) {
          GetWindowRect(hwnd,&rect);
          style = GetWindowLong(hwnd,GWL_STYLE);
          style |= WS_CAPTION;
          style |= WS_THICKFRAME;
          SetWindowLong(hwnd,GWL_STYLE,style);

          pt.x = rect.left;
          pt.y = rect.top;
          ScreenToClient((HWND)Plugingetvalue(VAL_HWCLIENT),&pt);
          MoveWindow(hwnd,pt.x+1,pt.y+1,rect.right-rect.left-1,rect.bottom-rect.top-1,TRUE);
          MoveWindow(hwnd,pt.x,pt.y,rect.right-rect.left,rect.bottom-rect.top,TRUE);
        }
      }
      break;
    default: break;
    }
  }

  return TRUE;
}
