###############################################################################
#                                                                             #
# Name   : IDAAPIHelp.py v0.3                                                 #
# Author : Frank Boldewin / www.reconstructer.org                             #
# Date   : 13.12.2006                                                         #
# Descr. : looks at cursor position for a valid mnemonic and passes the       #
#          grabbed api to the help file Reconst-PSDKHLP.chm, which is         #
#          shipped with this IDAPython script. If the API is found in the     #
#          helpfile, it shows information about its usage.                    #
#          The python script also tries to strip unneeded data like ds: or    #
#          __imp_ from the right instruction operand as well as detecting     #
#          a valid apiname by filtering out strings like sub_ or loc_ !       #
#                                                                             #
# Req.  :  IDA Pro & IDAPython (my versions were 5.0.0.879 and 0.8)           #
#                                                                             #
# Setup :  copy IDAAPIHelp.py and Reconst-PSDHLP.chm together into your       #
#          IDA directory, e.g. C:\Program Files\IDA. While analysing with IDA #
#          place your cursor over an offset with the desired API call from    #
#          which you wish to get information from and press "ALT+9". Then     #
#          select the script IDAAPIHelp.py and the requested info should      #
#          appear in case it's in the help database.                          #
#                                                                             #
###############################################################################

import string, os
from idaapi import *

def main():

	hh = "start /B %systemroot%\\hh.exe"
	hlpapi = ""
	
	api = ""
	
	helpfile = idadir("") + '\\Reconst-PSDKHLP.chm'

	if not os.path.isfile(helpfile):
		Warning("Can't find %s! Must be in the same dir as IDAAPIHelp.py!" % helpfile)
		return

	ea = ScreenEA()
	mnem = GetMnem(ea)
	optype1 = GetOpType(ea,0)
	optype2 = GetOpType(ea,1)
	op1 = GetOpnd(ea,0)
	op2 = GetOpnd(ea,1)

	if mnem != "call" and mnem != "mov" and mnem != "jmp":
		Warning("No valid mnem!")
		return

	if optype2 !=0:
		if optype1 == 1 and optype2 == 2:
			api = op2
		else:
			Warning("No valid instruction operands combination!")
			return
	else:
		if (optype1 == 7 or optype1 == 2):
			api = op1
		else:
			Warning("No API call!")
			return
			
	if api.find("sub_") == 0 or api.find("loc_") == 0:
		Warning("No API call!")
		return

	if api.find("ds:") == 0:
		api = api[3:]
	if api.find("__imp_") == 0:
		api = api[6:]
	if api[-1] == 'W' or api[-1] == 'A':
		api = api[:-1]
				
	hlpapi = hh + " " + helpfile + "::/" + api + ".htm"
	Exec(hlpapi)

if __name__ == "__main__":
	main()
