/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    search.cpp

Abstract: Implements very simple search routing. Supports wildcards.

Revision History:

 Sten        05/06/2002
      Initial release

--*/

#include <string.h>
#include "search.h"

///////////////////////////////////////////////////////////////////
//
//  RabSearch
//
//     Search routing. Like Rabbing search, but without hash
//     precomputing.
//
///////////////////////////////////////////////////////////////////

int RabSearch(unsigned char *SearchString, int StringLen,
    unsigned char *SearchBuff, int BuffSize)
{
    register int i,j;

    if (BuffSize < StringLen) return -64;

    for(i=0;i<(BuffSize-StringLen);i++)
    {
        for(j=0;j<StringLen;j++)
        {
            if (
                 (SearchString[j] != _XX_) &&
                 (SearchString[j] != SearchBuff[i+j])
               )
            break;
        }
        if (j==StringLen) return i;
    }
    return -100;
}
