/*++
    Copyright  (c) 2004 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    ac97.h

Abstract: AC'97 code functions 

Revision History:

 Sten        01/01/2004
      Initial release. Started expiriments on using AC'97.. Wow!!

--*/

#ifndef __AC97_H__
#define __AC97_H__

#include "pci.h"

#define INTEL_VID       0x8086           // Intel's PCI vendor ID
#define ICH_DID         0x2415           // ICH device ID
#define ICH0_DID        0x2425           // ICH0
#define ICH2_DID        0x2445           // ICH2  
#define ICH3_DID        0x2485           // ICH3 ?
#define ICH4_DID        0x24C5           // ICH4
#define ICH5_DID        0x24D5           // ICH5 ?
                                         // they all should be compatible.

#define NAMBAR_REG      0x10             // native audio mixer BAR
#define NAM_SIZE        256              // 256 bytes required.

#define NABMBAR_REG     0x14             // native audio bus mastering BAR
#define NABM_SIZE       64               // 64 bytes

#define INTLINE_REG     0x3C             // interrupt line register


/*
Codec registers.

Not all codecs are created equal. Refer to the spec for your specific codec.

All registers are 16bits wide.  Access to codec registers over the AC97 link
is defined by the OEM.  

Secondary codec's are accessed by ORing in BIT7 of all register accesses.

*/

// each codec/mixer register is 16bits

#define CODEC_RESET_REG                      0x00     // reset codec
#define CODEC_MASTER_VOL_REG                 0x02     // master volume
#define CODEC_HP_VOL_REG                     0x04     // headphone volume
#define CODEC_MASTER_MONO_VOl_REG            0x06     // master mono volume
#define CODEC_MASTER_TONE_REG                0x08     // master tone (R+L)
#define CODEC_PCBEEP_VOL_REG                 0x0a     // PC beep volume
#define CODEC_PHONE_VOL_REG                  0x0b     // phone volume
#define CODEC_MIC_VOL_REG                    0x0e     // MIC volume
#define CODEC_LINE_IN_VOL_REG                0x10     // line input volume
#define CODEC_CD_VOL_REG                     0x12     // CD volume
#define CODEC_VID_VOL_REG                    0x14     // video volume
#define CODEC_AUX_VOL_REG                    0x16     // aux volume
#define CODEC_PCM_OUT_REG                    0x18     // PCM output volume
#define CODEC_RECORD_SELECT_REG              0x1a     // record select input
#define CODEC_RECORD_VOL_REG                 0x1c     // record volume
#define CODEC_RECORD_MIC_VOL_REG             0x1e     // record mic volume
#define CODEC_GP_REG                         0x20     // general purpose
#define CODEC_3D_CONTROL_REG                 0x22     // 3D control
// 24h is reserved
#define CODEC_POWER_CTRL_REG                 0x26     // powerdown control
#define CODEC_EXT_AUDIO_REG                  0x28     // extended audio
#define CODEC_EXT_AUDIO_CTRL_REG             0x2a     // extended audio control
#define CODEC_PCM_FRONT_DACRATE_REG          0x2c     // PCM out sample rate
#define CODEC_PCM_SURND_DACRATE_REG          0x2e     // surround sound sample rate
#define CODEC_PCM_LFE_DACRATE_REG            0x30     // LFE sample rate
#define CODEC_LR_ADCRATE_REG                 0x32     // PCM in sample rate
#define CODEC_MIC_ADCRATE_REG                0x34     // mic in sample rate

// registers 36-7a are reserved on the ICH

#define CODEC_VENDORID1_REG                  0x7c     // codec vendor ID 1
#define CODEC_VENDORID2_REG                  0x7e     // codec vendor ID 2

// Mixer registers 0 through 51h reside in the ICH and are not forwarded over
// the AC97 link to the codec, which I think is a little weird.  Looks like
// the ICH makes it so you don't need a fully functional codec to play audio?
//
// whenever 2 codecs are present in the system, use BIT7 to access the 2nd
// set of registers, ie 80h-feh

#define PRIMARY_CODEC                        0       // 0-7F for primary codec
#define SECONDARY_CODEC                      BIT7    // 80-8f registers for 2ndary
                                        
#define SAMPLE_RATE_441khz                  44100    // 44.1Khz  (cd quality) rate

// BUS master registers, accessed via NABMBAR+offset

// ICH supports 3 different types of register sets for three types of things
// it can do, thus:
//
// PCM in (for recording) aka PI
// PCM out (for playback) aka PO
// MIC in (for recording) aka MC

#define PI_BDBAR_REG                 0x00     // PCM in buffer descriptor BAR
#define PO_BDBAR_REG                 0x10     // PCM out buffer descriptor BAR
#define MC_BDBAR_REG                 0x20     // MIC in buffer descriptor BAR

// each buffer descriptor BAR holds a pointer which has entries to the buffer
// contents of the .WAV file we're going to play.  Each entry is 8 bytes long
// (more on that later) and can contain 32 entries total, so each BAR is
// 256 bytes in length, thus:

#define BDL_SIZE                     (32*8)   // Buffer Descriptor List size
#define INDEX_MASK                   31       // indexes must be 0-31

#define PI_CIV_REG                   0x04     // PCM in current Index value (RO)
#define PO_CIV_REG                   0x14     // PCM out current Index value (RO)
#define MC_CIV_REG                   0x24     // MIC in current Index value (RO)

// 8bit read only
// each current index value is simply a pointer showing us which buffer
// (0-31) the codec is currently processing.  Once this counter hits 31, it
// wraps back to 0.
// this can be handy to know, as once it hits 31, we're almost out of data to
// play back or room to record!

#define PI_LVI_REG                   0x05     // PCM in Last Valid Index
#define PO_LVI_REG                   0x15     // PCM out Last Valid Index
#define MC_LVI_REG                   0x25     // MIC in Last Valid Index

// 8bit read/write
// The Last Valid Index is a number (0-31) to let the codec know what buffer
// number to stop on after processing.  It could be very nasty to play audio
// from buffers that aren't filled with the audio we want to play.

#define PI_SR_REG                    0x06     // PCM in Status register
#define PO_SR_REG                    0x16     // PCM out Status register
#define MC_SR_REG                    0x26     // MIC in Status register

// 16bit read/write
// status registers.  Bitfields follow:

#define FIFO_ERR                     BIT4     // FIFO Over/Underrun W1TC.

#define BCIS                         BIT3     // buffer completion interrupt status.
                                              // Set whenever the last sample in ANY
                                              // buffer is finished.  Bit is only
                                              // set when the Interrupt on Complete
                                              // (BIT4 of control reg) is set.

#define LVBCI                        BIT2     // Set whenever the codec has processed
                                              // the last buffer in the buffer list.
                                              // Will fire an interrupt if IOC bit is
                                              // set. Probably set after the last
                                              // sample in the last buffer is
                                              // processed.  W1TC

                                         
#define CELV                         BIT1     // Current buffer == last valid.
                                              // Bit is RO and remains set until LVI is
                                              // cleared.  Probably set up the start
                                              // of processing for the last buffer.


#define DCH                          BIT0     // DMA controller halted.
                                              // set whenever audio stream is stopped
                                              // or something else goes wrong.


#define PI_PICB_REG                  0x08     // PCM in position in current buffer(RO)
#define PO_PICB_REG                  0x18     // PCM out position in current buffer(RO)
#define MC_PICB_REG                  0x28     // MIC in position in current buffer (RO)

// 16bit read only
// position in current buffer regs show the number of dwords left to be
// processed in the current buffer.

#define PI_PIV_REG                   0x0a     // PCM in Prefected index value
#define PO_PIV_REG                   0x1a     // PCM out Prefected index value
#define MC_PIV_REG                   0x2a     // MIC in Prefected index value

// 8bit, read only
// Prefetched index value register.
// tells which buffer number (0-31) has be prefetched.  I'd imagine this
// value follows the current index value fairly closely. (CIV+1)

#define PI_CR_REG                    0x0b     // PCM in Control Register
#define PO_CR_REG                    0x1b     // PCM out Control Register
#define MC_CR_REG                    0x2b     // MIC in Control Register

// 8bit
// Control register *MUST* only be accessed as an 8bit value.
// Control register.  See bitfields below.

#define IOCE                         BIT4     // interrupt on complete enable.
                                              // set this bit if you want an interrupt
                                              // to fire whenever LVBCI is set.

#define FEIFE                        BIT3     // set if you want an interrupt to fire
                                              // whenever there is a FIFO (over or
                                              // under) error.

#define LVBIE                        BIT2     // last valid buffer interrupt enable.
                                              // set if you want an interrupt to fire
                                              // whenever the completion of the last
                                              // valid buffer.

#define RR                           BIT1     // reset registers.  Nukes all regs
                                              // except bits 4:2 of this register.
                                              // Only set this bit if BIT 0 is 0

#define RPBM                         BIT0     // Run/Pause
                                              // set this bit to start the codec!


#define GLOB_CNT_REG                 0x2c     // Global control register
#define SEC_RES_EN                   BIT5     // secondary codec resume event 
                                              // interrupt enable.  Not used here.
#define PRI_RES_EN                   BIT4     // ditto for primary. Not used here.
#define ACLINK_OFF                   BIT3     // Turn off the AC97 link
#define ACWARM_RESET                 BIT2     // Awaken the AC97 link from sleep.
                                              // registers preserved, bit self clears
#define ACCOLD_RESET                 BIT1     // Reset everything in the AC97 and
                                              // reset all registers.  Not self clearing

#define GPIIE                        BIT0     // GPI Interrupt enable.
                                              // set if you want an interrupt to
                                              // fire upon ANY of the bits in the
                                              // GPI (general pursose inputs?) not used.

#define GLOB_STS_REG                 0x30     // Global Status register (RO)

#define MD3                          BIT17   // modem powerdown status (yawn)
#define AD3                          BIT16   // Audio powerdown status (yawn)
#define RD_COMPLETE_STS              BIT15   // Codec read timed out. 0=normal
#define BIT3SLOT12                   BIT14   // shadowed status of bit 3 in slot 12
#define BIT2SLOT12                   BIT13   // shadowed status of bit 2 in slot 12
#define BIT1SLOT12                   BIT12   // shadowed status of bit 1 in slot 12
#define SEC_RESUME_STS               BIT11   // secondary codec has resumed (and irqed)
#define PRI_RESUME_STS               BIT10   // primary codec has resumed (and irqed)
#define SEC_CODEC_RDY                BIT9    // secondary codec is ready for action
#define PRI_CODEC_RDY                BIT8    // Primary codec is ready for action
                                             // software must check these bits before
                                             // starting the codec!
#define MIC_IN_IRQ                   BIT7    // MIC in caused an interrupt
#define PCM_OUT_IRQ                  BIT6    // One of the PCM out channels IRQed
#define PCM_IN_IRQ                   BIT5    // One of the PCM in channels IRQed
#define MODEM_OUT_IRQ                BIT2    // modem out channel IRQed
#define MODEM_IN_IRQ                 BIT1    // modem in channel IRQed
#define GPI_STS_CHANGE               BIT0    // set whenever GPI's have changed.
                                             // BIT0 of slot 12 also reflects this.

#define ACC_SEMA_REG                 0x34    // Codec write semiphore register
#define CODEC_BUSY                   BIT0    // codec register I/O is happening
                                             // self clearing

//
// Buffer Descriptors List
// As stated earlier, each buffer descriptor list is a set of (up to) 32 
// descriptors, each 8 bytes in length.  Bytes 0-3 of a descriptor entry point
// to a chunk of memory to either play from or record to.  Bytes 4-7 of an
// entry describe various control things detailed below.
// 
// Buffer pointers must always be aligned on a Dword boundry.
//

#define IOC                          BIT31    // Fire an interrupt whenever this
                                              // buffer is complete.

#define BUP                          BIT30    // Buffer Underrun Policy.
                                              // if this buffer is the last buffer
                                              // in a playback, fill the remaining
                                              // samples with 0 (silence) or not.
                                              // It's a good idea to set this to 1
                                              // for the last buffer in playback,
                                              // otherwise you're likely to get a lot
                                              // of noise at the end of the sound.

//
// Bits 15:0 contain the length of the buffer, in number of samples, which
// are 16 bits each, coupled in left and right pairs, or 32bits each.
// Luckily for us, that's the same format as .wav files.
//
// A value of FFFF is 65536 samples.  Running at 44.1Khz, that's just about
// 1.5 seconds of sample time.  FFFF * 32bits is 1FFFFh bytes or 128k of data.
//
// A value of 0 in these bits means play no samples.
//

#define WAV_BUFFER_SIZE    0xFFF0        
extern UCHAR  *WAV_BUFFER1;           // pointer to the first  wav buffer 
extern UCHAR  *WAV_BUFFER2;           // pointer to the second wav buffer
extern ULONG  AC97_PCI_ADDRESS;       // AC97 PCI address


BOOL ac97_Init( VOID );
VOID ac97_Done( VOID );
VOID ac97_PrepareToPlay( VOID );
VOID ac97_CreateBDL( VOID );
VOID ac97_SetBDLAddress( VOID );
VOID ac97_Play( VOID );
VOID ac97_Stop( VOID );
VOID ac97_Loop( VOID );

VOID ac97_SetPcmFrontDacRate   ( USHORT dwRate );
VOID ac97_SetPcmSurroundDacRate( USHORT dwRate );
VOID ac97_SetMasterVolume      ( USHORT dwVolume );
VOID ac97_SetPcmOutVolume      ( USHORT dwVolume );
VOID ac97_ResetDMA( VOID );
VOID ac97_SetLastValidIndex( UCHAR dwLastIndex );
VOID ac97_SetNewIndex( VOID );
VOID ac97_UpdateLVI( VOID );
ULONG ac97_GetCurrentIndex( VOID );


#endif  __AC97_H__
