/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    activatehook.cpp

Abstract:  Hook for Activate/Deactivate breakpoints functions inside SoftICE.
    Needed to activate/deactivate my own breakpoint (BPRs) when SoftICE popups.  

Revision History:

 Sten        05/06/2002
      Initial release

--*/


extern "C"{
#pragma warning ( push, 3 )
#include "ntddk.h"
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>

#include "wdbgexts.h"
#include "defs.h"
#include "softice.h"
#include "bpr.h"

static BYTE Patch[]                  = "\xE9\x00\x00\x00\x00\x90\x90";

static BYTE SavedActivateBytes[7];   // "\x80\x3D\xC0\x6D\x0A\x00\x01"
                                     //            ^^  ^^  ^^  ^^ - dw_IsBPActivated
                                     // cmp   dw_IsBPActivated, 1

static BYTE SavedDeactivateBytes[7]; // "\x80\x3D\xAB\x96\x0C\x00\x00"
                                     //            ^^  ^^  ^^  ^^ - dwNumberOfBPs?
                                     // cmp   dwNumberOfBPs?, 0

/////////////////////////////////////////////////////////////////////////////
// MyActivateBPsHook
//    Hook for si_ActivateBPs
//    Just activates my BPR breakpoints and calls si_ActivateHook
/////////////////////////////////////////////////////////////////////////////

static void __declspec(naked) MyActivateBPsHook(void)
{
     __asm
     {
           pushad
           mov      ebp, esp
           sub      esp, 32
     }

     bpr_ActivateAll();

     __asm
     {
           ; Emulate instrucion inside SoftICE body
           mov      eax, dword ptr [SavedActivateBytes + 2]
           cmp      [eax], 1

           ; Save result
           pushfd

           ; Skip our stub code
           mov      eax, si_ActivateBPs
           add      eax, 7

           ; Restore emulated instruction result
           popfd

           ; Call next instruction in si_ActivateBPs

           call     eax

           mov      esp, ebp
           popad
           ret           
     }
}

/////////////////////////////////////////////////////////////////////////////
// MyDeactivateBPsHook
//    Hook for si_DeactivateBPs
//    Just deactivates my BPR breakpoints and calls si_DeactivateHook
/////////////////////////////////////////////////////////////////////////////

static void __declspec(naked) MyDeactivateBPsHook(void)
{
     __asm
     {
           pushad
           mov      ebp, esp
           sub      esp, 32

     }

     bpr_DeactivateAll();

     __asm
     {
           ; Emulate instrucion inside SoftICE body
           mov      eax, dword ptr [SavedDeactivateBytes + 2]
           cmp      [eax], 0

           ; Save result
           pushfd

           ; Skip our stub code
           mov      eax, si_DeactivateBPs
           add      eax, 7

           ; Restore emulated instruction result
           popfd

           ; Call next instruction in si_DeactivateBPs
           call     eax

           mov      esp, ebp
           popad
           ret           
     }
}

/////////////////////////////////////////////////////////////////////////////
// InstallActivateBPsHook
//   Patches si_ActivateBPs so that my own handler is called
/////////////////////////////////////////////////////////////////////////////

void InstallActivateBPsHook(void)
{
     // Save old bytes
     RtlCopyMemory(SavedActivateBytes, si_ActivateBPs, 7);

     // Calculate relative offset for the JUMP instruction
     *(PULONG)((ULONG_PTR)Patch + 1) = ((ULONG_PTR)MyActivateBPsHook - (ULONG_PTR)si_ActivateBPs - 5);

     // Install my patch
     RtlCopyMemory(si_ActivateBPs, Patch, 7);
}

/////////////////////////////////////////////////////////////////////////////
// RemoveActivateBPsHook
//   Removes my patch from si_ActivateBPs
/////////////////////////////////////////////////////////////////////////////

void RemoveActivateBPsHook(void)
{
     // restore old bytes inside SoftICE pActivateBPs
     if (si_ActivateBPs)
          RtlCopyMemory(si_ActivateBPs, SavedActivateBytes, 7);
}

/////////////////////////////////////////////////////////////////////////////
// InstallDeactivateBPsHook
//   Patches si_DeactivateBPs so that my own handler is called
/////////////////////////////////////////////////////////////////////////////

void InstallDeactivateBPsHook(void)
{
     // Save old bytes
     RtlCopyMemory(SavedDeactivateBytes, si_DeactivateBPs, 7);

     // Calculate relative offset for the JUMP instruction
     *(PULONG)((ULONG_PTR)Patch + 1) = ((ULONG_PTR)MyDeactivateBPsHook - (ULONG_PTR)si_DeactivateBPs - 5);

     // Install my patch
     RtlCopyMemory(si_DeactivateBPs, Patch, 7);
}

/////////////////////////////////////////////////////////////////////////////
// RemoveDeactivateBPsHook
//   Removes my patch from si_DeactivateBPs
/////////////////////////////////////////////////////////////////////////////


void RemoveDeactivateBPsHook(void)
{
     // restore old bytes inside SoftICE pDeactivateBPs
     if (si_DeactivateBPs)
          RtlCopyMemory(si_DeactivateBPs, SavedDeactivateBytes, 7);
}

