/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    cmd_bpr.cpp

Abstract: Implements !BPR, !BC, !BL extension commands. 

Revision History:

 Sten        05/06/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>

#include "wdbgexts.h"
#include "defs.h"
#include "softice.h"
#include "bpr.h"

extern void help_BPR(void);

////////////////////////////////////////////////////////////////////////////
//
// BPR
//  Debug breakpoint on range. Like in SoftICE 9x.
// 
////////////////////////////////////////////////////////////////////////////

DECLARE_API(bpr)
{
    DWORD bpr_Type;
    DWORD bpr_Addr;
    DWORD bpr_Len;

	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    // TO DO:
    //  - handle syntax errors
    //  - handle other errors such as invalid address
   
    if(args[0]=='!') args += 6;          // "! bpr "

    if (                                  // check for help request
         (args[0] == '/') &&
         (
           (args[1] == 'h') ||
           (args[1] == 'H') ||
           (args[1] == '?') 
         )
       )
    {
         help_BPR();
         return;
    }
 
    if (args[0]==0)
    {
         help_BPR();
         return;
    }

    if (bpr_Count == MAX_BPR)         // maximum count reached
    {
         DbgPrint("BPR: Sorry, BPRs limit excedeed.\n");
         return;
    }

    bpr_Type = (DWORD)args[0];
    if (
        (bpr_Type == 'X') || 
        (bpr_Type == 'R') ||
        (bpr_Type == 'W') ||
        (bpr_Type == 'G') 
       )
    {
         __asm   // si_Expression2Integer is very asm-specific function
         {
               mov        esi, args
               add        esi, 2                    

               call       si_Expression2Integer
               jb         syntax_error

               mov        bpr_Addr, eax
               cmp        byte ptr [esi], 0
               je         syntax_error

               call       si_Expression2Integer
               jb         syntax_error

               mov        bpr_Len, eax             
         }

         bpr_Set(bpr_Type,
                 bpr_Addr,
                 bpr_Len,
                 ClientRegs->CR3);
    }
    else
    {
syntax_error:
         help_BPR();
    }
}

/////////////////////////////////////////////////////////////////////////////
//
// BC 
//  Clear breakpoint
//
////////////////////////////////////////////////////////////////////////////

DECLARE_API(bc)
{
    int    bpNo = 0; 

	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    if (args[0]=='!') args += 5;          // "! bc "

    if (args[0]=='*')
    {
        bpNo = -1;
    }
    else
    {
        __asm
        {
                   mov        esi, args

                   call       si_Expression2Integer
                   jb         syntax_error
                   mov        bpNo, eax
        }
    }

    if (bpNo != -1) 
       DbgPrint("BC: %x\n", bpNo);
    else
       DbgPrint("BC: All\n");

    if (bpNo == -1)
    {
        for (DWORD i=0; i<bpr_Count; i++) bpr_Clear(i); 
    }
    else
        bpr_Clear(bpNo);

    return;

syntax_error:

    DbgPrint("Syntax error.\n");
    return;
}

/////////////////////////////////////////////////////////////////////////////
//
// BL 
//   List current breakpoints
//
////////////////////////////////////////////////////////////////////////////

DECLARE_API(bl)
{
	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);
	UNREFERENCED_PARAMETER(args);

    bpr_ListAll();
}
