/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    cmd_cp.cpp

Abstract: Implements !CP extension command. 

Revision History:

 Sten        05/06/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>

#include "wdbgexts.h"
#include "softice.h"
#include "defs.h"

extern "C"{
   extern char CP1251;           // cp1251.cpp
}

extern void help_CP(void);       // cmd_help.cpp

static char *CurrentCodePage;

////////////////////////////////////////////////////////////////////////////
//
// MyDumpFilter
//
//  Filter dump window output. Uses current codepage for output.
// 
////////////////////////////////////////////////////////////////////////////

void __declspec(naked) MyDumpFilter(void)
{
   __asm
   {
           push     ebx
           mov      ebx, [CurrentCodePage]
           or       ebx, ebx
           jz       default    // CP866 by default

           xlatb               // convert character

default:
           pop      ebx

           cmp      al, ' '
           jb       bad_ch
           cmp      al, 0F0h
           jae      bad_ch
           cmp      al, 0DFh
           ja       good_ch
           cmp      al, 0B0h
           jb       good_ch

bad_ch:
           mov      al, '.'
good_ch:
           ret
   }
}

////////////////////////////////////////////////////////////////////////////
//
// CP
//
//  Set current codepage
// 
////////////////////////////////////////////////////////////////////////////

DECLARE_API(cp)
{
	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    if (args[0] == '!') args += 5; // "! cp "

    if (                                  // check for help request
         (args[0] == '/') &&
         (
           (args[1] == 'h') ||
           (args[1] == 'H') ||
           (args[1] == '?') 
         )
       )
    {
         help_CP();
         return;
    }
 
    if (args[0]==0)
    {
         help_CP();
         return;
    }

    if (_stricmp("866",  args) == 0) CurrentCodePage = NULL;
    if (_stricmp("1251", args) == 0) CurrentCodePage = &CP1251;
    
    return;
}