/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    dump.cpp

Abstract: Implements !DUMP extension command. 

Revision History:

 Sten        05/06/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>

#include "wdbgexts.h"
#include "softice.h"
#include "defs.h"

extern void help_DUMP(void);

#define OBJ_PREFIX      "\\??\\"
#define OBJ_PREFIX_LEN  (sizeof(OBJ_PREFIX)-1)

////////////////////////////////////////////////////////////////////////////
//
// DUMP
//
//  Dump memory to disk
// 
////////////////////////////////////////////////////////////////////////////

DECLARE_API(dump)
{
    char FileName[256];
    int  Addr;
    int  Len;
    void *Buf;

	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);
	
    if (args[0] == '!') args += 7; // "! dump "

    if (                                  // check for help request
         (args[0] == '/') &&
         (
           (args[1] == 'h') ||
           (args[1] == 'H') ||
           (args[1] == '?') 
         )
       )
    {
         help_DUMP();
         return;
    }
 
    if (args[0]==0)
    {
         help_DUMP();
         return;
    }

    // parse command line
    __asm
    {
          mov      esi, args
          lea      edi, FileName

my_loop:                                    ; get filename
          lodsb          
          cmp      al,  ' '
          jz       loop_end
          cmp      al, 0
          jz       loop_end
          stosb
          jmp      my_loop
loop_end:
          
          cmp      byte ptr [esi], 0
          jz       syntax_error

          call     si_Expression2Integer
          jb       syntax_error

          mov      Addr, eax
          cmp      byte ptr [esi], 0
          jz       syntax_error

          call     si_Expression2Integer
          jb       syntax_error
    
          mov      Len, eax
    }    

    if (strncmp(FileName, OBJ_PREFIX, OBJ_PREFIX_LEN) != 0)
    {
        if ((strlen(FileName)+OBJ_PREFIX_LEN+sizeof(char)) < sizeof(FileName))
        {
            RtlMoveMemory(FileName+OBJ_PREFIX_LEN, FileName, strlen(FileName));
            RtlCopyMemory(FileName, OBJ_PREFIX, OBJ_PREFIX_LEN);
        }
    }

    DbgPrint("DUMP: %s %x %x\n", FileName, Addr, Len);

    InitSEH();       
    Buf = ExAllocatePool(NonPagedPool, Len);
    if (Buf)
    {
        __try
        {
            RtlCopyMemory(Buf, (const void *)Addr, Len);
            SheduleDumpFile(FileName, Buf, Len);
            // buffer will be freed inside DumpFile()
        }
        __except(EXCEPTION_EXECUTE_HANDLER)
        {
            DbgPrint("DUMP: error exception occured while dumping memory.\n");
        }
    }
    else
    {
        DbgPrint("DUMP: can't allocate %d bytes of memory.\n", Len);
    }
    CleanupSEH();
    
    return;

syntax_error:
    DbgPrint("Syntax error.\n");
    return;
}