/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    cmd_dumpscreen.cpp

Abstract: Implements !DUMPSCREEN extension command. 

Revision History:

 Sten        05/06/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>
#include <string.h>

#include "wdbgexts.h"
#include "defs.h"
#include "softice.h"
#include "screen.h"

extern void help_DUMPSCREEN(void);

#define OBJ_PREFIX      "\\??\\"
#define OBJ_PREFIX_LEN  (sizeof(OBJ_PREFIX)-1)

////////////////////////////////////////////////////////////////////////////
//
// DUMPSCREEN
//
//  Dump screen to disk in RAW format
// 
////////////////////////////////////////////////////////////////////////////

DECLARE_API(dumpscreen)
{
    char *S=GetScreenPtr();
    int   W=GetWidth(), H=GetHeight();
    char  FileName[256];
    void *Buf;

	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    if (args[0] == '!') args += 13; // "! dumpscreen "

    if (                                  // check for help request
         (args[0] == '/') &&
         (
           (args[1] == 'h') ||
           (args[1] == 'H') ||
           (args[1] == '?') 
         )
       )
    {
         help_DUMPSCREEN();
         return;
    }
 
    if (args[0]==0)
    {
         help_DUMPSCREEN();
         return;
    }

    int tmp; tmp = sscanf(args, " %s ",    FileName); // assign return value to
                                                      // to tmp just to fool PREfast 
                                                      // utility

    if (strncmp(FileName, OBJ_PREFIX, OBJ_PREFIX_LEN) != 0)
    {
        if ((strlen(FileName)+OBJ_PREFIX_LEN+sizeof(char)) < sizeof(FileName))
        {
            RtlMoveMemory(FileName+OBJ_PREFIX_LEN, FileName, strlen(FileName));
            RtlCopyMemory(FileName, OBJ_PREFIX, OBJ_PREFIX_LEN);
        }
    }

    DbgPrint("DUMPSCR: %s\n", FileName);

    InitSEH();       

    Buf = ExAllocatePool(NonPagedPool, W*H*2);
    if (Buf)
    {
        __try
        {
            RtlCopyMemory(Buf, S, W*H*2);
            SheduleDumpFile(FileName, Buf, W*H*2);
            // buffer will be freed inside DumpFile()
        }
        __except(EXCEPTION_EXECUTE_HANDLER)
        {
            DbgPrint("DUMPSCR: error exception occured while dumping memory.\n");
        }
    }
    else
    {
        DbgPrint("DUMPSCR: can't allocate %d bytes of memory.\n", W*H*2);
    }
    CleanupSEH();
}