/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    cmd_eb.cpp

Abstract: Implements !EB extension command. 

Revision History:

 Sten      09/10/2003
      Initial release

--*/


extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>
#include <stdio.h>

#include "wdbgexts.h"
#include "defs.h"
#include "intel.h"
#include "softice.h"

extern WINDBG_EXTENSION_APIS ExtensionApis;

extern void help_EB(void);

////////////////////////////////////////////////////////////////////////////
//
// EB
//
//   Patch byte in memory and preserve PTE value 
//
////////////////////////////////////////////////////////////////////////////

DECLARE_API(eb)
{
    DWORD dwAddr;
    BYTE  dwValue;

	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    __asm
    {
               mov        esi, args

               call       si_Expression2Integer
               jb         syntax_error

               mov        dwAddr, eax
               cmp        byte ptr [esi], 0
               je         syntax_error

               call       si_Expression2Integer
               jb         syntax_error

               cmp        eax, 000000FFh
               ja         syntax_error
               mov        dwValue, al             
    }

    DbgPrint("ADDR=%08X VALUE=%02X\n", dwAddr, dwValue);

    InitSEH();
    DWORD SavedCR0 = EnableWrite();
    __try
    {
          // 1) Save    PTE
          // 2) Patch   Byte
          // 3) Restore PTE

          DWORD SavedPTE = *GetPte((void*)dwAddr);
          *(BYTE*)dwAddr = dwValue;
          *GetPte((void*)dwAddr) = SavedPTE;
    }
    __except(EXCEPTION_EXECUTE_HANDLER)
    {
        DbgPrint("Error: exception occured while patching memory.");
    }
    SetCR0(SavedCR0);
    CleanupSEH();

    return;

syntax_error:
    help_EB();

}
