/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    cmd_font.cpp

Abstract: Implements !FONT extension command. 

Revision History:

 Sten        05/06/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>

#include "wdbgexts.h"
#include "defs.h"
#include "softice.h"

extern void help_FONT(void);

extern "C" {
extern char Font08x08;
extern char Font08x14;
extern char Font08x16;
extern char Font10x20;
}


const SI_FONT FONT8X8 =
{
      8,                // Height
      8 ,               // Width
      &Font08x08        // Body
};

const SI_FONT FONT8X14 =
{
      14,               // Height
      8 ,               // Width
      &Font08x14        // Body
};

const SI_FONT FONT8X16 =
{
      16,               // Height
      8 ,               // Width
      &Font08x16        // Body
};

const SI_FONT FONT10X20 =
{
      20,               // Height
      10,               // Width
      &Font10x20        // Body
};

void __declspec(naked) siw_Render(void)
{
    __asm
    {
          pushad
          mov    al, 0Bh
          call   si_CallVideoDriver
          mov    al, 0Ch
          call   si_CallVideoDriver
          popad
          retn
    }
};

////////////////////////////////////////////////////////////////////////////
//
// FONT
//
//   Display information about installed fonts
//   Set current screen font
//
////////////////////////////////////////////////////////////////////////////

DECLARE_API(font)
{
    DWORD param;

	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    if(args[0]=='!') args += 7;          // "! font "

    if (args[0] == 0)
    { // display information about installed fonts
         dprintf("SoftICE fonts:\n");
      
         dprintf("  1:  %2dx%-2d    - %08X\n", 
                                 si_Fonts[0]->Width,
                                 si_Fonts[0]->Height, 
                                 si_Fonts[0]->Body);

         dprintf("  2:  %2dx%-2d    - %08X\n", 
                                 si_Fonts[1]->Width,
                                 si_Fonts[1]->Height, 
                                 si_Fonts[1]->Body);

         dprintf("  3:  %2dx%-2d    - %08X\n", 
                                 si_Fonts[2]->Width,
                                 si_Fonts[2]->Height, 
                                 si_Fonts[2]->Body);

         dprintf("External fonts:\n");
         dprintf("  4:  8x8      - external russian font\n");
         dprintf("  5:  8x14     - external russian font\n");
         dprintf("  6:  8x16     - external russian font\n");
         dprintf("  7: 10x20     - external russian font\n");
     }
     else
     {   // set font
         __asm
         {
				 mov        esi, args
				 call       si_Expression2Integer
				 jb         syntax_error

				 mov        [param], eax
         }

         switch (param)
         {
             case 0:    
             case 1:    si_SetFont(si_Fonts[0]); 
                        // Load standart SI 8x8 font into siwvid.
                        // that forces siwvid to display this font in text-mode
                        // NOTE: that siwvid only supports 8x8 and 8x16 fonts
                        siw_LoadFont((char*)si_Fonts[0]->Body, 2048);
                        break;

             case 2:    si_SetFont(si_Fonts[1]); break;
             case 3:    si_SetFont(si_Fonts[2]); break;

             case 4:    si_SetFont(&FONT8X8);    
                        // Load 8x8 font into siwvid.
                        // that forces siwvid to display this font in text-mode
                        siw_LoadFont(&Font08x08, 2048);
                        siw_Render();
                        break;

             case 5:    si_SetFont(&FONT8X14);   break;
             case 6:    si_SetFont(&FONT8X16);   
                        // Load 8x16 font into siwvid.
                        // That forces siwvid to display this font in text-mode.
                        siw_LoadFont(&Font08x16, 2048);
                        break;

             case 7:    si_SetFont(&FONT10X20);  break;

             default:   DbgPrint("Error. No such font installed - %d\n", param);            
                        break;
         }
    }

    return;

syntax_error:
    help_FONT();
}
