/*++
    Copyright  (c) 2003 Drakon Rider
    Contact information:
        mail: admin@drakan.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    cmd_fpos.cpp

Abstract: Implements !FPOS extension command.
Sets KDFilePos var to current file pointer.
(i think you need to add 

EXP=%systemroot%/system32/drivers/iceext.sys

into winice.dat to use this variable)

Displays current file pointer position.

Revision History:

 Drakon Rider        11.01.2004
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>
#include <string.h>

#include "wdbgexts.h"
#include "defs.h"
#include "softice.h"
#include "screen.h"

extern void help_FPOS(void);

DWORD KDFilePos = 0;

////////////////////////////////////////////////////////////////////////////
//
// FPOS
//
//  Function, returns 32bit file pointer.
// 
////////////////////////////////////////////////////////////////////////////

DECLARE_API(fpos)
{
	HANDLE hFile=0;
	IO_STATUS_BLOCK iosb;
	DWORD fpibuf[2];

	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    if (args[0] == '!') args += 7; // "! fpos "

    if (                                  // check for help request
         (args[0] == '/') &&
         (
           (args[1] == 'h') ||
           (args[1] == 'H') ||
           (args[1] == '?') 
         )
       )
    {
         help_FPOS();
         return;
    }
 
    if (args[0] == 0)
    {
         help_FPOS();
         return;
    }

    {
         __asm   // si_Expression2Integer is very asm-specific function
         {
               mov        esi, args

               call       si_Expression2Integer
               jb         syntax_error

               mov        hFile, eax
         }

	DbgPrint ("hFile %08X\n", hFile);

    ZwQueryInformationFile( hFile, &iosb, &fpibuf,\
                               sizeof( fpibuf ), FilePositionInformation );

//    fpibuf[1] high order or 64bit position - possibly never used
//    fpibuf[0] low  order of 64bit position for files from 0 to 2 Gb

   	DbgPrint ("FilePos %08X\n", fpibuf[0]);
	KDFilePos = fpibuf[0];
	return ;
    }

    {
syntax_error:
         help_FPOS();
    }
}