/*++
    Copyright  (c) 2002 Sten
    Contact information:
        mail: stenri@mail.ru

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

 
Module Name:
    cmd_help.cpp

Abstract: Implements !HELP extension command. 

Revision History:

 Sten        05/06/2002
      Initial release

--*/

extern "C" {
#pragma warning ( push, 3 )
#include <ntddk.h>
#pragma warning ( pop )
}

#pragma warning ( disable: 4514 ) // unreferenced inline function has been removed

#include <windef.h>
#include <ntverp.h>

#include <stdio.h>
#include <string.h>

#include "wdbgexts.h"
#include "softice.h"

static BYTE CUR_COLOR = 7;

////////////////////////////////////////////////////////////////////////////
//
// Say
//
// Helper function. Prints string with current color (CUR_COLOR).
//
////////////////////////////////////////////////////////////////////////////

void Say(char *msg)
{
   __asm
   {
         mov     esi, msg
         mov     bh , CUR_COLOR
         call    si_SayESIpause
   }
}

////////////////////////////////////////////////////////////////////////////
//
// Help on HELP :-)
//
////////////////////////////////////////////////////////////////////////////

void help_HELP(void)
{
   Say("Help on specified function");
   Say("!help [command]");           
   Say("Ex:");
   Say(" !help dump");          
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !BPR
//
////////////////////////////////////////////////////////////////////////////

void help_BPR(void)
{
   Say("Set break point on range");
   Say("!bpr [R|W|X] Addr Len");
   Say("Ex:");
   Say(" !bpr X 400000 1000");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !DUMP
//
////////////////////////////////////////////////////////////////////////////

void help_DUMP(void)
{
   Say("Dump memory to disk");
   Say("!dump FileName Addr Len");
   Say("Ex:");
   Say(" !dump c:\\dump.dat 400000 1000");
   Say(" !dump \\??\\c:\\dump.dat 400000 1000");
   Say(" !dump \\??\\c:\\dump.dat edx+ebx ecx");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !DUMPSCREEN
//
////////////////////////////////////////////////////////////////////////////

void help_DUMPSCREEN (void)
{
   Say("Dump SoftICE screen to disk in RAW format");
   Say("!dumpscreen filename");
   Say("Ex:");
   Say(" !dumpscreen \\??\\c:\\screen.bin");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !EB
//
////////////////////////////////////////////////////////////////////////////

void help_EB (void)
{
   Say("Patch byte in memory");
   Say("!eb address value");
   Say("Ex:");
   Say(" !eb eip 68");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !TETRIS
//
////////////////////////////////////////////////////////////////////////////

void help_TETRIS (void)
{
   Say("Play tetris game");
   Say("!tetris [delay]");
   Say("Ex:");
   Say(" !tetris");
   Say(" !tetris 150"); 
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !PTE
//
////////////////////////////////////////////////////////////////////////////

void help_PTE(void)
{
   Say("Display PDE and PTE contents of given address");
   Say("!pte Addr");
   Say("Ex:");
   Say(" !pte 400000");
   Say(" !pte eax");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !SUSPEND
//
////////////////////////////////////////////////////////////////////////////

void help_SUSPEND(void)
{
   Say("Suspend current thread execution");
   Say("!suspend");
   Say("Ex:");
   Say(" !suspend");
   Say("NOTE:");
   Say(" This commands exits SoftICE without promt.");
   Say(" This commands can only be used on ring3 threads.");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !RESUME
//
////////////////////////////////////////////////////////////////////////////

void help_RESUME(void)
{
   Say("Resume previously suspended thread");
   Say("!resume");
   Say("NOTE:");
   Say(" You can use !resume in the context of any active thread.");
   Say(" Command will brought you to the thread that was suspended before.");
   Say(" If you kill suspended process, !resume will simply exit from SoftICE.");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !IDT
//
////////////////////////////////////////////////////////////////////////////

void help_IDT (void)
{
   Say("Display interrupt descriptor table ");
   Say("!idt [IdtNumber]");
   Say("Ex:");
   Say(" !idt");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !FONT
//
////////////////////////////////////////////////////////////////////////////

void help_FONT (void)
{
   Say("Set screen font or display information about installed fonts");
   Say("!font [1|2|3|4|5|6|7]");
   Say("Ex:");
   Say(" !font");
   Say(" !font 4");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !CP
//
////////////////////////////////////////////////////////////////////////////

void help_CP (void)
{
   Say("Set current code page");
   Say("!cp [866|1251]");
   Say("Ex:");
   Say(" !cp 1251");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !LASTBRANCH
//
////////////////////////////////////////////////////////////////////////////

void help_LASTBRANCH (void)
{
   Say("Shows last branch information recorded by SoftICE");
   Say("!lastbranch");
   Say("Ex:");
   Say(" !lastbranch");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !INTSAVE
//
////////////////////////////////////////////////////////////////////////////

void help_INTSAVE (void)
{
   Say("Save current interrupt handler to internal table");
   Say("!intsave [00-FF]");
   Say("Ex:");
   Say(" !intsave");
   Say(" !intsave 3");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !INTREST
//
////////////////////////////////////////////////////////////////////////////

void help_INTREST (void)
{
   Say("Restore interrupt handler from internal table");
   Say("!intrest [00-FF]");
   Say("Ex:");
   Say(" !intrest");
   Say(" !intrest 3");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !INTXCHG
//
////////////////////////////////////////////////////////////////////////////

void help_INTXCHG (void)
{
   Say("Exchange interrupt handler and internal table value");
   Say("!intxchg [00-FF]");
   Say("Ex:");
   Say(" !intxchg");
   Say(" !intxchg 3");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !INTSHOW
//
////////////////////////////////////////////////////////////////////////////

void help_INTSHOW (void)
{
   Say("Print internal interrupt handlers table");
   Say("!intshow");
   Say("Ex:");
   Say(" !intshow");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !SDT
//
////////////////////////////////////////////////////////////////////////////
void help_SDT (void)
{
   Say("Print [Shadow] System Descriptor Table contents");
   Say("!sdt [0|1|2|3]");
   Say("Ex:");
   Say(" !sdt 1     - prints shadow descriptor table");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !PROTECT
//
////////////////////////////////////////////////////////////////////////////
void help_PROTECT (void)
{
   Say("Turn SoftICE protection ON/OFF.");
   Say("!protect [INT3|MELTICE|UEF|SYSINF|DE] [ON|OFF]");
   Say("Ex:");
   Say(" !protect off       - turn protection off");
   Say(" !protect INT3 off  - turn backdoor protection off");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !LOAD
//
////////////////////////////////////////////////////////////////////////////

void help_LOADFILE(void)
{
   Say("Load disk file to memory");
   Say("!loadfile FileName Addr");
   Say("Ex:");
   Say(" !loadfile c:\\dump.dat 400000");
   Say(" !loadfile \\??\\c:\\dump.dat 400000");
   Say(" !loadfile \\??\\c:\\dump.dat edx+ebx");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !FPOS (by Drakon Rider)
//
////////////////////////////////////////////////////////////////////////////

void help_FPOS(void)
{
   Say("Display file pointer (low 32bit)");
   Say("and set file pointer var KDFilePos");
   Say("!fpos hFile");
   Say("Ex:");
   Say(" !fpos 4C4");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !IF (by crUsAdEr)
//
////////////////////////////////////////////////////////////////////////////

void help_IF(void)
{
   Say("Execute commands depending on conditions passed!");
   Say("!if (condition) then \"cmd1;cmd2\" else \"cmd3;cmd4\" ");
   Say("Ex:");
   Say(" !if (eip>600000) then \"bpm eax\"");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !TRACE (by Godness)
//
////////////////////////////////////////////////////////////////////////////

void help_TRACE(void)
{
    Say("Trace command on conditions passed!");
    Say("!trace count [eip_when_pret]");
    Say("Ex:");
    Say(" !trace 1000 0x77C00000");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !TRCINIT (by Godness)
//
////////////////////////////////////////////////////////////////////////////

void help_TRCINIT(void)
{
    Say("Compile the tracer condition code");
    Say("!trcinit condition");
    Say("Ex:");
    Say(" !trcinit (eax == 3 || ebx >= 4) && esi != edi");
}

////////////////////////////////////////////////////////////////////////////
//
// Help on !TRCCODE (by Godness)
//
////////////////////////////////////////////////////////////////////////////

void help_TRCCODE(void)
{
    Say("Show the code that was compiled by TRCINIT function");
    Say("Ex:");
    Say(" !trccode");
}

////////////////////////////////////////////////////////////////////////////
//
// HELP
//  Display help.
// 
////////////////////////////////////////////////////////////////////////////

DECLARE_API(help)
{
	UNREFERENCED_PARAMETER(dwProcessor);
	UNREFERENCED_PARAMETER(dwCurrentPc);
	UNREFERENCED_PARAMETER(hCurrentThread);
	UNREFERENCED_PARAMETER(hCurrentProcess);

    if(args[0]=='!') args += 7;          // "! help "

    CUR_COLOR = *si_NormCharColor;

    if (args[0] == 0)
    {               
        CUR_COLOR = *si_ReverseCharColor;
        Say(" AVAILABLE ICEEXT COMMANDS ");

        CUR_COLOR = *si_NormCharColor;
        Say("!BC          - clear break point on range");
        Say("!BL          - list break points on range");
        Say("!BPR         - break point on range");
        Say("!CP          - set current codepage");
        Say("!DUMP        - dump memory to disk");
        Say("!DUMPSCREEN  - dump SoftICE screen to disk");
        Say("!EB          - edit byte in memory");
        Say("!FONT        - set screen font");
        Say("!FPOS        - display file pointer");

        Say("!INTSAVE     - save interrupt handler");
        Say("!INTREST     - restore interrupt handler");
        Say("!INTXCHG     - exchange interrupt handler");
        Say("!INTSHOW     - show internal interrupt handlers table");

        Say("!HELP        - help on specified function");
        Say("!LASTBRANCH  - show MSR last branch information");
        Say("!LOADFILE    - load disk file to memory");
        Say("!PROTECT     - turn protection on/off");
        Say("!SUSPEND     - suspend thread");
        Say("!RESUME      - resume thread");
        Say("!TETRIS      - tetris game");
        Say("!TRACE       - start tracer");
        Say("!TRCCODE     - show the tracer condition code");
        Say("!TRCINIT     - compile the tracer condition code");
	}
    else if(_stricmp("eb", args) == 0)         help_EB();
    else if(_stricmp("help", args) == 0)       help_HELP();
    else if(_stricmp("bpr",  args) == 0)       help_BPR();
    else if(_stricmp("dump", args) == 0)       help_DUMP();
    else if(_stricmp("dumpscreen", args) == 0) help_DUMPSCREEN();
    else if(_stricmp("tetris", args) == 0)     help_TETRIS();
    else if(_stricmp("pte", args) == 0)        help_PTE();
    else if(_stricmp("suspend", args) == 0)    help_SUSPEND();
    else if(_stricmp("resume", args) == 0)     help_RESUME();
    else if(_stricmp("idt", args) == 0)        help_IDT();
    else if(_stricmp("font", args) == 0)       help_FONT();
    else if(_stricmp("fpos", args) == 0)       help_FPOS();
    else if(_stricmp("cp", args) == 0)         help_CP();
    else if(_stricmp("lastbranch", args) == 0) help_LASTBRANCH();
    else if(_stricmp("protect", args) == 0)    help_PROTECT();
    else if(_stricmp("loadfile", args) == 0)   help_LOADFILE();
    else if(_stricmp("if", args) == 0)         help_IF();
    else if(_stricmp("trace", args) == 0)      help_TRACE();
    else if(_stricmp("trcinit", args) == 0)    help_TRCINIT();
    else if(_stricmp("trccode", args) == 0)    help_TRCCODE();
    else Say("Unknown command (use !help to see list of all commands)");
}